/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysTimingTriggerConfigMapper;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerConfig;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerConfigService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysTimingTriggerConfigServiceImpl")
public class SysTimingTriggerConfigServiceImpl
extends HussarServiceImpl<SysTimingTriggerConfigMapper, SysTimingTriggerConfig>
implements ISysTimingTriggerConfigService {
    private static Logger logger = LoggerFactory.getLogger(SysTimingTriggerConfigServiceImpl.class);
    @Resource
    private ISysTimingTriggerTaskService sysTimingTriggerTaskService;
    private static final String CONFIG_STATUS_ENABLE = "1";
    private static final String CONFIG_STATUS_UNENABLE = "0";

    public boolean saveTimingTriggerConfig(RuleFullVo ruleFullVo, String triggerId) {
        SysTimingTriggerConfig sysTimingTriggerConfig = new SysTimingTriggerConfig();
        sysTimingTriggerConfig.setAppId(Long.valueOf(ruleFullVo.getAppId()));
        sysTimingTriggerConfig.setFormId(Long.valueOf(ruleFullVo.getSourceForm()));
        sysTimingTriggerConfig.setTriggerId(Long.valueOf(triggerId));
        sysTimingTriggerConfig.setId(Long.valueOf(triggerId));
        sysTimingTriggerConfig.setTriggerTaskType(ruleFullVo.getTrigger());
        JSONObject timeRule = ruleFullVo.getTimedRule();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Object firstTriggerTimeConfig = timeRule.get((Object)"firstTriggerTime");
        Object endTriggerTimeObj = timeRule.get((Object)"endTriggerTime");
        LocalDateTime firstTriggerTime = null;
        LocalDateTime endTriggerTime = null;
        Object dateTime = null;
        if (!NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(ruleFullVo.getTrigger())) {
            String firstTriggerTimeConfigStr = JsonUtil.toJson((Object)firstTriggerTimeConfig);
            if (!firstTriggerTimeConfigStr.contains("dateTime")) {
                dateTime = firstTriggerTimeConfig;
            } else {
                JSONObject jsonObject = JSONObject.parseObject((String)JsonUtil.toJson((Object)firstTriggerTimeConfig));
                dateTime = jsonObject.get((Object)"dateTime");
            }
            if (HussarUtils.isNotEmpty((Object)dateTime)) {
                if (dateTime instanceof LocalDateTime) {
                    firstTriggerTime = (LocalDateTime)dateTime;
                } else {
                    String firstTriggerTimeStr = dateTime.toString().replaceAll("T", " ");
                    firstTriggerTime = LocalDateTime.parse(firstTriggerTimeStr, formatter);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)endTriggerTimeObj)) {
            if (endTriggerTimeObj instanceof LocalDateTime) {
                endTriggerTime = (LocalDateTime)endTriggerTimeObj;
            } else {
                String endTriggerTimeStr = endTriggerTimeObj.toString().replaceAll("T", " ");
                endTriggerTime = LocalDateTime.parse(endTriggerTimeStr, formatter);
            }
        }
        sysTimingTriggerConfig.setFirstTriggerTime(firstTriggerTime);
        sysTimingTriggerConfig.setFirstTriggerTimeConfig(JsonUtil.toJson((Object)firstTriggerTimeConfig));
        sysTimingTriggerConfig.setEndTriggerTime(endTriggerTime);
        JSONObject repeatRule = timeRule.getJSONObject("repeatRule");
        sysTimingTriggerConfig.setRepeatRule(repeatRule.toJSONString());
        SecurityUser user = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
        sysTimingTriggerConfig.setCreator(user.getUserId());
        sysTimingTriggerConfig.setCreateTime(LocalDateTime.now());
        sysTimingTriggerConfig.setLastTime(LocalDateTime.now());
        sysTimingTriggerConfig.setLastEditor(null);
        if (ruleFullVo.getEnable().booleanValue()) {
            sysTimingTriggerConfig.setConfigStatus(CONFIG_STATUS_ENABLE);
            this.sysTimingTriggerTaskService.removeByConfigId(sysTimingTriggerConfig.getId());
            String dataSourceKey = DataModelUtil.currentDsName();
            logger.info("\u4fdd\u5b58\u4e1a\u52a1\u89c4\u5219\u5f02\u6b65\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
            this.sysTimingTriggerTaskService.asyncInitTimingTriggerTask(sysTimingTriggerConfig, dataSourceKey);
        } else {
            sysTimingTriggerConfig.setConfigStatus(CONFIG_STATUS_UNENABLE);
            this.sysTimingTriggerTaskService.removeByConfigId(sysTimingTriggerConfig.getId());
        }
        return super.saveOrUpdate((BaseEntity)sysTimingTriggerConfig);
    }

    public List<SysTimingTriggerConfig> listByFormIdAndTriggerType(Long formId, String triggerType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTimingTriggerConfig::getFormId, (Object)formId)).eq(SysTimingTriggerConfig::getTriggerTaskType, (Object)triggerType)).eq(SysTimingTriggerConfig::getConfigStatus, (Object)CONFIG_STATUS_ENABLE);
        return this.list((Wrapper)queryWrapper);
    }

    public boolean configIsChange(SysTimingTriggerConfig oldSysTimingTriggerConfig, SysTimingTriggerConfig newSysTimingTriggerConfig) {
        boolean change = true;
        if (oldSysTimingTriggerConfig.getTriggerTaskType().equals(newSysTimingTriggerConfig.getTriggerTaskType()) && oldSysTimingTriggerConfig.getFirstTriggerTime().equals(newSysTimingTriggerConfig.getFirstTriggerTime()) && oldSysTimingTriggerConfig.getRepeatRule().equals(newSysTimingTriggerConfig.getRepeatRule()) && oldSysTimingTriggerConfig.getEndTriggerTime().equals(newSysTimingTriggerConfig.getEndTriggerTime()) && oldSysTimingTriggerConfig.getConfigStatus().equals(newSysTimingTriggerConfig.getConfigStatus())) {
            change = false;
        }
        return change;
    }
}

