/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewSchemaVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewVo;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysRuleExcHisMapper;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleExcHisDto;
import com.jxdinfo.hussar.formdesign.application.rule.model.FormDetails;
import com.jxdinfo.hussar.formdesign.application.rule.model.RuleActionResult;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleExcHis;
import com.jxdinfo.hussar.formdesign.application.rule.model.TriggerDetails;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleExcHisService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.SysRuleExcHisVo;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.rule.service.impl.SysRuleExcHisServiceImpl")
public class SysRuleExcHisServiceImpl
extends HussarServiceImpl<SysRuleExcHisMapper, SysRuleExcHis>
implements ISysRuleExcHisService {
    private static final Logger logger = LoggerFactory.getLogger(SysRuleExcHisServiceImpl.class);
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    private static final String FLOW_FROM = "1";

    public ApiResponse<Long> addRuleExcHis(SysRuleExcHisDto sysRuleExcHisDto) {
        this.save((BaseEntity)sysRuleExcHisDto);
        return ApiResponse.success((Object)sysRuleExcHisDto.getExcHisId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public ApiResponse<Boolean> editRuleExcHis(SysRuleExcHisDto sysRuleExcHisDto) {
        boolean flag = this.updateById((BaseEntity)sysRuleExcHisDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deleteRuleExcHis(Long excHisId) {
        boolean flag = this.removeById(excHisId);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public Page<SysRuleExcHisVo> getRuleExcHisList(SysRuleExcHisDto sysRuleExcHisDto) {
        String excUserId = sysRuleExcHisDto.getExcUserId();
        List<Object> excUserIdList = new ArrayList();
        if (StringUtil.isNotEmpty((Object)excUserId)) {
            String[] split = excUserId.split(",");
            excUserIdList = Arrays.asList(split);
        }
        String beginTime = sysRuleExcHisDto.getBeginTime();
        String endTime = sysRuleExcHisDto.getEndTime();
        Page page = (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(StringUtil.isNotEmpty((Object)sysRuleExcHisDto.getExcUserId()), SysRuleExcHis::getExcUserId, excUserIdList)).eq(sysRuleExcHisDto.getExcResult() != null, SysRuleExcHis::getExcResult, (Object)sysRuleExcHisDto.getExcResult())).between(StringUtil.isNotEmpty((Object)beginTime) && StringUtil.isNotEmpty((Object)endTime), SysRuleExcHis::getExcTime, (Object)beginTime, (Object)endTime)).eq(SysRuleExcHis::getRuleId, (Object)sysRuleExcHisDto.getRuleId())).orderByDesc(SysRuleExcHis::getExcTime)).page((IPage)new Page(sysRuleExcHisDto.getCurrent().longValue(), sysRuleExcHisDto.getSize().longValue()));
        Page pageResult = new Page(sysRuleExcHisDto.getCurrent().longValue(), sysRuleExcHisDto.getSize().longValue());
        if (page.getRecords().isEmpty()) {
            pageResult.setTotal(0L);
            pageResult.setRecords(new ArrayList());
            return pageResult;
        }
        List RuleExcHisList = page.getRecords();
        ArrayList<SysRuleExcHisVo> RuleExcHisVos = new ArrayList<SysRuleExcHisVo>();
        for (SysRuleExcHis sysRuleExcHis : RuleExcHisList) {
            SysRuleExcHisVo sysRuleExcHisVo = new SysRuleExcHisVo();
            BeanUtils.copyProperties((Object)sysRuleExcHis, (Object)sysRuleExcHisVo);
            String triggerDetailsStr = sysRuleExcHis.getTriggerDetails();
            TriggerDetails triggerDetails = (TriggerDetails)JSON.parseObject((String)triggerDetailsStr, TriggerDetails.class);
            sysRuleExcHisVo.setTriggerDetails(triggerDetails);
            String excResultContentStr = sysRuleExcHis.getExcResultContent();
            List excResultList = (List)JSON.parseObject((String)excResultContentStr, (TypeReference)new TypeReference<List<RuleActionResult>>(){}, (Feature[])new Feature[0]);
            sysRuleExcHisVo.setExcResultContent(excResultList);
            RuleExcHisVos.add(sysRuleExcHisVo);
        }
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(RuleExcHisVos);
        return pageResult;
    }

    public FormDetails getRuleExcHisDetail(Long formId, Long triggerDataId, Long appId) {
        Object data;
        JSONObject jsonObject;
        String processInstId;
        ApiResponse body;
        FormDetails formDetails = new FormDetails();
        FormViewVo view = null;
        try {
            view = this.hussarAppFormService.getView(formId.toString(), appId.toString());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u89c6\u56fe\u5931\u8d25,\u8868\u5355id:{},appId:{}", (Object)formId.toString(), (Object)appId);
            throw new BaseException((Throwable)e);
        }
        FormViewSchemaVo formView = view.getFormView();
        Map props = formView.getProps();
        formDetails.setFormStatus(formView.getFormStatus());
        formDetails.setFormLayout(props.get("formLayout").toString());
        formDetails.setFormWidth(Integer.valueOf((Integer)props.get("formWidth")));
        formDetails.setAppId(Long.valueOf(formView.getAppId()));
        formDetails.setFormType(formView.getFormType());
        formDetails.setFormName(formView.getFormName());
        formDetails.setFormTitle(formView.getFormTitle());
        formDetails.setFormId(formId);
        if (FLOW_FROM.equals(formView.getFormType()) && (body = (ApiResponse)this.formOperateExposedService.formQuery(formId.toString(), triggerDataId.toString(), null, formView.getAppId(), Boolean.FALSE.booleanValue()).getBody()) != null && HussarUtils.isNotEmpty((Object)(processInstId = (jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)(data = body.getData())))).getString("PROCESS_INST_ID")))) {
            formDetails.setProcessInstId(Long.valueOf(processInstId));
        }
        return formDetails;
    }
}

