/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.job;

import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimingTriggerTaskPoller
implements BasicProcessor {
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private ISysTimingTriggerTaskService sysTimingTriggerTaskService;
    private static final Logger logger = LoggerFactory.getLogger(TimingTriggerTaskPoller.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult process(TaskContext taskContext) {
        ProcessResult processResult = new ProcessResult(true);
        String dataSourceKey = DataModelUtil.currentDsName();
        if ("master".equals(dataSourceKey)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    logger.error("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                try {
                    HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                    this.sysTimingTriggerTaskService.dealTimingTask(hussarTenantDefinition.getConnName(), hussarTenantDefinition.getTenantCode());
                }
                catch (Exception e) {
                    logger.error("\u4e1a\u52a1\u89c4\u5219\u5b9a\u65f6\u4efb\u52a1\u6570\u636e\u6e90\u5207\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                }
                finally {
                    HussarContextHolder.remove();
                }
            }
        }
        return processResult;
    }
}

