/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExp;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.vo.WidgetExpGroupVo;
import com.jxdinfo.hussar.formdesign.application.property.vo.WidgetExpVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/hussarBase/property/widget"})
@RestController
public class WidgetExpController {
    @Resource
    private IWidgetExpService widgetExpService;

    @GetMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165\u7ec4\u4ef6")
    public ApiResponse<Void> importWidget(@RequestParam(value="fileId") Long fileId, @RequestParam(value="groupId") Long groupId) {
        return this.widgetExpService.importWidget(fileId, groupId);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u4ef6\u5217\u8868\uff0c\u4e8c\u7ea7\u5206\u7ec4\u6811\u5f62\u5c55\u793a")
    public ApiResponse<List<WidgetExpGroupVo>> getWidgets(@RequestParam(value="widgetName") String widgetName) {
        return this.widgetExpService.getWidgets(widgetName);
    }

    @GetMapping(value={"/pageList"})
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u4ef6\u5217\u8868\uff0c\u5217\u8868\u5206\u9875\u5c55\u793a")
    public ApiResponse<Page<WidgetExpVo>> getWidgetsPage(@RequestParam(value="size") Long size, @RequestParam(value="current") Long current, @RequestParam(value="widgetName") String widgetName, @RequestParam(value="widgetGroupId") Long widgetGroupId) {
        PageInfo pageInfo = new PageInfo(current.longValue(), size.longValue());
        return this.widgetExpService.getWidgetsPage(pageInfo, widgetName, widgetGroupId);
    }

    @GetMapping(value={"/showImage"})
    @ApiOperation(value="\u7ec4\u4ef6\u56fe\u6807\u5c55\u793a")
    public void showImage(@RequestParam(value="widgetName") String widgetName, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        this.widgetExpService.showImage(widgetName, fileName, response);
    }

    @GetMapping(value={"/download/{fileId}"})
    @ApiOperation(value="\u4e0b\u8f7d\u7ec4\u4ef6")
    public void downloadWidget(@PathVariable(value="fileId") Long fileId, HttpServletResponse response) {
        this.widgetExpService.downloadWidget(fileId, response);
    }

    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u7ec4\u4ef6")
    public ApiResponse<Void> deleteWidget(@PathVariable(value="id") Long id) {
        this.widgetExpService.deleteWidget(id);
        return ApiResponse.success();
    }

    @GetMapping(value={"/fileContent"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u4ef6\u4e0b\u6587\u4ef6\u5185\u5bb9")
    public String getWidgetFileContent(@RequestParam(value="widgetName") String widgetName, @RequestParam(value="fileName") String fileName) throws IOException {
        return this.widgetExpService.getWidgetFileContent(widgetName, fileName);
    }

    @GetMapping(value={"/allWidgets"})
    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u7ec4\u4ef6\u5217\u8868")
    public ApiResponse<List<WidgetExp>> getAllWidgets() {
        return ApiResponse.success((Object)this.widgetExpService.list());
    }

    @PostMapping(value={"/getWidgetsByName"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u4ef6\u540d\u83b7\u53d6\u7ec4\u4ef6\u96c6\u5408")
    public ApiResponse<List<WidgetExp>> getWidgetsByName(@RequestBody List<String> widgetNames) {
        List widgetExps = this.widgetExpService.getWidgetsByName(widgetNames);
        return ApiResponse.success((Object)widgetExps);
    }
}

