/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdOrganMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtOrganDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ThirdOrganAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ThirdOrganEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdOrganRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdOrganServiceImpl
extends HussarServiceImpl<ThirdOrganMapper, ThirdOrganRela>
implements IThirdOrganService {
    @Resource
    private IHussarBaseSyncOrganizationService hussarBaseSyncOrganizationService;
    @Resource
    private IHussarBaseOrganizationService organService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdOrganServiceImpl.class);

    @Override
    public ApiResponse<Void> addOrgan(ThirdOrganAddDto thirdOrganAddDto) {
        LOGGER.info("openApi -> \u65b0\u589e\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdOrganAddDto)));
        R addOutOrganResult = this.hussarBaseSyncOrganizationService.addOrganization((AddOutsideOrganizationDto)thirdOrganAddDto);
        if (!addOutOrganResult.isSuccess()) {
            LOGGER.error("openApi -> \u65b0\u589e\u7ec4\u7ec7\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addOutOrganResult.getErrorList()));
            return ApiResponse.fail((String)"\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25");
        }
        ThirdOrganRela thirdOrganRela = new ThirdOrganRela();
        Long structId = ((DataMapping)addOutOrganResult.getSuccessList().get(0)).getId();
        thirdOrganRela.setOrganId(structId);
        thirdOrganRela.setThirdOrganId(thirdOrganAddDto.getExtOrganId());
        this.save((BaseEntity)thirdOrganRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editOrgan(ThirdOrganEditDto thirdOrganEditDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdOrganEditDto)));
        R editOutsideOrganResult = this.hussarBaseSyncOrganizationService.editOrganization((EditOutsideOrganizationDto)thirdOrganEditDto);
        if (!editOutsideOrganResult.isSuccess()) {
            LOGGER.error("openApi -> \u4fee\u6539\u7ec4\u7ec7\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editOutsideOrganResult.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u7ec4\u7ec7\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> delOrgan(ExtOrganDelDto extOrganDelDto) {
        LOGGER.info("openApi -> \u5220\u9664\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)extOrganDelDto));
        ThirdOrganRela organRela = (ThirdOrganRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)extOrganDelDto.getExtOrganId())));
        if (HussarUtils.isEmpty((Object)((Object)organRela))) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u5f85\u5220\u9664\u7ec4\u7ec7\u76f8\u5173\u8bb0\u5f55");
        }
        ApiResponse delOrgResult = this.organService.deleteOrganization(organRela.getOrganId());
        if (!delOrgResult.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u7ec4\u7ec7\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)delOrgResult.getMsg());
            return ApiResponse.fail((String)"\u5220\u9664\u7ec4\u7ec7\u5931\u8d25");
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)extOrganDelDto.getExtOrganId()));
        return ApiResponse.success();
    }

    @Override
    public List<Long> listPlatformOrganIds(List<String> extOrganIds) {
        List organRelas = this.list((Wrapper)new LambdaQueryWrapper().in(ThirdOrganRela::getThirdOrganId, extOrganIds));
        return organRelas.stream().map(ThirdOrganRela::getOrganId).collect(Collectors.toList());
    }

    @Override
    public Long getPlatformOrganId(String extOrganId) {
        ThirdOrganRela organRela = (ThirdOrganRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)extOrganId)));
        return organRela.getOrganId();
    }
}

