/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.controller;

import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeConvertDto;
import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeCopyDto;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeService;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.LeftTreeAuthVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.LeftTreeFlatVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.NavLeftTreeVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.WidgetVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBase/leftTree"})
public class NavLeftTreeController {
    private final INavLeftTreeService navLeftTreeService;

    @Autowired
    public NavLeftTreeController(INavLeftTreeService navLeftTreeService) {
        this.navLeftTreeService = navLeftTreeService;
    }

    @GetMapping(value={"/filterWidget/list"})
    @ApiOperation(value="\u67e5\u8be2\u7b5b\u9009\u5b57\u6bb5\u5217\u8868")
    public ApiResponse<List<WidgetVo>> listFilterWidget(@RequestParam Long formId) {
        return this.navLeftTreeService.listFilterWidget(formId);
    }

    @GetMapping(value={"/supWidget/list"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7ec4\u4ef6\u7684\u4e0a\u7ea7\u5b57\u6bb5\u5217\u8868")
    public ApiResponse<List<WidgetVo>> listSupWidget(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u5b57\u6bb5\u6807\u8bc6") @RequestParam String widgetName) {
        return this.navLeftTreeService.listSupWidget(formId, widgetName);
    }

    @GetMapping(value={"/init"})
    @ApiOperation(value="\u521d\u59cb\u5316\u5de6\u4fa7\u5bfc\u822a\u6811")
    public ApiResponse<List<NavLeftTreeVo>> initLeftTree(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u89c6\u56feid") @RequestParam String viewId) {
        return this.navLeftTreeService.initLeftTree(formId, viewId);
    }

    @GetMapping(value={"/lazy"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u5de6\u4fa7\u5bfc\u822a\u6811")
    public ApiResponse<List<NavLeftTreeVo>> lazyLoadLeftTree(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u89c6\u56feid") @RequestParam String viewId, @ApiParam(value="\u6811\u8282\u70b9id") @RequestParam Long id) {
        return this.navLeftTreeService.lazyLoadLeftTree(formId, viewId, id);
    }

    @GetMapping(value={"/subNodes/get"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u6240\u6709\u4e0b\u7ea7\u8282\u70b9")
    public ApiResponse<List<LeftTreeFlatVo>> getAllSubNode(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u89c6\u56feid") @RequestParam String viewId, @ApiParam(value="\u6811\u8282\u70b9id") @RequestParam Long id) {
        return this.navLeftTreeService.getAllSubNode(formId, viewId, id);
    }

    @GetMapping(value={"/getLeftTreeAuth"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u5de6\u4fa7\u6811\u6743\u9650")
    public ApiResponse<LeftTreeAuthVo> getLeftTreeAuth(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u89c6\u56feid") @RequestParam String viewId) {
        return this.navLeftTreeService.getLeftTreeAuth(formId, viewId);
    }

    @PostMapping(value={"/copy"})
    @OpControllerAnno
    @ApiOperation(value="\u590d\u5236\u5de6\u4fa7\u6811\u8282\u70b9")
    public ApiResponse<NavLeftTreeVo> copyLeftTreeNode(@RequestBody LeftTreeCopyDto leftTreeCopyDto) {
        return this.navLeftTreeService.copyLeftTreeNode(leftTreeCopyDto);
    }

    @PostMapping(value={"/convert"})
    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u8f6c\u5de6\u4fa7\u6811\u8282\u70b9")
    public ApiResponse<NavLeftTreeVo> convertDataToTreeNode(@RequestBody LeftTreeConvertDto leftTreeConvertDto) {
        return this.navLeftTreeService.convertDataToTreeNode(leftTreeConvertDto);
    }

    @PostMapping(value={"/getBatch"})
    @ApiOperation(value="\u83b7\u53d6\u591a\u4e2a\u8282\u70b9\u7684\u5b50\u8282\u70b9")
    public ApiResponse<NavLeftTreeVo> getAllSubNodeBatch(@RequestBody Map<String, Object> map) {
        return this.navLeftTreeService.getAllSubNodeBatch(map);
    }
}

