/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormSaveDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysTableToFormDto;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysCreateFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.service.DataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.SysTableToFormServiceImpl")
public class SysCreateFormServiceImpl
implements ISysCreateFormService {
    private final Logger LOGGER = LoggerFactory.getLogger(SysCreateFormServiceImpl.class);
    @Resource
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private ISysFormService sysFormService;

    public ApiResponse<String> addFormAndSaveCanvas(SysTableToFormDto sysTableToFormDto) {
        String tableKey = sysTableToFormDto.getKey();
        List sysFormSaveDtos = sysTableToFormDto.getSysFormSaveDtos();
        String key = "createFromCacheKey_" + UUID.randomUUID();
        for (SysFormSaveDto formSaveDto : sysFormSaveDtos) {
            formSaveDto.setCreateSource("1");
        }
        this.sysUserTableNameService.activation(tableKey);
        this.dealAddFormAndSaveCanvas(sysFormSaveDtos, key, tableKey);
        return ApiResponse.success((Object)key, (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealAddFormAndSaveCanvas(List<SysFormSaveDto> sysFormSaveDto, String key, String tableKey) {
        String dataSourceKey;
        try {
            Long usr = BaseSecurityUtil.getUser().getId();
            String dataSourceName = NoCodeBusinessDB.getNocodeBusinessDB();
            String dataSourceKey2 = String.format("DATASOURCE_NAME_CACHE_KEY_%s", NoCodeBusinessDB.getNocodeBusinessDB());
            List dataSourceList = this.dataSourceService.getDataSourceList();
            DatasourceConfigDTO datasourceConfig = null;
            for (DatasourceConfigDTO datasourceConfigDTO : dataSourceList) {
                if (!HussarUtils.equals((Object)datasourceConfigDTO.getName(), (Object)dataSourceName)) continue;
                datasourceConfig = datasourceConfigDTO;
            }
            TransmittableThreadLocalHolder.set((String)dataSourceKey2, datasourceConfig);
            TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            dataSourceKey = DataModelUtil.currentDsName();
            try {
                DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
            }
            catch (IOException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.sysUserTableNameService.createdFail(tableKey, dataSourceKey);
        }
        dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            try {
                RequestContextHolder.resetRequestAttributes();
                this.sysFormService.dealTableToForm(sysFormSaveDto, key, tableKey, dataSourceKey);
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.sysUserTableNameService.createdFail(tableKey, dataSourceKey);
            }
        });
    }
}

