/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.form.service.IRenewCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpm/checkConfig"})
public class RenewCheckConfigController {
    private Logger logger = LoggerFactory.getLogger(RenewCheckConfigController.class);
    @Autowired
    private IRenewCheckConfigService renewCheckConfigService;
    @Autowired
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @PostMapping(value={"/renew"})
    public String renewCheckConfig(@RequestParam(required=false) String formId) {
        List flowFormCheckConfigList = this.sysFormCheckConfigService.getFlowFormCheckConfigList(formId);
        int count = flowFormCheckConfigList.size();
        this.logger.info("\u9700\u8981\u5904\u7406\u7684\u8868\u5355\u6570\u91cf\uff1a{}", (Object)count);
        AtomicInteger emptyConfigCount = new AtomicInteger();
        AtomicInteger dealCount = new AtomicInteger();
        AtomicInteger notExistCanvas = new AtomicInteger();
        AtomicInteger failCount = new AtomicInteger();
        ArrayList failFormIds = new ArrayList();
        flowFormCheckConfigList.forEach(sysFormCheckConfig -> {
            FormDesignResponse formCanvasSchemaResponse = this.canvasSchemaService.get(String.valueOf(sysFormCheckConfig.getFormId()));
            if (HussarUtils.isNotEmpty((Object)formCanvasSchemaResponse.getData())) {
                String identity = ((FormCanvasSchema)formCanvasSchemaResponse.getData()).getIdentity();
                String checkConfig = sysFormCheckConfig.getCheckConfig();
                JSONArray checkConfigs = JSONObject.parseArray((String)checkConfig);
                if (checkConfigs.size() > 0) {
                    try {
                        this.renewCheckConfigService.renewCheckConfig(identity, checkConfigs);
                        dealCount.incrementAndGet();
                    }
                    catch (Exception e) {
                        failCount.incrementAndGet();
                        failFormIds.add(((FormCanvasSchema)formCanvasSchemaResponse.getData()).getId());
                        this.logger.warn("\u63d0\u4ea4\u6821\u9a8c-\u8868\u5355\u5237\u65b0\u5931\u8d25\uff0cformId: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)((FormCanvasSchema)formCanvasSchemaResponse.getData()).getId(), (Object)e.getMessage());
                    }
                } else {
                    emptyConfigCount.incrementAndGet();
                }
            } else {
                notExistCanvas.incrementAndGet();
            }
        });
        String result = String.format("\u603b\u6570\u91cf\uff1a%s, \u5b8c\u6210\u6570\u91cf\uff1a%s, \u7a7a\u914d\u7f6e\u6570\u91cf\uff1a%s, \u672a\u627e\u5230\u753b\u5e03\u6570\u91cf: %s, \u5931\u8d25\u6570\u91cf\uff1a%s, \u5931\u8d25formIds: %s", count, dealCount, emptyConfigCount, notExistCanvas, failCount, CollectionUtil.join(failFormIds, (CharSequence)","));
        this.logger.info(result);
        return result;
    }
}

