/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.formdesign.application.data.dto.FormMapDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPushConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.TestUrlDto;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.HttpDoPostResponse;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushRecord;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarPush/data"})
public class PushDataController {
    private final PushDataService pushDataService;
    private final PushDataRecordService pushDataRecordService;
    private final FormMapService formMapService;

    @Autowired
    public PushDataController(PushDataService pushDataService, PushDataRecordService pushDataRecordService, FormMapService formMapService) {
        this.pushDataService = pushDataService;
        this.pushDataRecordService = pushDataRecordService;
        this.formMapService = formMapService;
    }

    @ApiOperation(value="\u4fdd\u5b58\u914d\u7f6e")
    @PostMapping(value={"/save"})
    public ApiResponse<Void> save(@RequestBody SysDataPushConfigDto sysDataPushConfigDto) {
        return this.pushDataService.saveConfig(sysDataPushConfigDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @GetMapping(value={"/list"})
    public ApiResponse<List<SysDataPushConfig>> list(@RequestParam String formId) {
        return this.pushDataService.getConfigList(formId);
    }

    @ApiOperation(value="\u6309 ID \u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ApiResponse<SysDataPushConfig> getById(@PathVariable Long id) {
        return ApiResponse.success((Object)this.pushDataService.getById((Serializable)id));
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public ApiResponse<Void> edit(@RequestBody SysDataPushConfigDto sysDataPushConfigDto) {
        return this.pushDataService.editConfig(sysDataPushConfigDto);
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestParam Long id) {
        return this.pushDataService.deleteConfig(id);
    }

    @ApiOperation(value="\u590d\u5236")
    @PostMapping(value={"/copy"})
    public ApiResponse<Void> copy(@RequestParam Long id) {
        return this.pushDataService.copy(id);
    }

    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @PostMapping(value={"/status"})
    public ApiResponse<Void> status(@RequestBody SysDataPushConfigDto sysDataPushConfigDto) {
        return this.pushDataService.status(sysDataPushConfigDto);
    }

    @ApiOperation(value="\u670d\u52a1\u5668\u8fde\u901a\u6027\u6d4b\u8bd5")
    @PostMapping(value={"/connection"})
    public ApiResponse<HttpDoPostResponse> connection(@RequestBody TestUrlDto testUrlDto) throws IOException {
        return this.pushDataService.connection(testUrlDto);
    }

    @ApiOperation(value="\u65e5\u5fd7\u67e5\u8be2")
    @GetMapping(value={"/record"})
    public ApiResponse<Page<SysDataPushRecord>> getRecord(@RequestParam(value="pushId") String pushId, @RequestParam(value="size", required=false, defaultValue="10") int size, @RequestParam(value="current", required=false, defaultValue="1") int current, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="success", required=false) String success) {
        return ApiResponse.success((Object)this.pushDataRecordService.getRecord(pushId, current, size, startTime, endTime, success));
    }

    @ApiOperation(value="\u8868\u5355\u5168\u5c40\u6620\u5c04\u4fdd\u5b58")
    @PostMapping(value={"/saveFormMap"})
    public ApiResponse<Void> saveFormMap(@RequestBody FormMapDto formMapDto) {
        return this.formMapService.saveFormMap(formMapDto);
    }

    @ApiOperation(value="\u8868\u5355\u5168\u5c40\u6620\u5c04\u83b7\u53d6")
    @GetMapping(value={"/getFormMap"})
    public ApiResponse<FormMap> getFormMap(@RequestParam(value="formId") String formId) {
        return ApiResponse.success((Object)this.formMapService.getFormMap(formId));
    }

    @ApiOperation(value="\u6570\u636e\u63a8\u9001\u63a5\u53d7\u6d4b\u8bd5")
    @PostMapping(value={"/test"})
    public ApiResponse<HashMap> test(@RequestBody HashMap map) {
        this.pushDataService.test(map, 1);
        return ApiResponse.success((Object)map);
    }

    @ApiOperation(value="\u6570\u636e\u63a8\u9001\u63a5\u53d7\u6d4b\u8bd5")
    @PostMapping(value={"/testTwo"})
    public ApiResponse<HashMap> testTwo(@RequestBody HashMap map) {
        this.pushDataService.test(map, 2);
        return ApiResponse.success((Object)map);
    }
}

