/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.config;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.port}")
    private int redisPort;
    @Value(value="${spring.redis.password}")
    private String redisPassword;
    @Value(value="${spring.redis.database}")
    private int redisDatabase;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + this.redisHost + ":" + this.redisPort).setDatabase(this.redisDatabase);
        if (HussarUtils.isNotEmpty((Object)this.redisPassword)) {
            config.useSingleServer().setPassword(this.redisPassword);
        }
        return Redisson.create((Config)config);
    }
}

