/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormServiceImpl;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitRoleButtonServiceImpl")
public class SysAppVisitRoleButtonServiceImpl
extends HussarServiceImpl<SysAppVisitRoleButtonMapper, SysAppVisitRoleButton>
implements ISysAppVisitRoleButtonService {
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysFormServiceImpl sysFormServiceImpl;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    private static Logger logger = LoggerFactory.getLogger(SysAppVisitRoleButtonServiceImpl.class);

    public ApiResponse<Boolean> addButtonAuthorityRoles(ButtonAuthoritiesDto buttonAuthoritiesDto) {
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)buttonAuthoritiesDto.getFormId())).eq(SysAppVisitRoleButton::getRoleId, (Object)buttonAuthoritiesDto.getRoleId()));
        ArrayList<SysAppVisitRoleButton> sysAppVisitRoleButtons = new ArrayList<SysAppVisitRoleButton>();
        List buttonDtoList = buttonAuthoritiesDto.getButtonDtoList();
        for (ButtonDto buttonDto : buttonDtoList) {
            SysAppVisitRoleButton sysAppVisitRoleButton = new SysAppVisitRoleButton();
            sysAppVisitRoleButton.setAppId(buttonAuthoritiesDto.getAppId());
            sysAppVisitRoleButton.setRoleId(buttonAuthoritiesDto.getRoleId());
            sysAppVisitRoleButton.setFormId(buttonAuthoritiesDto.getFormId());
            sysAppVisitRoleButton.setButtonName(buttonDto.getButtonName());
            sysAppVisitRoleButton.setButtonCode(buttonDto.getButtonCode());
            sysAppVisitRoleButtons.add(sysAppVisitRoleButton);
        }
        return ApiResponse.success((Object)this.saveBatch(sysAppVisitRoleButtons));
    }

    @HussarTransactional
    public void saveBatchButtonAuthority(List<ButtonAuthoritiesDto> buttonAuthoritiesDto, boolean isForm) {
        if (HussarUtils.isEmpty(buttonAuthoritiesDto)) {
            return;
        }
        Long appId = buttonAuthoritiesDto.get(0).getAppId();
        Long roleId = buttonAuthoritiesDto.get(0).getRoleId();
        Long formId = buttonAuthoritiesDto.get(0).getFormId();
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId)).eq(!isForm, SysAppVisitRoleButton::getRoleId, (Object)roleId)).eq(isForm, SysAppVisitRoleButton::getFormId, (Object)formId));
        ArrayList sysAppVisitRoleButtons = new ArrayList();
        buttonAuthoritiesDto.forEach(authoritiesDto -> {
            List buttonDtoList = authoritiesDto.getButtonDtoList();
            buttonDtoList.forEach(buttonDto -> {
                SysAppVisitRoleButton sysAppVisitRoleButton = new SysAppVisitRoleButton();
                sysAppVisitRoleButton.setAppId(appId);
                sysAppVisitRoleButton.setRoleId(authoritiesDto.getRoleId());
                sysAppVisitRoleButton.setFormId(authoritiesDto.getFormId());
                sysAppVisitRoleButton.setButtonName(buttonDto.getButtonName());
                sysAppVisitRoleButton.setButtonCode(buttonDto.getButtonCode());
                sysAppVisitRoleButtons.add(sysAppVisitRoleButton);
            });
        });
        if (HussarUtils.isNotEmpty(sysAppVisitRoleButtons)) {
            this.saveBatch(sysAppVisitRoleButtons);
        }
    }

    public ApiResponse<List<ButtonVo>> getButtonAuthorityRolesList(Long formId, Long roleId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysAppVisitRoleButton::getFormId, (Object)formId);
        ew.eq(SysAppVisitRoleButton::getRoleId, (Object)roleId);
        List roleButtonList = this.list((Wrapper)ew);
        ArrayList<ButtonVo> buttonVos = new ArrayList<ButtonVo>();
        for (SysAppVisitRoleButton sysAppVisitRoleButton : roleButtonList) {
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysAppVisitRoleButton.getButtonCode());
            buttonVo.setButtonName(sysAppVisitRoleButton.getButtonName());
            buttonVos.add(buttonVo);
        }
        return ApiResponse.success(buttonVos);
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId, List<SysCustomButton> customButtonList) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)shiroUser)) {
                shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
            }
            logger.info("\u7528\u6237\u4fe1\u606f; userId: {}\uff0cuserName: {}\uff0cformId: {}", new Object[]{shiroUser.getId(), shiroUser.getName(), formId});
            List rolesList = shiroUser.getRolesList();
            logger.info("\u7528\u6237\u4fe1\u606f\uff1brolesList\uff1a{}", (Object)rolesList.toString());
            if (HussarUtils.isNotEmpty((Object)shiroUser)) {
                SysForm sysForm = (SysForm)this.sysFormMapper.selectById(formId);
                AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
                Long appId = sysForm.getAppId();
                SysApplication appDetail = (SysApplication)this.sysApplicationMapper.selectById(appId);
                AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
                Long developRoleId = appDetail.getDevelopRoleId();
                if (shiroUser.isSuperAdmin() || rolesList.contains(developRoleId) || rolesList.contains(TenantConstant.ADMIN_ROLE)) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
                    this.sysFormService.sysCreateButton(buttonAuthoritiesDto, sysForm.getFormType());
                    List sysButtonList = buttonAuthoritiesDto.getButtonDtoList();
                    for (ButtonDto buttonDto : sysButtonList) {
                        result.add(BeanUtil.copy((Object)buttonDto, ButtonVo.class));
                    }
                    for (SysCustomButton customButton : customButtonList) {
                        ButtonVo buttonVo = new ButtonVo();
                        buttonVo.setButtonCode(customButton.getAction());
                        buttonVo.setButtonName(customButton.getAlias());
                        result.add(buttonVo);
                    }
                    return ApiResponse.success(result);
                }
                if (HussarUtils.isNotEmpty((Object)rolesList)) {
                    return ApiResponse.success(this.sysAppVisitRoleButtonMapper.selectByFromId(formId, rolesList));
                }
            }
            return ApiResponse.success();
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)shiroUser)) {
                shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
            }
            List rolesList = shiroUser.getRolesList();
            if (HussarUtils.isNotEmpty((Object)shiroUser)) {
                SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
                AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
                Long appId = sysForm.getAppId();
                SysApplication appDetail = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
                AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
                Long developRoleId = appDetail.getDevelopRoleId();
                if (shiroUser.isSuperAdmin() || rolesList.contains(developRoleId) || rolesList.contains(TenantConstant.ADMIN_ROLE)) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
                    this.sysFormService.sysCreateButton(buttonAuthoritiesDto, sysForm.getFormType());
                    List sysButtonList = buttonAuthoritiesDto.getButtonDtoList();
                    for (ButtonDto buttonDto : sysButtonList) {
                        result.add(BeanUtil.copy((Object)buttonDto, ButtonVo.class));
                    }
                    List customButtonList = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
                    for (SysCustomButton customButton : customButtonList) {
                        ButtonVo buttonVo = new ButtonVo();
                        buttonVo.setButtonCode(customButton.getAction());
                        buttonVo.setButtonName(customButton.getAlias());
                        result.add(buttonVo);
                    }
                    return ApiResponse.success(result);
                }
                if (HussarUtils.isNotEmpty((Object)rolesList)) {
                    return ApiResponse.success(this.sysAppVisitRoleButtonMapper.selectByFromId(formId, rolesList));
                }
            }
            return ApiResponse.success();
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public Map<Long, List<ButtonVo>> listButtonAuthorityByAppId(Long appId, Long roleId) {
        HashMap<Long, List<ButtonVo>> buttonAuthorityVoMap = new HashMap<Long, List<ButtonVo>>();
        List roleButtonList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
        Map<Long, List<SysAppVisitRoleButton>> buttonAuthorityGroup = roleButtonList.stream().collect(Collectors.groupingBy(SysAppVisitRoleButton::getFormId));
        List sysFormList = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        Map customButtonGroup = this.sysCustomButtonService.listCustomButtonByAppId(appId);
        for (SysForm sysForm : sysFormList) {
            String formType = sysForm.getFormType();
            ArrayList buttonVos = new ArrayList();
            buttonAuthorityVoMap.put(sysForm.getId(), buttonVos);
            List authorizedButtonActions = ((List)Optional.ofNullable(buttonAuthorityGroup.get(sysForm.getId())).orElse(new ArrayList())).stream().map(SysAppVisitRoleButton::getButtonCode).collect(Collectors.toList());
            ButtonAuthoritiesDto sysButtonAuthoritiesDto = new ButtonAuthoritiesDto();
            this.sysFormServiceImpl.sysCreateButton(sysButtonAuthoritiesDto, formType);
            List buttonDtoList = sysButtonAuthoritiesDto.getButtonDtoList();
            int index = 0;
            for (ButtonDto buttonDto2 : buttonDtoList) {
                String buttonCode = buttonDto2.getButtonCode();
                if (!buttonCode.equals("batchPrint")) continue;
                index = buttonDtoList.indexOf(buttonDto2);
            }
            if (index != -1) {
                buttonDtoList.remove(index);
            }
            List sysButtonAuthorities = sysButtonAuthoritiesDto.getButtonDtoList().stream().map(buttonDto -> {
                ButtonVo buttonVo = new ButtonVo();
                buttonVo.setButtonCode(buttonDto.getButtonCode());
                buttonVo.setButtonName(buttonDto.getButtonName());
                buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
                return buttonVo;
            }).collect(Collectors.toList());
            List customButtons = Optional.ofNullable(customButtonGroup.get(sysForm.getId())).orElse(new ArrayList());
            List customButtonAuthorities = customButtons.stream().map(customButton -> {
                ButtonVo buttonVo = new ButtonVo();
                buttonVo.setButtonCode(customButton.getAction());
                buttonVo.setButtonName(customButton.getAlias());
                buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
                return buttonVo;
            }).collect(Collectors.toList());
            buttonVos.clear();
            buttonVos.addAll(sysButtonAuthorities);
            buttonVos.addAll(customButtonAuthorities);
        }
        return buttonAuthorityVoMap;
    }

    public List<SysAppVisitRoleButton> listButtonAuthorized(Long appId, Long formId, Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysAppVisitRoleButton::getAppId, (Object)appId)).eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitRoleButton::getFormId, (Object)formId)).eq(HussarUtils.isNotEmpty((Object)roleId), SysAppVisitRoleButton::getRoleId, (Object)roleId);
        return this.list((Wrapper)queryWrapper);
    }
}

