/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppTemplateAttachmentMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppTemplateGroupMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppTemplateManageMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppTemplateManageDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppTemplateManageOnlineDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppTemplate;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppTemplateAttachment;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppTemplateManageService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppTemplateGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppTemplateVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.util.RestTemplateHttpUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppTemplateManageServiceImpl")
public class AppTemplateManageServiceImpl
extends HussarServiceImpl<SysAppTemplateManageMapper, SysAppTemplate>
implements IAppTemplateManageService,
InitializingBean {
    @Value(value="${hussar-formdesign.workspace}")
    private String workspace;
    private String templateFilePath;
    private String templateFileTempPath;
    @Value(value="${hussar.nocode.application-template.queryPageOnline:}")
    private String queryPageOnline;
    @Value(value="${hussar.nocode.application-template.queryTypeOnline:}")
    private String queryTypeOnline;
    @Value(value="${hussar.nocode.application-template.queryDetailOnline:}")
    private String queryDetailOnline;
    @Value(value="${hussar.nocode.application-template.downloadHussarOnline:}")
    private String downloadHussarOnline;
    @Value(value="${hussar.nocode.application-template.queryRecommendedTemplateListOnline:}")
    private String queryRecommendedTemplateListOnline;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${hussar.nocode.application-template.staticResourceUrl:hussarApi/hussarBase/application/appTempManage/getAttachment/}")
    private String staticResourceUrlValue;
    @Value(value="${hussar.nocode.public.frontIp:}")
    private String frontIp;
    private String staticResourceUrl;
    private static final String WRITE_SUFFIX_TYPE = "jpg,jpeg,png,gif";
    @Resource
    private SysAppTemplateManageMapper sysAppTemplateManageMapper;
    @Resource
    private SysAppTemplateAttachmentMapper sysAppTemplateAttachmentMapper;
    @Resource
    private SysAppTemplateGroupMapper sysAppTemplateGroupMapper;
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IAppImportService appImportService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppTemplateManageServiceImpl.class);

    public IPage<SysAppTemplateVo> getTemplateList(AppTemplateManageDto appTemplateManageDto, HttpServletRequest request) {
        Page page = new Page(appTemplateManageDto.getCurrent(), appTemplateManageDto.getSize());
        IPage<SysAppTemplateVo> pageVo = this.sysAppTemplateManageMapper.getAppListTemp((Page<SysAppTemplateVo>)page, appTemplateManageDto.getTemplateProfessionId(), appTemplateManageDto.getTemplateName(), appTemplateManageDto.getReleaseStatus());
        if (HussarUtils.isNotEmpty(pageVo)) {
            List apps = pageVo.getRecords();
            for (SysAppTemplateVo app : apps) {
                app.setThumbnail(this.staticResourceUrl + app.getThumbnail());
            }
        }
        return pageVo;
    }

    public IPage<SysAppTemplateVo> getManagementTemplateList(AppTemplateManageDto appTemplateManageDto, HttpServletRequest request) {
        Page page = new Page(appTemplateManageDto.getCurrent(), appTemplateManageDto.getSize());
        IPage<SysAppTemplateVo> pageVo = this.sysAppTemplateManageMapper.getAppListTemp((Page<SysAppTemplateVo>)page, appTemplateManageDto.getTemplateProfessionId(), appTemplateManageDto.getTemplateName(), appTemplateManageDto.getReleaseStatus());
        return pageVo;
    }

    public IPage<SysAppTemplateVo> getTemplateListByInstallNum(AppTemplateManageDto appInfo, HttpServletRequest request) {
        Page page = new Page(appInfo.getCurrent(), appInfo.getSize());
        IPage<SysAppTemplateVo> pageVo = this.sysAppTemplateManageMapper.listByInstallNum((Page<SysAppTemplateVo>)page, appInfo.getTemplateProfessionId(), appInfo.getTemplateName(), appInfo.getReleaseStatus());
        String Tcode = request.getHeader("Tcode");
        if (HussarUtils.isNotEmpty(pageVo)) {
            List apps = pageVo.getRecords();
            for (SysAppTemplateVo app : apps) {
                if (HussarUtils.isNotEmpty((Object)Tcode)) {
                    app.setThumbnail(this.staticResourceUrl + app.getThumbnail() + "?tcode=" + Tcode);
                    continue;
                }
                app.setThumbnail(this.staticResourceUrl + app.getThumbnail());
            }
        }
        return pageVo;
    }

    public SysAppTemplateVo getAppDetail(HttpServletRequest request, Map<String, String> map) {
        SysAppTemplateVo sysAppTemplateVo = new SysAppTemplateVo();
        Long appId = Long.parseLong(map.get("templateId"));
        if ("1".equals(map.get("type"))) {
            SysAppTemplate sysAppTemplate = (SysAppTemplate)this.sysAppTemplateManageMapper.selectById(appId);
            sysAppTemplate.setViewNumbs(sysAppTemplate.getViewNumbs() + 1);
            this.sysAppTemplateManageMapper.updateById(sysAppTemplate);
        }
        if (HussarUtils.isNotEmpty((Object)(sysAppTemplateVo = this.sysAppTemplateManageMapper.getAppDetailTemp(appId)))) {
            List<Object> attachments = Lists.newArrayListWithCapacity((int)4);
            ArrayList attachments1 = Lists.newArrayListWithCapacity((int)4);
            List<Object> appPicture = Lists.newArrayListWithCapacity((int)4);
            String thumbnails = "";
            List<Object> pcPictures = Lists.newArrayListWithCapacity((int)4);
            List<Object> mobilePictures = Lists.newArrayListWithCapacity((int)4);
            attachments = this.sysAppTemplateAttachmentMapper.getAttachmentsByAppId(sysAppTemplateVo.getTemplateId());
            attachments.forEach(attachment -> {
                if (HussarUtils.isNotEmpty((Object)attachment.getFilePath())) {
                    String tenantParam = attachment.getFilePath();
                    tenantParam = this.checkTemplatePath(tenantParam);
                    attachment.setFilePath(tenantParam);
                }
            });
            appPicture = attachments.stream().filter(SysAppTemplateAttachment2 -> SysAppTemplateAttachment2.getFileType() == 1).collect(Collectors.toList()).stream().map(SysAppTemplateAttachment::getFilePath).collect(Collectors.toList());
            String tcode = request.getHeader("Tcode");
            String tenantParam = "";
            if (HussarUtils.isNotEmpty((Object)tcode)) {
                tenantParam = "?tcode=" + tcode;
            }
            String finalTenantParam = tenantParam;
            attachments.stream().filter(SysAppTemplateAttachment2 -> SysAppTemplateAttachment2.getFileType() != 0).collect(Collectors.toList()).stream().forEach(SysAppTemplateAttachmentVo2 -> SysAppTemplateAttachmentVo2.setFilePath(this.staticResourceUrl + SysAppTemplateAttachmentVo2.getAttachmentId() + File.separator + this.getFileNameByFilePath(SysAppTemplateAttachmentVo2.getFilePath()) + finalTenantParam));
            thumbnails = (String)attachments.stream().filter(SysAppTemplateAttachment2 -> SysAppTemplateAttachment2.getFileType() == 2).collect(Collectors.toList()).stream().map(SysAppTemplateAttachment::getFilePath).collect(Collectors.toList()).get(0);
            pcPictures = attachments.stream().filter(SysAppTemplateAttachment2 -> SysAppTemplateAttachment2.getFileType() == 3).collect(Collectors.toList()).stream().sorted(Comparator.comparing(SysAppTemplateAttachment::getFileSeq)).collect(Collectors.toList()).stream().map(SysAppTemplateAttachment::getFilePath).collect(Collectors.toList());
            mobilePictures = attachments.stream().filter(SysAppTemplateAttachment2 -> SysAppTemplateAttachment2.getFileType() == 4).collect(Collectors.toList()).stream().sorted(Comparator.comparing(SysAppTemplateAttachment::getFileSeq)).collect(Collectors.toList()).stream().map(SysAppTemplateAttachment::getFilePath).collect(Collectors.toList());
            sysAppTemplateVo.setAppPicture((List)appPicture);
            sysAppTemplateVo.setThumbnail(thumbnails);
            sysAppTemplateVo.setPcPictures((List)pcPictures);
            sysAppTemplateVo.setMobilePictures((List)mobilePictures);
        }
        return sysAppTemplateVo;
    }

    @HussarTransactional
    public Boolean deleteTemplateById(AppTemplateManageDto appInfo) {
        List templateIds = appInfo.getTemplateIds();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)templateIds)) {
            queryWrapper.in(SysAppTemplate::getTemplateId, (Collection)templateIds);
        }
        boolean removeFlag = this.remove((Wrapper)queryWrapper);
        templateIds.forEach(templateId -> {
            String applicationFilesPath = this.templateFilePath + File.separator + templateId;
            File applicationFileDirectory = new File(applicationFilesPath);
            this.deleteFiles(applicationFileDirectory);
        });
        return removeFlag;
    }

    public Boolean updateReleaseStatus(AppTemplateManageDto appInfo) {
        SysAppTemplate sysAppTemplate = (SysAppTemplate)this.sysAppTemplateManageMapper.selectById(appInfo.getTemplateId());
        String releaseStatus = "1".equals(sysAppTemplate.getReleaseStatus()) ? "0" : "1";
        SysAppTemplate sysAppTemplateUp = new SysAppTemplate();
        sysAppTemplateUp.setTemplateId(appInfo.getTemplateId());
        sysAppTemplateUp.setReleaseStatus(releaseStatus);
        sysAppTemplateUp.setInstalledNumbs(sysAppTemplate.getInstalledNumbs());
        sysAppTemplateUp.setViewNumbs(sysAppTemplate.getViewNumbs());
        return this.updateById((BaseEntity)sysAppTemplateUp);
    }

    public List<SysAppGroupVo> getAppGroupList() {
        List sysAppGroups = Lists.newArrayListWithCapacity((int)4);
        ArrayList sysAppGroupVos = Lists.newArrayListWithCapacity((int)10);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        sysAppGroups = this.sysAppGroupService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysAppGroups)) {
            for (SysAppGroup sysAppGroup : sysAppGroups) {
                SysAppGroupVo sysAppGroupVo = new SysAppGroupVo();
                BeanUtils.copyProperties((Object)sysAppGroup, (Object)sysAppGroupVo);
                sysAppGroupVos.add(sysAppGroupVo);
            }
        }
        return sysAppGroupVos;
    }

    public void installApp(AppTemplateManageDto appInfo) throws Exception {
        AppImportDto appImportDto = new AppImportDto();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("APP_ID", appInfo.getTemplateId());
        paramMap.put("FILE_TYPE", "1");
        List templatePathList = this.sysAppTemplateAttachmentMapper.selectByMap(paramMap);
        String templatePath = ((SysAppTemplateAttachment)templatePathList.get(0)).getFilePath();
        templatePath = this.checkTemplatePath(templatePath);
        appImportDto.setHussarTemplatePath(templatePath);
        appImportDto.setAppName(appInfo.getTemplateName());
        appImportDto.setAppGroupId(appInfo.getGroupId());
        appImportDto.setAppIcon(appInfo.getTemplateIcon());
        appImportDto.setExportRoleFlag(appInfo.getExportRoleFlag().booleanValue());
        appImportDto.setAppIconType(appInfo.getTemplateIconType());
        appImportDto.setAppIconColor(appInfo.getTemplateIconColor());
        try {
            this.importAppForTemplateInstall(appImportDto);
            SysAppTemplate sysAppTemplate = (SysAppTemplate)this.sysAppTemplateManageMapper.selectById(appInfo.getTemplateId());
            sysAppTemplate.setInstalledNumbs(sysAppTemplate.getInstalledNumbs() + 1);
            this.sysAppTemplateManageMapper.updateById(sysAppTemplate);
        }
        catch (Exception e) {
            LOGGER.error("\u5b89\u88c5\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BaseException("\u5b89\u88c5\u5e94\u7528\u5931\u8d25\uff01");
        }
    }

    public void getAttachmentById(Long attachmentId, String fileName, HttpServletResponse response) {
        SysAppTemplateAttachment sysAppTemplateAttachment = new SysAppTemplateAttachment();
        if (HussarUtils.isEmpty((Object)attachmentId)) {
            ApiResponse.fail((String)"\u9644\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysAppTemplateAttachment = this.sysAppTemplateAttachmentMapper.getAttachmentById(attachmentId);
        File file = null;
        OutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            if (HussarUtils.isNotEmpty((Object)sysAppTemplateAttachment)) {
                String filePath = sysAppTemplateAttachment.getFilePath();
                filePath = this.checkTemplatePath(filePath);
                file = new File(filePath);
                inputStream = new FileInputStream(filePath);
                if (file.exists()) {
                    response.setContentType("image/jpeg");
                    response.setCharacterEncoding("utf-8");
                    outputStream = response.getOutputStream();
                    int len = 0;
                    byte[] buffer = new byte[1024];
                    while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u91ca\u653e\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u91ca\u653e\u8f93\u51fa\u6d41\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    private String getFileNameByFilePath(String filePath) {
        int subNums = filePath.lastIndexOf(File.separator);
        String fileName = filePath.substring(subNums + 1);
        return fileName;
    }

    private List<SysAppTemplateGroupVo> combinedData(List<SysAppTemplateVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppTemplateGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, SysAppTemplateGroupVo2 -> SysAppTemplateGroupVo2, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysAppTemplateVo sysApplication : appList) {
            SysAppTemplateGroupVo sysAppTemplateGroupVo = (SysAppTemplateGroupVo)resultCollect.get(sysApplication.getTemplateId());
            if (HussarUtils.isEmpty((Object)sysAppTemplateGroupVo)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppTemplateGroupVo.getSysApplicationList())) {
                sysAppTemplateGroupVo.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppTemplateGroupVo.getSysApplicationList())) continue;
            ArrayList<SysAppTemplateVo> sysApplicationList = new ArrayList<SysAppTemplateVo>();
            sysApplicationList.add(sysApplication);
            sysAppTemplateGroupVo.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppTemplateGroupVo>(resultCollect.values());
    }

    @HussarTransactional
    public ApiResponse<Boolean> saveAppTemplate(HttpServletRequest request) throws IOException {
        try {
            Map<String, String> paramMap = this.validParam(request);
            if (paramMap == null || paramMap.size() == 0) {
                LOGGER.error("\u5e94\u7528\u6a21\u677f\u65b0\u589e\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return ApiResponse.fail((String)"\u5e94\u7528\u6a21\u677f\u65b0\u589e\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            boolean validFilesResult = this.validFiles(multipartHttpServletRequest);
            if (!validFilesResult) {
                LOGGER.error("\u5e94\u7528\u6a21\u677f\u65b0\u589e\u7684\u6587\u4ef6\u6570\u91cf\u4e0d\u5408\u6cd5\u6216\u8005\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
                return ApiResponse.fail((String)"\u5e94\u7528\u6a21\u677f\u65b0\u589e\u7684\u6587\u4ef6\u6570\u91cf\u4e0d\u5408\u6cd5\u6216\u8005\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
            }
            String applicationFileParamPath = "";
            MultipartFile applicationFile = ((MultipartHttpServletRequest)request).getFile("applicationFile");
            if (HussarUtils.isNotEmpty((Object)applicationFile)) {
                applicationFileParamPath = applicationFile.getOriginalFilename();
            }
            String applicationFileTempPath = null;
            boolean applicationFileBoolean = false;
            String operation = paramMap.get("operation");
            SecurityUser user = BaseSecurityUtil.getUser();
            SysAppTemplate sysAppTemplate = new SysAppTemplate();
            sysAppTemplate.setTemplateCode("");
            sysAppTemplate.setTemplateDescribe(paramMap.get("appTemplateDesc"));
            sysAppTemplate.setTemplateName(paramMap.get("appTemplateName"));
            sysAppTemplate.setTemplateIcon(paramMap.get("appTemplateIcon"));
            sysAppTemplate.setUseType(paramMap.get("useType"));
            sysAppTemplate.setTemplateStatus("1");
            sysAppTemplate.setReleaseStatus("1");
            sysAppTemplate.setTemplateProfessionId(Long.valueOf(paramMap.get("templateProfessionId")));
            sysAppTemplate.setCreator(user.getUserId());
            sysAppTemplate.setCreatorName(user.getUserName());
            sysAppTemplate.setLastEditor(user.getUserId());
            LocalDateTime localDateTime = LocalDateTime.now();
            sysAppTemplate.setCreateTime(localDateTime);
            sysAppTemplate.setLastTime(localDateTime);
            sysAppTemplate.setTemplateIconType(paramMap.get("templateIconType"));
            sysAppTemplate.setTemplateIconColor(paramMap.get("templateIconColor"));
            Long appTemplateId = null;
            if ("1".equals(operation)) {
                int insertNum = this.sysAppTemplateManageMapper.insert(sysAppTemplate);
                if (insertNum == 1) {
                    appTemplateId = sysAppTemplate.getTemplateId();
                    Map<String, Object> filePaths = this.saveTemplateAttachmentFiles(multipartHttpServletRequest, appTemplateId, applicationFileBoolean, applicationFileParamPath, applicationFileTempPath);
                    ArrayList<SysAppTemplateAttachment> attachments = new ArrayList<SysAppTemplateAttachment>();
                    String applicationFilePath = (String)filePaths.get("applicationFilePath");
                    if (applicationFileBoolean) {
                        applicationFilePath = applicationFileParamPath;
                    }
                    if (HussarUtils.isNotEmpty((Object)applicationFilePath)) {
                        SysAppTemplateAttachment fileAttachment = this.getAppTemplateAttachment(appTemplateId, 1, applicationFilePath, 0);
                        attachments.add(fileAttachment);
                    }
                    String thumnailFilePath = (String)filePaths.get("thumbnailFilePath");
                    SysAppTemplateAttachment thumnailAttachment = this.getAppTemplateAttachment(appTemplateId, 2, thumnailFilePath, 0);
                    attachments.add(thumnailAttachment);
                    List pcFilePaths = (List)filePaths.get("pcFilesPath");
                    for (int i = 0; i < pcFilePaths.size(); ++i) {
                        SysAppTemplateAttachment pcAttachment = this.getAppTemplateAttachment(appTemplateId, 3, ((String)pcFilePaths.get(i)).toString(), i);
                        attachments.add(pcAttachment);
                    }
                    List mobileFilePaths = (List)filePaths.get("mobileFilesPath");
                    for (int i = 0; i < mobileFilePaths.size(); ++i) {
                        SysAppTemplateAttachment mobileAttachment = this.getAppTemplateAttachment(appTemplateId, 4, ((String)mobileFilePaths.get(i)).toString(), i);
                        attachments.add(mobileAttachment);
                    }
                    attachments.forEach(sysAppTemplateAttachment -> this.sysAppTemplateAttachmentMapper.insert(sysAppTemplateAttachment));
                    return ApiResponse.success((String)"\u5e94\u7528\u6a21\u677f\u65b0\u5efa\u6210\u529f");
                }
                return ApiResponse.fail((String)"\u5e94\u7528\u6a21\u677f\u65b0\u589e\u6267\u884c\u6570\u636e\u5e93\u62a5\u9519");
            }
            if ("2".equals(operation)) {
                appTemplateId = Long.valueOf(request.getParameter("appTemplateId"));
                if (HussarUtils.isNotEmpty((Object)appTemplateId)) {
                    sysAppTemplate.setTemplateId(appTemplateId);
                    SysAppTemplate appTemplate = (SysAppTemplate)this.sysAppTemplateManageMapper.selectById(appTemplateId);
                    sysAppTemplate.setCreateTime(appTemplate.getCreateTime());
                    sysAppTemplate.setReleaseStatus(appTemplate.getReleaseStatus());
                    sysAppTemplate.setViewNumbs(appTemplate.getViewNumbs());
                    sysAppTemplate.setInstalledNumbs(appTemplate.getInstalledNumbs());
                    this.sysAppTemplateManageMapper.updateById(sysAppTemplate);
                    if (HussarUtils.isEmpty((Object)applicationFileParamPath)) {
                        applicationFileBoolean = true;
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(SysAppTemplateAttachment::getAppId, (Object)appTemplateId);
                        queryWrapper.eq(SysAppTemplateAttachment::getFileType, (Object)1);
                        applicationFileParamPath = ((SysAppTemplateAttachment)this.sysAppTemplateAttachmentMapper.selectOne((Wrapper)queryWrapper)).getFilePath();
                        applicationFileTempPath = this.templateFileTempPath + File.separator + applicationFileParamPath.substring(applicationFileParamPath.lastIndexOf(File.separator) + 1);
                        applicationFileParamPath = this.checkTemplatePath(applicationFileParamPath);
                        com.google.common.io.Files.copy((File)new File(applicationFileParamPath), (File)new File(applicationFileTempPath));
                    }
                    String applicationFilesPath = this.templateFilePath + File.separator + appTemplateId;
                    File applicationFileDirectory = new File(applicationFilesPath);
                    this.deleteFiles(applicationFileDirectory);
                    LambdaQueryWrapper newQueryWrapper = new LambdaQueryWrapper();
                    newQueryWrapper.eq(SysAppTemplateAttachment::getAppId, (Object)appTemplateId);
                    newQueryWrapper.in(SysAppTemplateAttachment::getFileType, new Object[]{2, 3, 4});
                    this.sysAppTemplateAttachmentMapper.delete((Wrapper)newQueryWrapper);
                    Map<String, Object> filePaths = this.saveTemplateAttachmentFiles(multipartHttpServletRequest, appTemplateId, applicationFileBoolean, applicationFileParamPath, applicationFileTempPath);
                    ArrayList<SysAppTemplateAttachment> attachments = new ArrayList<SysAppTemplateAttachment>();
                    String applicationFilePath = (String)filePaths.get("applicationFilePath");
                    if (applicationFileBoolean) {
                        applicationFilePath = applicationFileParamPath;
                    }
                    if (HussarUtils.isNotEmpty((Object)applicationFilePath)) {
                        SysAppTemplateAttachment fileAttachment = this.getAppTemplateAttachment(appTemplateId, 1, applicationFilePath, 0);
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.eq(SysAppTemplateAttachment::getAppId, (Object)appTemplateId);
                        wrapper.eq(SysAppTemplateAttachment::getFileType, (Object)1);
                        this.sysAppTemplateAttachmentMapper.update(fileAttachment, (Wrapper)wrapper);
                    }
                    String thumnailFilePath = (String)filePaths.get("thumbnailFilePath");
                    SysAppTemplateAttachment thumnailAttachment = this.getAppTemplateAttachment(appTemplateId, 2, thumnailFilePath, 0);
                    attachments.add(thumnailAttachment);
                    List pcFilePaths = (List)filePaths.get("pcFilesPath");
                    for (int i = 0; i < pcFilePaths.size(); ++i) {
                        SysAppTemplateAttachment pcAttachment = this.getAppTemplateAttachment(appTemplateId, 3, ((String)pcFilePaths.get(i)).toString(), i);
                        attachments.add(pcAttachment);
                    }
                    List mobileFilePaths = (List)filePaths.get("mobileFilesPath");
                    for (int i = 0; i < mobileFilePaths.size(); ++i) {
                        SysAppTemplateAttachment mobileAttachment = this.getAppTemplateAttachment(appTemplateId, 4, ((String)mobileFilePaths.get(i)).toString(), i);
                        attachments.add(mobileAttachment);
                    }
                    attachments.forEach(sysAppTemplateAttachment -> this.sysAppTemplateAttachmentMapper.insert(sysAppTemplateAttachment));
                } else {
                    return ApiResponse.fail((String)"\u5e94\u7528\u6a21\u677f\u65b0\u589e\u6216\u8005\u4fee\u6539\u65f6\uff0c\u6a21\u677fID\u4e0d\u5408\u6cd5");
                }
            }
            return ApiResponse.success((String)"\u5e94\u7528\u6a21\u677f\u4fee\u6539\u6210\u529f");
        }
        catch (NumberFormatException e) {
            LOGGER.error("\u5e94\u7528\u6a21\u677f\u65b0\u589e\u5931\u8d25");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOGGER.error("\u5e94\u7528\u6a21\u677f\u65b0\u589e\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    private void deleteFiles(File deleteFile) {
        if (deleteFile.isDirectory()) {
            File[] files = deleteFile.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.deleteFiles(file);
                }
            }
            deleteFile.delete();
        } else {
            deleteFile.delete();
        }
    }

    private Map<String, Object> saveTemplateAttachmentFiles(MultipartHttpServletRequest request, Long appTemplateId, boolean applicationFileBoolean, String applicationFileParamPath, String applicationFileTempPath) throws IOException {
        String applicationFilesPath = this.templateFilePath + File.separator + appTemplateId;
        File applicationFileDirectory = new File(applicationFilesPath);
        if (!applicationFileDirectory.exists()) {
            applicationFileDirectory.mkdir();
        }
        HashMap<String, Object> filePaths = new HashMap<String, Object>();
        MultipartFile applicationFile = request.getFile("applicationFile");
        MultipartFile thumbnailFile = request.getFile("thumbnail");
        List pcFiles = request.getFiles("pcFiles");
        List mobileFiles = request.getFiles("mobileFiles");
        if (HussarUtils.isNotEmpty((Object)applicationFile)) {
            String applicationFilePath = applicationFilesPath + File.separator + applicationFile.getOriginalFilename();
            applicationFile.transferTo(Paths.get(applicationFilePath, new String[0]));
            filePaths.put("applicationFilePath", applicationFilePath);
        } else if (applicationFileBoolean) {
            File applicationFileTemp = new File(applicationFileParamPath);
            com.google.common.io.Files.copy((File)new File(applicationFileTempPath), (File)applicationFileTemp);
            filePaths.put("applicationFilePath", applicationFileParamPath);
            applicationFileTemp.deleteOnExit();
        }
        String thumbnailFilePath = applicationFilesPath + File.separator + HussarUtils.randomUUID() + "." + this.getFileSuffix(thumbnailFile);
        if (thumbnailFilePath.contains("?")) {
            thumbnailFilePath = thumbnailFilePath.substring(0, thumbnailFilePath.indexOf("?"));
        }
        thumbnailFile.transferTo(Paths.get(thumbnailFilePath, new String[0]));
        filePaths.put("thumbnailFilePath", thumbnailFilePath);
        ArrayList<String> pcFilesPath = new ArrayList<String>();
        if (pcFiles.size() <= 10) {
            for (int i = 0; i < pcFiles.size(); ++i) {
                String pcFilePath = applicationFilesPath + File.separator + HussarUtils.randomUUID() + "." + this.getFileSuffix((MultipartFile)pcFiles.get(i));
                if (pcFilePath.contains("?")) {
                    pcFilePath = pcFilePath.substring(0, pcFilePath.indexOf("?"));
                }
                ((MultipartFile)pcFiles.get(i)).transferTo(Paths.get(pcFilePath, new String[0]));
                pcFilesPath.add(pcFilePath);
            }
            filePaths.put("pcFilesPath", pcFilesPath);
        }
        ArrayList<String> mobileFilesPath = new ArrayList<String>();
        if (mobileFiles.size() <= 10) {
            for (int i = 0; i < mobileFiles.size(); ++i) {
                String mobileFilePath = applicationFilesPath + File.separator + HussarUtils.randomUUID() + "." + this.getFileSuffix((MultipartFile)mobileFiles.get(i));
                if (mobileFilePath.contains("?")) {
                    mobileFilePath = mobileFilePath.substring(0, mobileFilePath.indexOf("?"));
                }
                ((MultipartFile)mobileFiles.get(i)).transferTo(Paths.get(mobileFilePath, new String[0]));
                mobileFilesPath.add(mobileFilePath);
            }
            filePaths.put("mobileFilesPath", mobileFilesPath);
        }
        return filePaths;
    }

    private SysAppTemplateAttachment getAppTemplateAttachment(Long appTemplateId, int fileType, String filepath, int fileSeq) {
        SysAppTemplateAttachment appFileAttachment = new SysAppTemplateAttachment();
        appFileAttachment.setAppId(appTemplateId);
        appFileAttachment.setFilePath(filepath);
        appFileAttachment.setFileType(fileType);
        if (3 == fileType || 4 == fileType) {
            appFileAttachment.setFileSeq(fileSeq);
        }
        return appFileAttachment;
    }

    private Map<String, String> validParam(HttpServletRequest request) {
        HashMap<String, String> param = new HashMap<String, String>();
        String applicationName = request.getParameter("appTemplateName");
        String applicationDesc = request.getParameter("appTemplateDesc");
        String appTemplateGroup = request.getParameter("templateProfessionId");
        String appTemplateIcon = request.getParameter("templateIcon");
        String appTemplateIconType = request.getParameter("templateIconType");
        String appTemplateIconColor = request.getParameter("templateIconColor");
        String operation = request.getParameter("operation");
        String useType = request.getParameter("useType");
        if (HussarUtils.isNotEmpty((Object)applicationName) && HussarUtils.isNotEmpty((Object)applicationDesc) && HussarUtils.isNotEmpty((Object)appTemplateIcon) && HussarUtils.isNotEmpty((Object)appTemplateIconType) && HussarUtils.isNotEmpty((Object)appTemplateIconColor)) {
            param.put("appTemplateName", applicationName);
            param.put("appTemplateDesc", applicationDesc);
            param.put("templateProfessionId", appTemplateGroup);
            param.put("operation", operation);
            param.put("useType", useType);
            param.put("appTemplateIcon", appTemplateIcon);
            param.put("templateIconType", appTemplateIconType);
            param.put("templateIconColor", appTemplateIconColor);
        }
        return param;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validFiles(MultipartHttpServletRequest request) {
        String operation = request.getParameter("operation");
        boolean validResult = false;
        MultipartFile applicationFile = request.getFile("applicationFile");
        MultipartFile thumbnailFile = request.getFile("thumbnail");
        List pcFiles = request.getFiles("pcFiles");
        List mobileFiles = request.getFiles("mobileFiles");
        boolean appilicationFileJudgement = false;
        if (HussarUtils.isNotEmpty((Object)applicationFile)) {
            String applicationFileSuffix = this.getFileSuffix(applicationFile);
            if (!"hussar".equals(applicationFileSuffix)) return validResult;
            if (applicationFile.getSize() < 0x3200000L) {
                appilicationFileJudgement = true;
            }
        } else if (applicationFile == null && "2".equals(operation)) {
            appilicationFileJudgement = true;
        }
        if (!appilicationFileJudgement) {
            return validResult;
        }
        boolean thumbnailJudgement = false;
        String thumbnailSuffix = this.getFileSuffix(thumbnailFile);
        if (thumbnailSuffix.contains("?")) {
            thumbnailSuffix = thumbnailSuffix.substring(0, thumbnailSuffix.indexOf("?"));
        }
        String con = thumbnailFile.getContentType();
        thumbnailJudgement = this.checkImageType(thumbnailSuffix);
        if (!thumbnailJudgement) {
            return validResult;
        }
        boolean pcJudgement = false;
        if (pcFiles.size() > 10) return validResult;
        for (int i = 0; i < pcFiles.size(); ++i) {
            String pcFileSuffix = this.getFileSuffix((MultipartFile)pcFiles.get(i));
            if (pcFileSuffix.contains("?")) {
                pcFileSuffix = pcFileSuffix.substring(0, pcFileSuffix.indexOf("?"));
            }
            if (pcJudgement = this.checkImageType(pcFileSuffix)) continue;
            return validResult;
        }
        boolean mobileJudgement = false;
        if (mobileFiles.size() > 10) return validResult;
        for (int i = 0; i < mobileFiles.size(); ++i) {
            String mobileFileSuffix = this.getFileSuffix((MultipartFile)mobileFiles.get(i));
            if (mobileFileSuffix.contains("?")) {
                mobileFileSuffix = mobileFileSuffix.substring(0, mobileFileSuffix.indexOf("?"));
            }
            if (mobileJudgement = this.checkImageType(mobileFileSuffix)) continue;
            return validResult;
        }
        if (!mobileJudgement) return validResult;
        if (!pcJudgement) return validResult;
        if (!thumbnailJudgement) return validResult;
        if (!appilicationFileJudgement) return validResult;
        return true;
    }

    private String getFileSuffix(MultipartFile file) {
        String filename = file.getOriginalFilename();
        String[] fileSplitNames = filename.split("\\.");
        String fileSuffix = fileSplitNames[fileSplitNames.length - 1];
        return fileSuffix.toLowerCase();
    }

    private boolean checkImageType(String fileSuffix) {
        return WRITE_SUFFIX_TYPE.contains(fileSuffix);
    }

    public void importAppForTemplateInstall(AppImportDto appImportDto) {
        String hussarDecryptPath = "";
        try {
            hussarDecryptPath = this.appFileExtendService.fileDecrypt(appImportDto.getHussarTemplatePath());
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u6a21\u677f\u5b89\u88c5 => hussar \u6587\u4ef6\u7834\u89e3\u5931\u8d25\uff0c{}", (Object)appImportDto.getHussarTemplatePath());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new HussarException("\u5e94\u7528\u6a21\u677f\u5b89\u88c5 => hussar \u6587\u4ef6\u7834\u89e3\u5931\u8d25");
        }
        appImportDto.setPath(hussarDecryptPath);
        appImportDto.setExportRoleFlag(true);
        SecurityUser user = BaseSecurityUtil.getUser();
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
        try {
            this.appImportService.importApp(appImportDto);
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u6a21\u677f\u5b89\u88c5 => \u8c03\u7528\u5bfc\u5165\u5e94\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u4f20\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)appImportDto));
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            throw new HussarException("\u5e94\u7528\u6a21\u677f\u5b89\u88c5 => \u8c03\u7528\u5bfc\u5165\u5e94\u7528\u63a5\u53e3\u5931\u8d25");
        }
    }

    public IPage<SysAppTemplateVo> getRecommendedTemplateList(AppTemplateManageDto appTemplateManageDto, HttpServletRequest request) {
        if (appTemplateManageDto.getCurrent() > 2L) {
            return null;
        }
        Page page = new Page(appTemplateManageDto.getCurrent(), appTemplateManageDto.getSize());
        IPage<SysAppTemplateVo> pageVo = this.sysAppTemplateManageMapper.getRecommendedTemplateList((Page<SysAppTemplateVo>)page);
        return pageVo;
    }

    public ApiResponse<?> queryPage(AppTemplateManageOnlineDto appTemplateManageOnlineDto) {
        try {
            Map paramMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)appTemplateManageOnlineDto), Map.class);
            return RestTemplateHttpUtil.sendPostRequest(this.queryPageOnline, paramMap);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8d44\u4ea7\u4e2d\u5fc3\u5e94\u7528\u6a21\u677f\u5217\u8868\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    public ApiResponse<?> queryType(String typeName) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("typeName", typeName);
            return RestTemplateHttpUtil.sendPostRequest(this.queryTypeOnline, paramMap);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u67e5\u8be2\u8d44\u4ea7\u4e2d\u5fc3\u5e94\u7528\u5206\u7c7b\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    public ApiResponse<?> queryDetail(AppTemplateManageOnlineDto appTemplateManageOnlineDto) {
        try {
            Map paramMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)appTemplateManageOnlineDto), Map.class);
            return RestTemplateHttpUtil.sendPostRequest(this.queryDetailOnline, paramMap);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u67e5\u8be2\u8d44\u4ea7\u4e2d\u5fc3\u5e94\u7528\u6a21\u677f\u8be6\u60c5\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    public ApiResponse<?> installAppOnline(AppTemplateManageDto appInfo) {
        AppImportDto appImportDto = new AppImportDto();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String downloadHussarUrl = null;
        Path downloadHussarPath = null;
        try {
            ApiResponse apiResponse = RestTemplateHttpUtil.sendGetRequest(this.downloadHussarOnline.concat(String.valueOf(appInfo.getTemplateId())), paramMap);
            downloadHussarUrl = (String)((Map)apiResponse.getData()).get("url");
            InputStream inputStream = RestTemplateHttpUtil.downloadFile(downloadHussarUrl, paramMap);
            downloadHussarPath = Paths.get(this.templateFileTempPath + File.separator + (String)((Map)apiResponse.getData()).get("fileName"), new String[0]);
            Files.copy(inputStream, downloadHussarPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("\u83b7\u53d6\u8d44\u4ea7\u4e2d\u5fc3\u5e94\u7528\u6587\u4ef6\u5931\u8d25");
            throw new RuntimeException(e);
        }
        if ("".equals(downloadHussarPath.toString()) || null == downloadHussarPath) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u8d44\u4ea7\u4e2d\u5fc3\u5e94\u7528\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u62a5\u9519");
        }
        appImportDto.setHussarTemplatePath(downloadHussarPath.toString());
        appImportDto.setAppName(appInfo.getTemplateName());
        appImportDto.setAppGroupId(appInfo.getGroupId());
        appImportDto.setAppIcon(appInfo.getTemplateIcon());
        appImportDto.setExportRoleFlag(appInfo.getExportRoleFlag().booleanValue());
        appImportDto.setAppIconType(appInfo.getTemplateIconType());
        appImportDto.setAppIconColor(appInfo.getTemplateIconColor());
        try {
            this.importAppForTemplateInstall(appImportDto);
            return ApiResponse.success((String)"\u5e94\u7528\u5b89\u88c5\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5b89\u88c5\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BaseException("\u5b89\u88c5\u5e94\u7528\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<?> queryRecommendedTemplateListOnline(AppTemplateManageDto appInfo) {
        Map paramMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)appInfo), Map.class);
        return RestTemplateHttpUtil.sendPostRequest(this.queryRecommendedTemplateListOnline, paramMap);
    }

    public String checkTemplatePath(String templatePath) {
        if (!templatePath.contains(this.workspace)) {
            templatePath = this.workspace + templatePath;
        }
        return templatePath;
    }

    public void afterPropertiesSet() throws Exception {
        this.staticResourceUrl = this.frontIp + File.separator + this.staticResourceUrlValue;
        this.templateFilePath = this.workspace + File.separator + "apptemplate";
        this.templateFileTempPath = this.templateFilePath + File.separator + "temp";
        File templateFileTemp = new File(this.templateFileTempPath);
        if (!templateFileTemp.exists()) {
            templateFileTemp.mkdirs();
        }
    }
}

