/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util.redislock;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.hussar.formdesign.application.util.redislock.RedisLock;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAspect {
    @Resource
    private RedissonClient redissonClient;
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);

    @Pointcut(value="@annotation(com.jxdinfo.hussar.formdesign.application.util.redislock.RedisLock)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        return this.repeat(point);
    }

    private Object repeat(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        block8: {
            log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u5f00\u59cb\u6267\u884c*********");
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            RedisLock commit = method.getAnnotation(RedisLock.class);
            String redisKey = commit.key();
            TimeUnit timeUnit = commit.timeUnit();
            boolean watchDog = commit.watchDog();
            boolean methodOverUnLock = commit.methodOverUnLock();
            int waitTime = commit.waitTime();
            int leaseTime = commit.leaseTime();
            log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u5404\u4e2a\u53c2\u6570*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
            if (StringUtils.isBlank((CharSequence)redisKey)) {
                redisKey = this.getRedisKey(method);
            }
            try {
                RLock lock = this.redissonClient.getLock(redisKey);
                boolean locked = lock.tryLock((long)waitTime, watchDog ? -1L : (long)leaseTime, timeUnit);
                if (!locked) {
                    log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u83b7\u53d6\u5931\u8d25*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
                } else {
                    log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u83b7\u53d6\u6210\u529f*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
                }
                Object proceed = joinPoint.proceed();
                log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u65b9\u6cd5\u6267\u884c\u7ed3\u675f*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
                object = proceed;
                if (!methodOverUnLock) break block8;
                this.unLock(redisKey);
            }
            catch (InterruptedException e) {
                try {
                    log.error("*********Redission\u5206\u5e03\u5f0f\u9501\u65b9\u6cd5\u6267\u884c\u5f02\u5e38*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
                    log.error("*********Redission\u5206\u5e03\u5f0f\u9501\u65b9\u6cd5\u6267\u884c\u5f02\u5e38*********e={}", (Throwable)e);
                    Thread.currentThread().interrupt();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (methodOverUnLock) {
                        this.unLock(redisKey);
                        log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u91ca\u653e\u9501\u6210\u529f*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
                    }
                    throw throwable;
                }
            }
            log.info("*********Redission\u5206\u5e03\u5f0f\u9501\u91ca\u653e\u9501\u6210\u529f*********redisKey={},waitTime={},leaseTime={},timeUnit={},watchDog={},methodOverUnLock={}", new Object[]{redisKey, waitTime, leaseTime, timeUnit, watchDog, methodOverUnLock});
        }
        return object;
    }

    private String getRedisKey(Method method) {
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        return String.format("%s#%s", className, methodName);
    }

    public void unLock(String lockKey) {
        try {
            RLock lock = this.redissonClient.getLock(lockKey);
            if (null != lock && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error(String.format("\u91ca\u653e\u9501%s\u5f02\u5e38", lockKey));
        }
    }
}

