/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportServiceImpl;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormMigrateUtil {
    public static final String EXPORT_FOLDER_PATH = ".export-store";
    public static final String FORM_CONFIG_PATH = "formConfig";
    public static final String DASHBOARD_CONFIG_PATH = "dashboardConfig";
    public static final String PAGE_EXPAND = "pageExpand";
    public static final String WIDGET_EXPAND = "widgetExpand";
    public static final String COMMON_DATA_PATH = "commonData";
    public static final String BUSINESS_DATA_PATH = "businessData";
    public static final String EXPORT_META_FILE = "hussar.meta";
    public static final String APP_DATA_FILE = "app.json";
    public static final String APP_INFO_DATA = "appInfo";
    public static final String APP_AUTH_DATA = "appAuth";
    public static final String FORM_DATA_FILE = "form.json";
    public static final String DASHBOARD_DATA_FILE = "dashboard.json";
    public static final String FORM_DATA = "form";
    public static final String DASHBOARD_DATA = "dashboard";
    public static final String FORM_AUTH_DATA_FILE = "formAuth.json";
    public static final String BUTTON_AUTH_DATA = "buttonAuth";
    public static final String FILED_AUTH_DATA = "filedAuth";
    public static final String DATA_LOGIC_AUTH_DATA = "dataLogicAuth";
    public static final String DATA_LOGIC_FILTER_DATA = "dataLogicFilter";
    public static final String FLOW_DATA_FILE = "flow.json";
    public static final String BUSINESS_RULE_FILE = "rule.json";
    public static final String FORM_CHECK_CONFIG_FILE = "checkConfig.json";
    public static final String FORM_PUBIC_VIEW_FILE = "publicView.json";
    public static final String FORM_SCRIPT_FILE = "script.json";
    public static final String COMMON_DATA_FILE = "commonData.json";
    public static final String ROLE_DATA = "roles";
    public static final String ROLE_GROUP_DATA = "roleGroups";
    public static final String BUSINESS_DATA_FILE = "businessData.json";
    public static final String CUSTOM_BUTTON_DATA = "customButtonData";
    public static final String CUSTOM_BUTTON_DATA_FILE = "customButton.json";
    public static final String PRINT_TEMPLATE_PATH = "printTemplate";
    public static final String PRINT_TEMPLATE_FILE_PATH = "templateFile";
    public static final String PRINT_TEMPLATE_DATA_FILE = "printTemplate.json";
    public static final String PRINT_TEMPLATE_DATA = "printTemplateData";
    public static final String FORM_LINK_DATA_FILE = "formLink.json";
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";
    public static final String SETTING_PATH = "setting";
    public static final String SETTING_SUFFIX = ".setting";
    public static final String VIEW_PATH = "view";
    public static final String VIEW_SUFFIX = ".vd";
    public static final String STAFF_SCOPE_PATH = "staff";
    public static final String STAFF_SCOPE_SUFFIX = ".stf";
    public static final String STAFF_SCOPE_HISTORY = "history";
    private static final Logger LOGGER = LoggerFactory.getLogger(NoCodeConditionOnOfflineStorage.class);

    public static void deleteFolder(String folderPath) {
        File[] files;
        File file = new File(folderPath);
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            for (File subFile : files) {
                if (subFile.isFile()) {
                    subFile.delete();
                    continue;
                }
                FormMigrateUtil.deleteFolder(subFile.getAbsolutePath());
            }
        }
        file.delete();
    }

    public static <T> T readFileToObject(String filePath, Class<T> clazz) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try {
                String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                return (T)JSONObject.parseObject((String)text, clazz);
            }
            catch (IOException e) {
                ToolUtil.getLogger(AppImportServiceImpl.class).error("\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}" + e.getMessage());
                throw new RuntimeException();
            }
        }
        return null;
    }

    public static <T> T readFileToObjectWithReplace(String filePath, Class<T> clazz, Map<Object, Object> replaceMap) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try {
                String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
                ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(replaceMap.entrySet());
                sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
                for (Map.Entry entry : sortedEntries) {
                    text = text.replace(entry.getKey().toString(), entry.getValue().toString());
                }
                return (T)JSONObject.parseObject((String)text, clazz);
            }
            catch (IOException e) {
                ToolUtil.getLogger(AppImportServiceImpl.class).error("\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}" + e.getMessage());
                throw new RuntimeException();
            }
        }
        return null;
    }

    public static <T> List<T> parseJsonArrayToList(JSONArray jsonArray, Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (Object obj : jsonArray) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)obj;
                Object entity = jsonObject.toJavaObject(clazz);
                list.add(entity);
            }
        }
        return list;
    }

    public static <T> List<T> parseJsonObjectToListByKey(JSONObject jsonObject, String key, Class<T> clazz) {
        JSONArray jsonArray;
        if (ToolUtil.isNotEmpty((Object)jsonObject) && ToolUtil.isNotEmpty((Object)(jsonArray = (JSONArray)jsonObject.getObject(key, JSONArray.class)))) {
            return FormMigrateUtil.parseJsonArrayToList(jsonArray, clazz);
        }
        return null;
    }

    public static String getMigrateVersion() {
        try {
            Properties properties = new Properties();
            String pomPath = FileUtil.posixPath((String[])new String[]{"META-INF", "maven", "com.jxdinfo.hussar", "hussar-formdesign-application-server", "pom.properties"});
            properties.load(FormMigrateUtil.class.getResourceAsStream(pomPath));
            return properties.getProperty("version");
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u5bfc\u51fa\u5bfc\u5165\u65f6\u83b7\u53d6\u7248\u672c\u53f7\u5931\u8d25\uff0c\u5982\u679c\u662f\u5f00\u53d1\u73af\u5883\u8bf7\u5ffd\u7565\u6b64\u62a5\u9519\uff01");
            return null;
        }
    }
}

