/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.upgrade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.upgrade.dto.UpdataFilePathDto;
import com.jxdinfo.hussar.formdesign.application.upgrade.service.UpgradeService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.upgrade.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements UpgradeService {
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private ISysFormService formService;
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";

    private String getRoot() {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), this.formDesignProperties.getNoCodeStore()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateFilePath() throws LcdpException {
        String root = this.getRoot();
        Path rootPath = Paths.get(root, new String[0]);
        if (!Files.exists(rootPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path appPath : directoryStream) {
                try {
                    DirectoryStream<Path> appDirectoryStream = Files.newDirectoryStream(appPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
                    Throwable throwable = null;
                    try {
                        for (Path formPath : appDirectoryStream) {
                            String id;
                            File metaFile;
                            JSONObject data;
                            String meta = FileUtil.posixPath((String[])new String[]{formPath.toString(), CANVAS_PATH, formPath.getFileName() + CANVAS_SUFFIX + ".meta"});
                            Path metaPath = Paths.get(meta, new String[0]);
                            if (!Files.exists(metaPath, new LinkOption[0]) || HussarUtils.isEmpty((Object)(data = JSONObject.parseObject((String)FileUtils.readFileToString((File)(metaFile = new File(meta)), (Charset)StandardCharsets.UTF_8)))) || HussarUtils.isBlank((CharSequence)(id = (String)data.get((Object)"id"))) || HussarUtils.equals((Object)id, (Object)formPath.getFileName())) continue;
                            String newFormPathStr = FileUtil.posixPath((String[])new String[]{appPath.toString(), id});
                            Path newFormPath = Paths.get(newFormPathStr, new String[0]);
                            if (Files.exists(newFormPath, new LinkOption[0])) {
                                String newFormPathBack = newFormPathStr.replace(rootPath.toString(), "");
                                Files.move(newFormPath, Paths.get(FileUtil.posixPath((String[])new String[]{rootPath.toString(), "rollback", newFormPathBack}), new String[0]), new CopyOption[0]);
                            }
                            Files.move(formPath, newFormPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (appDirectoryStream == null) continue;
                        if (throwable != null) {
                            try {
                                appDirectoryStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        appDirectoryStream.close();
                    }
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FOLDER, rootPath.toString());
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FOLDER, root);
        }
    }

    @Override
    public void updateFormFilePath(UpdataFilePathDto updataFilePathDto) throws IOException {
        String root = this.getRoot();
        List formList = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)updataFilePathDto)) {
            List<Long> appIds = updataFilePathDto.getAppIds();
            List<Long> formIds = updataFilePathDto.getFormIds();
            if (HussarUtils.isNotEmpty(appIds)) {
                queryWrapper.in(SysForm::getAppId, appIds);
            }
            if (HussarUtils.isNotEmpty(appIds) && HussarUtils.isNotEmpty(formIds)) {
                queryWrapper.or();
            }
            if (HussarUtils.isNotEmpty(formIds)) {
                queryWrapper.in(SysForm::getId, formIds);
            }
        }
        if (HussarUtils.isEmpty(formList = this.formService.list((Wrapper)queryWrapper))) {
            return;
        }
        for (SysForm sysForm : formList) {
            String id;
            File metaFile;
            JSONObject data;
            String meta;
            Path metaPath;
            Long appId = sysForm.getAppId();
            Long formId = sysForm.getId();
            String tableName = sysForm.getTableName();
            String formPathStr = FileUtil.posixPath((String[])new String[]{root, String.valueOf(appId), tableName});
            Path formPath = Paths.get(formPathStr, new String[0]);
            if (!Files.exists(formPath, new LinkOption[0]) || !Files.exists(metaPath = Paths.get(meta = FileUtil.posixPath((String[])new String[]{formPathStr, CANVAS_PATH, tableName + CANVAS_SUFFIX + ".meta"}), new String[0]), new LinkOption[0]) || HussarUtils.isEmpty((Object)(data = JSONObject.parseObject((String)FileUtils.readFileToString((File)(metaFile = new File(meta)), (Charset)StandardCharsets.UTF_8)))) || HussarUtils.isBlank((CharSequence)(id = (String)data.get((Object)"id"))) || !HussarUtils.equals((Object)id, (Object)String.valueOf(formId))) continue;
            Path newFormPath = Paths.get(FileUtil.posixPath((String[])new String[]{root, String.valueOf(appId), id}), new String[0]);
            if (Files.exists(newFormPath, new LinkOption[0])) {
                String rollBackParam = FileUtil.posixPath((String[])new String[]{root, "rollback", String.valueOf(appId)});
                Path rollBackParamPath = Paths.get(rollBackParam, new String[0]);
                File rollBackParamFile = rollBackParamPath.toFile();
                if (!rollBackParamFile.exists()) {
                    rollBackParamFile.mkdirs();
                }
                Files.move(newFormPath, Paths.get(FileUtil.posixPath((String[])new String[]{rollBackParam, id}), new String[0]), new CopyOption[0]);
            }
            Files.move(formPath, newFormPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

