/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.util.TriggerVerify;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleTrigger;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysTimingTriggerTaskMapper;
import com.jxdinfo.hussar.formdesign.application.rule.middle.FirstTriggerTime;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerConfig;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerTask;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysTimingTriggerConfigServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysTimingTriggerTaskServiceImpl")
public class SysTimingTriggerTaskServiceImpl
extends HussarServiceImpl<SysTimingTriggerTaskMapper, SysTimingTriggerTask>
implements ISysTimingTriggerTaskService {
    private static Logger logger = LoggerFactory.getLogger(SysTimingTriggerTaskServiceImpl.class);
    @Resource
    private SysTimingTriggerTaskMapper sysTimingTriggerTaskMapper;
    @Resource
    private NoCodeRuleTrigger noCodeRuleTrigger;
    @Resource
    private SysTimingTriggerConfigServiceImpl sysTimingTriggerConfigService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    private static final String EXECUTE_STATUS = "1";
    private static final String UN_EXECUTE_STATUS = "0";

    @HussarDs(value="#dataSourceKey")
    public void asyncInitTimingTriggerTask(SysTimingTriggerConfig sysTimingTriggerConfig, String dataSourceKey) {
        ArrayList<SysTimingTriggerTask> sysTimingTriggerTasks = new ArrayList<SysTimingTriggerTask>();
        String triggerTaskType = sysTimingTriggerConfig.getTriggerTaskType();
        Long triggerId = sysTimingTriggerConfig.getTriggerId();
        NoCodeRuleTriggerType noCodeRuleTriggerType = NoCodeRuleTriggerType.valueOfType((String)triggerTaskType);
        switch (noCodeRuleTriggerType) {
            case TriggerTypeTimedDepend: {
                List triggerDataList = this.noCodeRuleTrigger.getTriggerDataByFilter(String.valueOf(triggerId));
                if (triggerDataList.isEmpty()) break;
                for (JSONObject jsonObject : triggerDataList) {
                    SysTimingTriggerTask sysTimingTriggerTask = this.parseConfig(sysTimingTriggerConfig, jsonObject);
                    if (!HussarUtils.isNotEmpty((Object)sysTimingTriggerTask)) continue;
                    sysTimingTriggerTasks.add(sysTimingTriggerTask);
                }
                break;
            }
            case TriggerTypeTimedRepeated: 
            case TriggerTypeTimedSingle: {
                SysTimingTriggerTask sysTimingTriggerTask = this.parseConfig(sysTimingTriggerConfig, null);
                sysTimingTriggerTasks.add(sysTimingTriggerTask);
            }
        }
        if (!sysTimingTriggerTasks.isEmpty()) {
            this.saveBatch(sysTimingTriggerTasks);
        }
    }

    private void handleCommonPart(SysTimingTriggerTask sysTimingTriggerTask, SysTimingTriggerConfig sysTimingTriggerConfig, JSONObject businessData) {
        BeanUtil.copy((Object)sysTimingTriggerConfig, (Object)sysTimingTriggerTask);
        sysTimingTriggerTask.setConfigId(sysTimingTriggerConfig.getId());
        sysTimingTriggerTask.setExecuteStatus(UN_EXECUTE_STATUS);
        sysTimingTriggerTask.setCreator(null);
        sysTimingTriggerTask.setLastEditor(null);
        sysTimingTriggerTask.setId(null);
        if (HussarUtils.isNotEmpty((Object)businessData)) {
            sysTimingTriggerTask.setDataId(this.handleDataId(sysTimingTriggerConfig, businessData));
        }
    }

    private Long handleDataId(SysTimingTriggerConfig sysTimingTriggerConfig, JSONObject businessData) {
        String tableName = this.sysFormService.getTableNameById(sysTimingTriggerConfig.getFormId());
        return Long.valueOf(businessData.getString(tableName));
    }

    private LocalDateTime handleNextReminderTime(SysTimingTriggerTask sysTimingTriggerTask, LocalDateTime currentTime) {
        RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysTimingTriggerTask.getRepeatRule(), RepeatRule.class);
        LocalDateTime nextReminderTime = repeatRule.calculateNextReminderTime(sysTimingTriggerTask.getFirstTriggerTime(), currentTime);
        if (HussarUtils.isNotEmpty((Object)sysTimingTriggerTask.getEndTriggerTime()) && nextReminderTime.isAfter(sysTimingTriggerTask.getEndTriggerTime()) || nextReminderTime.isBefore(currentTime)) {
            return null;
        }
        return nextReminderTime;
    }

    public boolean removeByConfigId(Long configId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTimingTriggerTask::getConfigId, (Object)configId)).eq(SysTimingTriggerTask::getExecuteStatus, (Object)UN_EXECUTE_STATUS);
        return this.remove((Wrapper)queryWrapper);
    }

    public List<SysTimingTriggerTask> queryTriggerTaskList(LocalDateTime currentTime) {
        LocalDateTime startTime = currentTime.minusSeconds(20L);
        return this.sysTimingTriggerTaskMapper.queryTriggerTaskList(startTime, currentTime);
    }

    @HussarDs(value="#dataSourceKey")
    public void asyncGenerateTaskByDataChange(Long formId, JSONObject businessData, String triggerType, String dataSourceKey) {
        ArrayList<SysTimingTriggerConfig> sysTimingTriggerConfigs = new ArrayList<SysTimingTriggerConfig>();
        ArrayList<SysTimingTriggerTask> sysTimingTriggerTasks = new ArrayList<SysTimingTriggerTask>();
        List<SysTimingTriggerConfig> formConfigs = this.sysTimingTriggerConfigService.listByFormIdAndTriggerType(formId, NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType());
        if (triggerType.equals(NoCodeRuleTriggerType.TriggerTypeCreate.getType())) {
            sysTimingTriggerConfigs.addAll(formConfigs);
        } else if (triggerType.equals(NoCodeRuleTriggerType.TriggerTypeUpdate.getType())) {
            String tableName = this.sysFormService.getTableNameById(formId);
            Long dataId = Long.valueOf(businessData.getString(tableName));
            List<Long> dataIds = Collections.singletonList(dataId);
            this.removeByFormIdAndDataIds(formId, dataIds);
            sysTimingTriggerConfigs.addAll(formConfigs);
        } else if (triggerType.equals(NoCodeRuleTriggerType.TriggerTypeDelete.getType())) {
            Long dataId = Long.valueOf(businessData.getString("RECORD_ID"));
            List<Long> dataIds = Collections.singletonList(dataId);
            this.removeByFormIdAndDataIds(formId, dataIds);
        }
        if (HussarUtils.isNotEmpty(sysTimingTriggerConfigs)) {
            Iterator iterator = sysTimingTriggerConfigs.iterator();
            while (iterator.hasNext()) {
                SysTimingTriggerTask sysTimingTriggerTask;
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                SysTimingTriggerConfig sysTimingTriggerConfig = (SysTimingTriggerConfig)iterator.next();
                Long triggerId = sysTimingTriggerConfig.getTriggerId();
                SysRuleTriggerAction sysRuleTriggerAction = (SysRuleTriggerAction)this.sysRuleTriggerActionService.getOne((Wrapper)queryWrapper.eq(SysRuleTriggerAction::getTriggerId, (Object)triggerId));
                boolean meetConditionFlag = this.checkWhetherMetTriggerCondition(sysRuleTriggerAction, businessData);
                if (!meetConditionFlag || !HussarUtils.isNotEmpty((Object)(sysTimingTriggerTask = this.parseConfig(sysTimingTriggerConfig, businessData)))) continue;
                sysTimingTriggerTasks.add(sysTimingTriggerTask);
            }
            this.saveBatch(sysTimingTriggerTasks);
        }
    }

    public void removeByFormIdAndDataIds(Long formId, List<Long> dataIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTimingTriggerTask::getFormId, (Object)formId)).in(SysTimingTriggerTask::getDataId, dataIds)).eq(SysTimingTriggerTask::getTriggerTaskType, (Object)NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType())).eq(SysTimingTriggerTask::getExecuteStatus, (Object)UN_EXECUTE_STATUS);
        this.remove((Wrapper)queryWrapper);
    }

    private boolean checkWhetherMetTriggerCondition(SysRuleTriggerAction sysRuleTriggerAction, JSONObject businessData) {
        JSONObject triggerCondition;
        List conditions;
        if (HussarUtils.isNotEmpty((Object)sysRuleTriggerAction.getTriggerConditions()) && HussarUtils.isNotEmpty((Object)(conditions = JSON.parseArray((String)(triggerCondition = JSON.parseObject((String)sysRuleTriggerAction.getTriggerConditions())).getString("cond"), JSONObject.class)))) {
            try {
                return TriggerVerify.conditionVerify((JSONObject)businessData, (String)sysRuleTriggerAction.getTriggerConditions(), (String)String.valueOf(sysRuleTriggerAction.getFormId()), (String)"");
            }
            catch (Exception e) {
                throw new HussarException("\u6309\u8868\u5355\u5b57\u6bb5\u5b9a\u65f6\u89e6\u53d1 => \u6821\u9a8c\u89e6\u53d1\u6761\u4ef6\u5931\u8d25");
            }
        }
        return true;
    }

    private SysTimingTriggerTask parseConfig(SysTimingTriggerConfig sysTimingTriggerConfig, JSONObject triggerData) {
        SysTimingTriggerTask sysTimingTriggerTask = new SysTimingTriggerTask();
        LocalDateTime now = LocalDateTime.now();
        this.handleCommonPart(sysTimingTriggerTask, sysTimingTriggerConfig, triggerData);
        LocalDateTime firstTrigerTime = this.handleFirstTriggerTime(sysTimingTriggerConfig, triggerData);
        if (HussarUtils.isEmpty((Object)firstTrigerTime)) {
            return null;
        }
        sysTimingTriggerTask.setFirstTriggerTime(firstTrigerTime);
        LocalDateTime nextTriggerTime = this.handleNextReminderTime(sysTimingTriggerTask, now);
        if (HussarUtils.isEmpty((Object)nextTriggerTime)) {
            return null;
        }
        sysTimingTriggerTask.setNextTriggerTime(nextTriggerTime);
        return sysTimingTriggerTask;
    }

    private LocalDateTime handleFirstTriggerTime(SysTimingTriggerConfig sysTimingTriggerConfig, JSONObject triggerData) {
        LocalDateTime firstTriggerTime = null;
        NoCodeRuleTriggerType noCodeRuleTriggerType = NoCodeRuleTriggerType.valueOfType((String)sysTimingTriggerConfig.getTriggerTaskType());
        block0 : switch (noCodeRuleTriggerType) {
            case TriggerTypeTimedDepend: {
                FirstTriggerTime firstTriggerTimeConfig = (FirstTriggerTime)JSON.parseObject((String)sysTimingTriggerConfig.getFirstTriggerTimeConfig(), FirstTriggerTime.class);
                String fieldName = firstTriggerTimeConfig.getFieldName();
                LocalDateTime fieldValue = (LocalDateTime)triggerData.getObject(fieldName, LocalDateTime.class);
                if (HussarUtils.isEmpty((Object)fieldValue)) {
                    return null;
                }
                String fieldType = firstTriggerTimeConfig.getFieldType();
                if ("yyyy-MM".equals(fieldType)) {
                    LocalTime time = LocalTime.parse(firstTriggerTimeConfig.getTime());
                    fieldValue = fieldValue.withDayOfMonth(1).with(time);
                } else if ("yyyy-MM-dd".equals(fieldType)) {
                    LocalTime localTime = LocalTime.parse(firstTriggerTimeConfig.getTime());
                    fieldValue = fieldValue.with(localTime);
                }
                String offsetType = firstTriggerTimeConfig.getOffsetType();
                int offsetValue = firstTriggerTimeConfig.getOffsetValue();
                String offsetUnit = firstTriggerTimeConfig.getOffsetUnit();
                if (offsetType.equals("today") || offsetType.equals("moment")) {
                    firstTriggerTime = fieldValue;
                    break;
                }
                if (!offsetType.equals("before") && !offsetType.equals("after")) break;
                offsetValue = offsetType.equals("before") ? -offsetValue : offsetValue;
                switch (offsetUnit) {
                    case "minute": {
                        firstTriggerTime = fieldValue.plusMinutes(offsetValue);
                        break block0;
                    }
                    case "hour": {
                        firstTriggerTime = fieldValue.plusHours(offsetValue);
                        break block0;
                    }
                    case "day": {
                        firstTriggerTime = fieldValue.plusDays(offsetValue);
                        break block0;
                    }
                }
                throw new HussarException("\u504f\u79fb\u5355\u4f4d\u4e0d\u7b26\u5408\u89c4\u8303");
            }
            case TriggerTypeTimedRepeated: 
            case TriggerTypeTimedSingle: {
                firstTriggerTime = sysTimingTriggerConfig.getFirstTriggerTime();
            }
        }
        return firstTriggerTime;
    }
}

