/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.policy.RenderPolicy;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.I18nUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.enums.FileNameMode;
import com.jxdinfo.hussar.formdesign.application.print.handle.SuggestionTemp;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.model.SysWordPrintTask;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysWordPrintTaskService;
import com.jxdinfo.hussar.formdesign.application.print.util.DocxUtil;
import com.jxdinfo.hussar.formdesign.application.print.util.GenerateCode;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintGeneFileName;
import com.jxdinfo.hussar.formdesign.application.print.vo.WidgetsAndData;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.ddr.poi.html.HtmlRenderPolicy;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTRImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WordHandle {
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    @Value(value="${hussar.nocode.wordPrint.selectionBoxEnable:false}")
    private boolean selectionBoxEnable;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysWordPrintTaskService sysWordPrintTaskService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private WaterMarkComponent waterMarkComponent;
    @Resource
    private I18nUtil i18nUtil;
    private static ConcurrentHashMap<String, Object> hashMap = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(WordHandle.class);

    private void replaceInPara(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        String tempString = "";
        int lastChar = 32;
        if (WordHandle.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString != null && tempString.indexOf("${") >= 0) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (runSet.size() > 0) {
                            String replaceText = WordHandle.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp(param, tempString, replaceText, aRun, widgets, richTextMap);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceInPara1(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        String tempString = "";
        int lastChar = 32;
        if (WordHandle.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString != null && tempString.indexOf("${") >= 0) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (runSet.size() > 0) {
                            String replaceText = WordHandle.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp1(param, tempString, replaceText, aRun, widgets, richTextMap);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceTemp(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList<String> temps = new ArrayList<String>();
        ArrayList<String> replaceTexts = new ArrayList<String>();
        Matcher matcher = WordHandle.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
            if (param.containsKey(group)) {
                if (HussarUtils.isEmpty((Object)param.get(group))) {
                    replaceTexts.add("");
                    continue;
                }
                replaceTexts.add(param.get(group).toString());
                continue;
            }
            replaceTexts.add("");
        }
        int s = 0;
        for (int j = 0; j < temps.size(); ++j) {
            int i;
            int k = j - s;
            String string = (String)temps.get(j);
            String text = (String)replaceTexts.get(j);
            if (WordHandle.judgeImage(string, widgets)) {
                if (!this.handleImg(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeTextArea(string, widgets)) {
                i = this.handleTextArea(string, text, aRun, widgets, k);
                s -= i;
                continue;
            }
            if (WordHandle.judgeSelect(string, widgets)) {
                this.handleSelect(param, string, text, aRun, widgets, k);
                continue;
            }
            if (WordHandle.judgeFile(string, widgets)) {
                this.handleFile(string, text, aRun, widgets, k);
                continue;
            }
            if (WordHandle.judgeRichText(string, widgets)) {
                this.handleRichText(string, text, aRun, widgets, richTextMap, k);
                continue;
            }
            if (WordHandle.judgeInputOrSer(string, widgets)) {
                if (!this.handleInputOrSer(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeSignature(string, widgets)) {
                if (!this.handleSignature(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeSuggestion(string, widgets)) {
                i = this.handleSuggestion(string, text, aRun, widgets, richTextMap, k);
                s -= i;
                continue;
            }
            aRun.setText(text, k);
        }
    }

    private void replaceTemp1(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList<String> temps = new ArrayList<String>();
        Matcher matcher = WordHandle.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
        }
        for (String string : temps) {
            int endIndex;
            int startIndex;
            String result = string.substring(startIndex = string.indexOf(35) + 1, endIndex = string.indexOf(125));
            if (HussarUtils.isNotEmpty((Object)widgets.get(result)) && widgets.get(result).equals(WidgetType.JXDNRichText.getType())) {
                tempString = tempString.replace(string, "{{" + result + "}}");
                richTextMap.put(result, String.valueOf(param.get(string)));
            }
            if (!HussarUtils.isNotEmpty((Object)widgets.get(result)) || !widgets.get(result).equals(WidgetType.JXDNSuggestion.getType())) continue;
            String widgetStr = widgets.get("widgetsStr");
            JSONArray array = JSON.parseArray((String)widgetStr);
            for (Object o : array) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(result) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() == 1 && ((String)list.get(0)).equals("name")) continue;
                tempString = tempString.replace(string, "{{" + result + "}}");
                richTextMap.put(result, String.valueOf(param.get(string)));
            }
        }
        aRun.setText(tempString, 0);
    }

    private void handleRichText(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int startIndex = tempString.indexOf(35) + 1;
        int endIndex = tempString.indexOf(125);
        String result = tempString.substring(startIndex, endIndex);
        aRun.setText("{{" + result + "}}", position);
        richTextMap.put(result, replaceText);
    }

    private boolean handleInputOrSer(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        String codeMode = "";
        if (tempString.contains("|") && tempString.contains("size")) {
            String[] split = tempString.split("\\|");
            if (split.length > 2) {
                codeMode = split[1];
                String size = split[2];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                if (split1.length == 2) {
                    List<Double> wh;
                    if ("qrcode".equals(codeMode)) {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.0);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.QR_CODE, aRun, ErrorCorrectionLevel.M);
                    } else {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.5);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.CODE_128, aRun, ErrorCorrectionLevel.H);
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    private boolean handleImg(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        JSONArray parse;
        int mode = 0;
        String imageconfig = tempString.substring(tempString.indexOf("=") + 1, tempString.indexOf("}"));
        String[] split = imageconfig.split("\\*");
        String width = split[0];
        String height = split[1];
        if (!width.contains("auto")) {
            if (height.contains("fixed")) {
                String[] split1 = height.split("_");
                height = split1[0];
                mode = 1;
            } else if (height.contains("_")) {
                String[] split2 = height.split("_");
                height = split2[0];
                mode = 2;
            } else {
                height = "auto";
                mode = 3;
            }
        }
        if (HussarUtils.isNotEmpty((Object)(parse = (JSONArray)JSONArray.parse((String)replaceText)))) {
            for (Object obj : parse) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)obj;
                String id = String.valueOf(jsonObject.get((Object)"id"));
                String type = String.valueOf(jsonObject.get((Object)"type"));
                String name = String.valueOf(jsonObject.get((Object)"name"));
                String absolutePath = this.showImage(Long.valueOf(id));
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(absolutePath);
                }
                catch (Exception e) {
                    LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u66ff\u6362\u56fe\u7247\u4e0d\u5b58\u5728,\u56fe\u7247:{}", (Object)tempString, (Object)jsonObject);
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                FileInputStream stream = null;
                FileInputStream stream2 = null;
                try {
                    stream = new FileInputStream(absolutePath);
                    stream2 = new FileInputStream(absolutePath);
                }
                catch (Exception e) {
                    LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u66ff\u6362\u56fe\u7247\u4e0d\u5b58\u5728,\u56fe\u7247:{}", (Object)tempString, (Object)jsonObject);
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                double widthToHeight = 0.0;
                byte[] bs = new byte[]{};
                try {
                    bs = IOUtils.toByteArray((InputStream)stream);
                }
                catch (Exception e) {
                    LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u6d41\u8f6c\u6362byte\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                try {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(bs));
                    widthToHeight = (double)image.getWidth() / (double)image.getHeight();
                    inputStream = this.handleWebp(inputStream, stream2, this.outputPath, image);
                }
                catch (Exception e) {
                    LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                try {
                    List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                    if (HussarUtils.isEmpty(wh)) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                    }
                    aRun.addPicture(inputStream, WordHandle.judgeImgType(type), name, wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                }
                catch (Exception e) {
                    LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    public InputStream handleWebp(InputStream inputStream, InputStream stream, String outputPath, BufferedImage image) throws IOException {
        boolean isWebp = this.imgType(stream);
        if (isWebp) {
            String path = outputPath + "wordTemplate" + File.separator + "webp" + File.separator;
            File filePath = new File(outputPath + "wordTemplate" + File.separator + "webp" + File.separator);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String newPath = path + System.currentTimeMillis() + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(newPath));
            return Files.newInputStream(Paths.get(newPath, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }

    public boolean imgType(InputStream inputStream) throws IOException {
        byte[] fileHeader = new byte[4];
        inputStream.read(fileHeader, 0, fileHeader.length);
        inputStream.close();
        String header = this.bytes2Hex(fileHeader);
        return header.contains("52494646");
    }

    public String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            sb.append(hex.length() == 2 ? hex : "0" + hex);
        }
        return sb.toString();
    }

    private boolean handleSignature(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (tempString.contains("|") && tempString.contains("size") && HussarUtils.isNotEmpty((Object)replaceText)) {
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    int index = replaceText.indexOf(",");
                    replaceText = replaceText.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(replaceText);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (HussarUtils.isNotEmpty((Object)inputStream)) {
                        try {
                            List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                            if (HussarUtils.isEmpty(wh)) {
                                LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                            }
                            aRun.addPicture((InputStream)inputStream, WordHandle.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                        }
                        catch (Exception e) {
                            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    private int handleSuggestion(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int add = 0;
        if (HussarUtils.isNotEmpty((Object)replaceText)) {
            JSONArray array = JSON.parseArray((String)replaceText);
            for (Object o : array) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)o;
                Object object1 = jsonObject.get((Object)"signature");
                if (HussarUtils.isNotEmpty((Object)object1)) {
                    String signature = String.valueOf(object1);
                    int index = signature.indexOf(",");
                    signature = signature.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(signature);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                    try {
                        aRun.addPicture((InputStream)inputStream, WordHandle.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", 1080000, 720000);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    continue;
                }
                Object name = jsonObject.get((Object)"userName");
                if (!HussarUtils.isNotEmpty((Object)name)) continue;
                String userName = String.valueOf(name);
                aRun.setText(userName, position + ++add);
            }
        } else {
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private int handleTextArea(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        int add = 0;
        if (replaceText.contains("\n")) {
            String[] strings = replaceText.split("\\n");
            aRun.setText(strings[0], position);
            for (int i = 1; i < strings.length; ++i) {
                aRun.addBreak();
                aRun.setText(strings[i], position + ++add);
            }
        } else {
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private void handleSelect(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (!this.selectionBoxEnable) {
            aRun.setText(replaceText, position);
        } else {
            JSONObject jsonObject;
            Object idObjs;
            String sub = tempString.substring(tempString.indexOf("#") + 1, tempString.indexOf("}"));
            if (sub.contains(".")) {
                sub = sub.split("\\.")[1];
            }
            String substring = sub;
            String widgetsStr = widgets.get("widgetsStr");
            JSONArray jsonArray = JSON.parseArray((String)widgetsStr);
            ArrayList<String> ids = new ArrayList<String>();
            String idKey = substring + "_value";
            Object dataValue = param.get("dataValue");
            if (HussarUtils.isNotEmpty((Object)dataValue) && HussarUtils.isNotEmpty((Object)(idObjs = (jsonObject = (JSONObject)dataValue).get((Object)idKey)))) {
                String idStr = String.valueOf(idObjs);
                String[] idArr = idStr.split(",");
                ids.addAll(Arrays.asList(idArr));
            }
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> boxs = new ArrayList<String>();
            ArrayList optionList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)replaceText)) {
                String[] checkBox = replaceText.split(",");
                boxs.addAll(Arrays.asList(checkBox));
            }
            jsonArray.forEach(obj -> {
                JSONObject props;
                Object options;
                Object object;
                JSONObject jsonObject;
                if (obj instanceof JSONObject && (jsonObject = (JSONObject)obj).get((Object)"name").equals(substring) && (object = jsonObject.get((Object)"props")) instanceof JSONObject && (options = (props = (JSONObject)object).get((Object)"options")) instanceof JSONArray) {
                    JSONArray jsonArray1 = (JSONArray)options;
                    jsonArray1.forEach(obj1 -> {
                        if (obj1 instanceof JSONObject) {
                            optionList.add(obj1);
                        }
                    });
                }
            });
            block0: for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                for (Object object : optionList) {
                    String valueStr;
                    if (!(object instanceof JSONObject)) continue;
                    JSONObject jsonObject2 = (JSONObject)object;
                    Object value = jsonObject2.get((Object)"value");
                    Object label = jsonObject2.get((Object)"label");
                    if (!(value instanceof String) || !(label instanceof String) || !(valueStr = String.valueOf(value)).equals(id)) continue;
                    String box = (String)boxs.get(i);
                    jsonObject2.put("label", (Object)box);
                    continue block0;
                }
            }
            for (Object object : optionList) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObject3 = (JSONObject)object;
                Object value = jsonObject3.get((Object)"value");
                Object label = jsonObject3.get((Object)"label");
                if (!(value instanceof String) || !(label instanceof String)) continue;
                String valueStr = String.valueOf(value);
                String labelStr = String.valueOf(label);
                values.add(valueStr);
                labels.add(labelStr);
            }
            StringBuilder checkBoxText = new StringBuilder();
            ArrayList<Integer> find = new ArrayList<Integer>();
            for (String label : labels) {
                boolean isFind = false;
                for (String box : boxs) {
                    if (!label.equals(box)) continue;
                    checkBoxText.append("R").append(label).append("      ");
                    find.add(boxs.indexOf(box));
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                checkBoxText.append("\u00a3").append(label).append("      ");
            }
            for (String box : boxs) {
                int index = boxs.indexOf(box);
                if (find.contains(index)) continue;
                checkBoxText.append("R").append(box).append("      ");
            }
            aRun.setText("\uffe5" + checkBoxText, position);
        }
    }

    private void handleFile(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        JSONArray parse = (JSONArray)JSONArray.parse((String)replaceText);
        if (HussarUtils.isNotEmpty((Object)parse)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                String fileName = String.valueOf(o.get((Object)"name"));
                sb.append(fileName).append(",");
            }
            String fileNameLast = String.valueOf(((JSONObject)parse.get(parse.size() - 1)).get((Object)"name"));
            sb.append(fileNameLast);
            replaceText = sb.toString();
        }
        aRun.setText(replaceText, position);
    }

    private static void insertCode(String tempString, String mode, String replaceText, int width, int height, BarcodeFormat barcodeFormat, XWPFRun aRun, ErrorCorrectionLevel errorCorrectionLevel) {
        try {
            BufferedImage bufferedImage = GenerateCode.generateCode(replaceText, mode, barcodeFormat, errorCorrectionLevel);
            if (HussarUtils.isNotEmpty((Object)bufferedImage)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                aRun.addPicture((InputStream)byteArrayInputStream, 6, mode, width * 36000, height * 36000);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u751f\u6210\u5931\u8d25", (Object)tempString);
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    private static int judgeImgType(String type) {
        if ("EMF".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("WMF".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("PICT".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("DIB".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("TIFF".equalsIgnoreCase(type)) {
            return 9;
        }
        if ("EPS".equalsIgnoreCase(type)) {
            return 10;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 11;
        }
        if ("WPG".equalsIgnoreCase(type)) {
            return 12;
        }
        LOGGER.error("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u7c7b\u578b\uff1a{},\u5df2\u81ea\u52a8\u8f6c\u4e3aPNG\u683c\u5f0f", (Object)type);
        return 6;
    }

    public XWPFDocument generateWord(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                param.put("dataValue", parse);
                WordHandle.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInPara(doc, param, widgets, richTextMap);
                WordHandle.analysisTable(doc);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInTable(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    public XWPFDocument generateWord1(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                WordHandle.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInPara1(doc, param, widgets, richTextMap);
                WordHandle.analysisTable(doc);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInTable1(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    private void replaceInPara(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Iterator iterator = doc.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph para = (XWPFParagraph)iterator.next();
            try {
                this.wpsHandlePara(para);
                this.replaceInPara(para, params, widgets, richTextMap);
                if (!this.selectionBoxEnable) continue;
                this.replaceSelect(para, params, widgets);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceInPara1(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Iterator iterator = doc.getParagraphsIterator();
        while (iterator.hasNext()) {
            XWPFParagraph para = (XWPFParagraph)iterator.next();
            try {
                this.replaceInPara1(para, params, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceSelect(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets) {
        if (para.getParagraphText().contains("\uffe5")) {
            List runR = para.getRuns();
            int fontSize = ((XWPFRun)runR.get(0)).getFontSize();
            HashMap<Integer, List> listMap = new HashMap<Integer, List>();
            int size = runR.size();
            for (int i = 0; i < size; ++i) {
                XWPFRun xwpfRun2 = (XWPFRun)runR.get(i);
                String text = xwpfRun2.text();
                if (!text.contains("\uffe5") || !text.contains("R") && !text.contains("\u00a3")) continue;
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                int k2 = 0;
                while (HussarUtils.isNotEmpty((Object)xwpfRun2.text())) {
                    xwpfRun2.setText("", k2);
                    ++k2;
                }
                boolean isFind = false;
                int start = 0;
                for (int s = 0; s < text.length(); ++s) {
                    XWPFRun run2;
                    String substring;
                    char ch = text.charAt(s);
                    if (!isFind) {
                        if (ch != 'R' && ch != '\u00a3') continue;
                        start = s;
                        isFind = true;
                        XWPFRun run3 = para.createRun();
                        indexList.add(runR.indexOf(run3));
                        run3.setText(String.valueOf(ch));
                        continue;
                    }
                    if (ch == 'R' || ch == '\u00a3') {
                        int end = s--;
                        substring = text.substring(start + 1, end);
                        run2 = para.createRun();
                        indexList.add(runR.indexOf(run2));
                        run2.setText(substring);
                        isFind = false;
                    }
                    if (s != text.length() - 1) continue;
                    substring = text.substring(start + 1);
                    run2 = para.createRun();
                    indexList.add(runR.indexOf(run2));
                    run2.setText(substring);
                }
                listMap.put(i, indexList);
            }
            ArrayList runList = new ArrayList(runR);
            if (HussarUtils.isNotEmpty(listMap)) {
                AtomicInteger k1 = new AtomicInteger();
                listMap.forEach((k, v) -> {
                    for (int x = 0; x < v.size(); ++x) {
                        int parseInt = Integer.parseInt(String.valueOf(v.get(x)));
                        XWPFRun remove = (XWPFRun)runList.remove(parseInt);
                        runList.add(k + x + 1 + k1.get(), remove);
                    }
                    k1.addAndGet(v.size());
                });
            }
            LinkedHashMap map = new LinkedHashMap();
            runList.forEach(xwpfRun -> {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put(xwpfRun.text(), xwpfRun.getFontFamily());
                map.put(runList.indexOf(xwpfRun), map1);
            });
            runR.forEach(run -> {
                int i = runR.indexOf(run);
                Map map1 = (Map)map.get(i);
                run.setText("", 0);
                String text = "";
                String font = null;
                for (String key : map1.keySet()) {
                    if (!key.equals("\uffe5")) {
                        text = key;
                    }
                    font = (String)map1.get(key);
                }
                run.setText(text);
            });
            for (XWPFRun xwpfRun3 : runR) {
                this.setFontSize(fontSize, xwpfRun3);
                if (!xwpfRun3.text().equals("R") && !xwpfRun3.text().equals("\u00a3") && !xwpfRun3.text().isEmpty()) continue;
                CTFonts font = xwpfRun3.getCTR().addNewRPr().addNewRFonts();
                font.setAscii("Wingdings 2");
                font.setCs("Wingdings 2");
                font.setEastAsia("Wingdings 2");
                font.setHAnsi("Wingdings 2");
            }
        }
    }

    private static String replaceText(String text, Map<String, Object> map) {
        Matcher matcher;
        String replaceText = text;
        if (text != null && (matcher = WordHandle.matcher(text)).find()) {
            while ((matcher = WordHandle.matcher(text)).find()) {
                String group = matcher.group();
                if (map.containsKey(group)) {
                    String value = String.valueOf(map.get(group));
                    text = replaceText = matcher.replaceFirst(value);
                    continue;
                }
                text = matcher.replaceFirst("");
            }
            if ("null".equals(text)) {
                replaceText = "";
            }
        }
        return replaceText;
    }

    private void setFontSize(int size, XWPFRun run) {
        if (size != -1) {
            run.setFontSize(size);
        }
    }

    private void replaceInTable(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Iterator iterator = doc.getTablesIterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            List rows = table.getRows();
            ArrayList<Integer> widths = new ArrayList<Integer>();
            HashSet<Integer> removeRows = new HashSet<Integer>();
            for (int k = 0; k < rows.size(); ++k) {
                XWPFTableRow row = (XWPFTableRow)rows.get(k);
                List cells = row.getTableCells();
                boolean flag = true;
                String tableName = "";
                int lastIndex = 0;
                boolean indexFlag = false;
                for (int i = 0; i < cells.size(); ++i) {
                    XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                    if (k == 0) {
                        widths.add(cell.getWidth());
                    }
                    List paras = cell.getParagraphs();
                    String text = cell.getText();
                    Matcher matcher = WordHandle.matcher(text);
                    if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
                        removeRows.add(k);
                        while (matcher.find()) {
                            String[] strings;
                            Object obj = params.get(matcher.group());
                            if (!(obj instanceof List)) continue;
                            List list = (List)obj;
                            String childName = matcher.group();
                            String substring1 = childName.substring(childName.indexOf("#"), childName.indexOf("}"));
                            String currentTableName = "";
                            if (substring1.contains(".") && (strings = substring1.split("\\.")).length == 2) {
                                if (!tableName.equals(strings[0])) {
                                    flag = true;
                                }
                                currentTableName = strings[0];
                            }
                            if (flag) {
                                for (int j = 0; j < list.size(); ++j) {
                                    XWPFRun run;
                                    XWPFRun runNew;
                                    XWPFRun sourceRun;
                                    XWPFRun runNew2;
                                    HashMap<String, Object> map1;
                                    Object sourceRun2;
                                    XWPFRun run2;
                                    XWPFParagraph sourcePh;
                                    XWPFParagraph newPh;
                                    List paragraphs;
                                    String[] strings2;
                                    String[] split1;
                                    String result;
                                    String group;
                                    HashMap<String, Object> map;
                                    String key21;
                                    Matcher matcher1;
                                    String text1;
                                    CTJc ctjc;
                                    CTPPr ctppr;
                                    CTP ctp;
                                    CTTc cttc;
                                    CTPPr pPr;
                                    XWPFTableCell newCell;
                                    XWPFTableCell sourceCell;
                                    int l;
                                    XWPFTableRow tableRow = HussarUtils.isEmpty((Object)tableName) ? table.insertNewTableRow(k + j + 1) : (lastIndex < j + 1 ? table.insertNewTableRow(k + j + 1) : (XWPFTableRow)rows.get(k + j + 1));
                                    Object obj1 = list.get(j);
                                    JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(obj1));
                                    if (!tableRow.getTableCells().isEmpty()) {
                                        for (l = i; l < cells.size(); ++l) {
                                            sourceCell = (XWPFTableCell)cells.get(l);
                                            newCell = tableRow.getCell(l);
                                            newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                            newCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
                                            pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                            if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                                cttc = newCell.getCTTc();
                                                ctp = (CTP)cttc.getPList().get(0);
                                                ctppr = ctp.getPPr();
                                                if (ctppr == null) {
                                                    ctppr = ctp.addNewPPr();
                                                }
                                                if ((ctjc = ctppr.getJc()) == null) {
                                                    ctjc = ctppr.addNewJc();
                                                }
                                                ctjc.setVal(pPr.getJc().getVal());
                                            }
                                            text1 = sourceCell.getText();
                                            matcher1 = WordHandle.matcher(text1);
                                            key21 = "";
                                            map = new HashMap<String, Object>();
                                            group = "";
                                            while (matcher1.find()) {
                                                group = matcher1.group();
                                                if (group.contains(".")) {
                                                    int endIndex;
                                                    int startIndex = text1.indexOf(35) + 1;
                                                    result = text1.substring(startIndex, endIndex = text1.indexOf(125));
                                                    split1 = result.split("\\.");
                                                    if (split1.length != 2) continue;
                                                    if (split1[1].contains("|")) {
                                                        strings2 = split1[1].split("\\|");
                                                        if (strings2.length == 3) {
                                                            key21 = strings2[0];
                                                            map.put(group, parse.get((Object)key21));
                                                        }
                                                        if (strings2.length != 2) continue;
                                                        key21 = strings2[0];
                                                        map.put(group, parse.get((Object)key21));
                                                        continue;
                                                    }
                                                    key21 = split1[1];
                                                    map.put(group, parse.get((Object)key21));
                                                    continue;
                                                }
                                                String group1 = String.valueOf(params.get(group));
                                                map.put(group, group1);
                                            }
                                            if (HussarUtils.isEmpty((Object)parse.get((Object)key21))) {
                                                paragraphs = newCell.getParagraphs();
                                                newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
                                                sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
                                                if (sourcePh.getRuns().isEmpty()) {
                                                    run2 = newPh.createRun();
                                                } else {
                                                    sourceRun2 = (XWPFRun)sourcePh.getRuns().get(0);
                                                    newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                                    run2 = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
                                                    run2.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                    run2.setColor(sourceRun2.getColor());
                                                    run2.setBold(sourceRun2.isBold());
                                                    run2.setItalic(sourceRun2.isItalic());
                                                    this.setFontSize(sourceRun2.getFontSize(), run2);
                                                }
                                                if ("index".equals(key21)) {
                                                    if (indexFlag) continue;
                                                    map1 = new HashMap();
                                                    map1.put(group, j + 1);
                                                    run2.setText(WordHandle.replaceText(text1, map1));
                                                    continue;
                                                }
                                                if (HussarUtils.isNotEmpty((Object)widgets.get(key21)) && (widgets.get(key21).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(key21).equals(WidgetType.SELECT.getType()))) {
                                                    sourceRun2 = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
                                                    newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                                    try {
                                                        for (XWPFRun run12 : sourcePh.getRuns()) {
                                                            runNew2 = newPh.createRun();
                                                            runNew2.setText(run12.text());
                                                            runNew2.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                            runNew2.setColor(sourceRun2.getColor());
                                                            runNew2.setBold(sourceRun2.isBold());
                                                            runNew2.setItalic(sourceRun2.isItalic());
                                                            this.setFontSize(sourceRun2.getFontSize(), runNew2);
                                                        }
                                                        this.replaceInPara(newPh, map, widgets, richTextMap);
                                                    }
                                                    catch (FileNotFoundException e) {
                                                        LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
                                                    }
                                                    continue;
                                                }
                                                run2.setText("");
                                                continue;
                                            }
                                            paragraphs = newCell.getParagraphs();
                                            newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
                                            sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
                                            sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
                                            if (WordHandle.judgeInputOrSer(text1, widgets) || WordHandle.judgeImage(text1, widgets) || WordHandle.judgeFile(text1, widgets) || WordHandle.judgeTextArea(text1, widgets) || WordHandle.judgeSelect(text1, widgets) || WordHandle.judgeSignature(text1, widgets)) {
                                                newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                                try {
                                                    for (Object run1 : sourcePh.getRuns()) {
                                                        runNew = newPh.createRun();
                                                        runNew.setText(run1.text());
                                                        runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                        runNew.setColor(sourceRun.getColor());
                                                        runNew.setBold(sourceRun.isBold());
                                                        runNew.setItalic(sourceRun.isItalic());
                                                        this.setFontSize(sourceRun.getFontSize(), runNew);
                                                    }
                                                    this.replaceInPara(newPh, map, widgets, richTextMap);
                                                }
                                                catch (FileNotFoundException e) {
                                                    LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
                                                }
                                                continue;
                                            }
                                            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                            run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
                                            run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                            run.setColor(sourceRun.getColor());
                                            run.setBold(sourceRun.isBold());
                                            run.setItalic(sourceRun.isItalic());
                                            run.setText(WordHandle.replaceText(text1, map));
                                            this.setFontSize(sourceRun.getFontSize(), run);
                                        }
                                        continue;
                                    }
                                    indexFlag = true;
                                    for (l = 0; l < cells.size(); ++l) {
                                        sourceCell = (XWPFTableCell)cells.get(l);
                                        newCell = tableRow.addNewTableCell();
                                        newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                        newCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
                                        pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                        if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                            cttc = newCell.getCTTc();
                                            ctp = (CTP)cttc.getPList().get(0);
                                            ctppr = ctp.getPPr();
                                            if (ctppr == null) {
                                                ctppr = ctp.addNewPPr();
                                            }
                                            if ((ctjc = ctppr.getJc()) == null) {
                                                ctjc = ctppr.addNewJc();
                                            }
                                            ctjc.setVal(pPr.getJc().getVal());
                                        }
                                        text1 = sourceCell.getText();
                                        matcher1 = WordHandle.matcher(text1);
                                        key21 = "";
                                        map = new HashMap();
                                        group = "";
                                        while (matcher1.find()) {
                                            group = matcher1.group();
                                            if (group.contains(".")) {
                                                int endIndex;
                                                int startIndex = text1.indexOf(35) + 1;
                                                result = text1.substring(startIndex, endIndex = text1.indexOf(125));
                                                split1 = result.split("\\.");
                                                if (split1.length != 2) continue;
                                                if (split1[1].contains("|")) {
                                                    strings2 = split1[1].split("\\|");
                                                    if (strings2.length == 3) {
                                                        key21 = strings2[0];
                                                        map.put(group, parse.get((Object)key21));
                                                    }
                                                    if (strings2.length != 2) continue;
                                                    key21 = strings2[0];
                                                    map.put(group, parse.get((Object)key21));
                                                    continue;
                                                }
                                                key21 = split1[1];
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            String group1 = String.valueOf(params.get(group));
                                            map.put(group, group1);
                                        }
                                        if (HussarUtils.isEmpty((Object)parse.get((Object)key21))) {
                                            paragraphs = newCell.getParagraphs();
                                            newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
                                            sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
                                            if (sourcePh.getRuns().isEmpty()) {
                                                run2 = newPh.createRun();
                                            } else {
                                                sourceRun2 = (XWPFRun)sourcePh.getRuns().get(0);
                                                newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                                run2 = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
                                                run2.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                run2.setColor(sourceRun2.getColor());
                                                run2.setBold(sourceRun2.isBold());
                                                run2.setItalic(sourceRun2.isItalic());
                                                this.setFontSize(sourceRun2.getFontSize(), run2);
                                            }
                                            if ("index".equals(key21)) {
                                                map1 = new HashMap<String, Object>();
                                                map1.put(group, j + 1);
                                                run2.setText(WordHandle.replaceText(text1, map1));
                                                continue;
                                            }
                                            if (HussarUtils.isNotEmpty((Object)widgets.get(key21)) && (widgets.get(key21).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(key21).equals(WidgetType.SELECT.getType()))) {
                                                sourceRun2 = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
                                                newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                                try {
                                                    Object run1;
                                                    run1 = sourcePh.getRuns().iterator();
                                                    while (run1.hasNext()) {
                                                        XWPFRun run12;
                                                        run12 = (XWPFRun)run1.next();
                                                        runNew2 = newPh.createRun();
                                                        runNew2.setText(run12.text());
                                                        runNew2.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                        runNew2.setColor(sourceRun2.getColor());
                                                        runNew2.setBold(sourceRun2.isBold());
                                                        runNew2.setItalic(sourceRun2.isItalic());
                                                        this.setFontSize(sourceRun2.getFontSize(), runNew2);
                                                    }
                                                    this.replaceInPara(newPh, map, widgets, richTextMap);
                                                }
                                                catch (FileNotFoundException e) {
                                                    LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
                                                }
                                                continue;
                                            }
                                            run2.setText("");
                                            continue;
                                        }
                                        paragraphs = newCell.getParagraphs();
                                        newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
                                        sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
                                        sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
                                        if (WordHandle.judgeInputOrSer(text1, widgets) || WordHandle.judgeImage(text1, widgets) || WordHandle.judgeFile(text1, widgets) || WordHandle.judgeTextArea(text1, widgets) || WordHandle.judgeSelect(text1, widgets) || WordHandle.judgeSignature(text1, widgets)) {
                                            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                            try {
                                                for (Object run1 : sourcePh.getRuns()) {
                                                    runNew = newPh.createRun();
                                                    runNew.setText(run1.text());
                                                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                                    runNew.setColor(sourceRun.getColor());
                                                    runNew.setBold(sourceRun.isBold());
                                                    runNew.setItalic(sourceRun.isItalic());
                                                    this.setFontSize(sourceRun.getFontSize(), runNew);
                                                }
                                                this.replaceInPara(newPh, map, widgets, richTextMap);
                                            }
                                            catch (FileNotFoundException e) {
                                                LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
                                            }
                                            continue;
                                        }
                                        newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
                                        run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
                                        run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                                        run.setColor(sourceRun.getColor());
                                        run.setBold(sourceRun.isBold());
                                        run.setItalic(sourceRun.isItalic());
                                        this.setFontSize(sourceRun.getFontSize(), run);
                                        run.setText(WordHandle.replaceText(text1, map));
                                    }
                                }
                                tableName = currentTableName;
                                lastIndex = list.size();
                            }
                            flag = false;
                        }
                        continue;
                    }
                    for (XWPFParagraph para : paras) {
                        try {
                            this.wpsHandlePara(para);
                            this.replaceInPara(para, params, widgets, richTextMap);
                            if (!this.selectionBoxEnable) continue;
                            this.replaceSelect(para, params, widgets);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
            }
            List collect = removeRows.stream().sorted().collect(Collectors.toList());
            if (!HussarUtils.isNotEmpty(collect)) continue;
            int removeNum = 0;
            for (Integer removeRow : collect) {
                removeRow = removeRow - removeNum;
                ++removeNum;
                table.removeRow(removeRow.intValue());
            }
        }
    }

    private void wpsHandlePara(XWPFParagraph para) {
        ArrayList<Character> chars = new ArrayList<Character>();
        if (HussarUtils.isNotEmpty((Object)para)) {
            List runs1 = para.getRuns();
            for (XWPFRun run1 : runs1) {
                List embeddedPictures = run1.getEmbeddedPictures();
                if (HussarUtils.isNotEmpty((Object)embeddedPictures)) {
                    return;
                }
                UnderlinePatterns underline = run1.getUnderline();
                if (underline.equals((Object)UnderlinePatterns.NONE)) continue;
                return;
            }
            String paragraphText = para.getParagraphText();
            if (paragraphText.contains("$") && paragraphText.contains("{") && paragraphText.contains("#") && paragraphText.contains("}")) {
                String fontFamily = "";
                String color = "";
                boolean bold = false;
                boolean italic = false;
                int fontSize = 0;
                List runs = para.getRuns();
                for (XWPFRun run : runs) {
                    if (!HussarUtils.isNotEmpty((Object)run)) continue;
                    String text = run.text();
                    if (fontSize == 0 || fontSize == -1) {
                        fontFamily = run.getFontFamily();
                        color = run.getColor();
                        bold = run.isBold();
                        italic = run.isItalic();
                        fontSize = run.getFontSize();
                    }
                    if (!HussarUtils.isNotEmpty((Object)text)) continue;
                    for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        chars.add(Character.valueOf(c));
                    }
                }
                for (int j = 0; j < chars.size(); ++j) {
                    List brList;
                    CTRImpl ctr;
                    String text;
                    Character c = (Character)chars.get(j);
                    if (runs.size() >= j + 1) {
                        XWPFRun xwpfRun = (XWPFRun)runs.get(j);
                        text = xwpfRun.text();
                        ctr = (CTRImpl)xwpfRun.getCTR();
                        if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList = ctr.getBrList()))) {
                            ctr.removeBr(0);
                        }
                        if (c.toString().equals("\n")) {
                            xwpfRun.addBreak();
                        }
                        if (fontSize != -1) {
                            xwpfRun.setFontSize(fontSize);
                        }
                        xwpfRun.setColor(color);
                        xwpfRun.setBold(bold);
                        xwpfRun.setItalic(italic);
                        xwpfRun.setText(c.toString(), 0);
                        continue;
                    }
                    XWPFRun run = para.createRun();
                    text = run.text();
                    ctr = (CTRImpl)run.getCTR();
                    if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList = ctr.getBrList()))) {
                        ctr.removeBr(0);
                    }
                    if (c.toString().equals("\n")) {
                        run.addBreak();
                    }
                    run.setColor(color);
                    run.setFontFamily(fontFamily);
                    run.setBold(bold);
                    run.setItalic(italic);
                    if (fontSize != -1) {
                        run.setFontSize(fontSize);
                    }
                    run.setText(c.toString(), 0);
                }
            }
        }
    }

    private void replaceInTable1(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Iterator iterator = doc.getTablesIterator();
        while (iterator.hasNext()) {
            XWPFTable table = (XWPFTable)iterator.next();
            List rows = table.getRows();
            ArrayList<Integer> widths = new ArrayList<Integer>();
            for (int k = 0; k < rows.size(); ++k) {
                XWPFTableRow row = (XWPFTableRow)rows.get(k);
                List cells = row.getTableCells();
                for (int i = 0; i < cells.size(); ++i) {
                    XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                    if (k == 0) {
                        widths.add(cell.getWidth());
                    }
                    List paras = cell.getParagraphs();
                    String text = cell.getText();
                    if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) continue;
                    for (XWPFParagraph para : paras) {
                        try {
                            this.replaceInPara1(para, params, widgets, richTextMap);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private static Matcher matcher(String str) {
        return Pattern.compile("\\$\\{(.+?)\\}", 2).matcher(str);
    }

    private static void analysisPlaceholder(XWPFDocument document, Map<String, String> widgets) {
        for (XWPFParagraph paragraph : document.getParagraphs()) {
            String paragraphText = paragraph.getParagraphText();
            Matcher matcher = WordHandle.matcher(paragraphText);
            while (matcher.find()) {
                String key = matcher.group();
                String value = WordHandle.getFormValue(key);
                if (value.contains(".")) {
                    String[] split = value.split("\\.");
                    value = split[0];
                }
                if (HussarUtils.isNotEmpty((Object)widgets.get(value))) {
                    if (widgets.get(value).equals(WidgetType.CHILDREN_TABLE.getType()) || widgets.get(value).equals(WidgetType.JXDNChildrenTableAgg.getType())) continue;
                    hashMap.put(key, value);
                    continue;
                }
                if (value.equals("flowHistoryInfo")) continue;
                hashMap.put(key, value);
            }
        }
    }

    private static void analysisTable(XWPFDocument document) {
        Iterator tablesIterator = document.getTablesIterator();
        while (tablesIterator.hasNext()) {
            XWPFTable table = (XWPFTable)tablesIterator.next();
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    Matcher matcher = WordHandle.matcher(cell.getText());
                    while (matcher.find()) {
                        String key = matcher.group();
                        String value = WordHandle.getFormValue(key);
                        hashMap.put(key, value);
                    }
                }
            }
        }
    }

    private static String getFormValue(String textPlaceholder) {
        if (textPlaceholder.contains("|")) {
            return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("|"));
        }
        return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("}"));
    }

    private static void getFormData(Map<String, Object> hashMap, JSONObject dataJson) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            String key1;
            String[] split;
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            Object obj = null;
            if (value.contains(".")) {
                split = value.split("\\.");
                if (split.length == 2) {
                    key1 = split[0];
                    String key2 = split[1];
                    Object obj1 = dataJson.get((Object)key1);
                    if (obj1 != null && obj1 instanceof List) {
                        List list = (List)obj1;
                        hashMap.put(key, list);
                        continue;
                    }
                }
            } else if (value.contains("|")) {
                split = value.split("\\|");
                if (split.length == 2 || split.length == 3) {
                    key1 = split[0];
                    obj = dataJson.get((Object)key1);
                }
            } else if (dataJson.containsKey((Object)value)) {
                obj = value.equals("printUserName") && HussarUtils.isEmpty((Object)dataJson.get((Object)value)) ? "\u5916\u90e8\u7528\u6237" : dataJson.get((Object)value);
            } else {
                if (key.equals("dataValue")) continue;
                hashMap.remove(key);
                continue;
            }
            if (obj != null) {
                hashMap.put(key, obj);
                continue;
            }
            if (key.equals("dataValue")) continue;
            hashMap.put(key, "");
        }
    }

    private String getContent(InputStream ... ises) throws IOException {
        if (ises != null) {
            StringBuilder result = new StringBuilder();
            for (InputStream is : ises) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
            }
            return result.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int entry(String mark, JSONObject parse, String inputFilePath, String outputFilePath, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets) {
        int taskState;
        block62: {
            Path path = Paths.get(outputFilePath, new String[0]);
            long timestamp = System.currentTimeMillis();
            Path temporaryPath = Paths.get(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator + timestamp + ".docx", new String[0]);
            File filePath = new File(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            taskState = 1;
            XWPFDocument xwpfDocument1 = null;
            XWPFTemplate template = null;
            FileOutputStream out = null;
            XWPFDocument document = null;
            XWPFDocument xwpfDocument = null;
            File file = null;
            try {
                try (FileInputStream inputStream = new FileInputStream(inputFilePath);
                     OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
                     XWPFDocument document1 = new XWPFDocument((InputStream)inputStream);
                     InputStream cssInput = WordHandle.class.getResourceAsStream("/wordPrint/wordPrint.css");){
                    HashMap<String, String> richTextMap = new HashMap<String, String>();
                    JSONObject parse1 = new JSONObject();
                    LinkedHashMap<String, List<String>> cssParse = new LinkedHashMap<String, List<String>>();
                    String css = HussarUtils.isNotEmpty((Object)cssInput) ? this.getContent(cssInput) : "";
                    if (HussarUtils.isNotEmpty((Object)parse)) {
                        parse.forEach((key, value) -> {
                            if (HussarUtils.isNotEmpty(widgets.get(key)) && ((String)widgets.get(key)).equals(WidgetType.JXDNRichText.getType())) {
                                String contents = "<!DOCTYPE html>\n<html lang=\"zh-cn\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n" + css + "    </style>\n</head>\n<body>\n" + value + "</body>\n</html>";
                                String html = this.matcherColor(contents);
                                Document doc = Jsoup.parse((String)html);
                                html = this.handleSpan(doc, cssParse, html);
                                html = this.handleMark(doc, cssParse, html);
                                this.handleTable(doc, cssParse, html);
                                parse1.put(key, (Object)html);
                            }
                        });
                    }
                    if (HussarUtils.isNotEmpty((Object)parse)) {
                        for (Object key2 : parse.keySet()) {
                            this.handleSu(parse, widgets, (String)key2, parse1);
                        }
                    }
                    xwpfDocument1 = this.generateWord1(hashMap, document1, widgets, parse1, richTextMap);
                    ConfigureBuilder configureBuilder = Configure.builder();
                    if (HussarUtils.isNotEmpty(richTextMap)) {
                        for (String key3 : richTextMap.keySet()) {
                            configureBuilder.bind(key3, (RenderPolicy)new HtmlRenderPolicy());
                        }
                    }
                    Configure configure = configureBuilder.build();
                    template = XWPFTemplate.compile((XWPFDocument)xwpfDocument1, (Configure)configure);
                    template.render(richTextMap);
                    file = new File(temporaryPath.toString());
                    out = new FileOutputStream(file);
                    template.write((OutputStream)out);
                    document = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPath), new String[0]), new OpenOption[0]));
                    List paragraphs = document.getParagraphs();
                    this.handleHtmlColor(paragraphs, cssParse);
                    xwpfDocument = this.generateWord(hashMap, document, widgets, parse, richTextMap);
                    if (HussarUtils.isNotEmpty((Object)mark)) {
                        DocxUtil.makeFullWaterMarkByWordArt(xwpfDocument, mark);
                    }
                    xwpfDocument.write(outputStream);
                    long fileSize = Files.size(path);
                    attachmentManagerModelVo.setAttachmentSize(Long.valueOf(fileSize));
                    this.attachmentManagerService.updateById((Object)attachmentManagerModelVo);
                }
                this.closeXWPFDocument(xwpfDocument1);
                this.closeTemplate(template);
                this.closeFile(out);
                this.closeXWPFDocument(document);
                this.closeXWPFDocument(xwpfDocument);
                if (!file.exists()) break block62;
                file.delete();
            }
            catch (Exception e) {
                taskState = -1;
                this.ossService.deleteFile(attachmentManagerModelVo.getId());
                LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
                LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            finally {
                this.closeXWPFDocument(xwpfDocument1);
                this.closeTemplate(template);
                this.closeFile(out);
                this.closeXWPFDocument(document);
                this.closeXWPFDocument(xwpfDocument);
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        hashMap.clear();
        return taskState;
    }

    private void handleSu(JSONObject parse, Map<String, String> widgets, String key, JSONObject parse1) {
        String content = "";
        String signature = "";
        String approveTime = "";
        String html = "";
        StringBuilder allBody = new StringBuilder();
        if (HussarUtils.isNotEmpty((Object)widgets.get(key)) && widgets.get(key).equals(WidgetType.JXDNSuggestion.getType())) {
            JSONArray array;
            String widgetStr = widgets.get("widgetsStr");
            JSONArray a1 = JSON.parseArray((String)widgetStr);
            for (Object o : a1) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(key) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() != 1 || !((String)list.get(0)).equals("name")) continue;
                return;
            }
            Object object = parse.get((Object)key);
            if (HussarUtils.isNotEmpty((Object)object) && HussarUtils.isNotEmpty((Object)(array = JSON.parseArray((String)String.valueOf(object))))) {
                for (Object object1 : array) {
                    Object object3;
                    HashSet<String> set = new HashSet<String>();
                    String text = "";
                    if (!HussarUtils.isNotEmpty(object1)) continue;
                    JSONObject jsonObject = (JSONObject)object1;
                    Object object2 = jsonObject.get((Object)"content");
                    if (HussarUtils.isNotEmpty((Object)object2)) {
                        set.add("content");
                        content = String.valueOf(object2);
                    }
                    if (HussarUtils.isNotEmpty((Object)(object3 = jsonObject.get((Object)"signature")))) {
                        set.add("user");
                        signature = String.valueOf(object3);
                        text = "<img width=\"64px\" height=\"30px\" src=\"" + signature + "\">\n";
                    } else {
                        Object object5 = jsonObject.get((Object)"userName");
                        if (HussarUtils.isNotEmpty((Object)object5)) {
                            set.add("user");
                            text = signature = String.valueOf(object5);
                        }
                    }
                    Object object4 = jsonObject.get((Object)"approveTime");
                    if (HussarUtils.isNotEmpty((Object)object4)) {
                        set.add("time");
                        approveTime = String.valueOf(object4);
                        approveTime = this.handleApproveTime(approveTime, widgets, key);
                    }
                    html = set.contains("content") ? SuggestionTemp.getHtml() : SuggestionTemp.getNoContentHtml();
                    String body = SuggestionTemp.getBody(set);
                    String replace = body.replace("{{content}}", content).replace("{{approveTime}}", approveTime).replace("{{user}}", text);
                    allBody.append(replace);
                }
            }
            html = html.replace("{{template}}", allBody.toString());
            parse.put(key, (Object)html);
            parse1.put(key, (Object)html);
        }
    }

    private String handleApproveTime(String approveTime, Map<String, String> widgets, String key) {
        String string = widgets.get("widgetsStr");
        String format = "";
        if (HussarUtils.isNotEmpty((Object)string)) {
            String widget = JSON.parseArray((String)string);
            Iterator iterator = widget.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject;
                Object object;
                Object o = iterator.next();
                if (!HussarUtils.isNotEmpty(o) || !String.valueOf(object = (jsonObject = (JSONObject)o).get((Object)"name")).equals(key)) continue;
                Object object1 = jsonObject.get((Object)"props");
                JSONObject props = (JSONObject)object1;
                Object object2 = props.get((Object)"format");
                format = String.valueOf(object2);
                break;
            }
        }
        switch (format) {
            case "yyyy-MM-dd HH": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6";
                break;
            }
            case "yyyy-MM-dd": {
                format = "yyyy\u5e74MM\u6708dd\u65e5";
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
            }
        }
        long timestamp = Long.parseLong(approveTime);
        LocalDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return dateTime.format(formatter);
    }

    private void handleTable(Document doc, Map<String, List<String>> cssParse, String html) {
    }

    private String handleMark(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements marks = doc.select("mark");
        for (Element markCss : marks) {
            String cssClass = markCss.attr("class");
            String text = markCss.text();
            ArrayList<String> color = new ArrayList<String>();
            switch (cssClass) {
                case "marker-yellow": {
                    this.setCss(cssParse, markCss, text, color, "yellow");
                    break;
                }
                case "marker-green": {
                    this.setCss(cssParse, markCss, text, color, "green");
                    break;
                }
                case "marker-blue": {
                    this.setCss(cssParse, markCss, text, color, "72ccfd");
                    break;
                }
                case "marker-pink": {
                    this.setCss(cssParse, markCss, text, color, "fc7899");
                    break;
                }
                case "pen-red": {
                    this.setCss(cssParse, markCss, text, color, "e71313");
                    break;
                }
                case "pen-green": {
                    this.setCss(cssParse, markCss, text, color, "128a00");
                }
            }
        }
        return doc.html();
    }

    private void setCss(Map<String, List<String>> cssParse, Element markCss, String text, List<String> color, String css) {
        if (!cssParse.containsKey(text)) {
            color.add(css);
            cssParse.put(text, color);
        } else {
            cssParse.get(text).add(css);
        }
        markCss.text("%" + text + "%");
    }

    private String handleSpan(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements spans = doc.select("span");
        for (Element span : spans) {
            String pattern;
            Pattern p;
            Matcher m;
            String style = span.attr("style");
            String text = span.text();
            if (!style.contains("background-color") || !(m = (p = Pattern.compile(pattern = "background-color:#[0-9a-fA-F]+;")).matcher(style)).matches()) continue;
            ArrayList<String> color = new ArrayList<String>();
            style = m.group();
            color.add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
            span.text("%" + text + "%");
            if (!cssParse.containsKey(text)) {
                cssParse.put(text, color);
                continue;
            }
            cssParse.get(text).add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
        }
        return doc.html();
    }

    private void handleHtmlColor(List<XWPFParagraph> paragraphs, Map<String, List<String>> cssParse) {
        for (XWPFParagraph paragraph : paragraphs) {
            List runs = paragraph.getRuns();
            block1: for (XWPFRun run : runs) {
                String text = run.text();
                for (String key : cssParse.keySet()) {
                    String group;
                    String patternString = "%(.*?)%";
                    Pattern pattern = Pattern.compile(patternString);
                    Matcher matcher = pattern.matcher(text);
                    if (!matcher.find() || !key.equals(group = matcher.group(1))) continue;
                    run.setText("", 0);
                    run.setText(key, 0);
                    String cssParseString = "";
                    List<String> list = cssParse.get(key);
                    if (!list.isEmpty()) {
                        cssParseString = list.get(0);
                        list.remove(0);
                    }
                    if (cssParseString.equals("yellow") || cssParseString.equals("green")) {
                        run.setTextHighlightColor(cssParseString);
                        continue block1;
                    }
                    if (cssParseString.equals("e71313") || cssParseString.equals("128a00")) {
                        run.setColor(cssParseString);
                        continue block1;
                    }
                    CTShd shd = CTShd.Factory.newInstance();
                    shd.setFill((Object)cssParseString);
                    shd.setVal(STShd.CLEAR);
                    run.getCTR().getRPr().setShd(shd);
                    continue block1;
                }
            }
        }
    }

    private void closeFile(FileOutputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeTemplate(XWPFTemplate o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeXWPFDocument(XWPFDocument o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private String matcherColor(String htmlString) {
        HashMap hslColors = new HashMap();
        Pattern pattern = Pattern.compile("hsl\\(\\s*(\\d+),\\s*(\\d+)%\\s*,\\s*(\\d+)%\\s*\\)");
        Matcher matcher = pattern.matcher(htmlString);
        while (matcher.find()) {
            ArrayList<String> list = new ArrayList<String>();
            String hue = matcher.group(1);
            String saturation = matcher.group(2);
            String lightness = matcher.group(3);
            list.add(hue);
            list.add(saturation);
            list.add(lightness);
            hslColors.put(matcher.group(0), list);
        }
        if (HussarUtils.isNotEmpty(hslColors)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : hslColors.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                double hue = Double.parseDouble((String)value.get(0));
                double saturation = Double.parseDouble((String)value.get(1));
                double lightness = Double.parseDouble((String)value.get(2));
                String hex = this.gentHex(hue, saturation, lightness);
                map.put(key, hex);
            }
            for (Map.Entry entry : map.entrySet()) {
                htmlString = htmlString.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return htmlString;
    }

    public String gentHex(double H, double S, double L) {
        int[] rgb = WordHandle.hslToRgb(H /= 360.0, S /= 100.0, L /= 100.0);
        int red = rgb[0];
        int green = rgb[1];
        int blue = rgb[2];
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    private static int[] hslToRgb(double h, double s, double l) {
        double r;
        double g;
        double b;
        if (s == 0.0) {
            g = b = l;
            r = b;
        } else {
            double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
            double p = 2.0 * l - q;
            r = WordHandle.hueToRgb(p, q, h + 0.3333333333333333);
            g = WordHandle.hueToRgb(p, q, h);
            b = WordHandle.hueToRgb(p, q, h - 0.3333333333333333);
        }
        int red = (int)Math.round(r * 255.0);
        int green = (int)Math.round(g * 255.0);
        int blue = (int)Math.round(b * 255.0);
        return new int[]{red, green, blue};
    }

    private static double hueToRgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - t) * 6.0;
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void wordHandle(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            UserDetails userDetails;
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)WordHandle.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            String processInstId = wordPrintParamsDto.getProcessInstId();
            String businessId = wordPrintParamsDto.getBusinessId();
            String tabType = wordPrintParamsDto.getTabType();
            Object data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            Map widgets = widgetsAndData.getMap();
            String jsonString = JSONObject.toJSONString((Object)entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject parse = (JSONObject)JSONObject.parse((String)jsonString);
            parse.put("langCode", (Object)wordPrintParamsDto.getLangCode());
            if (HussarUtils.isNotEmpty((Object)processInstId) && HussarUtils.isNotEmpty((Object)businessId)) {
                BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
                JSONArray jsonArray = result.getResult();
                JSONArray jsonArray1 = new JSONArray();
                if (HussarUtils.isEmpty((Object)jsonArray)) {
                    LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
                } else {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                    Object object = jsonObject.get((Object)"completeList");
                    jsonArray1 = (JSONArray)object;
                    for (Object o : jsonArray1) {
                        JSONObject jsonObject1 = (JSONObject)o;
                        Object object1 = jsonObject1.get((Object)"comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        String comment = String.valueOf(object1);
                        try {
                            JSONObject jsonObject2 = JSONObject.parseObject((String)comment);
                            jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                }
                parse.put("flowHistoryInfo", (Object)jsonArray1);
            }
            parse.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)(userDetails = wordPrintParamsDto.getUserDetails())) ? userDetails.getUserName() : null));
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            String printTime = WordHandle.getFormatTime(System.currentTimeMillis());
            parse.put("printDateTime", (Object)printTime);
            JSONObject content = (JSONObject)JSONObject.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.attachmentManagerService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String fileName = this.handlerGeneFileName(printTemplate, printTime, formId, parse);
            String outputPathNew = this.outputPath + "wordTemplate" + File.separator;
            attachmentManagerModelVo.setAttachmentName(fileName);
            attachmentManagerModelVo.setAttachmentDir(outputPathNew);
            attachmentManagerModelVo.setAttachmentType(WordHandle.getSuffix(attachmentManagerModelVo.getAttachmentName()).replace(".", ""));
            this.attachmentManagerService.save((Object)attachmentManagerModelVo);
            Long fileId = attachmentManagerModelVo.getId();
            if (HussarUtils.isEmpty((Object)fileId)) {
                throw new BaseException("\u6253\u5370\u6587\u4ef6\u76f8\u5173\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }
            String outputFilePath = outputPathNew + File.separator + fileId + ".docx";
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            taskState = this.entry(mark, parse, attachmentManagerServiceByFileId.getPath(), outputFilePath, attachmentManagerModelVo, widgets);
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    private void updateTask(int taskState, Long fileId, Long taskId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SysWordPrintTask::getFileId, (Object)fileId)).set(SysWordPrintTask::getTaskStatus, (Object)taskState)).eq(SysWordPrintTask::getTaskId, (Object)taskId);
        boolean flag = this.sysWordPrintTaskService.update((Wrapper)updateWrapper);
        if (!flag) {
            LOGGER.error("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25,\u4efb\u52a1id\uff1a{}", (Object)taskId);
            throw new BaseException("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25");
        }
    }

    private String handlerGeneFileName(SysPrintTemplate printTemplate, String printTime, String formId, JSONObject parse) {
        String fileName = null;
        SysPrintGeneFileName geneFileName = (SysPrintGeneFileName)JSON.parseObject((String)printTemplate.getFileName(), SysPrintGeneFileName.class);
        if (HussarUtils.isNotEmpty((Object)geneFileName)) {
            FileNameMode mode = FileNameMode.getFileNameMode((int)geneFileName.getMode());
            String template = geneFileName.getTemplate();
            SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)((Object)formId));
            if (HussarUtils.isEmpty((Object)sysForm)) {
                LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
                throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728");
            }
            switch (Objects.requireNonNull(mode)) {
                case DEFAULT: {
                    Object object = parse.get((Object)"langCode");
                    if (HussarUtils.isNotEmpty((Object)object)) {
                        String langCode = String.valueOf(object);
                        fileName = this.i18nUtil.getCommonI18nByKeys(langCode, sysForm.getI18nKeys(), "formName", sysForm.getFormName());
                    } else {
                        fileName = sysForm.getFormName();
                    }
                    fileName = fileName + "_" + printTime;
                    break;
                }
                case TITLE: {
                    Object o = parse.get((Object)"title");
                    fileName = String.valueOf(o);
                    break;
                }
                case TEMPLATE: {
                    JSONObject parse1 = new JSONObject();
                    parse.put("formName", (Object)sysForm.getFormName());
                    Matcher matcher = WordHandle.matcher(template);
                    while (matcher.find()) {
                        String key2 = matcher.group();
                        String value2 = matcher.group(1);
                        parse1.put(key2, (Object)value2);
                    }
                    parse.forEach((key, value) -> parse1.forEach((key1, value1) -> {
                        if (value1.equals(key)) {
                            if (HussarUtils.isEmpty((Object)value)) {
                                parse1.put(key1, (Object)"");
                            } else {
                                parse1.put(key1, value);
                            }
                        }
                    }));
                    fileName = WordHandle.replaceText(template, (Map<String, Object>)parse1);
                }
            }
        }
        if (!HussarUtils.isNull(fileName)) {
            String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(fileName);
            while (matcher.find()) {
                String group = matcher.group();
                String replace = group.replace(":", "");
                String replace1 = replace.replace("-", "");
                String replace2 = replace1.replace(" ", "_");
                fileName = fileName.replace(group, replace2);
            }
            fileName = fileName.length() > 50 ? fileName.substring(0, 50) : fileName;
        }
        return fileName + ".docx";
    }

    private String showImage(Long id) {
        AttachmentManagerModel image;
        String absolutePath = null;
        if (HussarUtils.isNotEmpty((Object)id) && !HussarUtils.isEmpty((Object)(image = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)id)))) {
            String fileName = image.getAttachmentName();
            String fileSavePath = image.getAttachmentDir();
            String suffix = WordHandle.getSuffix(fileName);
            absolutePath = fileSavePath + id + suffix;
        }
        return absolutePath;
    }

    public static String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private static List<Double> getImageWidthAndHeight(String width, String height, int mode, double widthToHeight) {
        if (widthToHeight == 0.0) {
            widthToHeight = 1.5;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        if (mode == 0) {
            list.add(Double.parseDouble(height) * widthToHeight);
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 1) {
            list.add(Double.valueOf(width));
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 2) {
            list.add(Double.valueOf(width));
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 3) {
            list.add(Double.parseDouble(width));
            list.add(Double.parseDouble(width) / widthToHeight);
            return list;
        }
        list.add(Double.parseDouble(width));
        list.add(Double.parseDouble(height));
        return list;
    }

    public static String getFormatTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static boolean judgeImage(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.IMAGE.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.IMAGE.getType());
        }
        return false;
    }

    public static boolean judgeSuggestion(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNSuggestion.getType());
    }

    public static boolean judgeSignature(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
        }
        return false;
    }

    public static boolean judgeFile(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.FILE.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.FILE.getType());
    }

    public static boolean judgeRichText(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
    }

    public static boolean judgeTextArea(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
    }

    public static boolean judgeSelect(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.CHECK_BOX_GROUP.getType()) || widgets.get(result).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(result).equals(WidgetType.SELECT.getType()) || widgets.get(result).equals(WidgetType.RADIO_GROUP.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.CHECK_BOX_GROUP.getType()) || widgets.get(result).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(result).equals(WidgetType.SELECT.getType()) || widgets.get(result).equals(WidgetType.RADIO_GROUP.getType());
    }

    public static boolean judgeInputOrSer(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124, startIndex));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
        }
        return false;
    }
}

