/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.panel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.panel.dao.SysPanelMapper;
import com.jxdinfo.hussar.formdesign.application.panel.dto.SysPanelDto;
import com.jxdinfo.hussar.formdesign.application.panel.model.SysPanel;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelService;
import com.jxdinfo.hussar.formdesign.application.panel.vo.SysPanelVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.panel.service.impl.SysPanelServiceImpl")
public class SysPanelServiceImpl
extends HussarServiceImpl<SysPanelMapper, SysPanel>
implements ISysPanelService {
    @Resource
    private SysPanelMapper sysPanelMapper;

    public ApiResponse<Long> addPanel(SysPanelDto sysPanelDto) {
        this.save((BaseEntity)sysPanelDto);
        return ApiResponse.success((Object)sysPanelDto.getPanelId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public ApiResponse<Boolean> editPanel(SysPanelDto sysPanelDto) {
        boolean flag = this.updateById((BaseEntity)sysPanelDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deletePanel(Long panelId) {
        boolean flag = this.removeById(panelId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<SysPanelVo> getPanelList(SysPanelDto sysPanelDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List panelList = this.sysPanelMapper.selectList((Wrapper)queryWrapper.like(SysPanel::getPanelName, (Object)sysPanelDto.getPanelName()));
        ArrayList<SysPanelVo> panelVos = new ArrayList<SysPanelVo>();
        for (SysPanel sysPanel : panelList) {
            SysPanelVo sysPanelVo = new SysPanelVo();
            if (!HussarUtils.isNotEmpty((Object)sysPanel)) continue;
            BeanUtils.copyProperties((Object)sysPanel, (Object)sysPanelVo);
            panelVos.add(sysPanelVo);
        }
        return panelVos;
    }

    public SysPanelVo getPanelDetail(String panelId) {
        SysPanelVo sysPanelVo = new SysPanelVo();
        SysPanel sysPanel = (SysPanel)this.getById((Serializable)((Object)panelId));
        if (HussarUtils.isNotEmpty((Object)sysPanel)) {
            BeanUtils.copyProperties((Object)sysPanel, (Object)sysPanelVo);
        }
        return sysPanelVo;
    }
}

