/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.panel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.panel.dao.SysPanelChartMapper;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.application.panel.dto.SysPanelChartDto;
import com.jxdinfo.hussar.formdesign.application.panel.model.SysPanelChart;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelChartService;
import com.jxdinfo.hussar.formdesign.application.panel.vo.SysPanelChartVo;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.panel.service.impl.SysPanelChartServiceImpl")
public class SysPanelChartServiceImpl
extends HussarServiceImpl<SysPanelChartMapper, SysPanelChart>
implements ISysPanelChartService {
    @Resource
    private SysPanelChartMapper sysPanelChartMapper;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysApplicationExternalService applicationService;

    public ApiResponse<Long> addPanelChart(SysPanelChartDto sysPanelChartDto) {
        this.save((BaseEntity)sysPanelChartDto);
        return ApiResponse.success((Object)sysPanelChartDto.getChartId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public ApiResponse<Boolean> editPanelChart(SysPanelChartDto sysPanelChartDto) {
        boolean flag = this.updateById((BaseEntity)sysPanelChartDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deletePanelChart(Long chartId) {
        boolean flag = this.removeById(chartId);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public List<SysPanelChartVo> getPanelChartList(SysPanelChartDto sysPanelChartDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List panelChartList = this.sysPanelChartMapper.selectList((Wrapper)queryWrapper.like(SysPanelChart::getChartName, (Object)sysPanelChartDto.getChartName()));
        return panelChartList.stream().map(sysPanelChart -> (SysPanelChartVo)sysPanelChart).collect(Collectors.toList());
    }

    public SysPanelChartVo getPanelChartDetail(String panelChartId) {
        SysPanelChartVo sysPanelChartVo = new SysPanelChartVo();
        SysPanelChart sysPanelChart = (SysPanelChart)this.getById((Serializable)((Object)panelChartId));
        if (HussarUtils.isNotEmpty((Object)sysPanelChart)) {
            BeanUtils.copyProperties((Object)sysPanelChart, (Object)sysPanelChartVo);
        }
        return sysPanelChartVo;
    }

    public ApiResponse<Object> queryChartData(QueryChartDataDto queryChartDataDto) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), queryChartDataDto.getAppId(), queryChartDataDto.getFormId(), "echartQuery");
        ResponseEntity responseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, queryChartDataDto.getParams());
        return (ApiResponse)responseEntity.getBody();
    }

    public ApiResponse<Object> formData(QueryChartDataDto queryChartDataDto) {
        Boolean flag = (Boolean)this.applicationService.checkRolePermissions(Long.valueOf(queryChartDataDto.getFormId())).getData();
        if (!flag.booleanValue()) {
            return ApiResponse.success(null, (String)"\u65e0\u8868\u5355\u6743\u9650");
        }
        String appId = queryChartDataDto.getAppId();
        String formId = queryChartDataDto.getFormId();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (!((Boolean)WidgetTool.isSourceExist((String)appId, (String)formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return objectApiResponse;
        }
        String viewId = HussarUtils.equals((Object)queryChartDataDto.getFormType(), (Object)"0") ? "joiopt0oou9plqj559byloyqdj0dk31i" : "e33a41s5fcl06btfvdc0qnbvqt9wd1h4";
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        return (ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, queryChartDataDto.getParams()).getBody();
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }
}

