/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.aspect;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogComponent;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OpControllerAnnoAspect {
    @Value(value="${hussar.nocode.dataOperateLog.isEnable:true}")
    private Boolean isSaveLog;
    @Resource
    private OperateLogComponent operateLogComponent;

    @Before(value="@annotation(annotation)")
    public void before(OpControllerAnno annotation) {
        if (this.isSaveLog.booleanValue()) {
            String device;
            SecurityUser user = BaseSecurityUtil.getUser();
            TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
            TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (HussarUtils.isNotEmpty((Object)requestAttributes)) {
                HttpServletRequest request = requestAttributes.getRequest();
                device = this.operateLogComponent.judgeDevice(request);
            } else {
                device = "Unknown";
            }
            TransmittableThreadLocalHolder.set((String)"device", (Object)device);
        }
    }
}

