/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncUserService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdUserMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.AddStaffUserDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtStaffUserEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtUserDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtUserEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ThirdUserAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdUserRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdStaffService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdUserServiceImpl
extends HussarServiceImpl<ThirdUserMapper, ThirdUserRela>
implements IThirdUserService {
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private IThirdOrganService thirdOrganService;
    @Resource
    private IHussarBaseSyncUserService hussarBaseSyncUserService;
    @Resource
    private IThirdStaffService thirdStaffService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdUserServiceImpl.class);

    @Override
    public ApiResponse<Void> addUser(ThirdUserAddDto thirdUserAddDto) {
        LOGGER.info("openApi -> \u65b0\u589e\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdUserAddDto)));
        thirdUserAddDto.setOrganIds(this.thirdOrganService.listPlatformOrganIds(thirdUserAddDto.getExtOrganIds()));
        thirdUserAddDto.setStaffId(this.thirdStaffService.getPlatformStaffId(thirdUserAddDto.getExtStaffId()));
        R addUserRes = this.hussarBaseSyncUserService.addOnlyUserWithSecure((AddOnlyOutsideUserDto)thirdUserAddDto);
        if (!addUserRes.isSuccess()) {
            LOGGER.error("openApi -> \u65b0\u589e\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addUserRes.getErrorList()));
            return ApiResponse.fail((String)"\u65b0\u589e\u7528\u6237\u5931\u8d25");
        }
        ThirdUserRela thirdUserRela = new ThirdUserRela();
        thirdUserRela.setUserId(((DataMapping)addUserRes.getSuccessList().get(0)).getId());
        thirdUserRela.setThirdUserId(thirdUserAddDto.getExtUserId());
        this.save((BaseEntity)thirdUserRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editUser(ExtUserEditDto extUserEditDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extUserEditDto)));
        extUserEditDto.setOrganIds(this.thirdOrganService.listPlatformOrganIds(extUserEditDto.getExtOrganIds()));
        extUserEditDto.setStaffId(this.thirdStaffService.getPlatformStaffId(extUserEditDto.getExtStaffId()));
        R editUserRes = this.hussarBaseSyncUserService.editOnlyUser((EditOnlyOutsideUserDto)extUserEditDto);
        if (!editUserRes.isSuccess()) {
            LOGGER.error("openApi -> \u4fee\u6539\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editUserRes.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u7528\u6237\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delUser(ExtUserDelDto extUserDelDto) {
        String userAccount = extUserDelDto.getUserAccount();
        LOGGER.info("openApi -> \u5220\u9664\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)userAccount);
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userAccount));
        R delUserRes = this.hussarBaseSyncUserService.deleteOnlyUser(userAccount);
        if (!delUserRes.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delUserRes.getErrorList()));
            return ApiResponse.fail((String)"\u5220\u9664\u7528\u6237\u5931\u8d25");
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getUserId, (Object)user.getId()));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> addStaffUser(AddStaffUserDto addStaffUserDto) {
        LOGGER.info("openApi -> \u65b0\u589e\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)addStaffUserDto)));
        if (addStaffUserDto.getOrganIds() == null) {
            addStaffUserDto.setOrganIds(new ArrayList());
        }
        String[] extDepartmentIds = addStaffUserDto.getExtDepartmentId().split(",");
        for (int i = 0; i < extDepartmentIds.length; ++i) {
            Long platformOrganId = this.thirdOrganService.getPlatformOrganId(extDepartmentIds[i]);
            addStaffUserDto.getOrganIds().add(platformOrganId);
        }
        ThirdUserRela thirdUserRela1 = this.getThirdUserRela(addStaffUserDto.getExtUserId());
        if (HussarUtils.isNotEmpty((Object)((Object)thirdUserRela1)) && HussarUtils.equals((Object)"1", (Object)thirdUserRela1.getDelFlag())) {
            ExtStaffUserEditDto extStaffUserEditDto = (ExtStaffUserEditDto)((Object)HussarUtils.copyProperties((Object)((Object)addStaffUserDto), ExtStaffUserEditDto.class));
            assert (extStaffUserEditDto != null);
            extStaffUserEditDto.setUpdateDeleteFlag(true);
            R editOutsideUserDtoR = this.hussarBaseSyncUserService.editUser((EditOutsideUserDto)extStaffUserEditDto);
            if (!editOutsideUserDtoR.isSuccess()) {
                LOGGER.error("openApi -> \u65b0\u589e\u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editOutsideUserDtoR.getErrorList()));
                throw new HussarException("\u65b0\u589e\u4eba\u5458\u7528\u6237\u5931\u8d25");
            }
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(ThirdUserRela::getUserId, (Object)thirdUserRela1.getUserId());
            ThirdUserRela thirdUserRela = new ThirdUserRela();
            thirdUserRela.setDelFlag("0");
            this.update((BaseEntity)thirdUserRela, (Wrapper)updateWrapper);
        } else {
            R addStaffUserResult = this.hussarBaseSyncUserService.addUser((AddOutsideUserDto)addStaffUserDto);
            if (!addStaffUserResult.isSuccess()) {
                LOGGER.error("openApi -> \u65b0\u589e\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addStaffUserResult.getErrorList()));
                return ApiResponse.fail((String)"\u65b0\u589e\u4eba\u5458\u7528\u6237\u5931\u8d25");
            }
            ThirdUserRela thirdUserRela = new ThirdUserRela();
            thirdUserRela.setThirdUserId(addStaffUserDto.getExtUserId());
            thirdUserRela.setUserId(((DataMapping)addStaffUserResult.getSuccessList().get(0)).getId());
            thirdUserRela.setDelFlag("0");
            this.save((BaseEntity)thirdUserRela);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editStaffUser(ExtStaffUserEditDto extStaffUserEditDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extStaffUserEditDto)));
        if (extStaffUserEditDto.getOrganIds() == null) {
            extStaffUserEditDto.setOrganIds(new ArrayList());
        }
        String[] extDepartmentIds = extStaffUserEditDto.getExtDepartmentId().split(",");
        for (int i = 0; i < extDepartmentIds.length; ++i) {
            Long platformOrganId = this.thirdOrganService.getPlatformOrganId(extDepartmentIds[i]);
            extStaffUserEditDto.getOrganIds().add(platformOrganId);
        }
        R editStaffUserResult = this.hussarBaseSyncUserService.editUser((EditOutsideUserDto)extStaffUserEditDto);
        if (!editStaffUserResult.isSuccess()) {
            LOGGER.error("openApi -> \u4fee\u6539\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editStaffUserResult.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delStaffUser(ExtUserDelDto extUserDelDto) {
        String userAccount = extUserDelDto.getUserAccount();
        LOGGER.info("openApi -> \u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)userAccount));
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userAccount));
        R delStaffUserRes = this.hussarBaseSyncUserService.deleteUser(userAccount);
        if (!delStaffUserRes.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delStaffUserRes.getErrorList()));
            return ApiResponse.fail((String)"\u5220\u9664\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getUserId, (Object)user.getId()));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delLogicalStaffUser(ExtUserDelDto extUserDelDto) {
        String userAccount = extUserDelDto.getUserAccount();
        LOGGER.info("openApi -> \u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)userAccount));
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userAccount));
        R delStaffUserRes = this.hussarBaseSyncUserService.deleteLogicalUser(userAccount);
        if (!delStaffUserRes.isSuccess()) {
            LOGGER.error("openApi -> \u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delStaffUserRes.getErrorList()));
            return ApiResponse.fail((String)"\u5220\u9664\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(ThirdUserRela::getUserId, (Object)user.getId());
        ThirdUserRela thirdUserRela = new ThirdUserRela();
        thirdUserRela.setDelFlag("1");
        this.update((BaseEntity)thirdUserRela, (Wrapper)updateWrapper);
        return ApiResponse.success();
    }

    @Override
    public List<Long> listPlatformUserIds(List<String> extUserIds) {
        List userRelas = this.list((Wrapper)new LambdaQueryWrapper().in(ThirdUserRela::getThirdUserId, extUserIds));
        return userRelas.stream().map(ThirdUserRela::getUserId).collect(Collectors.toList());
    }

    @Override
    public Long getPlatformUserId(String extUserId) {
        ThirdUserRela userRela = (ThirdUserRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getThirdUserId, (Object)extUserId)));
        return userRela.getUserId();
    }

    @Override
    public ThirdUserRela getThirdUserRela(String extUserId) {
        return (ThirdUserRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getThirdUserId, (Object)extUserId)));
    }
}

