/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdStaffMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtStaffAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtStaffDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtStaffEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdOrganRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdStaffRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdStaffService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdStaffServiceImpl
extends HussarServiceImpl<ThirdStaffMapper, ThirdStaffRela>
implements IThirdStaffService {
    @Resource
    private IHussarBaseSyncStaffService hussarBaseSyncStaffService;
    @Resource
    private IThirdOrganService thirdOrganService;
    @Resource
    private ISysStaffService sysStaffService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdStaffServiceImpl.class);

    @Override
    public ApiResponse<Void> addStaff(ExtStaffAddDto extStaffAddDto) {
        LOGGER.info("openApi -> \u65b0\u589e\u4eba\u5458\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extStaffAddDto)));
        List organRelas = this.thirdOrganService.list((Wrapper)new LambdaQueryWrapper().in(ThirdOrganRela::getThirdOrganId, extStaffAddDto.getExtOrganIds()));
        List organIds = organRelas.stream().map(ThirdOrganRela::getOrganId).collect(Collectors.toList());
        extStaffAddDto.setOrganIds(organIds);
        R addStaffRes = this.hussarBaseSyncStaffService.addOnlyStaff((AddOnlyOutsideStaffDto)extStaffAddDto);
        if (!addStaffRes.isSuccess()) {
            LOGGER.error("openApi -> \u65b0\u589e\u4eba\u5458\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addStaffRes.getErrorList()));
            return ApiResponse.fail((String)"\u65b0\u589e\u4eba\u5458\u5931\u8d25");
        }
        ThirdStaffRela staffRela = new ThirdStaffRela();
        staffRela.setStaffId(((DataMapping)addStaffRes.getSuccessList().get(0)).getId());
        staffRela.setThirdStaffId(extStaffAddDto.getExtStaffId());
        this.save((BaseEntity)staffRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editStaff(ExtStaffEditDto extStaffEditDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u4eba\u5458\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extStaffEditDto)));
        extStaffEditDto.setOrganIds(this.thirdOrganService.listPlatformOrganIds(extStaffEditDto.getExtOrganIds()));
        R editStaffRes = this.hussarBaseSyncStaffService.editOnlyStaff((EditOnlyOutsideStaffDto)extStaffEditDto);
        if (!editStaffRes.isSuccess()) {
            LOGGER.error("openApi -> \u4fee\u6539\u4eba\u5458\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editStaffRes.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u4eba\u5458\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delStaff(ExtStaffDelDto extStaffDelDto) {
        String staffCode = extStaffDelDto.getStaffCode();
        LOGGER.info("openApi -> \u5220\u9664\u4eba\u5458\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)staffCode));
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStaffCode, (Object)staffCode));
        R delStaffRes = this.hussarBaseSyncStaffService.deleteOnlyStaff(staffCode);
        if (!delStaffRes.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u4eba\u5458\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delStaffRes.getErrorList()));
            return ApiResponse.fail((String)"\u5220\u9664\u4eba\u5458\u5931\u8d25");
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdStaffRela::getStaffId, (Object)staff.getId()));
        return ApiResponse.success();
    }

    @Override
    public Long getPlatformStaffId(String extStaffId) {
        ThirdStaffRela staffRela = (ThirdStaffRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdStaffRela::getThirdStaffId, (Object)extStaffId)));
        return staffRela.getStaffId();
    }
}

