/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.job;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushTask;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.msg.push.dto.AppImSendArticleDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class MsgPushTaskPoller
implements BasicProcessor {
    @Resource
    private SysMsgPushTaskService msgPushTaskService;
    @Resource
    private ISysFormService formService;
    @Autowired(required=false)
    private PushMsgService pushMsgService;
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String socket;
    private static final String DEVICE_WEB = "hussarAppFrame";
    private static final String DEVICE_MOBILE = "hussarApp";
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgPushTaskPoller.class);

    public ProcessResult process(TaskContext context) {
        String dataSourceKey = DataModelUtil.currentDsName();
        String tenantCode = context.getTenantCode();
        LocalDateTime now = LocalDateTime.now();
        LOGGER.info("\u6d88\u606f\u63a8\u9001 => \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a{},\u6570\u636e\u6e90\uff1a{}", (Object)now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), (Object)dataSourceKey);
        List sysMsgPushTasks = this.msgPushTaskService.queryMsgPushTasks(now);
        if (HussarUtils.isNotEmpty((Object)sysMsgPushTasks)) {
            for (SysMsgPushTask sysMsgPushTask : sysMsgPushTasks) {
                ThreadPoolUtil.execute(() -> {
                    RequestContextHolder.resetRequestAttributes();
                    this.invokeMessageCenterInterface(sysMsgPushTask, dataSourceKey, tenantCode);
                });
            }
            ArrayList<SysMsgPushTask> updatedTasks = new ArrayList<SysMsgPushTask>();
            ArrayList<SysMsgPushTask> newTasks = new ArrayList<SysMsgPushTask>();
            for (SysMsgPushTask sysMsgPushTask : sysMsgPushTasks) {
                LocalDateTime nextReminderTime;
                sysMsgPushTask.setStatus("1");
                sysMsgPushTask.setExecuteTime(now);
                updatedTasks.add(sysMsgPushTask);
                RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysMsgPushTask.getRepeatRule(), RepeatRule.class);
                if ("only_once".equals(repeatRule.getType()) || (nextReminderTime = repeatRule.calculateNextReminderTime(sysMsgPushTask.getFirstReminderTime(), now)).isAfter(sysMsgPushTask.getEndReminderTime())) continue;
                SysMsgPushTask newTask = new SysMsgPushTask();
                BeanUtils.copyProperties((Object)sysMsgPushTask, (Object)newTask);
                newTask.setId(null);
                newTask.setNextReminderTime(nextReminderTime);
                newTask.setStatus("0");
                newTask.setExecuteTime(null);
                newTasks.add(newTask);
            }
            this.msgPushTaskService.saveBatch(newTasks);
            this.msgPushTaskService.updateBatchById(updatedTasks);
        }
        return new ProcessResult(true, "success");
    }

    @HussarDs(value="#dataSourceKey")
    void invokeMessageCenterInterface(SysMsgPushTask sysMsgPushTask, String dataSourceKey, String tenantCode) {
        List modes = JSON.parseArray((String)sysMsgPushTask.getReminderMode(), String.class);
        Iterator iterator = modes.iterator();
        block16: while (iterator.hasNext()) {
            String mode;
            switch (mode = (String)iterator.next()) {
                case "app_im": {
                    AppImSendArticleDto imPushDto = new AppImSendArticleDto();
                    imPushDto.setAppId("formMsgPush");
                    imPushDto.setAppSecret("296416d4aff41d2ead60e4d790e72318");
                    imPushDto.setSceneCode("formMsgPush");
                    String reminders = sysMsgPushTask.getReminders();
                    reminders = reminders.substring(1, reminders.length() - 1);
                    imPushDto.setUserIds(Arrays.asList(reminders.split(",")));
                    imPushDto.setText(sysMsgPushTask.getReminderContent());
                    imPushDto.setUrl(this.assemblyUrl(DEVICE_MOBILE, sysMsgPushTask));
                    LOGGER.info("\u8868\u5355\u6d88\u606f\u63a8\u9001 => \u6267\u884c\u63a8\u9001\u4efb\u52a1 {}", (Object)sysMsgPushTask.getId());
                    LOGGER.info("\u8868\u5355\u6d88\u606f\u63a8\u9001 => \u6267\u884c\u63a8\u9001\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)imPushDto));
                    try {
                        this.pushMsgService.sendAppImArticleMsg(imPushDto);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6d88\u606f\u63a8\u9001 => \u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25", (Throwable)e);
                    }
                    continue block16;
                }
                case "station_message": {
                    try {
                        this.callZnxInterface(sysMsgPushTask, tenantCode);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6d88\u606f\u63a8\u9001 => \u3010\u7ad9\u5185\u4fe1\u3011\u63a8\u9001\u5931\u8d25", (Throwable)e);
                    }
                    continue block16;
                }
                case "mail": {
                    LOGGER.info("\u90ae\u7bb1");
                    continue block16;
                }
                case "app_push": {
                    LOGGER.info("APP \u901a\u77e5");
                    continue block16;
                }
            }
            throw new HussarException("\u63d0\u9192\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
    }

    private void callZnxInterface(SysMsgPushTask sysMsgPushTask, String tenantCode) {
        MsgUnitySendDto msgUnitySendDto = new MsgUnitySendDto();
        msgUnitySendDto.setSceneCode("formMsgPush");
        msgUnitySendDto.setTenantCode(tenantCode);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("msg", sysMsgPushTask.getReminderContent());
        msgUnitySendDto.setTemplateParams(templateParams);
        msgUnitySendDto.setSendTypes((List)Lists.newArrayList((Object[])new String[]{"station_message"}));
        HashMap incompleteTemplateParams = new HashMap();
        HashMap<String, String> znxIncompleteTemplateParams = new HashMap<String, String>();
        znxIncompleteTemplateParams.put("msgWebUrl", this.assemblyUrl(DEVICE_WEB, sysMsgPushTask));
        znxIncompleteTemplateParams.put("msgMobileUrl", this.assemblyUrl(DEVICE_MOBILE, sysMsgPushTask));
        incompleteTemplateParams.put("station_message", znxIncompleteTemplateParams);
        msgUnitySendDto.setIncompleteTemplateParams(incompleteTemplateParams);
        HashMap<String, String> receiveAddressMap = new HashMap<String, String>();
        String reminders = sysMsgPushTask.getReminders().substring(1, sysMsgPushTask.getReminders().length() - 1);
        receiveAddressMap.put("station_message", reminders);
        msgUnitySendDto.setReceiveAddress(receiveAddressMap);
        LOGGER.error("\u6d88\u606f\u63a8\u9001 => \u3010\u7ad9\u5185\u4fe1\u3011\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)msgUnitySendDto));
        this.pushMsgService.unitySendMessage(msgUnitySendDto);
    }

    private String assemblyUrl(String deviceType, SysMsgPushTask task) {
        String formType = ((SysForm)this.formService.getById((Serializable)task.getFormId())).getFormType();
        StringBuilder url = new StringBuilder(this.socket);
        if (HussarUtils.isEmpty((Object)task.getDataId())) {
            if (DEVICE_WEB.equals(deviceType)) {
                url.append("/hussarAppFrame/?appId=").append(task.getAppId()).append("#/form/").append(task.getFormId());
            } else {
                url.append("/hussarApp/#/container/list?appId=").append(task.getAppId()).append("&formId=").append(task.getFormId()).append("&formType=").append(formType);
            }
        } else {
            if (DEVICE_WEB.equals(deviceType)) {
                url.append("/hussarAppFrame/?appId=").append(task.getAppId()).append("#/form-detail/").append(task.getFormId()).append("?rowId=").append(task.getDataId());
            } else {
                url.append("/hussarApp/#/container/form?id=").append(task.getDataId()).append("&appId=").append(task.getAppId()).append("&formId=").append(task.getFormId()).append("&formType=").append(formType);
            }
            if ("1".equals(formType)) {
                url.append("&tabType=0");
            }
        }
        return url.toString();
    }
}

