/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.util;

import com.jxdinfo.hussar.formdesign.application.lefttree.util.ParamValidator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LeftTreeUtil {
    private LeftTreeUtil() {
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void condRun(boolean expression, Runnable runnable) {
        if (expression) {
            runnable.run();
        }
    }

    public static void condRun(boolean expression, Runnable run1, Runnable run2) {
        if (expression) {
            run1.run();
        } else {
            run2.run();
        }
    }

    public static String convertString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return String.valueOf(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long convertLong(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final class Param {
        private Object object;
        private String message;

        public Param(Object object, String message) {
            this.object = object;
            this.message = message;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static final class Validator {
        Map<Param, ParamValidator> map = new HashMap<Param, ParamValidator>();
        ParamValidator notNullValidator = (param, message) -> {
            if (HussarUtils.isEmpty((Object)param)) {
                throw new HussarException(message);
            }
        };

        public Validator isNotNull(Object param, String message) {
            this.map.put(new Param(param, message), this.notNullValidator);
            return this;
        }

        public void validate() {
            for (Map.Entry<Param, ParamValidator> entry : this.map.entrySet()) {
                entry.getValue().validate(entry.getKey().getObject(), entry.getKey().getMessage());
            }
        }
    }
}

