/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.formLink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.enums.SysFormLinkEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkSingleMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkSingleStatusMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkSingleDto;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingle;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkSingleStatusVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkSingleVo;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.formLink.service.impl.SysFormLinkSingleServiceImpl")
public class SysFormLinkSingleServiceImpl
extends HussarServiceImpl<SysFormLinkSingleMapper, SysFormLinkSingle>
implements ISysFormLinkSingleService {
    @Resource
    private SysFormLinkSingleMapper sysFormLinkSingleMapper;
    @Resource
    private SysFormLinkSingleStatusMapper sysFormLinkSingleStatusMapper;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ISysFormService sysFormService;
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String ip;
    @Value(value="${hussar.nocode.redirect.publicSingle}")
    private String publicSingle;

    @HussarTransactional
    public synchronized ApiResponse<SysFormLinkSingleVo> addOrUpdateFormLinkSingle(SysFormLinkSingleDto sysFormLinkSingleDto, HttpServletRequest request) {
        Long dataId = sysFormLinkSingleDto.getDataId();
        Long formId = sysFormLinkSingleDto.getFormId();
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNull((Object)dataId)) {
            throw new BaseException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle formLinkSingleByDataId = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNull((Object)formLinkSingleByDataId)) {
            sysFormLinkSingleDto.setLinkShortAddress(this.generateShortLink());
            sysFormLinkSingleDto.setHasPass(SysFormLinkEnum.LINKPASS_CLOSE.getValue());
        } else {
            if (sysFormLinkSingleDto.isRefresh()) {
                sysFormLinkSingleDto.setLinkShortAddress(this.generateShortLink());
            }
            if (sysFormLinkSingleDto.isRefreshPass()) {
                sysFormLinkSingleDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
            }
            if (formLinkSingleByDataId.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_CLOSE.getValue().intValue() && sysFormLinkSingleDto.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_OPEN.getValue().intValue()) {
                sysFormLinkSingleDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
            }
            sysFormLinkSingleDto.setLinkId(formLinkSingleByDataId.getLinkId());
        }
        boolean flag = this.saveOrUpdate((BaseEntity)sysFormLinkSingleDto);
        if (!flag) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
        }
        return ApiResponse.success((Object)this.getFormLinkSingleDetail(dataId, formId, request).getData());
    }

    public ApiResponse<SysFormLinkSingleVo> getFormLinkSingleDetail(Long dataId, Long formId, HttpServletRequest request) {
        String tcode;
        if (HussarUtils.isNull((Object)dataId)) {
            throw new BaseException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle sysFormLinkSingle = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        SysFormLinkSingleVo formLinkSingleByDataId = (SysFormLinkSingleVo)BeanUtil.copyProperties((Object)sysFormLinkSingle, SysFormLinkSingleVo.class);
        if (HussarUtils.isNull((Object)formLinkSingleByDataId)) {
            SysFormLinkSingleVo sysFormLinkSingleVo = new SysFormLinkSingleVo();
            return ApiResponse.success((Object)sysFormLinkSingleVo, (String)"\u8be5\u5355\u6761\u6570\u636e\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        try {
            SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
            formLinkSingleByDataId.setFormName(sysForm.getFormName());
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
        formLinkSingleByDataId.setType("s");
        String shortLink = this.ip + "/" + this.publicSingle + formLinkSingleByDataId.getLinkShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        formLinkSingleByDataId.setShortLink(shortLink);
        return ApiResponse.success((Object)formLinkSingleByDataId);
    }

    public ApiResponse<Boolean> verifyStatus(Long dataId, String shortLink, Long formId) {
        if (HussarUtils.isNull((Object)dataId)) {
            throw new BaseException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle formLinkSingleByDataId = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNull((Object)formLinkSingleByDataId)) {
            return ApiResponse.success((Object)false);
        }
        SysFormLinkSingleStatusVo sysFormLinkSingleStatusByFormId = this.sysFormLinkSingleStatusMapper.getSysFormLinkSingleStatusByFormId(formLinkSingleByDataId.getFormId());
        if (HussarUtils.isNull((Object)sysFormLinkSingleStatusByFormId)) {
            return ApiResponse.success((Object)false);
        }
        if (!formLinkSingleByDataId.getLinkShortAddress().equals(shortLink)) {
            return ApiResponse.success((Object)false);
        }
        if (sysFormLinkSingleStatusByFormId.getSingleStatus().intValue() == SysFormLinkEnum.SINGLE_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        if (formLinkSingleByDataId.getLinkStatus().intValue() == SysFormLinkEnum.SINGLE_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        LocalDateTime date = LocalDateTime.now();
        if (date.isAfter(formLinkSingleByDataId.getExpiryTime())) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> verifyStatusPublic(Long dataId, Long formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle formLinkSingleByDataId = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNull((Object)formLinkSingleByDataId)) {
            return ApiResponse.success((Object)false);
        }
        SysFormLinkSingleStatusVo sysFormLinkSingleStatusByFormId = this.sysFormLinkSingleStatusMapper.getSysFormLinkSingleStatusByFormId(formLinkSingleByDataId.getFormId());
        if (HussarUtils.isNull((Object)sysFormLinkSingleStatusByFormId)) {
            return ApiResponse.success((Object)false);
        }
        if (sysFormLinkSingleStatusByFormId.getSingleStatus().intValue() == SysFormLinkEnum.SINGLE_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        if (formLinkSingleByDataId.getLinkStatus().intValue() == SysFormLinkEnum.SINGLE_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        LocalDateTime date = LocalDateTime.now();
        if (date.isAfter(formLinkSingleByDataId.getExpiryTime())) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> isLinkPass(Long dataId, Long formId) {
        if (HussarUtils.isNull((Object)dataId)) {
            throw new BaseException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle formLinkSingleByDataId = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        if (formLinkSingleByDataId.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> verifyLinkPass(SysFormLinkSingleDto sysFormLinkSingleDto) {
        String linkPass = sysFormLinkSingleDto.getLinkPass();
        Long dataId = sysFormLinkSingleDto.getDataId();
        Long formId = sysFormLinkSingleDto.getFormId();
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNull((Object)dataId)) {
            throw new BaseException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingle::getDataId, (Object)dataId)).eq(SysFormLinkSingle::getFormId, (Object)formId);
        SysFormLinkSingle formLinkSingleByDataId = (SysFormLinkSingle)this.getOne((Wrapper)queryWrapper);
        if (linkPass.equals(formLinkSingleByDataId.getLinkPass())) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    public String generateShortLink() {
        String shortLink = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        int count = this.sysFormLinkSingleMapper.getCountByShortLink(shortLink);
        if (count != 0) {
            this.generateShortLink();
        }
        return shortLink;
    }

    @HussarDs(value="#tcode")
    public String redirect(String shortLink, String tcode) {
        if (HussarUtils.isNull((Object)shortLink)) {
            throw new BaseException("\u8868\u5355\u5355\u6761\u6570\u636e\u5916\u94fe\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkSingleVo formLinkSingleByShortAddress = this.sysFormLinkSingleMapper.getFormLinkSingleByShortAddress(shortLink = shortLink.substring(0, 6));
        if (HussarUtils.isNull((Object)formLinkSingleByShortAddress)) {
            return null;
        }
        return formLinkSingleByShortAddress.getLinkAddress();
    }

    @HussarTransactional
    public Boolean deleteBatch(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idArray) {
            idList.add(Long.parseLong(id));
        }
        List<Long> existIdList = this.sysFormLinkSingleMapper.getExistDataId(idList);
        if (existIdList.size() == 0) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysFormLinkSingle::getDataId, existIdList);
        return this.remove((Wrapper)queryWrapper);
    }
}

