/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.formLink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkSingleInnerMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkSingleInnerDto;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingleInner;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkSingleInnerVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.formLink.service.impl.SysFormLinkSingleInnerServiceImpl")
public class SysFormLinkSingleInnerServiceImpl
extends HussarServiceImpl<SysFormLinkSingleInnerMapper, SysFormLinkSingleInner>
implements ISysFormLinkSingleInnerService {
    @Resource
    private SysFormLinkSingleInnerMapper sysFormLinkSingleInnerMapper;
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String ip;
    @Value(value="${hussar.nocode.redirect.publicSingleInner}")
    private String publicSingleInner;

    public synchronized ApiResponse<SysFormLinkSingleInnerVo> addOrUpdateFormLinkSingleInner(SysFormLinkSingleInnerDto sysFormLinkSingleInnerDto, HttpServletRequest request) {
        Long dataId = sysFormLinkSingleInnerDto.getDataId();
        Long formId = sysFormLinkSingleInnerDto.getFormId();
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNull((Object)dataId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingleInner::getFormId, (Object)formId)).isNull(SysFormLinkSingleInner::getDataId);
            SysFormLinkSingleInner sysFormLinkSingleInner = (SysFormLinkSingleInner)this.getOne((Wrapper)queryWrapper);
            if (!HussarUtils.isNull((Object)sysFormLinkSingleInner)) {
                sysFormLinkSingleInnerDto.setLinkId(sysFormLinkSingleInner.getLinkId());
            } else {
                sysFormLinkSingleInnerDto.setInnerShortAddress(this.generateShortLink());
            }
            if (!this.saveOrUpdate((BaseEntity)sysFormLinkSingleInnerDto)) {
                throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
            }
            return ApiResponse.success((Object)this.getFormLinkSingleInnerDetail(null, formId, request).getData());
        }
        LambdaQueryWrapper queryWrapperInner = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapperInner.eq(SysFormLinkSingleInner::getFormId, (Object)formId)).eq(SysFormLinkSingleInner::getDataId, (Object)dataId);
        SysFormLinkSingleInner formLinkSingleInnerByDataId = (SysFormLinkSingleInner)this.getOne((Wrapper)queryWrapperInner);
        if (HussarUtils.isNull((Object)formLinkSingleInnerByDataId)) {
            sysFormLinkSingleInnerDto.setInnerShortAddress(this.generateShortLink());
        } else {
            sysFormLinkSingleInnerDto.setInnerShortAddress(formLinkSingleInnerByDataId.getInnerShortAddress());
            sysFormLinkSingleInnerDto.setLinkId(formLinkSingleInnerByDataId.getLinkId());
        }
        if (!this.saveOrUpdate((BaseEntity)sysFormLinkSingleInnerDto)) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
        }
        return ApiResponse.success((Object)this.getFormLinkSingleInnerDetail(dataId, formId, request).getData());
    }

    public ApiResponse<SysFormLinkSingleInnerVo> getFormLinkSingleInnerDetail(Long dataId, Long formId, HttpServletRequest request) {
        String tcode;
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNull((Object)dataId)) {
            String tcode2;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysFormLinkSingleInner::getFormId, (Object)formId)).isNull(SysFormLinkSingleInner::getDataId);
            SysFormLinkSingleInner sysFormLinkSingleInner = (SysFormLinkSingleInner)this.getOne((Wrapper)queryWrapper);
            SysFormLinkSingleInnerVo sysFormLinkSingleInnerVo = new SysFormLinkSingleInnerVo();
            if (HussarUtils.isNull((Object)sysFormLinkSingleInner)) {
                return ApiResponse.success((Object)sysFormLinkSingleInnerVo, (String)"\u8be5\u5355\u6761\u6570\u636e\u5e94\u7528\u5185\u94fe\u63a5\u4e0d\u5b58\u5728");
            }
            BeanUtil.copyProperties((Object)sysFormLinkSingleInner, (Object)sysFormLinkSingleInnerVo);
            String shortLink = this.ip + "/" + this.publicSingleInner + sysFormLinkSingleInner.getInnerShortAddress();
            if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode2 = request.getHeader("Tcode")))) {
                shortLink = shortLink + "?tcode=" + tcode2;
            }
            sysFormLinkSingleInnerVo.setInnerShortLink(shortLink);
            return ApiResponse.success((Object)sysFormLinkSingleInnerVo);
        }
        LambdaQueryWrapper queryWrapperInner = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapperInner.eq(SysFormLinkSingleInner::getFormId, (Object)formId)).eq(SysFormLinkSingleInner::getDataId, (Object)dataId);
        SysFormLinkSingleInner formLinkSingleInner = (SysFormLinkSingleInner)this.getOne((Wrapper)queryWrapperInner);
        SysFormLinkSingleInnerVo formLinkSingleInnerByDataId = (SysFormLinkSingleInnerVo)BeanUtil.copyProperties((Object)formLinkSingleInner, SysFormLinkSingleInnerVo.class);
        if (HussarUtils.isNull((Object)formLinkSingleInnerByDataId)) {
            SysFormLinkSingleInnerVo sysFormLinkSingleInnerVo = new SysFormLinkSingleInnerVo();
            return ApiResponse.success((Object)sysFormLinkSingleInnerVo, (String)"\u8be5\u5355\u6761\u6570\u636e\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        String shortLink = this.ip + "/" + this.publicSingleInner + formLinkSingleInnerByDataId.getInnerShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        formLinkSingleInnerByDataId.setInnerShortLink(shortLink);
        return ApiResponse.success((Object)formLinkSingleInnerByDataId);
    }

    public String redirectInner(String shortLink, HttpServletRequest request) {
        if (HussarUtils.isNull((Object)shortLink)) {
            throw new BaseException("\u8868\u5355\u5355\u6761\u6570\u636e\u5916\u94fe\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String innerParams = this.sysFormLinkSingleInnerMapper.getInnerParamsByShortAddress(shortLink = shortLink.substring(0, 6));
        if (HussarUtils.isEmpty((Object)innerParams)) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        ObjectMapper objectMapper = new ObjectMapper();
        Map resultMap = null;
        try {
            resultMap = (Map)objectMapper.readValue(innerParams, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new BaseException("json\u8f6c\u6362\u5931\u8d25");
        }
        StringBuilder sb = new StringBuilder();
        if (userAgent.contains("Android") || userAgent.contains("iPhone") || userAgent.contains("iPad") || userAgent.contains("Mobile")) {
            String queryString = request.getQueryString();
            sb.append("/hussarApp/#/container/form?appId=").append(resultMap.get("appId")).append(HussarUtils.isEmpty((Object)request.getParameter("tcode")) ? "" : "&tcode=" + request.getParameter("tcode")).append("&formId=").append(resultMap.get("formId")).append(HussarUtils.isEmpty(resultMap.get("rowId")) ? "" : "&id=" + resultMap.get("rowId")).append(HussarUtils.isEmpty(resultMap.get("processInstId")) ? "" : "&processInstId=" + resultMap.get("processInstId")).append(HussarUtils.isEmpty(resultMap.get("taskId")) ? "" : "&taskId=" + resultMap.get("taskId")).append(HussarUtils.isEmpty(resultMap.get("tabType")) ? "" : "&tabType=" + resultMap.get("tabType")).append(HussarUtils.isEmpty(resultMap.get("formType")) ? "" : "&formType=" + resultMap.get("formType"));
            if (HussarUtils.isNotEmpty((Object)queryString)) {
                sb.append("&").append(queryString);
            }
        } else {
            sb.append("/hussarAppFrame/?appId=").append(resultMap.get("appId")).append(HussarUtils.isEmpty((Object)request.getParameter("tcode")) ? "" : "&tcode=" + request.getParameter("tcode")).append("#").append(resultMap.get("singlePath")).append("/").append(resultMap.get("formId")).append("?action=").append(resultMap.get("action")).append(HussarUtils.isEmpty(resultMap.get("rowId")) ? "" : "&rowId=" + resultMap.get("rowId")).append(HussarUtils.isEmpty(resultMap.get("processInstId")) ? "" : "&processInstId=" + resultMap.get("processInstId")).append(HussarUtils.isEmpty(resultMap.get("taskId")) ? "" : "&taskId=" + resultMap.get("taskId")).append(HussarUtils.isEmpty(resultMap.get("tabType")) ? "" : "&tabType=" + resultMap.get("tabType"));
        }
        return sb.toString();
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean deleteBatch(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idArray) {
            idList.add(Long.parseLong(id));
        }
        List<Long> existIdList = this.sysFormLinkSingleInnerMapper.getExistDataId(idList);
        if (existIdList.size() == 0) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysFormLinkSingleInner::getDataId, existIdList);
        return this.remove((Wrapper)queryWrapper);
    }

    private String generateShortLink() {
        String shortLink = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        int count = this.sysFormLinkSingleInnerMapper.getCountByInnerShortLink(shortLink);
        if (count != 0) {
            this.generateShortLink();
        }
        return shortLink;
    }
}

