/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.service.IRenewCheckConfigService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RenewCheckConfigServiceImpl
implements IRenewCheckConfigService {
    @Autowired
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;

    public void renewCheckConfig(String processKey, JSONArray data) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getType, (Object)"wfd");
        List sysActProcessFileList = this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper);
        for (SysActProcessFile sysActProcessFile : sysActProcessFileList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)wfdFile);
            JSONObject slots = jsonObject.getJSONObject("slots");
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONObject nodeProps;
                JSONArray checkRule;
                JSONObject node = nodes.getJSONObject(i);
                if (!BpmNodeTypeUtil.isStart((String)node.getString("name")) && !BpmNodeTypeUtil.isUserTask((String)node.getString("name")) || !HussarUtils.isEmpty((Object)(checkRule = (nodeProps = node.getJSONObject("props")).getJSONArray("nodeCheckRuleList")))) continue;
                nodeProps.put("nodeCheckRuleList", (Object)data);
            }
            wfdFile = JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            SysActProcessFile processFile = new SysActProcessFile();
            processFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
            LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
            if (HussarUtils.isEmpty((Object)sysActProcessFile.getProcessId())) {
                updateWrapper.isNull(SysActProcessFile::getProcessId);
            } else {
                updateWrapper.eq(SysActProcessFile::getProcessId, (Object)sysActProcessFile.getProcessId());
            }
            updateWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
            updateWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            this.sysActProcessFileMapper.update(processFile, (Wrapper)updateWrapper);
            String cacheKey = String.format("workflow_file:%s:%s", processKey, sysActProcessFile.getVersion());
            HussarCacheUtil.evict((String)"workflow_file", (Object)cacheKey);
        }
    }
}

