/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppRegionService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.application.form.dto.ChildFormIportLabeDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IChildFormImportService;
import com.jxdinfo.hussar.formdesign.application.form.vo.ChildFormImportLabelVo;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.ChildFormImportServiceImpl")
public class ChildFormImportServiceImpl
implements IChildFormImportService {
    @Resource
    private ExcelImport excelImport;
    @Resource
    private IHussarAppRegionService hussarAppRegionService;

    public ApiResponse<List<List<ChildFormIportLabeDto>>> getIdByLabel(List<List<ChildFormImportLabelVo>> rows) {
        if (CollectionUtil.isEmpty(rows)) {
            return ApiResponse.success((Object)Lists.newArrayListWithCapacity((int)0));
        }
        Map<Object, Object> mapUserNameSysUsers = Maps.newHashMapWithExpectedSize((int)5);
        Map<Object, Object> mapOrganNameSysOrgans = Maps.newHashMapWithExpectedSize((int)5);
        Map<Object, Object> parentIdRegionVoMap = Maps.newHashMapWithExpectedSize((int)5);
        List<ChildFormImportLabelVo> firstRow = rows.get(0);
        for (ChildFormImportLabelVo firstRowCell : firstRow) {
            if (WidgetType.JXDNUser.getType().equals(firstRowCell.getFieldType()) || WidgetType.JXDNUserMulti.getType().equals(firstRowCell.getFieldType())) {
                List allUsers = this.excelImport.getAllUser();
                mapUserNameSysUsers = allUsers.stream().filter(sysUsers -> "1".equals(sysUsers.getAccountStatus())).collect(Collectors.toMap(SysUsers::getUserName, Function.identity(), (key1, key2) -> key1));
                continue;
            }
            if (WidgetType.JXDNOrg.getType().equals(firstRowCell.getFieldType()) || WidgetType.JXDNOrgMulti.getType().equals(firstRowCell.getFieldType())) {
                List allOrgans = this.excelImport.getAllOrgan();
                mapOrganNameSysOrgans = allOrgans.stream().collect(Collectors.toMap(OrganizationBo::getOrganName, Function.identity(), (key1, key2) -> key1));
                continue;
            }
            if (!WidgetType.ADDRESS.getType().equals(firstRowCell.getFieldType())) continue;
            parentIdRegionVoMap = this.hussarAppRegionService.getRegionInfo().stream().collect(Collectors.groupingBy(RegionVo::getParentId));
        }
        ArrayList returnDto = Lists.newArrayListWithCapacity((int)5);
        for (int row = 0; row < rows.size(); ++row) {
            ArrayList childFormIportLabeDtos = Lists.newArrayListWithCapacity((int)5);
            List<ChildFormImportLabelVo> labelVos = rows.get(row);
            Map<String, List<ChildFormImportLabelVo>> realNameMap = labelVos.stream().collect(Collectors.groupingBy(ChildFormImportLabelVo::getRealName));
            for (Map.Entry<String, List<ChildFormImportLabelVo>> map : realNameMap.entrySet()) {
                Object model;
                List<ChildFormImportLabelVo> value = map.getValue();
                ChildFormIportLabeDto labeDto = new ChildFormIportLabeDto();
                ChildFormImportLabelVo labelVo = value.get(0);
                BeanUtil.copy((Object)labelVo, (Object)labeDto);
                JXDNWidgetDefault widgetDefault = (JXDNWidgetDefault)SpringContextUtil.getBean((String)labelVo.getFieldType());
                if (WidgetType.ADDRESS.getType().equals(labelVo.getFieldType())) {
                    String addressStr;
                    labeDto.setFieldName(labeDto.getRealName());
                    Map valueLevel = value.stream().collect(Collectors.toMap(ChildFormImportLabelVo::getFieldName, Function.identity()));
                    StringBuilder addressAllBuilder = new StringBuilder();
                    if (valueLevel.containsKey(labeDto.getRealName() + "_province")) {
                        addressAllBuilder.append(((ChildFormImportLabelVo)valueLevel.get(labeDto.getRealName() + "_province")).getName());
                    }
                    if (valueLevel.containsKey(labeDto.getRealName() + "_city")) {
                        addressAllBuilder.append("/").append(((ChildFormImportLabelVo)valueLevel.get(labeDto.getRealName() + "_city")).getName());
                    }
                    if (valueLevel.containsKey(labeDto.getRealName() + "_town")) {
                        addressAllBuilder.append("/").append(((ChildFormImportLabelVo)valueLevel.get(labeDto.getRealName() + "_town")).getName());
                    }
                    if (valueLevel.containsKey(labeDto.getRealName() + "_street")) {
                        addressAllBuilder.append("/").append(((ChildFormImportLabelVo)valueLevel.get(labeDto.getRealName() + "_street")).getName());
                    }
                    if (HussarUtils.isNotEmpty((Object)(model = widgetDefault.getModelByWidgetType(addressStr = HussarUtils.isNotEmpty((Object)addressAllBuilder) ? addressAllBuilder.toString() : "", (Map)mapUserNameSysUsers, (Map)mapOrganNameSysOrgans, (Map)parentIdRegionVoMap, labelVo.getAddressLevel())))) {
                        JSONObject jsonObject = (JSONObject)model;
                        labeDto.setName(HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"label")) ? String.valueOf(jsonObject.get((Object)"label")) : "");
                    }
                } else {
                    model = widgetDefault.getModelByWidgetType(labelVo.getName(), (Map)mapUserNameSysUsers, (Map)mapOrganNameSysOrgans, (Map)parentIdRegionVoMap, labelVo.getAddressLevel());
                }
                labeDto.setModel(model);
                childFormIportLabeDtos.add(labeDto);
            }
            returnDto.add(childFormIportLabeDtos);
        }
        return ApiResponse.success((Object)returnDto);
    }
}

