/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.job;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullTaskDto;
import com.jxdinfo.hussar.formdesign.application.data.middle.SysDataPullRepeatRule;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullTask;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.util.DataPullUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@HussarDs(value="#a0.dbName")
@Component
public class SysDataPullTaskProcessor
implements BasicProcessor {
    @Resource
    private SysDataPullService sysPullDataService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private ISysUsersService sysUsersService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysDataPullTaskProcessor.class);

    public ProcessResult process(TaskContext taskContext) {
        LocalDateTime now = LocalDateTime.now();
        String dataSourceKey = DataModelUtil.currentDsName();
        LOGGER.info("\u6570\u636e\u62c9\u53d6 => \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a{},\u6570\u636e\u6e90\uff1a{}", (Object)now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), (Object)dataSourceKey);
        List sysDataPullTasks = this.sysDataPullTaskService.queryDataPullTasks(now);
        sysDataPullTasks = sysDataPullTasks.stream().filter(sysDataPullTask -> {
            boolean validTask = this.validTask((SysDataPullTask)sysDataPullTask, now);
            return validTask;
        }).collect(Collectors.toList());
        LOGGER.info("\u6570\u636e\u62c9\u53d6 => \u5f53\u524d\u5f85\u62c9\u53d6\u4efb\u52a1\u5217\u8868\uff1a{},\u6570\u636e\u6e90\uff1a{}", sysDataPullTasks.stream().map(SysDataPullTask::getId).collect(Collectors.toList()), (Object)dataSourceKey);
        if (HussarUtils.isNotEmpty(sysDataPullTasks)) {
            ArrayList<SysDataPullTask> updatedTasks = new ArrayList<SysDataPullTask>();
            ArrayList<SysDataPullTaskDto> newTasks = new ArrayList<SysDataPullTaskDto>();
            for (SysDataPullTask sysDataPullTask2 : sysDataPullTasks) {
                try {
                    SecurityUser sysUser = new SecurityUser();
                    sysUser.setUserId(DataPullUtil.getExternalUserId());
                    sysUser.setUserName(DataPullUtil.getUserName());
                    TransmittableThreadLocalHolder.set((String)"loginUser", (Object)sysUser);
                    this.sysPullDataService.asyncPullData(sysDataPullTask2.getFormId(), sysDataPullTask2.getConfigId(), null);
                }
                catch (Exception e) {
                    LOGGER.error("\u6570\u636e\u62c9\u53d6 => \u8c03\u7528\u6570\u636e\u62c9\u53d6\u540c\u6b65\u5931\u8d25 => \u6570\u636e\u6e90:{}", (Object)dataSourceKey);
                    LOGGER.error("\u6570\u636e\u62c9\u53d6 => \u8c03\u7528\u6570\u636e\u62c9\u53d6\u540c\u6b65\u5931\u8d25:" + e);
                }
                sysDataPullTask2.setStatus("1");
                sysDataPullTask2.setExecuteTime(now);
                updatedTasks.add(sysDataPullTask2);
                SysDataPullRepeatRule repeatRule = (SysDataPullRepeatRule)JSON.parseObject((String)sysDataPullTask2.getRepeatRule(), SysDataPullRepeatRule.class);
                if ("only_once".equals(repeatRule.getType())) continue;
                LocalDateTime nextExecuteTime = repeatRule.calculateNextReminderTime(sysDataPullTask2.getFirstExecuteTime(), now);
                String endExecuteTimeSet = sysDataPullTask2.getEndExecuteTimeSet();
                if (endExecuteTimeSet != null && !endExecuteTimeSet.equals("0") && nextExecuteTime.isAfter(sysDataPullTask2.getEndExecuteTime())) continue;
                SysDataPullTaskDto newTask = new SysDataPullTaskDto();
                BeanUtils.copyProperties((Object)sysDataPullTask2, (Object)newTask);
                newTask.setId(null);
                newTask.setNextExecuteTime(nextExecuteTime);
                newTask.setStatus("0");
                newTask.setExecuteTime(null);
                newTasks.add(newTask);
            }
            this.sysDataPullTaskService.updateBatchById(updatedTasks);
            this.sysDataPullTaskService.saveBatch(newTasks);
        }
        return null;
    }

    private boolean validTask(SysDataPullTask sysDataPullTask, LocalDateTime dataPullExecuteTime) {
        if (StringUtil.isNotEmpty((Object)sysDataPullTask.getEndExecuteTimeSet()) && sysDataPullTask.getEndExecuteTimeSet().equals("1")) {
            if (dataPullExecuteTime.isAfter(sysDataPullTask.getEndExecuteTime())) {
                return false;
            }
            if (sysDataPullTask.getStatus().equals("1")) {
                return false;
            }
        }
        return true;
    }
}

