/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppLinkInnerMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppLinkInner;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppLinkInnerService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppLinkInnerVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysAppLinkInnerServiceImpl
extends HussarServiceImpl<SysAppLinkInnerMapper, SysAppLinkInner>
implements ISysAppLinkInnerService {
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String ip;
    @Value(value="${hussar.nocode.appInner.redirect}")
    private String redirect;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysAppLinkInnerServiceImpl.class);
    @Resource
    private ISysApplicationService sysApplicationService;

    public ApiResponse<SysAppLinkInnerVo> add(SysAppLinkInner sysAppLinkInner, HttpServletRequest request) {
        AssertUtil.isNotNull((Object)sysAppLinkInner, (String)"\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        sysAppLinkInner.setInnerShortAddress(this.generateShortLink());
        boolean flag = this.save((BaseEntity)sysAppLinkInner);
        if (!flag) {
            return ApiResponse.fail((String)"\u6dfb\u52a0\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u5931\u8d25");
        }
        return this.getAppLinkInnerDetail(sysAppLinkInner.getAppId(), request);
    }

    public ApiResponse<SysAppLinkInnerVo> getAppLinkInnerDetail(Long appId, HttpServletRequest request) {
        String tcode;
        Object parse;
        AssertUtil.isNotNull((Object)appId, (String)"\u5e94\u7528Id\u4e0d\u80fd\u4e3a\u7a7a");
        SysApplicationVo data = (SysApplicationVo)this.sysApplicationService.getAppDetail(appId).getData();
        AssertUtil.isNotNull((Object)data, (String)"\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysAppLinkInner::getAppId, (Object)appId);
        SysAppLinkInner sysAppLinkInner = (SysAppLinkInner)this.getOne((Wrapper)wrapper);
        if (HussarUtils.isNull((Object)sysAppLinkInner)) {
            return ApiResponse.success((String)"\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u4e0d\u5b58\u5728");
        }
        String innerParams = sysAppLinkInner.getInnerParams();
        if (HussarUtils.isNotEmpty((Object)innerParams) && (parse = JSON.parse((String)innerParams)) instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)parse;
            jsonObject.put("appName", (Object)data.getAppName());
            innerParams = jsonObject.toJSONString();
            sysAppLinkInner.setInnerParams(innerParams);
        }
        String shortLink = this.ip + "/" + this.redirect + sysAppLinkInner.getInnerShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        SysAppLinkInnerVo sysAppLinkInnerVo = new SysAppLinkInnerVo();
        BeanUtil.copyProperties((Object)sysAppLinkInner, (Object)sysAppLinkInnerVo);
        sysAppLinkInnerVo.setInnerShortLink(shortLink);
        return ApiResponse.success((Object)sysAppLinkInnerVo);
    }

    public String redirectInner(String shortLink, HttpServletRequest request) {
        Object parse;
        AssertUtil.isNotNull((Object)shortLink, (String)"\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        shortLink = shortLink.substring(0, 6);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysAppLinkInner::getInnerShortAddress, (Object)shortLink);
        SysAppLinkInner sysAppLinkInner = (SysAppLinkInner)this.getOne((Wrapper)queryWrapper);
        AssertUtil.isNotNull((Object)sysAppLinkInner, (String)"\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u4e0d\u5b58\u5728");
        SysApplicationVo data = (SysApplicationVo)this.sysApplicationService.getAppDetail(sysAppLinkInner.getAppId()).getData();
        AssertUtil.isNotNull((Object)data, (String)"\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
        String innerParams = sysAppLinkInner.getInnerParams();
        if (HussarUtils.isNotEmpty((Object)innerParams) && (parse = JSON.parse((String)innerParams)) instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)parse;
            jsonObject.put("appName", (Object)data.getAppName());
            innerParams = jsonObject.toJSONString();
        }
        if (HussarUtils.isEmpty((Object)innerParams)) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        ObjectMapper objectMapper = new ObjectMapper();
        Map resultMap = null;
        try {
            resultMap = (Map)objectMapper.readValue(innerParams, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new BaseException("json\u8f6c\u6362\u5931\u8d25");
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (userAgent.contains("Android") || userAgent.contains("iPhone") || userAgent.contains("iPad") || userAgent.contains("Mobile")) {
                String queryString = request.getQueryString();
                sb.append("/hussarApp/#/application/menu?appId=").append(resultMap.get("appId")).append(HussarUtils.isEmpty(resultMap.get("appName")) ? "" : "&appName=" + URLEncoder.encode(String.valueOf(resultMap.get("appName")), "utf-8"));
                if (HussarUtils.isNotEmpty((Object)queryString)) {
                    sb.append("&").append(queryString);
                }
            } else {
                sb.append("/hussarAppFrame/?appId=").append(resultMap.get("appId"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u77ed\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
        return sb.toString();
    }

    public String generateShortLink() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String shortLink = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        int count = (int)this.count((Wrapper)queryWrapper.eq(SysAppLinkInner::getInnerShortAddress, (Object)shortLink));
        if (count != 0) {
            this.generateShortLink();
        }
        return shortLink;
    }
}

