/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.vo.DevelopTeamMemberVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppDevelopTeamMemberVo;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysAppDevelopTeamServiceImpl")
public class SysAppDevelopTeamServiceImpl
extends HussarServiceImpl<SysAppDevelopTeamMapper, SysAppDevelopTeam>
implements ISysAppDevelopTeamService {
    @Resource
    private SysAppDevelopTeamMapper sysAppDevelopTeamMapper;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper sysAppDevelopTeamMemberCommonMapper;
    @Resource
    private IHussarBaseUserBoService userBoService;

    public List<Long> selectAppListByCurrentUser() {
        if (HussarUtils.isNotEmpty((Object)NoCodeSecurityUtil.getUser().getRolesList()) && (NoCodeSecurityUtil.getUser().isSuperAdmin() || NoCodeSecurityUtil.getUser().getRolesList().contains(TenantConstant.ADMIN_ROLE))) {
            return this.sysApplicationMapper.selectAllAppList();
        }
        Long userId = NoCodeSecurityUtil.getUser().getId();
        return this.sysAppDevelopTeamMapper.selectAppListByCurrentUser(userId);
    }

    public Boolean checkCurrentUserInTeam(Long appId) {
        List<Long> appIdList = this.selectAppListByCurrentUser();
        return appIdList.contains(appId);
    }

    public SysAppDevelopTeamMemberVo getCurrentMemberInAppDevelopTeam(Long appId) {
        List sysAppDevelopTeamMembers;
        if (HussarUtils.isEmpty((Object)appId)) {
            throw new BaseException("\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SysAppDevelopTeam> teams = this.sysAppDevelopTeamMapper.selectAppDevelopTeamList(Arrays.asList(appId));
        if (HussarUtils.isEmpty(teams)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        SysAppDevelopTeam team = teams.get(0);
        SysAppDevelopTeamMemberVo appDevelopTeamMemberVo = new SysAppDevelopTeamMemberVo();
        BeanUtils.copyProperties((Object)team, (Object)appDevelopTeamMemberVo);
        appDevelopTeamMemberVo.setTeamId(team.getId());
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        UserStaffVo userAndStaffInfo = this.userBoService.getUserAndStaffInfo(userId);
        if (HussarUtils.isEmpty((Object)userAndStaffInfo)) {
            throw new BaseException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Integer memberType = -1;
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        memberType = user.isSuperAdmin() || isTenantAdmin ? Integer.valueOf(1) : Integer.valueOf(HussarUtils.isNotEmpty((Object)(sysAppDevelopTeamMembers = this.sysAppDevelopTeamMemberCommonMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getUserId, (Object)userId)).and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw.eq(SysAppDevelopTeamMember::getTeamId, (Object)team.getId());
        })))) ? ((SysAppDevelopTeamMember)sysAppDevelopTeamMembers.get(0)).getMemberType() : -1);
        DevelopTeamMemberVo memberVo = new DevelopTeamMemberVo();
        memberVo.setId(userId);
        memberVo.setUserName(userAndStaffInfo.getUserName());
        memberVo.setMemberType(memberType);
        String organFNames = userAndStaffInfo.getOrgans().stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
        memberVo.setOrganFname(organFNames);
        appDevelopTeamMemberVo.setMember(memberVo);
        return appDevelopTeamMemberVo;
    }
}

