/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.dto.SysAppAuthorizationDto;
import com.jxdinfo.hussar.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.application.factory.HussarAppVisitAuthCallBackFactory;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.util.SyncMenuHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.appImportThreadServiceImpl")
public class AppImportThreadServiceImpl
implements IAppImportThreadService {
    @Resource
    private IAppImportInfoService appImportInfoService;
    @Resource
    private ISysApplicationService appService;
    @Resource
    private SyncMenuHandler syncMenuHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImportThreadServiceImpl.class);

    @HussarDs(value="#dataSourceKey")
    public void startImportThread(AppImportDto appImportDto, String dataSourceKey) {
        String currentDsName = DataModelUtil.currentDsName();
        LOGGER.info("\u5e94\u7528\u5bfc\u5165 => \u4f20\u5165\u6570\u636e\u6e90\uff1a{}, \u5f53\u524d\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey, (Object)currentDsName);
        ImportMappingDto importMappingDto = new ImportMappingDto();
        try {
            this.appImportInfoService.init(appImportDto);
            this.appImportInfoService.importCommonData(appImportDto);
            this.appImportInfoService.importAppData(appImportDto, importMappingDto);
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            this.appImportInfoService.importFormData(appImportDto, importMappingDto);
            this.appImportInfoService.importFormAuthData(appImportDto, importMappingDto);
            this.appImportInfoService.importMidFile(appImportDto, importMappingDto);
            this.appImportInfoService.importFlowData(appImportDto, importMappingDto);
            this.appImportInfoService.importBusinessData(appImportDto, importMappingDto);
            this.pushAppAuthToPortalCenter(importMappingDto.getNewAppId(), "1");
            this.syncMenuHandler.syncMenuForAppImport(importMappingDto.getNewAppId());
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)8, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty((Object)importMappingDto.getNewAppId())) {
                this.appService.removeById((Serializable)importMappingDto.getNewAppId());
                this.syncMenuHandler.syncMenuForAppImportFail(importMappingDto.getNewAppId());
            }
            LOGGER.error("\u5e94\u7528\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u5bfc\u5165\u5931\u8d25");
        }
    }

    private void pushAppAuthToPortalCenter(Long newAppId, String appType) {
        ArrayList<SysAppAuthorizationDto> appAuthorList = new ArrayList<SysAppAuthorizationDto>();
        SysAppAuthorizationDto appAuthorizationDto = new SysAppAuthorizationDto();
        Long userId = ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId();
        appAuthorizationDto.setId(userId);
        appAuthorizationDto.setType("4");
        appAuthorList.add(appAuthorizationDto);
        SysAppVisitAuthorizeDto appAuthorizeDto = new SysAppVisitAuthorizeDto();
        appAuthorizeDto.setAppId(newAppId);
        appAuthorizeDto.setAppAuthorList(appAuthorList);
        LOGGER.info("\u5bfc\u5165\u5e94\u7528\u540c\u6b65\u5230\u95e8\u6237\uff1aappAuthorizeDto={}, appType={}", (Object)JSONObject.toJSONString((Object)appAuthorizeDto), (Object)appType);
        HussarAppVisitAuthCallBackFactory.addAuthorization((SysAppVisitAuthorizeDto)appAuthorizeDto, (String)appType);
    }
}

