/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.excel.util.FileUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppLinkInner;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppWatermark;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppLinkInnerService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppWatermarkService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.button.constant.CustomButtonConstant;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogThreadLocal;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.dto.ScriptBaseAssemble;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptRecord;
import com.jxdinfo.hussar.formdesign.application.property.service.IPageExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.SnowflakeID;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.NumberUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl")
public class AppImportInfoServiceImpl
implements IAppImportInfoService {
    @Resource
    private OperateLogThreadLocal operateLogThreadLocal;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysFormGroupService formGroupService;
    @Resource
    private ISysAppAuthorizeService appAuthorizeService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private ISysAppVisitRoleButtonService buttonAuthService;
    @Resource
    private ISysUpAppVisitRoleFieldService fieldAuthService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicAuthService;
    @Resource
    private ISysAppVisitDataLogicFilterService dataLogicFilterService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService developTeamMemberService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private OssService ossService;
    @Resource
    private IPageExpService pageExpService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private ISysRuleInfoService ruleInfoService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private SysDataPullService pullDataService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImportInfoServiceImpl.class);
    @Resource
    private ISysAppLinkInnerService sysAppLinkInnerService;
    @Resource
    private ISysAppWatermarkService sysAppWatermarkService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private SnowflakeID snowflakeID;

    public void init(AppImportDto appImportDto) {
        AppMigrateUtil.importFolderPath = appImportDto.getPath();
    }

    @ImportProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u5165\u516c\u5171\u6570\u636e")
    public void importCommonData(AppImportDto appImportDto) {
        if (!appImportDto.getExportRoleFlag()) {
            return;
        }
        JSONObject roleData = AppMigrateUtil.readData(appImportDto.getPath(), "role", JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)roleData)) {
            List sysRoles;
            List roles;
            List roleGroups = JSON.parseArray((String)roleData.getString("roleGroups"), SysRoleGroup.class);
            if (HussarUtils.isNotEmpty((Object)roleGroups)) {
                List existRoleGroupIds = this.roleGroupService.list().stream().map(SysRoleGroup::getId).collect(Collectors.toList());
                List newRoleGroups = roleGroups.stream().filter(roleGroup -> !existRoleGroupIds.contains(roleGroup.getId())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(newRoleGroups)) {
                    this.roleGroupService.saveBatch(newRoleGroups);
                }
            }
            if (HussarUtils.isNotEmpty((Object)(roles = JSON.parseArray((String)roleData.getString("roles"), SysRoles.class))) && HussarUtils.isNotEmpty(sysRoles = roles.stream().filter(role -> role.getFromAppId() == 1L).collect(Collectors.toList()))) {
                List sysRoleIds = sysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
                List existSysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, sysRoleIds));
                List existSysRoleIds = existSysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
                List nonExistSysRoles = sysRoles.stream().filter(sysRole -> !existSysRoleIds.contains(sysRole.getId())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(nonExistSysRoles)) {
                    this.sysRolesService.saveBatch(nonExistSysRoles);
                }
            }
        }
    }

    @ImportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u5165\u5e94\u7528\u6570\u636e")
    public void importAppData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        Long userId = ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId();
        String appInfoPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "app.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(appInfoPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)jsonObject)) {
            SysApplication application = (SysApplication)jsonObject.getObject("appInfo", SysApplication.class);
            if (HussarUtils.isNotEmpty((Object)application)) {
                Long newAppId;
                LambdaQueryWrapper wrapper;
                SysAppDevelopTeam sysAppDevelopTeam;
                JSONArray jsonArray;
                List<SysAppAuthorize> appAuthorizes;
                importMappingDto.setOldAppId(application.getId());
                application.setId(null);
                application.setAppCode(null);
                application.setAppName(appImportDto.getAppName());
                application.setAppGroupId(appImportDto.getAppGroupId());
                if (HussarUtils.isNotEmpty((Object)appImportDto.getAppIconType())) {
                    application.setAppIconType(appImportDto.getAppIconType());
                } else {
                    application.setAppIconType("1");
                }
                if (HussarUtils.isNotEmpty((Object)appImportDto.getAppIcon())) {
                    application.setAppIcon(appImportDto.getAppIcon());
                } else {
                    application.setAppIcon("caidan-1Jmoren");
                }
                if (HussarUtils.isNotEmpty((Object)appImportDto.getAppIconColor())) {
                    application.setAppIconColor(appImportDto.getAppIconColor());
                } else {
                    application.setAppIconColor("#2794F8");
                }
                SysApplicationDto sysApplicationDto = new SysApplicationDto();
                BeanUtil.copyProperties((Object)application, (Object)sysApplicationDto);
                sysApplicationDto.setCreator(userId);
                sysApplicationDto.setCreateTime(LocalDateTime.now());
                sysApplicationDto.setLastEditor(userId);
                sysApplicationDto.setLastTime(LocalDateTime.now());
                sysApplicationDto.setI18nKeys(appImportDto.getI18nKeys());
                SysApplicationVo sysApplicationVo = this.applicationService.addApplication(sysApplicationDto);
                importMappingDto.setNewAppId(sysApplicationVo.getId());
                if (appImportDto.getExportRoleFlag() && HussarUtils.isNotEmpty(appAuthorizes = AppMigrateUtil.parseJsonArrayToList(jsonArray = (JSONArray)jsonObject.getObject("appAuth", JSONArray.class), SysAppAuthorize.class))) {
                    for (SysAppAuthorize appAuthorize : appAuthorizes) {
                        appAuthorize.setId(null);
                        appAuthorize.setAppId(importMappingDto.getNewAppId());
                    }
                    this.appAuthorizeService.saveBatch(appAuthorizes);
                }
                if (HussarUtils.isNotEmpty((Object)(sysAppDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)(newAppId = importMappingDto.getNewAppId()))))))) {
                    Long teamId = sysAppDevelopTeam.getId();
                    this.developTeamMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
                    SysAppDevelopTeamMember sysAppDevelopTeamMember = new SysAppDevelopTeamMember();
                    sysAppDevelopTeamMember.setTeamId(teamId);
                    sysAppDevelopTeamMember.setUserId(userId);
                    sysAppDevelopTeamMember.setMemberType(Integer.valueOf(2));
                    LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)userId);
                    if (HussarUtils.isEmpty((Object)this.developTeamMemberService.getOne((Wrapper)wrapper1))) {
                        this.developTeamMemberService.save((Object)sysAppDevelopTeamMember);
                    }
                }
            }
            this.importAppLinkInner(appImportDto, importMappingDto);
            this.importAppWatermark(appImportDto, importMappingDto);
        }
        if (appImportDto.getExportRoleFlag()) {
            this.importAppRole(importMappingDto, appImportDto);
        }
    }

    private void importAppRole(ImportMappingDto importMappingDto, AppImportDto appImportDto) {
        List roles;
        JSONObject roleData = AppMigrateUtil.readData(appImportDto.getPath(), "role", JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)roleData) && HussarUtils.isNotEmpty((Object)(roles = JSON.parseArray((String)roleData.getString("roles"), SysRoles.class)))) {
            for (SysRoles role : roles) {
                if (role.getFromAppId() == 1L) continue;
                Long oldRoleId = role.getId();
                SysRoles newRole = new SysRoles();
                BeanUtils.copyProperties((Object)role, (Object)newRole);
                newRole.setId(null);
                newRole.setFromAppId(importMappingDto.getNewAppId());
                this.sysRolesService.save((Object)newRole);
                Long newRoleId = newRole.getId();
                importMappingDto.getRoleIdMap().put(oldRoleId, newRoleId);
            }
        }
    }

    private void importAppLinkInner(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        SysAppLinkInner sysAppLinkInner;
        String path = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "appLinkInner.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(path, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty((Object)(sysAppLinkInner = (SysAppLinkInner)jsonObject.getObject("appLinkInner", SysAppLinkInner.class)))) {
            Map resultMap;
            sysAppLinkInner.setLinkId(null);
            sysAppLinkInner.setAppId(importMappingDto.getNewAppId());
            String shortLink = this.sysAppLinkInnerService.generateShortLink();
            sysAppLinkInner.setInnerShortAddress(shortLink);
            String innerParams = sysAppLinkInner.getInnerParams();
            if (HussarUtils.isEmpty((Object)innerParams)) {
                throw new BaseException("\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u53c2\u6570innerParams\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                resultMap = (Map)objectMapper.readValue(innerParams, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception e) {
                throw new BaseException("json\u8f6c\u6362\u5931\u8d25");
            }
            resultMap.put("appId", importMappingDto.getNewAppId());
            resultMap.put("appName", appImportDto.getAppName());
            String jsonStr = JsonUtil.toJson((Object)resultMap);
            sysAppLinkInner.setInnerParams(jsonStr);
            this.sysAppLinkInnerService.save((Object)sysAppLinkInner);
        }
    }

    private void importAppWatermark(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        SysAppWatermark sysAppWatermark;
        String path = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "appWatermark.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(path, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty((Object)(sysAppWatermark = (SysAppWatermark)jsonObject.getObject("appWatermark", SysAppWatermark.class)))) {
            sysAppWatermark.setWatermarkId(null);
            sysAppWatermark.setAppId(importMappingDto.getNewAppId());
            this.sysAppWatermarkService.save((Object)sysAppWatermark);
        }
    }

    @ImportProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")
    public void importFormData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "form.json"});
        JSONObject formData = AppMigrateUtil.readFileToObject(formFilePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formData)) {
            List list;
            List<SysForm> forms;
            JSONArray jsonArray = (JSONArray)formData.getObject("formGroups", JSONArray.class);
            List<SysFormGroup> formGroups = AppMigrateUtil.parseJsonArrayToList(jsonArray, SysFormGroup.class);
            if (HussarUtils.isNotEmpty(formGroups)) {
                for (SysFormGroup sysFormGroup : formGroups) {
                    Long oldFormGroupId = sysFormGroup.getId();
                    sysFormGroup.setId(null);
                    sysFormGroup.setAppId(importMappingDto.getNewAppId());
                    this.formGroupService.save((Object)sysFormGroup);
                    Long newFormGroupId = sysFormGroup.getId();
                    importMappingDto.getFormGroupMap().put(oldFormGroupId, newFormGroupId);
                }
            }
            if (HussarUtils.isNotEmpty(forms = AppMigrateUtil.parseJsonObjectToListByKey(formData, "forms", SysForm.class))) {
                for (SysForm form : forms) {
                    Long oldFormId = form.getId();
                    String oldTableName = form.getTableName();
                    form.setId(null);
                    form.setAppId(importMappingDto.getNewAppId());
                    String newTableName = this.generateNewTableName(oldTableName, form.getFormType());
                    form.setTableName(newTableName);
                    form.setFormGroupId((Long)importMappingDto.getFormGroupMap().get(form.getFormGroupId()));
                    this.formService.save((Object)form);
                    SysFormDto sysFormDto = new SysFormDto();
                    BeanUtils.copyProperties((Object)form, (Object)sysFormDto);
                    this.formService.initFormDevelopRole(sysFormDto);
                    Long newFormId = form.getId();
                    importMappingDto.getFormIdMap().put(oldFormId, newFormId);
                    importMappingDto.getFormTypeMap().put(newFormId, form.getFormType());
                    if ("3".equals(form.getFormType()) || "2".equals(form.getFormType())) continue;
                    importMappingDto.getTableNameMap().put(oldTableName, newTableName);
                }
            }
            if (appImportDto.getExportRoleFlag() && HussarUtils.isNotEmpty((Object)(list = JSON.parseArray((String)formData.getString("formAuth"), SysAppVisitFormAuthorizeRoles.class)))) {
                for (SysAppVisitFormAuthorizeRoles formAuth : list) {
                    formAuth.setId(null);
                    formAuth.setAppId(importMappingDto.getNewAppId());
                    formAuth.setFormId((Long)importMappingDto.getFormIdMap().get(formAuth.getFormId()));
                    if (!importMappingDto.getRoleIdMap().containsKey(formAuth.getRoleId())) continue;
                    formAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(formAuth.getRoleId()));
                }
                this.formAuthService.saveBatch((Collection)list);
            }
            this.importDashboardData(appImportDto, importMappingDto);
        }
    }

    public void importDashboardData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String dashboardFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "dashboard.json"});
        JSONObject dashboardData = AppMigrateUtil.readFileToObject(dashboardFilePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)dashboardData)) {
            for (String key : dashboardData.keySet()) {
                List<DashEntry> dashEntryList = AppMigrateUtil.parseJsonObjectToListByKey(dashboardData, key, DashEntry.class);
                Long newFormId = (Long)importMappingDto.getFormIdMap().get(Long.parseLong(key));
                this.dashEntryService.importPanelData(newFormId, null, null, null, importMappingDto.getNewAppId(), dashEntryList);
            }
        }
    }

    private String generateNewTableName(String oldTableName, String formType) {
        String prefix;
        String newTableName = !"3".equals(formType) && !"2".equals(formType) ? (oldTableName.length() > 16 ? (NumberUtil.isNumber((CharSequence)(prefix = oldTableName.substring(0, oldTableName.length() - 16))) ? prefix + RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz", (int)1) + RandomUtil.randomString((String)"0123456789", (int)15) : prefix + RandomUtil.randomString((String)"0123456789", (int)16)) : oldTableName + RandomUtil.randomString((String)"0123456789", (int)16)) : oldTableName;
        return newTableName;
    }

    @ImportProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6743\u9650\u6570\u636e")
    public void importFormAuthData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        if (!appImportDto.getExportRoleFlag()) {
            return;
        }
        JSONObject formAuthData = AppMigrateUtil.readData(appImportDto.getPath(), "formAuth", JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formAuthData)) {
            List dataLogicAuths;
            List fieldAuths;
            List buttonAuths = JSON.parseArray((String)formAuthData.getString("buttonAuth"), SysAppVisitRoleButton.class);
            if (HussarUtils.isNotEmpty((Object)buttonAuths)) {
                for (Object buttonAuth : buttonAuths) {
                    buttonAuth.setId(null);
                    buttonAuth.setAppId(importMappingDto.getNewAppId());
                    buttonAuth.setFormId((Long)importMappingDto.getFormIdMap().get(buttonAuth.getFormId()));
                    if (!importMappingDto.getRoleIdMap().containsKey(buttonAuth.getRoleId())) continue;
                    buttonAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(buttonAuth.getRoleId()));
                }
                this.buttonAuthService.saveBatch((Collection)buttonAuths);
            }
            if (HussarUtils.isNotEmpty((Object)(fieldAuths = JSON.parseArray((String)formAuthData.getString("filedAuth"), SysUpAppVisitRoleField.class)))) {
                for (SysUpAppVisitRoleField fieldAuth : fieldAuths) {
                    fieldAuth.setId(null);
                    fieldAuth.setAppId(importMappingDto.getNewAppId());
                    fieldAuth.setFormId((Long)importMappingDto.getFormIdMap().get(fieldAuth.getFormId()));
                    if (!importMappingDto.getRoleIdMap().containsKey(fieldAuth.getRoleId())) continue;
                    fieldAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(fieldAuth.getRoleId()));
                }
                this.fieldAuthService.saveBatch((Collection)fieldAuths);
            }
            if (HussarUtils.isNotEmpty((Object)(dataLogicAuths = JSON.parseArray((String)formAuthData.getString("dataLogicAuth"), SysAppVisitDataLogic.class)))) {
                HashMap<Long, Long> mapping = new HashMap<Long, Long>();
                for (SysAppVisitDataLogic dataLogicAuth : dataLogicAuths) {
                    Long oldId = dataLogicAuth.getId();
                    long newId = LrEngineUtil.nextId();
                    mapping.put(oldId, newId);
                    dataLogicAuth.setId(Long.valueOf(newId));
                    dataLogicAuth.setAppId(importMappingDto.getNewAppId());
                    dataLogicAuth.setFormId((Long)importMappingDto.getFormIdMap().get(dataLogicAuth.getFormId()));
                    if (!importMappingDto.getRoleIdMap().containsKey(dataLogicAuth.getRoleId())) continue;
                    dataLogicAuth.setRoleId((Long)importMappingDto.getRoleIdMap().get(dataLogicAuth.getRoleId()));
                }
                this.dataLogicAuthService.saveBatch((Collection)dataLogicAuths);
                List dataLogicFilters = JSON.parseArray((String)formAuthData.getString("dataLogicFilter"), SysAppVisitDataLogicFilter.class);
                if (HussarUtils.isNotEmpty((Object)dataLogicFilters)) {
                    for (SysAppVisitDataLogicFilter dataLogicFilter : dataLogicFilters) {
                        Long oldId = dataLogicFilter.getRoleDataLogicId();
                        dataLogicFilter.setId(null);
                        dataLogicFilter.setRoleDataLogicId((Long)mapping.get(oldId));
                    }
                }
                this.dataLogicFilterService.saveBatch((Collection)dataLogicFilters);
            }
        }
    }

    @ImportProgressCache(status=5, msg="\u6b63\u5728\u5bfc\u5165\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void importMidFile(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws Exception {
        Object[] files;
        this.recordReplaceMapping(appImportDto, importMappingDto);
        this.importCustomButton(appImportDto, importMappingDto);
        this.importScript(appImportDto, importMappingDto);
        String oldAppId = String.valueOf(importMappingDto.getOldAppId());
        String midFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", oldAppId});
        File midFileFolder = new File(midFilePath);
        if (midFileFolder.exists() && midFileFolder.isDirectory() && HussarUtils.isNotEmpty((Object[])(files = midFileFolder.listFiles()))) {
            for (Object file : files) {
                HashMap<Object, Object> staffReplaceMap;
                String newSettingFormId = "";
                HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
                replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
                replaceMap.putAll(importMappingDto.getFormIdMap());
                replaceMap.putAll(importMappingDto.getTableNameMap());
                replaceMap.putAll(importMappingDto.getSubTableNameMap());
                replaceMap.putAll(importMappingDto.getProcessKeyMap());
                replaceMap.putAll(importMappingDto.getScriptRecordMap());
                replaceMap.putAll(importMappingDto.getScriptMethodMap());
                String canvasPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "canvas", ((File)file).getName() + ".fd"});
                FormCanvasSchema formCanvasSchema = AppMigrateUtil.readFileToObjectWithReplace(canvasPath, FormCanvasSchema.class, replaceMap);
                if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
                    newSettingFormId = formCanvasSchema.getId();
                    this.clearSerialNumberId(formCanvasSchema);
                    this.canvasService.saveCanvasForImport(formCanvasSchema, importMappingDto);
                }
                String settingPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "setting", ((File)file).getName() + ".setting"});
                HashMap<Object, Object> settingReplaceMap = new HashMap<Object, Object>();
                settingReplaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
                settingReplaceMap.putAll(importMappingDto.getSubTableNameMap());
                settingReplaceMap.putAll(importMappingDto.getFormIdMap());
                settingReplaceMap.putAll(importMappingDto.getScriptMethodMap());
                settingReplaceMap.putAll(importMappingDto.getScriptRecordMap());
                FormSettingSchema formSettingSchema = AppMigrateUtil.readFileToObjectWithReplace(settingPath, FormSettingSchema.class, settingReplaceMap);
                if (HussarUtils.isNotEmpty((Object)formSettingSchema)) {
                    LOGGER.info("formCanvasSchema====>:{}", (Object)formSettingSchema);
                    LOGGER.info("newSettingFormId====>:{}", (Object)newSettingFormId);
                    SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
                    bean.saveOrUpdate((BaseSetting)formSettingSchema, newSettingFormId);
                }
                String viewPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "view", ((File)file).getName() + ".vd"});
                HashMap<Object, Object> viewReplaceMap = new HashMap<Object, Object>();
                viewReplaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
                viewReplaceMap.putAll(importMappingDto.getFormIdMap());
                viewReplaceMap.putAll(importMappingDto.getTableNameMap());
                viewReplaceMap.putAll(importMappingDto.getSubTableNameMap());
                viewReplaceMap.putAll(importMappingDto.getScriptRecordMap());
                viewReplaceMap.putAll(importMappingDto.getScriptMethodMap());
                FormViewSchema formViewSchema = AppMigrateUtil.readFileToObjectWithReplace(viewPath, FormViewSchema.class, viewReplaceMap);
                if (HussarUtils.isNotEmpty((Object)formViewSchema)) {
                    this.viewService.save(formViewSchema);
                }
                String fileName = ((File)file).getName() + "history" + ".stf";
                String staffPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "staff", fileName});
                JSONArray jsonArray = AppMigrateUtil.readFileToObjectWithReplace(staffPath, JSONArray.class, staffReplaceMap = new HashMap<Object, Object>(importMappingDto.getFormIdMap()));
                List<StaffScope> staffScopes = AppMigrateUtil.parseJsonArrayToList(jsonArray, StaffScope.class);
                if (!HussarUtils.isNotEmpty(staffScopes)) continue;
                this.staffScopeScemaService.saveOrUpdateBatch(staffScopes);
            }
        }
        this.importCheckConfig(appImportDto, importMappingDto);
        this.importMsgPush(appImportDto, importMappingDto);
        this.importPrintTemplate(appImportDto, importMappingDto);
        this.importFormLink(appImportDto, importMappingDto);
        this.importDataPull(appImportDto, importMappingDto);
        this.importDataPush(appImportDto, importMappingDto);
        this.importDataPushMap(appImportDto, importMappingDto);
        this.importPublicView(appImportDto, importMappingDto);
    }

    private void importPrintTemplate(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        try {
            String printTemplatePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "printTemplate", "printTemplate.json"});
            JSONObject jsonObject = AppMigrateUtil.readFileToObject(printTemplatePath, JSONObject.class);
            if (HussarUtils.isNotEmpty((Object)jsonObject)) {
                JSONArray printTemplateJsonArray = (JSONArray)jsonObject.getObject("printTemplateData", JSONArray.class);
                List<SysPrintTemplate> printTemplates = AppMigrateUtil.parseJsonArrayToList(printTemplateJsonArray, SysPrintTemplate.class);
                String templateFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "printTemplate", "templateFile"});
                this.sysPrintTemplateService.importPrintTemplate(importMappingDto, printTemplates, templateFilePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6253\u5370\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    private void importCustomButton(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        JSONArray customButtonJsonArray;
        List<SysCustomButton> customButtons;
        String customButtonPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "customButton.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(customButtonPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)jsonObject) && HussarUtils.isNotEmpty(customButtons = AppMigrateUtil.parseJsonArrayToList(customButtonJsonArray = (JSONArray)jsonObject.getObject("customButtonData", JSONArray.class), SysCustomButton.class))) {
            this.replaceCustomButton(importMappingDto, customButtons, "1");
            this.sysCustomButtonService.saveBatch(customButtons);
            this.sysCustomButtonService.mountBtnAuth2DevelopRole(importMappingDto.getNewAppId(), customButtons);
        }
    }

    public void replaceCustomButton(ImportMappingDto importMappingDto, List<SysCustomButton> customButtons, String importSource) {
        for (SysCustomButton button : customButtons) {
            try {
                button.setId(null);
                Long newFormId = (Long)importMappingDto.getFormIdMap().get(button.getFormId());
                Long newAppId = importMappingDto.getNewAppId();
                button.setAppId(newAppId);
                button.setFormId(newFormId);
                JSONObject filter = button.getFilter();
                JSONArray conditions = (JSONArray)filter.get((Object)"conditions");
                for (Object condition : conditions) {
                    JSONObject cond = (JSONObject)condition;
                    String parentVal = String.valueOf(cond.get((Object)"parent"));
                    if (!HussarUtils.isNotEmpty((Object)parentVal)) continue;
                    Object newParentVal = importMappingDto.getSubTableNameMap().get(parentVal);
                    cond.put("parent", newParentVal);
                }
                if (CustomButtonConstant.EVENT_WRITE.equals(button.getEvent())) {
                    boolean currentAppFlag;
                    JSONObject fillAction = button.getFillAction();
                    if (HussarUtils.isEmpty((Object)fillAction.get((Object)"values"))) {
                        JSONArray fillAuthorities = (JSONArray)fillAction.get((Object)"fillAuthority");
                        for (Object fillAuthority : fillAuthorities) {
                            JSONObject authority = (JSONObject)fillAuthority;
                            String type = (String)authority.get((Object)"type");
                            if (!WidgetType.CHILDREN_TABLE.getType().equals(type) && !WidgetType.JXDNChildrenTableAgg.getType().equals(type)) continue;
                            authority.put("field", importMappingDto.getSubTableNameMap().get(String.valueOf(authority.get((Object)"field"))));
                        }
                        continue;
                    }
                    JSONObject data = (JSONObject)fillAction.get((Object)"data");
                    Long targetAppId = Long.valueOf(String.valueOf(data.get((Object)"appId")));
                    Long targetFormId = Long.valueOf(String.valueOf(data.get((Object)"formId")));
                    String asyncType = String.valueOf(data.get((Object)"asyncType"));
                    boolean bl = currentAppFlag = "1".equals(importSource) && targetAppId.equals(importMappingDto.getOldAppId());
                    if (currentAppFlag) {
                        data.put("appId", (Object)importMappingDto.getNewAppId());
                        if (HussarUtils.isNotEmpty(importMappingDto.getFormIdMap().get(targetAppId))) {
                            data.put("formId", importMappingDto.getFormIdMap().get(targetFormId));
                        }
                    }
                    if (asyncType.equals("currentApp") && !currentAppFlag) {
                        data.put("asyncType", (Object)"crossApp");
                    } else if (asyncType.equals("crossApp") && currentAppFlag) {
                        data.put("asyncType", (Object)"currentApp");
                    }
                    JSONArray fillValues = (JSONArray)fillAction.get((Object)"values");
                    for (Object value : fillValues) {
                        JSONObject depend;
                        JSONObject val = (JSONObject)value;
                        if (currentAppFlag && HussarUtils.isNotEmpty((Object)val.get((Object)"parent"))) {
                            val.put("parent", importMappingDto.getSubTableNameMap().get(String.valueOf(val.get((Object)"parent"))));
                        }
                        if (!HussarUtils.isNotEmpty((Object)(depend = (JSONObject)val.get((Object)"depend"))) || !HussarUtils.isNotEmpty((Object)depend.get((Object)"parent"))) continue;
                        depend.put("parent", importMappingDto.getSubTableNameMap().get(String.valueOf(depend.get((Object)"parent"))));
                    }
                    continue;
                }
                if (!CustomButtonConstant.EVENT_UPDATE.equals(button.getEvent())) continue;
                JSONObject updateAction = button.getUpdateAction();
                JSONObject target = (JSONObject)updateAction.get((Object)"target");
                target.put("appId", (Object)newAppId);
                target.put("formId", (Object)newFormId);
            }
            catch (Exception e) {
                LOGGER.error("\u81ea\u5b9a\u4e49\u6309\u94ae\u914d\u7f6e\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private void importBusinessRule(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws IOException {
        SecurityUser user = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
        String ruleFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "rule.json"});
        File file = new File(ruleFilePath);
        if (!file.exists()) {
            return;
        }
        String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        HashMap<Long, Long> replaceMap = new HashMap<Long, Long>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        ArrayList sortedEntries = new ArrayList(replaceMap.entrySet());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        List ruleNew = JSONArray.parseArray((String)text, RuleFullVo.class);
        for (RuleFullVo rule : ruleNew) {
            rule.setRuleId(null);
            try {
                this.ruleInfoService.saveRule(rule);
            }
            catch (Exception e) {
                LOGGER.error("\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private void importBusinessRule1(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws IOException {
        String ruleFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "rule.json"});
        File file = new File(ruleFilePath);
        if (!file.exists()) {
            return;
        }
        String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        List ruleCardVos = JSONArray.parseArray((String)text, RuleFullVo.class);
        for (RuleFullVo rule : ruleCardVos) {
            rule.setRuleId(null);
            rule.setAppId(String.valueOf(importMappingDto.getNewAppId()));
            rule.setSourceForm(String.valueOf(importMappingDto.getFormIdMap().get(Long.parseLong(rule.getSourceForm()))));
            Map subTableNameMap = importMappingDto.getSubTableNameMap();
            for (JSONObject object : rule.getActions()) {
                List actions;
                JSONObject filterStr;
                List filters;
                String oldFormId = object.getJSONObject("target").getString("formId");
                String newFormId = String.valueOf(importMappingDto.getFormIdMap().get(Long.parseLong(oldFormId)));
                String oldAppId = object.getJSONObject("target").getString("appId");
                LOGGER.info("\u65e7Id:{},\u65b0Id:{}", (Object)oldFormId, (Object)newFormId);
                if (HussarUtils.isNotEmpty((Object)newFormId) && !"null".equals(newFormId)) {
                    object.getJSONObject("target").put("formId", (Object)newFormId);
                }
                if (oldAppId.equals(String.valueOf(importMappingDto.getOldAppId()))) {
                    object.getJSONObject("target").put("appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
                }
                if (HussarUtils.isNotEmpty((Object)(filters = JSONArray.parseArray((String)(filterStr = object.getJSONObject("filter")).getString("cond"), JSONObject.class)))) {
                    for (JSONObject filter : filters) {
                        String newSubFormName;
                        String oldSubFormName;
                        JSONObject depend;
                        String newSubFormName2;
                        String parent = filter.getString("parent");
                        if (HussarUtils.isNotEmpty((Object)parent) && HussarUtils.isNotEmpty((Object)(newSubFormName2 = (String)subTableNameMap.get(parent)))) {
                            filter.put("parent", (Object)newSubFormName2);
                        }
                        if (HussarUtils.isEmpty((Object)(depend = filter.getJSONObject("depend"))) || !HussarUtils.isNotEmpty((Object)(oldSubFormName = depend.getString("parent"))) || !HussarUtils.isNotEmpty((Object)(newSubFormName = (String)subTableNameMap.get(oldSubFormName)))) continue;
                        depend.put("parent", (Object)newSubFormName);
                        filter.put("depend", (Object)depend);
                    }
                    filterStr.put("cond", (Object)filters);
                    object.put("filter", (Object)filterStr);
                }
                if (!HussarUtils.isNotEmpty((Object)(actions = JSONArray.parseArray((String)object.getString("values"), JSONObject.class)))) continue;
                for (JSONObject action : actions) {
                    String newSubFormName;
                    String oldSubFormName;
                    JSONObject depend;
                    String newSubFormName3;
                    String parent = action.getString("parent");
                    if (HussarUtils.isNotEmpty((Object)parent) && HussarUtils.isNotEmpty((Object)(newSubFormName3 = (String)subTableNameMap.get(parent)))) {
                        action.put("parent", (Object)newSubFormName3);
                    }
                    if (!HussarUtils.isNotEmpty((Object)(depend = action.getJSONObject("depend"))) || !HussarUtils.isNotEmpty((Object)(oldSubFormName = depend.getString("parent"))) || !HussarUtils.isNotEmpty((Object)(newSubFormName = (String)subTableNameMap.get(oldSubFormName)))) continue;
                    depend.put("parent", (Object)newSubFormName);
                    action.put("depend", (Object)depend);
                }
                object.put("values", (Object)actions);
            }
            try {
                this.ruleInfoService.saveRule(rule);
            }
            catch (Exception e) {
                LOGGER.error("\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private void importFormLink(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String formLinkFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "formLink.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formLinkFilePath, JSONObject.class);
        this.sysFormLinkService.saveBatchImportData(jsonObject, importMappingDto);
    }

    private void importCheckConfig(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws IOException {
        String checkConfigFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "checkConfig.json"});
        File file = new File(checkConfigFilePath);
        if (!file.exists()) {
            return;
        }
        String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        List checkConfigs = JSONArray.parseArray((String)text, SysFormCheckConfig.class);
        checkConfigs.forEach(checkConfig -> {
            if (HussarUtils.isNotEmpty((Object)checkConfig)) {
                String config = checkConfig.getCheckConfig();
                String json = JSON.parse((String)config).toString();
                for (Map.Entry entry : importMappingDto.getSubTableNameMap().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!json.contains(key)) continue;
                    json = json.replace(key, value);
                }
                checkConfig.setCheckConfigId(null);
                checkConfig.setCheckConfig(json);
                checkConfig.setFormId((Long)importMappingDto.getFormIdMap().get(checkConfig.getFormId()));
            }
        });
        this.sysFormCheckConfigService.saveBatch((Collection)checkConfigs);
    }

    @ImportProgressCache(status=6, msg="\u6b63\u5728\u5bfc\u5165\u6d41\u7a0b\u914d\u7f6e\u6570\u636e")
    public void importFlowData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        this.recordReplaceMappingOfFlow(importMappingDto);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "flow.json"});
        JSONObject flowData = AppMigrateUtil.readFileToObject(flowFilePath, JSONObject.class);
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        if (HussarUtils.isNotEmpty((Object)flowData)) {
            for (String key : flowData.keySet()) {
                JSONArray data = (JSONArray)flowData.getObject(key, JSONArray.class);
                List<WorkflowDumpVo> workflowDumpVos = AppMigrateUtil.parseJsonArrayToList(data, WorkflowDumpVo.class);
                workflowDumpVoListMap.put(key, workflowDumpVos);
            }
        }
        com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto flowImportMappingDto = new com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto();
        BeanUtils.copyProperties((Object)importMappingDto, (Object)flowImportMappingDto);
        if (HussarUtils.isNotEmpty((Object)importMappingDto.getTableNameMap())) {
            Map<String, String> mainTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setMainTableNameMap(mainTableNameMap);
        }
        if (HussarUtils.isNotEmpty((Object)importMappingDto.getTaskTableNameMap())) {
            Map<String, String> taskTableNameMap = importMappingDto.getTaskTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setTaskTableNameMap(taskTableNameMap);
        }
        flowImportMappingDto.setMainTableBusinessKeyMap(importMappingDto.getTableNameMap());
        flowImportMappingDto.getMainTableBusinessKeyMap().put("RECORD_ID", "RECORD_ID");
        this.flowMigrateService.importWorkflow(workflowDumpVoListMap, flowImportMappingDto);
    }

    @ImportProgressCache(status=7, msg="\u6b63\u5728\u5bfc\u5165\u4e1a\u52a1\u6570\u636e")
    @OperateLogTypeCache(mode=4)
    public void importBusinessData(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws Exception {
        this.updateTableInfo(importMappingDto);
        String filePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "businessData", "businessData.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        replaceMap.putAll(importMappingDto.getProcessKeyMap());
        JSONObject jsonObject = AppMigrateUtil.readFileToObjectWithReplace(filePath, JSONObject.class, replaceMap);
        EngineUserUtil.setUser((UserDetails)((UserDetails)TransmittableThreadLocalHolder.get((String)"loginUser")));
        this.importPageExp(appImportDto);
        this.importWidgetExp(appImportDto);
        if (HussarUtils.isNotEmpty((Object)jsonObject)) {
            String appId = String.valueOf(importMappingDto.getNewAppId());
            Set tableNames = jsonObject.keySet();
            for (String tableName : tableNames) {
                JSONArray jsonArray = (JSONArray)jsonObject.getObject(tableName, JSONArray.class);
                List<Object> importList = AppMigrateUtil.parseJsonArrayToList(jsonArray, Object.class);
                ArrayList<JSONObject> importListFinal = new ArrayList<JSONObject>();
                for (Object object : importList) {
                    if (!HussarUtils.isNotEmpty((Object)object)) continue;
                    JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
                    if (HussarUtils.isNotEmpty((Object)json.get((Object)"PROCESS_STATE"))) {
                        json.put("PROCESS_STATE", (Object)"2");
                    } else if (HussarUtils.isNotEmpty((Object)json.get((Object)"process_state"))) {
                        json.put("process_state", (Object)"2");
                    }
                    json.remove((Object)"PROCESS_INST_ID");
                    json.remove((Object)"process_inst_id");
                    importListFinal.add(json);
                }
                HashMap<String, ArrayList<JSONObject>> params = new HashMap<String, ArrayList<JSONObject>>();
                params.put("importList", importListFinal);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getTableName, (Object)tableName);
                String formId = String.valueOf(((SysForm)this.formService.getOne((Wrapper)wrapper)).getId());
                this.formOperateExposedService.tableSave(appId, formId, params);
            }
        }
        this.afterBusinessData(importMappingDto);
        this.importBusinessRule(appImportDto, importMappingDto);
        this.operateLogThreadLocal.remove();
        EngineUserUtil.remove();
    }

    private void afterBusinessData(ImportMappingDto importMappingDto) throws Exception {
        Collection formIds = importMappingDto.getFormIdMap().values();
        if (HussarUtils.isNotEmpty(formIds)) {
            for (Long formId : formIds) {
                if ("3".equals(importMappingDto.getFormTypeMap().get(formId)) || "2".equals(importMappingDto.getFormTypeMap().get(formId))) continue;
                this.reSync(String.valueOf(formId));
            }
        }
    }

    public void clearSerialNumberId(FormCanvasSchema formCanvasSchema) {
        List widgets = formCanvasSchema.getWidgets();
        this.clearFirstLevelSerialNumberId(widgets);
    }

    public void clearFirstLevelSerialNumberId(List<Widget> widgets) {
        if (HussarUtils.isNotEmpty(widgets)) {
            for (Widget widget : widgets) {
                if (WidgetType.JXDNSerialNumber.getType().equals(widget.getType())) {
                    List serialNumRuleDTOS = JsonParser.array((Object)widget, (String)"$.props.rules", SerialNumRuleDTO.class).orElse(null);
                    if (!HussarUtils.isNotEmpty((Object)serialNumRuleDTOS)) continue;
                    for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOS) {
                        serialNumRuleDTO.getConfig().setId(null);
                    }
                    JSONPath.set((Object)widget, (String)"$.props.rules", (Object)serialNumRuleDTOS);
                    continue;
                }
                if (!widget.getIsContainer()) continue;
                List childrenWidgets = widget.getChildren();
                this.clearFirstLevelSerialNumberId(childrenWidgets);
            }
        }
    }

    public void recordReplaceMappingOfFlow(ImportMappingDto importMappingDto) {
        Map<String, String> taskTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> "PROCESS_TASK_INFO_" + (String)entry.getKey(), entry -> "PROCESS_TASK_INFO_" + (String)entry.getValue()));
        importMappingDto.setTaskTableNameMap(taskTableNameMap);
        importMappingDto.getMainTableBusinessKeyMap().putAll(importMappingDto.getTableNameMap());
    }

    private void recordReplaceMapping(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        Object[] files;
        String oldAppId = String.valueOf(importMappingDto.getOldAppId());
        String midFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", oldAppId});
        File midFileFolder = new File(midFilePath);
        if (midFileFolder.exists() && midFileFolder.isDirectory() && HussarUtils.isNotEmpty((Object[])(files = midFileFolder.listFiles()))) {
            for (Object file : files) {
                String canvasPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "canvas", ((File)file).getName() + ".fd"});
                FormCanvasSchema formCanvasSchema = AppMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
                if (!HussarUtils.isNotEmpty((Object)formCanvasSchema)) continue;
                for (Widget widget : formCanvasSchema.childTables()) {
                    String oleSubTableName = widget.getName();
                    String randomSubTableName = RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)16);
                    String newSubTableName = "field_jxdnchildrentable_" + randomSubTableName;
                    importMappingDto.getSubTableNameMap().put(oleSubTableName, newSubTableName);
                }
                String oldFlowIdentity = formCanvasSchema.getIdentity();
                if (!HussarUtils.isNotEmpty((Object)oldFlowIdentity)) continue;
                String newFlowIdentity = oldFlowIdentity.substring(0, oldFlowIdentity.length() - 18) + RandomUtil.randomString((String)"0123456789", (int)18);
                importMappingDto.getProcessKeyMap().put(oldFlowIdentity, newFlowIdentity);
            }
        }
    }

    private void updateTableInfo(ImportMappingDto importMappingDto) throws Exception {
        Collection fromIds = importMappingDto.getFormIdMap().values();
        for (Long formId : fromIds) {
            LOGGER.info("\u6b63\u5728\u83b7\u53d6\u5bfc\u5165\u5e94\u7528\u7684\u753b\u5e03\u4fe1\u606f\uff0cappId\uff1a{}", (Object)AppContextUtil.getAppId());
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            if (HussarUtils.isEmpty((Object)formCanvasSchema)) continue;
            FormSchema formSchema = new FormSchema.Builder().formPage(formCanvasSchema).build();
            try {
                DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)formSchema);
                NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
                DataModelBase dataModelBase = builder.direct();
                noCodeModelHandler.updateTable(dataModelBase, builder.createContrast());
                builder.clearFieldForImport(dataModelBase);
                noCodeModelHandler.sync(dataModelBase);
            }
            catch (Exception e) {
                System.out.println("\u8be5\u8868\u5355\u83b7\u53d6\u753b\u5e03\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                LOGGER.info("\u6b63\u5728\u83b7\u53d6\u5bfc\u5165\u5e94\u7528\u7684\u753b\u5e03\u4fe1\u606f\uff0c\u65e7appId:{}\uff0c\u65b0appId:{},\u65b0formId:{}", new Object[]{AppContextUtil.getAppId(), importMappingDto.getNewAppId(), formId});
            }
        }
    }

    private void reSync(String formId) throws Exception {
        LOGGER.info("\u5e94\u7528\u5bfc\u5165\u4e2d\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u540c\u6b65\u6570\u636e\u6a21\u578b\u81f3\u89e3\u6790\u5f15\u64ce formId:{}", (Object)formId);
        FormDesignResponse form = this.formOperateService.get(formId);
        LOGGER.info("\u5bfc\u5165\u5e94\u7528\u4e2d\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u540c\u6b65\u6570\u636e\u6a21\u578b\u81f3\u89e3\u6790\u5f15\u64ce formId:{},formType:{}", (Object)formId, (Object)((FormSchema)form.getData()).getFormCanvas().getFormType());
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)((FormSchema)form.getData()));
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.sync(dataModelBase);
    }

    private void importPageExp(AppImportDto appImportDto) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "pageExpand"});
        File folder = new File(formFilePath);
        Object[] files = folder.listFiles();
        if (HussarUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                String fileName = ((File)file).getName();
                String filePath = formFilePath + File.separator + fileName;
                Long fileId = this.fileUpload(filePath);
                this.pageExpService.importPage(fileId, Long.valueOf(1L));
            }
        }
    }

    private void importWidgetExp(AppImportDto appImportDto) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "widgetExpand"});
        File folder = new File(formFilePath);
        Object[] files = folder.listFiles();
        if (HussarUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                String fileName = ((File)file).getName();
                String filePath = formFilePath + File.separator + fileName;
                Long fileId = this.fileUpload(filePath);
                this.widgetExpService.importWidget(fileId, Long.valueOf(1L));
            }
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException iOException) {
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    private void importMsgPush(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String msgPushPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "msg.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        String text = AppMigrateUtil.readFileWithReplace(msgPushPath, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List configs = JSON.parseArray((String)text, SysMsgPushConfig.class);
        for (SysMsgPushConfig config : configs) {
            config.setId(null);
            config.setReminders("{\"organs\": [], \"staffs\": [], \"showFields\": [], \"containSub\": false}");
        }
        this.msgPushConfigService.saveBatch((Collection)configs);
    }

    private void importDataPull(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String dataPullPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "dataPull.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        String text = AppMigrateUtil.readFileWithReplace(dataPullPath, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List configs = JSON.parseArray((String)text, SysDataPullConfig.class);
        for (SysDataPullConfig config : configs) {
            List list;
            Long oldId = config.getId();
            config.setId(null);
            SecurityUser loginUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
            config.setCreator(loginUser.getId());
            config.setLastEditor(loginUser.getId());
            config.setLastTime(LocalDateTime.now());
            SysDataPullConfigDto sysDataPullConfigDto = new SysDataPullConfigDto();
            BeanUtils.copyProperties((Object)config, (Object)sysDataPullConfigDto);
            this.pullDataService.saveConfig(sysDataPullConfigDto);
            if (config.getTriggerAction().equals("1") && !(list = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPullId, (Object)oldId)).eq(SysCustomButton::getFormId, (Object)config.getFormId()))).isEmpty()) {
                for (SysCustomButton customButton : list) {
                    customButton.setDataPullId(sysDataPullConfigDto.getId());
                    this.sysCustomButtonService.saveOrUpdate((Object)customButton);
                }
            }
            if (!"1".equals(config.getStatus()) || !StringUtil.isNotEmpty((String)config.getTriggerAction()) || !config.getTriggerAction().equals("0") || "1".equals(config.getDelFlag())) continue;
            this.sysDataPullTaskService.removeByConfigId(config.getId());
            String dataSourceKey = DataModelUtil.currentDsName();
            try {
                DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ThreadPoolUtil.execute(() -> {
                RequestContextHolder.resetRequestAttributes();
                this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig(config, dataSourceKey);
            });
        }
    }

    private void importDataPush(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String dataPushPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "dataPush.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        String text = AppMigrateUtil.readFileWithReplace(dataPushPath, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List configs = JSON.parseArray((String)text, SysDataPushConfig.class);
        for (SysDataPushConfig config : configs) {
            config.setId(null);
        }
        this.pushDataService.saveBatch((Collection)configs);
    }

    private void importDataPushMap(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String dataPushMapPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "dataPushMap.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        String text = AppMigrateUtil.readFileWithReplace(dataPushMapPath, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List maps = JSON.parseArray((String)text, FormMap.class);
        for (FormMap map : maps) {
            map.setId(null);
        }
        this.formMapService.saveBatch((Collection)maps);
    }

    private void importPublicView(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String publicViewPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "publicView.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        String text = AppMigrateUtil.readFileWithReplace(publicViewPath, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List dataViews = JSON.parseArray((String)text, DataView.class);
        List<CustomView> publicViewList = dataViews.stream().map(dataView -> this.customViewService.convertToCustomView(dataView)).collect(Collectors.toList());
        publicViewList.forEach(customView -> customView.setViewId(null));
        this.customViewService.saveBatch(publicViewList);
    }

    private void importScript(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String path = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "script.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
        replaceMap.putAll(importMappingDto.getFormIdMap());
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        String text = AppMigrateUtil.readFileWithReplace(path, replaceMap);
        if (HussarUtils.isEmpty((Object)text)) {
            return;
        }
        List scriptBases = JSON.parseArray((String)text, ScriptBase.class);
        if (HussarUtils.isEmpty((Object)scriptBases)) {
            return;
        }
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        ArrayList<ScriptRecord> scriptRecords = new ArrayList<ScriptRecord>();
        this.snowflakeID.init();
        HashMap<String, String> scriptRecordMap = new HashMap<String, String>();
        HashMap scriptMethodMap = new HashMap();
        for (ScriptBase scriptBase : scriptBases) {
            long recordId = this.snowflakeID.nextIdLong();
            scriptRecordMap.put(String.valueOf(scriptBase.getId()), String.valueOf(recordId));
            ScriptRecord scriptRecord = new ScriptRecord.Builder().withId(Long.valueOf(recordId)).withName(scriptBase.getName()).withDesc(scriptBase.getDesc()).withNote(scriptBase.getNote()).withIcon(scriptBase.getIcon()).withType(scriptBase.getType()).withAuthor(scriptBase.getAuthor()).withVersion(scriptBase.getVersion()).withEditorNote(scriptBase.getEditorNote()).withFileId(scriptBase.getFileId()).withGroupId(scriptBase.getGroupId()).withFormId(scriptBase.getFormId()).build();
            ScriptBaseAssemble scriptBaseAssemble = new ScriptBaseAssemble(new ArrayList(), scriptRecord);
            scriptRecords.add(scriptRecord);
            scriptRecordService.importMethods(scriptBase.getMethods(), scriptBaseAssemble, scriptMethodMap);
        }
        scriptRecordService.saveBatch(scriptRecords);
        importMappingDto.setScriptMethodMap(scriptMethodMap);
        importMappingDto.setScriptRecordMap(scriptRecordMap);
    }
}

