/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sdk.service.impl;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionAppSdkOn;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.HussarNoCodeAppTeamCallBackServiceImpl")
@HussarTokenDs
@Conditional(value={ConditionAppSdkOn.class})
public class HussarSdkAppTeamCallBackServiceImpl
implements IHussarAppTeamCallBackService {
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private IHussarBaseUserBoService sysUserRoleService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppDevelopTeamMemberBoService appDevelopTeamMemberBoService;

    public String getAppType() {
        return "1";
    }

    public void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto) {
    }

    public void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        SysApplication app = this.applicationBoService.selectById(appDevelopTeamDto.getAppId());
        if ("1".equals(app.getAppType())) {
            List newUserIds = appDevelopTeamDto.getUserIds();
            List oldUserVoList = this.appDevelopTeamMemberBoService.listAppDevelopTeamMember(appDevelopTeamDto.getTeamId());
            Long developRoleId = app.getDevelopRoleId();
            RoleUserDto roleUserDto = new RoleUserDto();
            roleUserDto.setRoleId(developRoleId);
            List removeList = oldUserVoList.stream().map(userVo -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userVo.getId());
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setDels(removeList);
            List addList = newUserIds.stream().map(userId -> {
                RoleOrgUserVo roleOrgUserVo = new RoleOrgUserVo();
                roleOrgUserVo.setId(userId);
                return roleOrgUserVo;
            }).collect(Collectors.toList());
            roleUserDto.setAdds(addList);
            this.sysRolesExternalService.addOrDelAppDevRoleUser(roleUserDto).getData();
        }
    }

    public void updateMember(UpdateMemberTypeDto updateDto) {
    }

    public void removeMembers(Long appId, Long userId) {
        SysApplication application = this.applicationBoService.selectById(appId);
        this.sysUserRoleService.removeByGrantedRoleIdAndUserId(application.getDevelopRoleId(), userId);
    }

    public void transferAdministrator(TransferMemberTypeDto transferDto) {
    }
}

