/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sdk.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.SysAppGroupDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.properties.FormDesignAppProperties;
import com.jxdinfo.hussar.formdesign.application.sdk.dao.SysIdConvertsNewMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionAppSdkOn;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.sync.idconverts.model.SysIdConverts;
import com.jxdinfo.hussar.workstation.application.dto.SysWorkstationAppDto;
import com.jxdinfo.hussar.workstation.application.sdk.service.workstationApp.SysWorkstationAppSDKService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.HussarSdkAppCallBackServiceImpl")
@HussarTokenDs
@Conditional(value={ConditionAppSdkOn.class})
public class HussarSdkAppCallBackServiceImpl
implements IHussarAppCallBackService {
    @Value(value="${hussar.unify.authentication.enable}")
    private boolean unifyAuthenticationEnable;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private SysFormMapper formMapper;
    @Resource
    private SysFormGroupMapper formGroupMapper;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFieldMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ISysApplicationBoService iSysApplicationBoService;
    @Resource
    private SysWorkstationAppSDKService workstationAppSDKService;
    @Resource
    private FormDesignAppProperties formDesignAppProperties;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private SysIdConvertsNewMapper sysIdConvertsNewMapper;
    @Resource
    private IDashEntryService dashEntryService;
    private static Logger logger = LoggerFactory.getLogger(HussarSdkAppCallBackServiceImpl.class);

    public String getAppType() {
        return "1";
    }

    public void deleteApp(SysApplication app) {
        this.workstationAppSDKService.deleteWorkstationApp(app.getId());
    }

    public void updateApp(SysApplication app) {
        SysApplicationVo applicationVo = (SysApplicationVo)this.sysApplicationService.getAppDetail(app.getId()).getData();
        SysWorkstationAppDto sysWorkstationAppDto = new SysWorkstationAppDto();
        BeanUtil.copyProperties((Object)applicationVo, (Object)sysWorkstationAppDto);
        sysWorkstationAppDto.setAppName(app.getAppName());
        sysWorkstationAppDto.setAppDescribe(app.getAppDescribe());
        sysWorkstationAppDto.setAppIcon(app.getAppIcon());
        List groups = this.sysAppGroupMapper.getAppGroupById(app.getAppGroupId());
        SysAppGroup sysAppGroup = (SysAppGroup)groups.get(0);
        SysAppGroupDto sysAppGroupDto = new SysAppGroupDto();
        BeanUtil.copyProperties((Object)sysAppGroup, (Object)sysAppGroupDto);
        Long groupId = this.workstationAppSDKService.addGroup(sysAppGroupDto);
        sysWorkstationAppDto.setAppType("8");
        sysWorkstationAppDto.setAppGroupId(groupId);
        if (HussarUtils.isEmpty((Object)sysWorkstationAppDto.getWebUrl())) {
            sysWorkstationAppDto.setWebUrl(this.formDesignAppProperties.getWebAppUrl() + app.getId());
        }
        sysWorkstationAppDto.setMobileUrl(this.formDesignAppProperties.getMobileAppUrl() + app.getId());
        logger.info("\u4fee\u6539\u96f6\u4ee3\u7801\u5e94\u7528\uff1a\u5165\u53c2\u4e3a:{}", (Object)JsonUtil.toJson((Object)sysWorkstationAppDto));
        if (this.unifyAuthenticationEnable) {
            SysIdConverts sysIdConvert;
            Long employeeId;
            SysUsers lastEditor;
            SysIdConverts sysIdConvert2;
            Long employeeId2;
            SysUsers creator = this.sysUsersService.getUser(sysWorkstationAppDto.getCreator());
            if (HussarUtils.isNotEmpty((Object)creator) && HussarUtils.isNotEmpty((Object)(employeeId2 = creator.getEmployeeId())) && HussarUtils.isNotEmpty((Object)(sysIdConvert2 = this.sysIdConvertsNewMapper.selectByNumId(employeeId2))) && HussarUtils.isNotEmpty((Object)sysIdConvert2.getIamUser())) {
                sysWorkstationAppDto.setCreator(sysIdConvert2.getIamUser());
            }
            if (HussarUtils.isNotEmpty((Object)(lastEditor = this.sysUsersService.getUser(sysWorkstationAppDto.getLastEditor()))) && HussarUtils.isNotEmpty((Object)(employeeId = lastEditor.getEmployeeId())) && HussarUtils.isNotEmpty((Object)(sysIdConvert = this.sysIdConvertsNewMapper.selectByNumId(employeeId))) && HussarUtils.isNotEmpty((Object)sysIdConvert.getIamUser())) {
                sysWorkstationAppDto.setLastEditor(sysIdConvert.getIamUser());
            }
        }
        try {
            sysWorkstationAppDto.setAppCode(null);
            this.workstationAppSDKService.saveWorkstationApp(sysWorkstationAppDto);
        }
        catch (Exception e) {
            logger.error("updateApp\u63a5\u53e3\u65b0\u589e\u63a8\u9001\u7edf\u4e00\u95e8\u6237\u5931\u8d25\uff0c\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
            logger.error(e.getMessage());
            sysWorkstationAppDto.setAppCode(null);
            this.workstationAppSDKService.updateWorkstationApp(sysWorkstationAppDto);
        }
        String oldName = ((SysApplicationVo)this.sysApplicationService.getAppDetail(app.getId()).getData()).getAppName();
        if (!HussarUtils.equals((Object)oldName, (Object)app.getAppName())) {
            SysApplicationVo appDetail = (SysApplicationVo)this.sysApplicationService.getAppDetail(app.getId()).getData();
            RoleInfoVO roleViewMap = this.rolesService.getRoleViewMap(appDetail.getDevelopRoleId());
            SysRoles sysRoles = new SysRoles();
            HussarUtils.copy((Object)roleViewMap, (Object)sysRoles);
            sysRoles.setRoleName(app.getAppName() + "\u5f00\u53d1\u8005");
            logger.info("\u4fee\u6539\u96f6\u4ee3\u7801\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272\uff1a\u5165\u53c2\u4e3a:{}", (Object)JsonUtil.toJson((Object)sysRoles));
            this.rolesService.updateRole(sysRoles);
        }
    }

    public void addApp(SysApplication app) {
        SysIdConverts sysIdConvert;
        Long employeeId;
        SysUsers sysUsers;
        UserDetails userDetails;
        SysWorkstationAppDto sysWorkstationAppDto = new SysWorkstationAppDto();
        BeanUtil.copyProperties((Object)app, (Object)sysWorkstationAppDto);
        sysWorkstationAppDto.setPlatform("3");
        sysWorkstationAppDto.setReleaseStatus("1");
        if ("1".equals(sysWorkstationAppDto.getAppType())) {
            this.initDevelopRole((SysApplicationDto)sysWorkstationAppDto);
        }
        if (HussarUtils.isEmpty((Object)(userDetails = (UserDetails)TransmittableThreadLocalHolder.get((String)"loginUserDetails")))) {
            userDetails = HussarSecurityUtils.getLoginUserDetails();
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
        }
        if (HussarUtils.isNotEmpty((Object)sysWorkstationAppDto.getDevelopRoleId())) {
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(sysWorkstationAppDto.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
        }
        List groups = this.sysAppGroupMapper.getAppGroupById(app.getAppGroupId());
        SysAppGroup sysAppGroup = (SysAppGroup)groups.get(0);
        SysAppGroupDto sysAppGroupDto = new SysAppGroupDto();
        BeanUtil.copyProperties((Object)sysAppGroup, (Object)sysAppGroupDto);
        Long groupId = this.workstationAppSDKService.addGroup(sysAppGroupDto);
        sysWorkstationAppDto.setAppGroupId(groupId);
        sysWorkstationAppDto.setAppType("8");
        Long appId = app.getId();
        Long creator = userDetails.getUserId();
        if (this.unifyAuthenticationEnable && HussarUtils.isNotEmpty((Object)(sysUsers = this.sysUsersService.getUser(userDetails.getUserId()))) && HussarUtils.isNotEmpty((Object)(employeeId = sysUsers.getEmployeeId())) && HussarUtils.isNotEmpty((Object)(sysIdConvert = this.sysIdConvertsNewMapper.selectByNumId(employeeId))) && HussarUtils.isNotEmpty((Object)sysIdConvert.getIamUser())) {
            creator = sysIdConvert.getIamUser();
        }
        sysWorkstationAppDto.setCreator(creator);
        sysWorkstationAppDto.setWebUrl(this.formDesignAppProperties.getWebAppUrl() + appId);
        sysWorkstationAppDto.setMobileUrl(this.formDesignAppProperties.getMobileAppUrl() + appId);
        sysWorkstationAppDto.setAppCode("");
        logger.info("\u65b0\u589e\u96f6\u4ee3\u7801\u5e94\u7528\uff1a\u5165\u53c2\u4e3a:{}", (Object)JsonUtil.toJson((Object)sysWorkstationAppDto));
        this.workstationAppSDKService.saveWorkstationApp(sysWorkstationAppDto);
    }

    private void initDevelopRole(SysApplicationDto sysApplicationDto) {
        ApiResponse result = this.rolesExternalService.addAppDevRole(sysApplicationDto.getAppName(), null);
        if (!result.isSuccess()) {
            throw new BaseException("\u521b\u5efa\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272\u5931\u8d25");
        }
        Long developRoleId = (Long)result.getData();
        sysApplicationDto.setDevelopRoleId(developRoleId);
        RoleUserDto userDto = new RoleUserDto();
        userDto.setRoleId(developRoleId);
        ArrayList userVos = Lists.newArrayListWithCapacity((int)1);
        RoleOrgUserVo u = new RoleOrgUserVo();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        u.setId(user.getId());
        userVos.add(u);
        userDto.setAdds((List)userVos);
        this.rolesExternalService.addOrDelAppDevRoleUser(userDto);
        SysAppAuthorize authorize = new SysAppAuthorize();
        authorize.setId(Long.valueOf(IdWorker.getId((Object)new SysAppAuthorize())));
        authorize.setAppId(sysApplicationDto.getId());
        authorize.setRoleId(developRoleId);
        authorize.setAuthorizationType("2");
        this.appAuthorizeMapper.insert((Object)authorize);
        this.iSysApplicationBoService.editApp(sysApplicationDto);
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
        Long developRoleId;
        List roles;
        Long appId = appRecycle.getId();
        List formVos = this.formMapper.getSysFormList(null, null, null, "2", appId);
        for (SysFormVo vo : formVos) {
            this.dashEntryService.deleteData(vo.getId());
        }
        this.formMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        this.formGroupMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appRecycle) && HussarUtils.isNotEmpty((Object)(roles = this.rolesExternalService.getRoleInfoByIds(HussarUtils.toLongList((String)String.valueOf(developRoleId = appRecycle.getDevelopRoleId())))))) {
            this.rolesExternalService.delRole(developRoleId);
        }
        this.appAuthorizeMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appId));
        this.formAuthorizeRolesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId));
        this.roleButtonMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId));
        this.roleFieldMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getAppId, (Object)appId));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }
}

