/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class ExcelCellTypeAnalysisUtil {
    private static final String NUMBER_REG = "^[-+]?(?:0\\.\\d+|[1-9]\\d*\\.\\d+|\\d+)$";
    private static final String DATE_YEAR = "\\d{4}";
    private static final DateTimeFormatter FORMATTERDATE1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter FORMATTERDATE2 = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter FORMATTERDATE3 = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter FORMATTERDATE4 = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private static final DateTimeFormatter FORMATTERDATE5 = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter FORMATTERDATE6 = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
    private static final DateTimeFormatter FORMATTERDATE7 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter FORMATTERDATE8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter FORMATTERDATE9 = DateTimeFormatter.ofPattern("yyyy-M-dd");
    private static final DateTimeFormatter FORMATTERDATE10 = DateTimeFormatter.ofPattern("yyyy/M/dd");
    private static final DateTimeFormatter FORMATTERDATE11 = DateTimeFormatter.ofPattern("yyyy-M-d");
    private static final DateTimeFormatter FORMATTERDATE12 = DateTimeFormatter.ofPattern("yyyy/M/d");
    private static final DateTimeFormatter FORMATTERDATETIME1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter FORMATTERDATETIME5 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter FORMATTERDATETIME2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTERDATETIME3 = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
    private static final DateTimeFormatter FORMATTERDATETIME4 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssZ");
    private static final SimpleDateFormat FORMATTERYEARMONTH1 = new SimpleDateFormat("yyyy-MM");
    private static final SimpleDateFormat FORMATTERYEARMONTH2 = new SimpleDateFormat("yyyy/MM");
    private static final SimpleDateFormat FORMATTERYEARMONTH3 = new SimpleDateFormat("yyyy-M");
    private static final SimpleDateFormat FORMATTERYEARMONTH4 = new SimpleDateFormat("yyyy/M");
    private static final SimpleDateFormat FORMATTERYEARMONTHTIMEMIU1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat FORMATTERYEARMONTHTIMEMIU2 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat FORMATTERYEARMONTHTIMEMIU3 = new SimpleDateFormat("yyyy-M-dd HH:mm");
    private static final SimpleDateFormat FORMATTERYEARMONTHTIMEMIU4 = new SimpleDateFormat("yyyy/M/dd HH:mm");

    public static boolean analysisNumber(String numberStr) {
        if (HussarUtils.isEmpty((Object)numberStr)) {
            return false;
        }
        return numberStr.matches(NUMBER_REG);
    }

    public static boolean analysisYearMonthTimeMiu(String dateStr) {
        try {
            FORMATTERYEARMONTHTIMEMIU1.parse(dateStr);
            return true;
        }
        catch (ParseException parseException) {
            try {
                FORMATTERYEARMONTHTIMEMIU2.parse(dateStr);
                return true;
            }
            catch (ParseException parseException2) {
                try {
                    FORMATTERYEARMONTHTIMEMIU3.parse(dateStr);
                    return true;
                }
                catch (ParseException parseException3) {
                    try {
                        FORMATTERYEARMONTHTIMEMIU4.parse(dateStr);
                        return true;
                    }
                    catch (ParseException parseException4) {
                        return false;
                    }
                }
            }
        }
    }

    public static boolean analysisYearMonth(String dateStr) {
        try {
            FORMATTERYEARMONTH1.parse(dateStr);
            return true;
        }
        catch (ParseException parseException) {
            try {
                FORMATTERYEARMONTH2.parse(dateStr);
                return true;
            }
            catch (ParseException parseException2) {
                try {
                    FORMATTERYEARMONTH3.parse(dateStr);
                    return true;
                }
                catch (ParseException parseException3) {
                    try {
                        FORMATTERYEARMONTH4.parse(dateStr);
                        return true;
                    }
                    catch (ParseException parseException4) {
                        return false;
                    }
                }
            }
        }
    }

    public static boolean analysisDate(String dateStr) {
        try {
            LocalDate.parse(dateStr, FORMATTERDATE1);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDate.parse(dateStr, FORMATTERDATE2);
                return true;
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    LocalDate.parse(dateStr, FORMATTERDATE3);
                    return true;
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    try {
                        LocalDate.parse(dateStr, FORMATTERDATE4);
                        return true;
                    }
                    catch (DateTimeParseException dateTimeParseException4) {
                        try {
                            LocalDate.parse(dateStr, FORMATTERDATE5);
                            return true;
                        }
                        catch (DateTimeParseException dateTimeParseException5) {
                            try {
                                LocalDate.parse(dateStr, FORMATTERDATE6);
                                return true;
                            }
                            catch (DateTimeParseException dateTimeParseException6) {
                                try {
                                    LocalDate.parse(dateStr, FORMATTERDATE7);
                                    return true;
                                }
                                catch (DateTimeParseException dateTimeParseException7) {
                                    try {
                                        LocalDate.parse(dateStr, FORMATTERDATE8);
                                        return true;
                                    }
                                    catch (DateTimeParseException dateTimeParseException8) {
                                        try {
                                            LocalDate.parse(dateStr, FORMATTERDATE9);
                                            return true;
                                        }
                                        catch (DateTimeParseException dateTimeParseException9) {
                                            try {
                                                LocalDate.parse(dateStr, FORMATTERDATE10);
                                                return true;
                                            }
                                            catch (DateTimeParseException dateTimeParseException10) {
                                                try {
                                                    LocalDate.parse(dateStr, FORMATTERDATE11);
                                                    return true;
                                                }
                                                catch (DateTimeParseException dateTimeParseException11) {
                                                    try {
                                                        LocalDate.parse(dateStr, FORMATTERDATE12);
                                                        return true;
                                                    }
                                                    catch (DateTimeParseException dateTimeParseException12) {
                                                        return false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static boolean analysisDateTime(String dateStr) {
        try {
            LocalDate.parse(dateStr, FORMATTERDATETIME1);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDate.parse(dateStr, FORMATTERDATETIME5);
                return true;
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    LocalDate.parse(dateStr, FORMATTERDATETIME2);
                    return true;
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    try {
                        LocalDate.parse(dateStr, FORMATTERDATETIME3);
                        return true;
                    }
                    catch (DateTimeParseException dateTimeParseException4) {
                        try {
                            LocalDate.parse(dateStr, FORMATTERDATETIME4);
                            return true;
                        }
                        catch (DateTimeParseException dateTimeParseException5) {
                            return false;
                        }
                    }
                }
            }
        }
    }

    public static boolean analysisDateYear(String dateYearStr) {
        return dateYearStr.matches(DATE_YEAR);
    }
}

