/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseTypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseTypeConverter.class);
    private static final List<String> STRING_TYPE = new ArrayList<String>(Arrays.asList("CHAR", "VARCHAR", "LONG VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "BINARY", "VARBINARY", "LONG VARBINARY", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB", "ENUM", "SET", "JSON", "BIT", "BOOL", "CHAR", "VARCHAR2", "NCHAR", "NVARCHAR2", "CLOB", "NCLOB", "BLOB", "BFILE", "ROWID", "UROWID", "RAW", "LONG", "LONG RAW", "XMLTYPE", "JSON", "OBJECT", "VARRAY", "TABLE", "SECUREFILE LOB", "BASICFILE LOB", "CHAR", "VARCHAR", "TEXT", "BYTEA", "BOOLEAN", "ENUM", "POINT", "LINE", "LSEG", "BOX", "PATH", "POLYGON", "CIRCLE", "CIDR", "INET", "MACADDR", "UUID", "XML", "JSON", "JSONB", "ARRAY", "COMPOSITE", "INT4RANGE", "INT8RANGE", "NUMRANGE", "TSRANGE", "TSTZRANGE", "DATERANGE", "TSVECTOR", "TSQUERY", "BIT", "VARBIT", "MONEY", "CHAR", "VARCHAR2", "NCHAR", "NVARCHAR2", "CLOB", "NCLOB", "BLOB", "BFILE", "ROWID", "UROWID", "RAW", "LONG", "LONG RAW", "XMLTYPE", "JSON", "OBJECT", "VARRAY", "TABLE", "SECUREFILE LOB", "BASICFILE LOB", "SDO_GEOMETRY", "SDO_TOPO_GEOMETRY", "ANYDATA", "ANYTYPE", "ANYELEMENT", "CHAR", "VARCHAR", "TEXT", "BYTEA", "BOOLEAN", "ENUM", "POINT", "LINE", "LSEG", "BOX", "PATH", "POLYGON", "CIRCLE", "CIDR", "INET", "MACADDR", "UUID", "XML", "JSON", "JSONB", "ARRAY", "COMPOSITE", "INT4RANGE", "INT8RANGE", "NUMRANGE", "TSRANGE", "TSTZRANGE", "DATERANGE", "TSVECTOR", "TSQUERY", "BIT", "VARBIT", "MONEY", "CHAR", "CHARACTER", "VARCHAR", "VARCHAR2", "TEXT", "LONGVARCHAR", "BINARY", "IMAGE", "BINARY", "VARBINARY", "LONGVARBINARY", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB", "CLOB", "BFILE", "BIT", "BOOL", "BOOLEAN", "ENUM", "SET", "JSON", "XML", "CHAR", "VARCHAR", "TEXT", "MEDIUMTEXT", "LONGTEXT", "CLOB", "BOOLEAN", "BOOL", "BINARY", "VARBINARY", "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB", "CHAR", "VARCHAR", "TEXT", "BLOB", "BYTEA", "RAW", "BOOLEAN", "ENUM", "UUID", "BIT", "BIT VARYING", "XML", "JSON", "ARRAY", "CIDR", "INET", "MONEY", "HLL", "TSVECTOR", "TSQUERY", "CHAR", "VARCHAR", "TEXT", "NCHAR", "NVARCHAR", "NTEXT", "MONEY", "SMALLMONEY", "BINARY", "VARBINARY", "IMAGE", "BIT", "UNIQUEIDENTIFIER", "XML", "JSON", "SQL_VARIANT", "TABLE", "CURSOR"));
    private static final List<String> NUMBER_TYPE = new ArrayList<String>(Arrays.asList("TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "MEDIUMINT", "MEDIUMINT UNSIGNED", "INT", "INT UNSIGNED", "INTEGER", "INTEGER UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "DECIMAL", "NUMERIC", "FLOAT", "DOUBLE", "DOUBLE PRECISION", "DOUBLE PRECISION UNSIGNED", "DOUBLE UNSIGNED", "REAL", "NUMBER", "INTEGER", "PLS_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "SMALLINT", "INTEGER", "BIGINT", "DECIMAL", "NUMERIC", "REAL", "DOUBLE PRECISION", "SMALLSERIAL", "SERIAL", "BIGSERIAL", "NUMBER", "INTEGER", "PLS_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "SMALLINT", "INTEGER", "BIGINT", "DECIMAL", "NUMERIC", "REAL", "DOUBLE PRECISION", "SMALLSERIAL", "SERIAL", "BIGSERIAL", "NUMRIC", "DECIMAL", "DEC", "NUMBER", "INTEGER", "INT", "BIGINT", "TINYINT", "BYTE", "SMALLINT", "FLOAT", "DOUBLE", "REAL", "DOUBLE PRECISION", "TINYINT", "SMALLINT", "MEDIUMINT", "INT", "INTEGER", "BIGINT", "FLOAT", "DOUBLE", "DOUBLE PRECISION", "REAL", "DECIMAL", "NUMERIC", "TINYINT", "SMALLINT", "INT1", "SMALLINT", "INT2", "INTEGER", "INT", "INT4", "BINARY_INTEGER", "BIGINT", "INT8", "NUMERIC", "DECIMAL", "REAL", "FLOAT4", "FLOAT", "DOUBLE PRECISION", "FLOAT8", "SMALLSERIAL", "SERIAL", "BIGSERIAL", "BIGINT", "INT", "SMALLINT", "TINYINT", "DECIMAL", "NUMERIC", "FLOAT", "REAL"));
    private static final List<String> DATE_TYPE = new ArrayList<String>(Arrays.asList("DATE", "TIME", "DATETIME", "TIMESTAMP", "YEAR", "DATE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "INTERVAL YEAR TO MONTH", "INTERVAL DAY TO SECOND", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITHOUT TIME ZONE", "DATE TIME TIME WITH TIME ZONE", "TIME WITHOUT TIME ZONE", "INTERVAL", "DATE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "INTERVAL YEAR TO MONTH", "INTERVAL DAY TO SECOND", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITHOUT TIME ZONE", "DATE", "TIME", "TIME WITH TIME ZONE", "TIME WITHOUT TIME ZONE", "INTERVAL", "DATE", "TIME", "TIMESTAMP", "DATETIME", "TIME WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE", "DATE", "TIME", "DATETIME", "TIMESTAMP", "YEAR", "DATE", "TIME", "TIME WITHOUT TIME ZONE", "TIMEWITH TIME ZONE", "TIMESTAMP", "TIMESTAMP WITHOUT TIME ZONE", "TIMESTAMP WITH TIME ZONE", "INTERVAL", "SMALLDATETIME", "RELTIME", "DATE", "TIME", "DATETIME", "SMALLDATETIME"));

    public static String convertDataBaseType(String realType) {
        if (STRING_TYPE.contains(realType.toUpperCase())) {
            return "string";
        }
        if (NUMBER_TYPE.contains(realType.toUpperCase())) {
            return "number";
        }
        if (DATE_TYPE.contains(realType.toUpperCase())) {
            return "date";
        }
        LOGGER.error("\u672a\u627e\u5230\u6570\u636e\u7c7b\u578b\uff1a{} \u5bf9\u5e94\u7684\u7ec4\u4ef6\u7c7b\u578b", (Object)realType.toUpperCase());
        return "string";
    }
}

