/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lang.enums;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public enum LangEnum {
    ZH_CN("zh-CN", "\u7b80\u4f53\u4e2d\u6587", "\u7b80\u4f53\u4e2d\u6587"),
    EN_US("en-US", "\u82f1\u8bed", "English"),
    DE_DE("de-DE", "\u5fb7\u8bed", "deutsch"),
    ZH_TW("zh-TW", "\u7e41\u4f53\u4e2d\u6587", "\u7e41\u9ad4\u4e2d\u6587"),
    FR("fr-FR", "\u6cd5\u8bed", "Fran\u00e7ais"),
    JA_JP("ja-JP", "\u65e5\u8bed", "\u65e5\u672c\u8a9e"),
    KO_KR("ko-KR", "\u97e9\u8bed", "\ud55c\uad6d\uc5b4"),
    IT_IT("it-IT", "\u610f\u5927\u5229\u8bed", "Italiano"),
    ES_ES("es-ES", "\u897f\u73ed\u7259\u8bed", "Espa\u00f1ol"),
    SV_SE("sv-SE", "\u745e\u5178\u8bed", "Svenska"),
    TR_TR("tr-TR", "\u571f\u8033\u5176\u8bed", "T\u00fcrk\u00e7e"),
    PT_PT("pt-PT", "\u8461\u8404\u7259\u8bed", "Portugu\u00eas"),
    NL_NL("nl-NL", "\u8377\u5170\u8bed", "Nethelands"),
    DA_DK("da-DK", "\u4e39\u9ea6\u8bed", "Dansk"),
    NB_NO("nb-NO", "\u632a\u5a01\u8bed", "Norsk"),
    EL_GR("el-GR", "\u5e0c\u814a\u8bed", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"),
    FI_FI("fi-FI", "\u82ac\u5170\u8bed", "Suomi"),
    PL_PL("pl-PL", "\u6ce2\u5170\u8bed", "Polski"),
    UK_UA("uk-UA", "\u4e4c\u514b\u5170\u8bed", "Ukrainian"),
    IN_ID("in-ID", "\u5370\u5ea6\u5c3c\u897f\u4e9a\u8bed", "Indonesia"),
    HR_HR("hr-HR", "\u514b\u7f57\u5730\u4e9a\u8bed", "Hrvatski"),
    NE_NP("ne-NP", "\u5c3c\u6cca\u5c14\u8bed", "\u0928\u0947\u092a\u093e\u0932\u0940"),
    VI_VN("vi-VN", "\u8d8a\u5357\u8bed", "Ti\u00ea\u0301ng Vi\u00ea\u0323t"),
    TH_TH("th-TH", "\u6cf0\u8bed", "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22"),
    HI_IN("hi-IN", "\u5370\u5730\u8bed", "\u0939\u093f\u0902\u0926\u0940"),
    RU_RU("ru-RU", "\u4fc4\u8bed", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439");

    private String langLabel;
    private String langValue;
    private String langName;

    private LangEnum(String langValue, String langLabel, String langName) {
        this.langLabel = langLabel;
        this.langValue = langValue;
        this.langName = langName;
    }

    public String getLangName() {
        return this.langName;
    }

    public void setLangName(String langName) {
        this.langName = langName;
    }

    public String getLangLabel() {
        return this.langLabel;
    }

    public void setLangLabel(String langLabel) {
        this.langLabel = langLabel;
    }

    public String getLangValue() {
        return this.langValue;
    }

    public void setLangValue(String langValue) {
        this.langValue = langValue;
    }

    public static String getLabelByValue(String value) {
        for (LangEnum langEnum : LangEnum.values()) {
            if (!langEnum.getLangValue().equals(value)) continue;
            return langEnum.getLangLabel();
        }
        return null;
    }

    public static String getNameByValue(String value) {
        for (LangEnum langEnum : LangEnum.values()) {
            if (!langEnum.getLangValue().equals(value)) continue;
            return langEnum.getLangName();
        }
        return null;
    }

    public static String getValueByLabel(String label) {
        for (LangEnum langEnum : LangEnum.values()) {
            if (!langEnum.getLangLabel().equals(label)) continue;
            return langEnum.getLangValue();
        }
        return null;
    }

    public static boolean checkLang(String lang) {
        String valueByLabel = LangEnum.getValueByLabel(lang);
        return HussarUtils.isNotEmpty((Object)valueByLabel);
    }

    public static boolean checkLangValue(String LangCode) {
        for (LangEnum langEnum : LangEnum.values()) {
            if (!langEnum.getLangValue().equals(LangCode)) continue;
            return true;
        }
        return false;
    }
}

