/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AttachListDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.BatchDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.BatchDownLoadStatus;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DataDealUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.configapi.service.ConfigApiService;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.data.service.BatchDownLodService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigAndGroupVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DownLoadComponent {
    @Resource
    private HussarFormDesignProperties hussarFormDesignFrameProperties;
    @Resource
    private OssService ossService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private ISysApplicationExternalService appExternalService;
    @Resource
    private BatchDownLodService batchDownLodService;
    @Resource
    private CanvasService canvasService;
    @Autowired
    private ConfigApiService configApiService;
    private static final int MAX_QUERY_COUNT = 500;
    private static final int MAX_NAME = 50;
    private static final int START_NAME = 0;
    private static final String RECORD_ID = "RECORD_ID";
    private static final String BATCH_DOWNLOAD = "batch";
    private static final String SINGLE_DOWNLOAD = "single";
    private static final Logger logger = LoggerFactory.getLogger(DownLoadComponent.class);

    public static String getFormatTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void handleAttachmentsInList(AttachListDownloadDto attachListDownloadDto, SysBatchDownloadTask task, String dataSourceKey) {
        logger.info("--\u6279\u91cf\u4e0b\u8f7d\u9644\u4ef6\u5217\u8868,\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
        long timeStart = System.currentTimeMillis();
        logger.info("--\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)task.getTaskId(), (Object)DownLoadComponent.getFormatTime(timeStart));
        try {
            FormCanvasSchema canvasSchema = this.prepareCanvasSchema(Long.valueOf(attachListDownloadDto.getFormId()));
            List<EngineResultEntity> data = this.getDataDetails(attachListDownloadDto);
            Map<String, String> configs = this.createConfigMap();
            List<Widget> allWidgets = this.createAllWidgets(canvasSchema);
            JSONArray businessDataArray = new JSONArray();
            this.processBusinessData(data, allWidgets, attachListDownloadDto, configs, businessDataArray);
            String zipFolderPath = this.createDownloadFolder(attachListDownloadDto);
            Map<String, Map<String, String>> dataFieldDirMap = this.createFieldFolders(zipFolderPath, data, attachListDownloadDto);
            HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
            this.copyFilesToFolders(businessDataArray, attachListDownloadDto, dataFieldDirMap, nameRepeat, canvasSchema.childTables());
            this.zipFile(zipFolderPath, attachListDownloadDto.getFileName(), task.getTaskId(), task);
        }
        catch (Exception e) {
            this.handleException(task, e);
        }
        finally {
            this.batchDownLodService.updateById((Object)task);
        }
    }

    private Map<String, String> createConfigMap() {
        ConfigAndGroupVo data = (ConfigAndGroupVo)this.configApiService.listGroupAndInfoByName(null).getData();
        if (HussarUtils.isNotEmpty((Object)data)) {
            List infoList = data.getInfoList();
            HashMap<String, String> configs = new HashMap<String, String>(infoList.size());
            infoList.forEach(e -> configs.put(e.getConfigKey(), e.getConfigValue()));
            return configs;
        }
        return Collections.emptyMap();
    }

    private List<Widget> createAllWidgets(FormCanvasSchema canvasSchema) {
        ArrayList<Widget> allWidgets = new ArrayList<Widget>(canvasSchema.widgets());
        allWidgets.addAll(canvasSchema.systemWidgets());
        return allWidgets;
    }

    private void processBusinessData(List<EngineResultEntity> data, List<Widget> allWidgets, AttachListDownloadDto dto, Map<String, String> configs, JSONArray businessDataArray) {
        for (EngineResultEntity entity : data) {
            businessDataArray.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)entity)));
            allWidgets.forEach(widget -> entity.put((Object)widget.getName(), DataDealUtil.dealFieldValue(entity, widget)));
            this.handleFileName(dto.getIdMap(), null, dto.getFields(), entity, configs, BATCH_DOWNLOAD);
        }
    }

    private String createDownloadFolder(AttachListDownloadDto dto) throws IOException {
        String projectBackPath = this.formDesignProperties.getBackProjectPath() + File.separator + System.currentTimeMillis() + File.separator;
        String zipFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), projectBackPath, dto.getFileName()});
        Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
        return zipFolderPath;
    }

    private Map<String, Map<String, String>> createFieldFolders(String basePath, List<EngineResultEntity> data, AttachListDownloadDto dto) throws IOException {
        HashMap<String, Map<String, String>> dataFieldDirMap = new HashMap<String, Map<String, String>>();
        for (EngineResultEntity businessData : data) {
            String recordId = String.valueOf(businessData.get((Object)RECORD_ID));
            HashMap<String, String> fieldDirMap = new HashMap<String, String>(dto.getFields().size());
            String rowFolderName = "";
            if (HussarUtils.equals((Object)dto.getDownLoadType(), (Object)"row")) {
                rowFolderName = this.createRowFolderName((Map)dto.getIdMap().get(recordId));
            }
            for (Widget field : dto.getFields()) {
                String fieldDir = FileUtil.posixPath((String[])new String[]{basePath, rowFolderName, field.getTitle()});
                if (!new File(fieldDir).exists()) {
                    Files.createDirectories(Paths.get(fieldDir, new String[0]), new FileAttribute[0]);
                }
                fieldDirMap.put(field.getTitle(), fieldDir);
            }
            dataFieldDirMap.put(recordId, fieldDirMap);
        }
        return dataFieldDirMap;
    }

    private String createRowFolderName(Map<String, Object> nameMap) {
        if (nameMap == null) {
            return "";
        }
        String folderName = String.valueOf(nameMap.get("folderName"));
        return (folderName = this.verifyName(folderName)).length() > 50 ? folderName.substring(0, 50) : folderName;
    }

    private void copyFilesToFolders(JSONArray businessDataArray, AttachListDownloadDto dto, Map<String, Map<String, String>> dataFieldDirMap, Map<String, Integer> nameRepeat, List<Widget> schemaWidgets) {
        Map idMap = dto.getIdMap();
        List fields = dto.getFields();
        for (Object data : businessDataArray) {
            Map widgetNameMap;
            JSONObject entity = (JSONObject)data;
            String recordId = String.valueOf(entity.get((Object)RECORD_ID));
            Map nameMap = (Map)idMap.get(recordId);
            if (nameMap == null || (widgetNameMap = (Map)nameMap.get("fieldName")) == null) continue;
            for (Widget field : fields) {
                this.handleFile(entity, widgetNameMap, dataFieldDirMap, recordId, nameRepeat, schemaWidgets, field);
            }
        }
    }

    private void handleException(SysBatchDownloadTask task, Exception e) {
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.FAIL.getStatus()));
        long timeEnd = System.currentTimeMillis();
        this.printMsg(task.getTaskId(), timeEnd, e);
    }

    private void printMsg(Long taskId, Long timeEnd, Exception e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        logger.error("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u7ed3\u675f\u3002\u4e0b\u8f7d\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadComponent.getFormatTime(timeEnd));
    }

    private void handleFileName(Map<String, Map<String, Object>> idMap, List<BatchDownloadDto.MyDetail> detailList, List<Widget> fields, EngineResultEntity entity, Map<String, String> configs, String downLoadType) {
        switch (downLoadType) {
            case "batch": {
                this.handleBatchDownload(idMap, fields, configs, entity);
                break;
            }
            case "single": {
                this.handleSingleDownload(detailList, fields, configs, entity);
            }
        }
    }

    private void handleBatchDownload(Map<String, Map<String, Object>> idMap, List<Widget> fields, Map<String, String> configs, EngineResultEntity entity) {
        Object recordId = entity.getOrDefault((Object)RECORD_ID, (Object)"");
        Map<String, Object> map = idMap.get(String.valueOf(recordId));
        if (HussarUtils.isEmpty(map)) {
            return;
        }
        Object fieldName = map.get("fieldName");
        if (HussarUtils.isEmpty((Object)fieldName)) {
            return;
        }
        Map fieldNameMap = (Map)fieldName;
        for (Map.Entry entry : fieldNameMap.entrySet()) {
            String fileName;
            String[] keys = this.parseKeys((String)entry.getKey());
            Optional<Widget> widgetOpt = this.findWidget(fields, keys[1], keys[0]);
            if (!widgetOpt.isPresent() || (fileName = this.generateFileName(widgetOpt.get(), configs, entity)) == null) continue;
            entry.setValue(fileName);
        }
    }

    private void handleSingleDownload(List<BatchDownloadDto.MyDetail> detailList, List<Widget> fields, Map<String, String> configs, EngineResultEntity entity) {
        if (HussarUtils.isEmpty(detailList)) {
            return;
        }
        for (BatchDownloadDto.MyDetail detail : detailList) {
            if (HussarUtils.isEmpty((Object)detail.getFields())) continue;
            for (BatchDownloadDto.MyField field : detail.getFields()) {
                String fileName;
                String[] keys;
                Optional<Widget> widgetOpt;
                Map fileIdMap = field.getFileIdMap();
                if (HussarUtils.isEmpty((Object)fileIdMap) || !(widgetOpt = this.findWidget(fields, (keys = this.parseKeys(field.getName()))[1], keys[0])).isPresent() || (fileName = this.generateFileName(widgetOpt.get(), configs, entity)) == null) continue;
                fileIdMap.replaceAll((k, v) -> fileName);
            }
        }
    }

    private String[] parseKeys(String originalKey) {
        if (originalKey.contains(".")) {
            String[] split = originalKey.split("\\.");
            return new String[]{split[0], split[1]};
        }
        return new String[]{"", originalKey};
    }

    private Optional<Widget> findWidget(List<Widget> fields, String name, String parentKey) {
        return fields.stream().filter(w -> HussarUtils.equals((Object)w.getName(), (Object)name) && HussarUtils.equals((Object)w.getParentKey(), (Object)parentKey)).findFirst();
    }

    private String generateFileName(Widget widget, Map<String, String> configs, EngineResultEntity entity) {
        JSONObject props = widget.getProps();
        Object isReName = props.get((Object)"isReName");
        if (HussarUtils.isEmpty((Object)isReName) || Boolean.FALSE.equals(isReName)) {
            return null;
        }
        Object name = props.get((Object)"fileName");
        if (HussarUtils.isEmpty((Object)name)) {
            return null;
        }
        JSONObject fileNameMap = JSON.parseObject((String)JSON.toJSONString((Object)name));
        Object name1 = fileNameMap.get((Object)"name");
        Object params = fileNameMap.get((Object)"params");
        if (HussarUtils.isEmpty((Object)name1) && HussarUtils.isEmpty((Object)params)) {
            return null;
        }
        if (HussarUtils.isNotEmpty((Object)name1) && HussarUtils.isEmpty((Object)params)) {
            return String.valueOf(name1);
        }
        String nameTemp = String.valueOf(name1);
        JSONArray paramArray = (JSONArray)params;
        for (Object param : paramArray) {
            JSONObject paramJson = (JSONObject)param;
            String type = String.valueOf(paramJson.get((Object)"type"));
            String name2 = String.valueOf(paramJson.get((Object)"name"));
            String id = String.valueOf(paramJson.get((Object)"id"));
            String replaceBefore = "${" + id + "}";
            switch (type) {
                case "formData": {
                    nameTemp = this.replaceFormData(nameTemp, replaceBefore, name2, entity);
                    break;
                }
                case "config": {
                    nameTemp = this.replaceConfig(nameTemp, replaceBefore, name2, configs);
                }
            }
        }
        return nameTemp;
    }

    private String replaceFormData(String template, String placeholder, String fieldName, EngineResultEntity entity) {
        Object value = entity.get((Object)fieldName);
        return template.replace(placeholder, HussarUtils.isNotEmpty((Object)value) ? String.valueOf(value) : "");
    }

    private String replaceConfig(String template, String placeholder, String configPath, Map<String, String> configs) {
        if (!configPath.contains(".")) {
            return template;
        }
        String configValue = configs.get(configPath);
        return template.replace(placeholder, HussarUtils.isNotEmpty((Object)configValue) ? configValue : "");
    }

    private void handleFile(JSONObject businessData, Map<String, String> widgetNameMap, Map<String, Map<String, String>> dataFieldDirMap, String recordId, Map<String, Integer> nameRepeat, List<Widget> schemaWidgets, Widget field) {
        HashMap<Long, String> fileIdMap = new HashMap<Long, String>();
        if (this.isMainTableField(field)) {
            this.handleMainTableField(businessData, widgetNameMap, field, fileIdMap);
        } else {
            this.handleChildTableField(businessData, widgetNameMap, schemaWidgets, field, fileIdMap, dataFieldDirMap, recordId, nameRepeat);
        }
        if (HussarUtils.isNotEmpty(fileIdMap)) {
            this.copyFilesToTargetDirectory(field, recordId, dataFieldDirMap, fileIdMap, nameRepeat);
        }
    }

    private boolean isMainTableField(Widget field) {
        return HussarUtils.isBlank((CharSequence)field.getParentKey());
    }

    private void handleMainTableField(JSONObject businessData, Map<String, String> widgetNameMap, Widget field, Map<Long, String> fileIdMap) {
        String fieldValue = (String)businessData.get((Object)field.getName());
        String fileName = widgetNameMap.get(field.getName());
        if (HussarUtils.isNotBlank((CharSequence)fieldValue)) {
            this.parseFileIds(fieldValue).forEach(id -> fileIdMap.put((Long)id, fileName));
        }
    }

    private void handleChildTableField(JSONObject businessData, Map<String, String> widgetNameMap, List<Widget> schemaWidgets, Widget field, Map<Long, String> fileIdMap, Map<String, Map<String, String>> dataFieldDirMap, String recordId, Map<String, Integer> nameRepeat) {
        String parentKey = field.getParentKey();
        if (this.isDirectChildTable(businessData, parentKey)) {
            this.handleDirectChildTable(businessData, widgetNameMap, field, fileIdMap);
        } else {
            this.handleGrandchildTable(businessData, widgetNameMap, schemaWidgets, field, dataFieldDirMap, recordId, nameRepeat);
        }
    }

    private boolean isDirectChildTable(JSONObject businessData, String parentKey) {
        return businessData.containsKey((Object)parentKey) && businessData.get((Object)parentKey) instanceof JSONArray;
    }

    private void handleDirectChildTable(JSONObject businessData, Map<String, String> widgetNameMap, Widget field, Map<Long, String> fileIdMap) {
        String parentKey = field.getParentKey();
        JSONArray subTableData = (JSONArray)businessData.get((Object)parentKey);
        if (HussarUtils.isEmpty((Object)subTableData)) {
            return;
        }
        String fieldNameAll = parentKey + "." + field.getName();
        String fileName = widgetNameMap.get(fieldNameAll);
        for (Object data : subTableData) {
            JSONObject entity = (JSONObject)data;
            String fieldValue = (String)entity.get((Object)field.getName());
            if (!HussarUtils.isNotBlank((CharSequence)fieldValue)) continue;
            this.parseFileIds(fieldValue).forEach(id -> fileIdMap.put((Long)id, fileName));
        }
    }

    private void handleGrandchildTable(JSONObject businessData, Map<String, String> widgetNameMap, List<Widget> schemaWidgets, Widget field, Map<String, Map<String, String>> dataFieldDirMap, String recordId, Map<String, Integer> nameRepeat) {
        String parentKey = field.getParentKey();
        Optional<Widget> grandchildTable = this.findGrandchildTable(schemaWidgets, parentKey);
        if (!grandchildTable.isPresent()) {
            return;
        }
        String childTableKey = grandchildTable.get().getName();
        JSONArray childData = (JSONArray)businessData.get((Object)childTableKey);
        if (HussarUtils.isEmpty((Object)childData)) {
            return;
        }
        for (Object data : childData) {
            JSONObject entity = (JSONObject)data;
            this.handleFile(entity, widgetNameMap, dataFieldDirMap, recordId, nameRepeat, schemaWidgets, field);
        }
    }

    private Optional<Widget> findGrandchildTable(List<Widget> schemaWidgets, String targetParentKey) {
        return schemaWidgets.stream().filter(widget -> widget.getChildren() != null).flatMap(widget -> widget.getChildren().stream().filter(child -> HussarUtils.equals((Object)targetParentKey, (Object)child.getName())).map(child -> widget)).findFirst();
    }

    private List<Long> parseFileIds(String fieldValue) {
        return Arrays.stream(fieldValue.split(",")).map(String::trim).filter(id -> !id.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
    }

    private void copyFilesToTargetDirectory(Widget field, String recordId, Map<String, Map<String, String>> dataFieldDirMap, Map<Long, String> fileIdMap, Map<String, Integer> nameRepeat) {
        Map<String, String> dirMap = dataFieldDirMap.get(recordId);
        if (dirMap == null) {
            return;
        }
        String targetDir = dirMap.get(field.getTitle());
        if (targetDir == null) {
            return;
        }
        this.copyFilesToFolder(fileIdMap, targetDir, nameRepeat);
    }

    private String verifyName(String name) {
        if (HussarUtils.isNotEmpty((Object)name)) {
            name = name.replace("\\", "");
            name = name.replace("/", "");
            name = name.replace(":", "");
            name = name.replace("*", "");
            name = name.replace("?", "");
            name = name.replace("\"", "");
            name = name.replace(">", "");
            name = name.replace("<", "");
            name = name.replace("|", "");
            name = name.replace("$", "");
            name = name.replace("#", "");
            name = name.replace("&", "");
            name = name.replace("%", "");
            name = name.replace("~", "");
            name = name.replace("{", "");
            name = name.replace("}", "");
            name = name.replace("[", "");
            name = name.replace("]", "");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void handleBatchDownload(BatchDownloadDto batchDownloadDto, SysBatchDownloadTask task, String dataSourceKey) {
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
        long timeStart = System.currentTimeMillis();
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)task.getTaskId(), (Object)DownLoadComponent.getFormatTime(timeStart));
        try {
            FormCanvasSchema canvasSchema = this.prepareCanvasSchema(batchDownloadDto.getFormId());
            EngineResultEntity entity = this.fetchFormData(batchDownloadDto);
            Map<String, String> configs = this.createConfigMap();
            List<Widget> allWidgets = this.createAllWidgets(canvasSchema);
            this.processBusinessData(allWidgets, entity, batchDownloadDto, configs);
            String zipFolderPath = this.createDownloadFolder(batchDownloadDto);
            this.handleDownloadType(batchDownloadDto, zipFolderPath);
            this.zipFile(zipFolderPath, batchDownloadDto.getFileName(), task.getTaskId(), task);
        }
        catch (Exception e) {
            this.handleException(task, e);
        }
        finally {
            this.batchDownLodService.updateById((Object)task);
        }
    }

    private FormCanvasSchema prepareCanvasSchema(Long formId) {
        return (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
    }

    private EngineResultEntity fetchFormData(BatchDownloadDto dto) throws BaseException {
        ResponseEntity response = this.hussarAppFormService.formQuery(String.valueOf(dto.getFormId()), String.valueOf(dto.getDataId()), null, String.valueOf(dto.getAppId()));
        if (HussarUtils.isEmpty((Object)response.getBody()) || HussarUtils.isEmpty((Object)((ApiResponse)response.getBody()).getData())) {
            throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (EngineResultEntity)((ApiResponse)response.getBody()).getData();
    }

    private void processBusinessData(List<Widget> widgets, EngineResultEntity entity, BatchDownloadDto dto, Map<String, String> configs) {
        widgets.forEach(widget -> entity.put((Object)widget.getName(), DataDealUtil.dealFieldValue(entity, widget)));
        this.handleFileName(null, dto.getData(), dto.getFields(), entity, configs, SINGLE_DOWNLOAD);
    }

    private String createDownloadFolder(BatchDownloadDto dto) {
        String fileName = this.getVerifiedFileName(dto.getFileName());
        String projectBackPath = this.formDesignProperties.getBackProjectPath() + File.separator + System.currentTimeMillis() + File.separator;
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), projectBackPath, fileName});
    }

    private String getVerifiedFileName(String fileName) {
        return HussarUtils.isNotEmpty((Object)fileName) ? this.verifyName(fileName) : fileName;
    }

    private void handleDownloadType(BatchDownloadDto dto, String zipFolderPath) throws IOException, HussarException {
        HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
        Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
        switch (dto.getType()) {
            case "detail": {
                this.handleDetailDownload(dto, zipFolderPath, nameRepeat);
                break;
            }
            case "field": {
                this.handleFieldDownload(dto, zipFolderPath, nameRepeat);
                break;
            }
            default: {
                throw new HussarException("\u4e0b\u8f7d\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void handleDetailDownload(BatchDownloadDto dto, String basePath, Map<String, Integer> nameRepeat) throws IOException {
        List fields = ((BatchDownloadDto.MyDetail)dto.getData().get(0)).getFields();
        for (BatchDownloadDto.MyField myField : fields) {
            String fieldFolder = FileUtil.posixPath((String[])new String[]{basePath, myField.getLabel()});
            Files.createDirectories(Paths.get(fieldFolder, new String[0]), new FileAttribute[0]);
            this.copyFilesToFolder(myField.getFileIdMap(), fieldFolder, nameRepeat);
        }
    }

    private void handleFieldDownload(BatchDownloadDto dto, String basePath, Map<String, Integer> nameRepeat) {
        Map fileIds = ((BatchDownloadDto.MyField)((BatchDownloadDto.MyDetail)dto.getData().get(0)).getFields().get(0)).getFileIdMap();
        this.copyFilesToFolder(fileIds, basePath, nameRepeat);
    }

    public void copyFilesToFolder(Map<Long, String> fileIds, String basicPath, Map<String, Integer> nameRepeat) {
        if (fileIds.isEmpty()) {
            logger.error("\u6ca1\u6709\u6587\u4ef6\u9700\u8981\u5904\u7406");
            return;
        }
        List<AttachmentManagerModel> attachments = this.getAttachmentsByIds(fileIds.keySet());
        attachments.forEach(attachment -> this.copySingleFile((AttachmentManagerModel)attachment, (String)fileIds.get(attachment.getId()), basicPath, nameRepeat));
    }

    private List<AttachmentManagerModel> getAttachmentsByIds(Set<Long> ids) {
        String[] idArray = (String[])ids.stream().map(String::valueOf).toArray(String[]::new);
        List vos = this.ossService.getByFileIds(idArray);
        return vos.stream().filter(Objects::nonNull).map(vo -> (AttachmentManagerModel)HussarUtils.copyProperties((Object)vo, AttachmentManagerModel.class)).collect(Collectors.toList());
    }

    private void copySingleFile(AttachmentManagerModel attachment, String fileName, String basicPath, Map<String, Integer> nameRepeat) {
        String originalName = attachment.getAttachmentName();
        int index = originalName.lastIndexOf(".");
        originalName = index > 0 ? originalName.substring(0, index) : originalName;
        String fileType = attachment.getAttachmentType();
        String baseName = this.getValidBaseName(HussarUtils.isNotEmpty((Object)fileName) ? fileName : originalName);
        String newFilename = this.buildSafeFilename(baseName, fileType, basicPath, nameRepeat);
        String destinationPath = this.buildDestinationPath(basicPath, newFilename);
        if (new File(destinationPath).exists()) {
            destinationPath = this.handleDuplicateFile(destinationPath, newFilename, fileType, nameRepeat);
        }
        this.copyFileById(attachment.getId(), destinationPath);
    }

    private String getValidBaseName(String name) {
        String baseName = this.verifyName(name);
        if (baseName.length() > 50) {
            baseName = baseName.substring(0, 50);
        }
        return baseName;
    }

    private String buildSafeFilename(String baseName, String fileType, String path, Map<String, Integer> nameRepeat) {
        String newFilename = baseName + "." + fileType;
        if (nameRepeat.containsKey(newFilename)) {
            int count = nameRepeat.get(newFilename) + 1;
            nameRepeat.put(newFilename, count);
            return baseName + "(" + count + ")." + fileType;
        }
        nameRepeat.put(newFilename, 0);
        return newFilename;
    }

    private String buildDestinationPath(String basePath, String filename) {
        return FileUtil.posixPath((String[])new String[]{basePath, filename});
    }

    private String handleDuplicateFile(String basePath, String baseFilename, String fileType, Map<String, Integer> nameRepeat) {
        String fileName = baseFilename.substring(0, baseFilename.lastIndexOf("."));
        int conflictCount = nameRepeat.getOrDefault(fileName + "." + fileType, 0);
        nameRepeat.put(fileName + "." + fileType, ++conflictCount);
        String conflictFileName = fileName + "(" + conflictCount + ")." + fileType;
        return this.buildDestinationPath(basePath, conflictFileName);
    }

    public Long zipFile(String zipFolderPath, String zipFolderName, Long taskId, SysBatchDownloadTask task) throws Exception {
        File parentDir = new File(zipFolderPath).getParentFile();
        String zipPath = parentDir.getAbsolutePath() + File.separator + UUID.randomUUID() + ".zip";
        ZipUtil.zip((String)zipFolderPath, (String)zipPath);
        MockMultipartFile multipartFile = new MockMultipartFile(zipFolderName + ".zip", zipFolderName + ".zip", ".zip", Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
        ApiResponse longApiResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        Long data = (Long)longApiResponse.getData();
        long timeEnd = System.currentTimeMillis();
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u7ed3\u675f\u3002\u4e0b\u8f7d\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadComponent.getFormatTime(timeEnd));
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.SUCCESS.getStatus()));
        task.setFileId(data);
        return data;
    }

    private void copyFileById(Long sourceFileId, String destinationPath) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.ossService.backgroundDownload(sourceFileId, (OutputStream)byteArrayOutputStream);
        byte[] data = byteArrayOutputStream.toByteArray();
        try {
            FileUtils.writeByteArrayToFile((File)new File(destinationPath), (byte[])data);
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u5f02\u5e38", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    private List<EngineResultEntity> getDataDetails(AttachListDownloadDto attachListDownloadDto) {
        List<Object> data = new ArrayList<EngineResultEntity>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List filters = attachListDownloadDto.getFilter();
        ArrayList dataIds = new ArrayList(attachListDownloadDto.getIdMap().keySet());
        if (HussarUtils.isNotEmpty(dataIds)) {
            Filter idsFilter = new Filter();
            idsFilter.setField(RECORD_ID);
            idsFilter.setMatch("AND");
            idsFilter.setRule("_in");
            idsFilter.setVal(String.join((CharSequence)",", dataIds));
            filters.add(idsFilter);
        }
        queryParams.put("superQueryConditionDto", filters);
        SysForm form = this.appExternalService.getFormDetailById(Long.valueOf(Long.parseLong(attachListDownloadDto.getFormId())));
        AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
        int i = 1;
        while (true) {
            queryParams.put("current", i);
            queryParams.put("size", 500);
            ResponseEntity tableQueryRes = this.hussarAppFormService.tableQuery(attachListDownloadDto.getFormId(), attachListDownloadDto.getViewId(), queryParams, attachListDownloadDto.getAppId());
            if (((ApiResponse)Objects.requireNonNull(tableQueryRes.getBody())).isSuccess()) {
                PageVo pageVo = (PageVo)((ApiResponse)tableQueryRes.getBody()).getData();
                List maxPageData = pageVo.getData();
                data.addAll(maxPageData);
                if (maxPageData.size() < 500) {
                    break;
                }
            } else {
                logger.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                break;
            }
            ++i;
        }
        if ("1".equals(form.getFormType())) {
            data = data.stream().filter(engineResultEntity -> HussarUtils.isNotEmpty((Object)engineResultEntity.get((Object)"PROCESS_KEY"))).collect(Collectors.toList());
        }
        return data;
    }

    public String copyOssFile(Long ossFileId) {
        boolean flag;
        String copyFilePath = this.hussarFormDesignFrameProperties.getWorkspace() + File.separator + UUID.randomUUID();
        File file = new File(copyFilePath);
        if (!file.exists() && !(flag = file.mkdirs())) {
            throw new BaseException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25");
        }
        try {
            AttachmentManagerModel model = this.ossService.getModelById(ossFileId);
            String attachmentName = model.getAttachmentName();
            copyFilePath = copyFilePath + File.separator + attachmentName;
            ApiResponse download = this.ossService.backgroundDownload(ossFileId);
            byte[] data = (byte[])download.getData();
            MockMultipartFile multipartFile = new MockMultipartFile(attachmentName, data);
            File upload = new File(copyFilePath);
            multipartFile.transferTo(upload);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
        return copyFilePath;
    }
}

