/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppAuthService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class HussarAppAuthServiceImpl
implements IHussarAppAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarAppAuthServiceImpl.class);
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private IHussarAppFormService appFormService;

    public ResponseEntity<ApiResponse<Object>> tableQueryAuth(String formId, Map<String, Object> params, String appId) {
        AppContextUtil.setAppId((String)appId);
        params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filter = new Filter();
        filter.setField("jxdDataOperateType");
        filter.setRule("_eq");
        filter.setVal("0");
        filter.setMatch("AND");
        filters.add(filter);
        if (HussarUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
            params.put("superQueryConditionDto", filters);
        } else {
            Object object = params.get("superQueryConditionDto");
            if (object != null) {
                List list = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), Filter.class);
                filters.addAll(list);
            }
            params.put("superQueryConditionDto", filters);
        }
        FormDesignResponse getViewSchemaResponse = this.viewSchemaService.get(formId);
        FormViewSchema formViewSchema = Optional.ofNullable(getViewSchemaResponse).map(FormDesignResponse::getData).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        List views = Optional.ofNullable(formViewSchema.getViews()).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        String viewId = views.stream().filter(dataView -> "0".equals(dataView.getTabType()) || HussarUtils.isEmpty((Object)dataView.getTabType())).findFirst().map(DataView::getId).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        return this.appFormService.tableQuery(formId, viewId, params, appId);
    }

    public ResponseEntity<ApiResponse<Object>> formQueryAuth(String formId, String id, String appId) {
        return this.appFormService.formQueryPublic(formId, id, "0", appId);
    }
}

