/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormOutLinkService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.impl.HussarAppFormServiceImpl;
import com.jxdinfo.hussar.formdesign.app.frame.server.strategy.verifyFingerprintRedis.Context;
import com.jxdinfo.hussar.formdesign.app.frame.server.strategy.verifyFingerprintRedis.QueryVerifyStrategy;
import com.jxdinfo.hussar.formdesign.app.frame.server.strategy.verifyFingerprintRedis.SingleVerifyStrategy;
import com.jxdinfo.hussar.formdesign.app.frame.server.strategy.verifyFingerprintRedis.WriteVerifyStrategy;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.FormOutLinkUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FormOutLinkServiceImpl
implements FormOutLinkService {
    @Resource
    private RedisTemplate<Object, Object> redisTemplate;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ViewSchemaService viewSchemaService;

    public ApiResponse<Integer> getFormState(String appId, String formId) {
        SysApplicationVo app = this.applicationService.getAppDetailById(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)app) || HussarUtils.equals((Object)"0", (Object)app.getReleaseStatus())) {
            return ApiResponse.success((Object)HussarAppFormServiceImpl.STATE_APP_DOWN, (String)"\u5e94\u7528\u88ab\u5220\u9664\u6216\u5df2\u4e0b\u67b6");
        }
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.success((Object)HussarAppFormServiceImpl.STATE_FORM_NONEXISTENCE, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return ApiResponse.success((Object)HussarAppFormServiceImpl.STATE_PERMISSION, (String)"\u6709\u8868\u5355\u6743\u9650");
    }

    public ResponseEntity<ApiResponse<Object>> verifyFingerprintCountAndSave(String appId, String formId, String dataId, Map<String, Object> params, HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)dataId) ? new Context(new WriteVerifyStrategy(), request, this.redisTemplate, formId, dataId).executeStrategy() : new Context(new SingleVerifyStrategy(), request, this.redisTemplate, formId, dataId).executeStrategy()) {
            return ResponseEntity.ok((Object)ApiResponse.success((Object)false, (String)"\u8d85\u8fc75\u5206\u949f\u5185\u6700\u5927\u63d0\u4ea4\u6b21\u6570"));
        }
        FormOutLinkUtil.setExternalUserDetails();
        FormOutLinkUtil.setRuleSecurityUser();
        return this.appFormService.formSaveWithDataAuthAndRule(formId, params, appId, null);
    }

    public ResponseEntity<ApiResponse<Object>> verifyFingerprintCountAndSaveFlow(String formId, String dataId, Map<String, Object> params, HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)dataId) ? new Context(new WriteVerifyStrategy(), request, this.redisTemplate, formId, dataId).executeStrategy() : new Context(new SingleVerifyStrategy(), request, this.redisTemplate, formId, dataId).executeStrategy()) {
            return ResponseEntity.ok((Object)ApiResponse.success((Object)false, (String)"\u8d85\u8fc75\u5206\u949f\u5185\u6700\u5927\u63d0\u4ea4\u6b21\u6570"));
        }
        params.put("isExternal", true);
        FormOutLinkUtil.setExternalUserDetails();
        FormOutLinkUtil.setRuleSecurityUser();
        return this.appFormService.flowFormSubmitWithDataAuthAndRule(formId, params, null);
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String appId, String formId, Map<String, Object> params, HttpServletRequest request) {
        if (new Context(new QueryVerifyStrategy(), request, this.redisTemplate, formId, null).executeStrategy()) {
            return ResponseEntity.ok((Object)ApiResponse.success((Object)false, (String)"\u8d85\u8fc71\u5206\u949f\u5185\u6700\u5927\u67e5\u8be2\u6b21\u6570"));
        }
        AppContextUtil.setAppId((String)appId);
        FormDesignResponse getViewSchemaResponse = this.viewSchemaService.get(formId);
        FormViewSchema formViewSchema = Optional.ofNullable(getViewSchemaResponse).map(FormDesignResponse::getData).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        List views = Optional.ofNullable(formViewSchema.getViews()).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        String viewId = views.stream().filter(dataView -> "0".equals(dataView.getTabType()) || HussarUtils.isEmpty((Object)dataView.getTabType())).findFirst().map(DataView::getId).orElseThrow(() -> new HussarException("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u8d44\u6e90\u5931\u8d25"));
        return this.appFormService.tableQuery(formId, viewId, params, appId);
    }

    public ApiResponse<Boolean> checkToken(String token) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser((String)token);
            if (HussarUtils.isNotEmpty((Object)user.getUserId())) {
                return ApiResponse.success((Object)true);
            }
        }
        catch (Exception e) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)false);
    }
}

