/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.authorization.permit.model.SysUserAttachment;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentBoService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AddAssigneeDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.CreateAssistTaskDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.DataExportDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.FlowRejectBatchDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.FlowSubmitBatchDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderByIdsDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.SearchDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DataType;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysNoCodeConditionInfo;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysNoCodeCustomTable;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FlowBatchDealService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHandwrittenSignatureService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppConditionInfoService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppCustomFieldService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.DataVerifyResultVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldControlVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldOperateControlVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FlowBatchStatusVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormConvertCheckVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormFieldsVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryDataCountVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelExport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportDataVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResultVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormVerifyVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.StaffScopeDto;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomViewDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.view.ViewHideDTO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.AddCustomNodeDto;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/hussarApp/formInfo"})
public class HussarAppFormController {
    private static final Logger logger = LoggerFactory.getLogger(HussarAppFormController.class);
    private static final String IMPORT_ERR = "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u4ee5\u53ca\u6570\u636e\u662f\u5426\u5408\u89c4";
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private IHussarAppCustomFieldService hussarAppCustomFieldService;
    @Resource
    private IHussarAppConditionInfoService hussarAppConditionInfoService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private IHandwrittenSignatureService handwrittenSignatureService;
    @Resource
    private FlowBatchDealService flowBatchDealService;
    @Resource
    private IHussarBaseUserAttachmentBoService hussarBaseUserAttachmentService;
    @Resource
    private ISysFormExtApiService sysTransRequestService;
    @Resource
    private OssService ossService;
    @Resource
    private ExcelExport excelExport;

    @ApiOperation(value="\u8868\u683c\u89c6\u56fe\u67e5\u8be2", notes="\u8868\u683c\u89c6\u56fe\u67e5\u8be2")
    @PostMapping(value={"/tableQuery"})
    public ResponseEntity<ApiResponse<Object>> tableQuery(@RequestParam String formId, @RequestParam String viewId, @RequestBody Map<String, Object> params, @RequestParam(required=false) String appId) {
        return this.appFormService.tableQuery(formId, viewId, params, appId);
    }

    @ApiOperation(value="\u9009\u62e9\u7ec4\u4ef6\u6570\u636e\u67e5\u8be2", notes="\u9009\u62e9\u7ec4\u4ef6\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"/formDataBySelect"})
    public ApiResponse<Object> formDataBySelect(@RequestBody QueryChartDataDto selectQueryDto) {
        return this.appFormService.formDataBySelect(selectQueryDto);
    }

    @ApiOperation(value="\u8868\u683c\u96c6\u5408\u67e5\u8be2", notes="\u8868\u683c\u96c6\u5408\u67e5\u8be2")
    @PostMapping(value={"/tableQueryByCondition"})
    public ResponseEntity<ApiResponse<Object>> tableQueryByCondition(@RequestParam String formId, @RequestParam String viewId, @RequestBody Map<String, Object> params, @RequestParam(required=false) String appId) {
        return this.appFormService.tableQueryByConditionWithAuth(formId, viewId, params, appId);
    }

    @ApiOperation(value="\u6839\u636e\u753b\u5e03\u914d\u7f6e\u6c42\u548c\u3001\u5e73\u5747", notes="\u6839\u636e\u753b\u5e03\u914d\u7f6e\u6c42\u548c\u3001\u5e73\u5747")
    @PostMapping(value={"/tableDataHandle"})
    public ApiResponse<Object> tableDataHandle(@RequestParam String formId, @RequestParam String viewId, @RequestBody Map<String, Object> params, @RequestParam(required=false) String appId) throws JsonProcessingException {
        return this.appFormService.tableDataSumAvg(formId, viewId, params, appId);
    }

    @ApiOperation(value="\u8868\u5355\u67e5\u8be2", notes="\u8868\u5355\u67e5\u8be2")
    @GetMapping(value={"/formQuery"})
    public ResponseEntity<ApiResponse<Object>> formQuery(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType, @RequestParam(required=false) String appId) {
        return this.appFormService.formQuery(formId, id, tabType, appId);
    }

    @ApiOperation(value="\u8868\u5355\u6570\u636e\u67e5\u8be2\u6743\u9650\u6821\u9a8c", notes="\u5355\u6570\u636e\u67e5\u8be2\u6743\u9650\u6821\u9a8c")
    @GetMapping(value={"/dataVerify"})
    public ResponseEntity<ApiResponse<DataVerifyResultVo>> dataVerify(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType, @RequestParam(required=false) String appId) {
        return this.appFormService.dataVerify(formId, id, tabType, appId);
    }

    @ApiOperation(value="\u8868\u5355\u8be6\u60c5\u6821\u9a8c", notes="\u8868\u5355\u8be6\u60c5\u6821\u9a8c")
    @GetMapping(value={"/formVerify"})
    public ApiResponse<FormVerifyVO> formVerify(@RequestParam String appId, @RequestParam String formId, @RequestParam String id) {
        return this.appFormService.formVerify(appId, formId, id);
    }

    @ApiOperation(value="\u8868\u683c\u6570\u636e\u6279\u91cf\u5220\u9664", notes="\u8868\u683c\u6570\u636e\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> deleteBatch(@RequestParam String formId, @RequestParam String ids, @RequestParam(required=false) String appId, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.deleteBatchWithRule(formId, ids, appId, convertVersion, new ArrayList());
    }

    @ApiOperation(value="\u8868\u5355\u6570\u636e\u4fdd\u5b58", notes="\u8868\u5355\u6570\u636e\u4fdd\u5b58")
    @PostMapping(value={"/formSave"})
    @OpControllerAnno
    @OperateLogTypeCache
    public ResponseEntity<ApiResponse<Object>> formSave(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) String appId, HttpServletRequest request, @RequestParam(required=false) Long buttonId, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.formSaveWithDataAuthAndRule(formId, params, appId, convertVersion);
    }

    @ApiOperation(value="\u8868\u5355\u6570\u636e\u589e\u91cf\u4fdd\u5b58", notes="\u8868\u5355\u6570\u636e\u589e\u9879\u4fdd\u5b58")
    @PostMapping(value={"/formIncrementSave"})
    public ResponseEntity<ApiResponse<Object>> formIncrementSave(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) String appId, HttpServletRequest request) {
        return this.appFormService.formIncrementSaveWithDataAuthAndRule(formId, params, appId);
    }

    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b", notes="\u63d0\u4ea4\u6d41\u7a0b")
    @PostMapping(value={"/flowFormSubmit"})
    @OpControllerAnno
    @OperateLogTypeCache
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(@RequestParam String formId, @RequestBody Map<String, Object> params, HttpServletRequest request, @RequestParam(required=false) Long buttonId, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.flowFormSubmitWithDataAuthAndRule(formId, params, convertVersion);
    }

    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b", notes="\u63d0\u4ea4\u6d41\u7a0b")
    @PostMapping(value={"/flowSubmitBatch"})
    @OpControllerAnno
    @OperateLogTypeCache
    public ResponseEntity<ApiResponse<Object>> flowSubmitBatch(@RequestBody FlowSubmitBatchDto flowSubmitBatchDto) {
        String comment = flowSubmitBatchDto.getComment();
        Map formData = flowSubmitBatchDto.getFormData();
        Map extendFields = flowSubmitBatchDto.getExtendFields();
        String ids = flowSubmitBatchDto.getIds();
        String formId = flowSubmitBatchDto.getFormId();
        String taskIds = flowSubmitBatchDto.getTaskIds();
        String cacheName = "FLOW_SUBMIT_BATCH";
        String cachekey = "FLOW_SUBMIT_BATCH_" + formId + EngineUtil.getId();
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.flowBatchDealService.flowSubmitBatchWithDataAuthAndRule(formId, taskIds, ids, comment, extendFields, formData, cacheName, cachekey, dataSourceKey));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processName", cacheName);
        map.put("processKey", cachekey);
        return ResponseEntity.ok((Object)ApiResponse.success(map));
    }

    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b", notes="\u64a4\u56de\u6d41\u7a0b")
    @PostMapping(value={"/flowFormRecall"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> flowFormRecall(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.flowFormRecall(formId, params, convertVersion);
    }

    @ApiOperation(value="\u9a73\u56de\u81f3\u521d\u59cb\u70b9", notes="\u9a73\u56de\u81f3\u521d\u59cb\u70b9")
    @PostMapping(value={"/initialNodeReject"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> initialNodeReject(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.initialNodeRejectWithDataAuth(formId, params, convertVersion);
    }

    @ApiOperation(value="\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", notes="\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9")
    @PostMapping(value={"/prevNodeReject"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> prevNodeReject(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.prevNodeRejectWithDataAuth(formId, params, convertVersion);
    }

    @PostMapping(value={"/anyNodeReject"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> anyNodeReject(@RequestParam String formId, @RequestParam String type, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.anyNodeRejectMode(formId, type, params, convertVersion);
    }

    @PostMapping(value={"/flowRejectBatch"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> flowRejectBatch(@RequestBody FlowRejectBatchDto flowRejectBatchDto) throws IOException {
        String formId = flowRejectBatchDto.getFormId();
        String cacheName = "FLOW_REJECT_BATCH";
        String cachekey = "FLOW_REJECT_BATCH_" + formId + EngineUtil.getId();
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.flowBatchDealService.flowRejectBatch(flowRejectBatchDto, cacheName, cachekey, dataSourceKey));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processName", cacheName);
        map.put("processKey", cachekey);
        return ResponseEntity.ok((Object)ApiResponse.success(map));
    }

    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", notes="\u4efb\u52a1\u8f6c\u529e")
    @PostMapping(value={"/taskEntrust"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> taskEntrust(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.taskEntrustWithDataAuth(formId, params, convertVersion);
    }

    @ApiOperation(value="\u6d41\u7a0b\u7ec8\u6b62", notes="\u6d41\u7a0b\u7ec8\u6b62")
    @PostMapping(value={"/endProcess"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> endProcess(@RequestParam String formId, @RequestBody Map<String, Object> params, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.endProcessWithDataAuthAndRule(formId, params, convertVersion);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u8bbe\u8ba1\u5668\u753b\u5e03", notes="\u83b7\u53d6\u8868\u5355\u8bbe\u8ba1\u5668\u753b\u5e03")
    @GetMapping(value={"/getCanvas"})
    public ApiResponse<FormFieldsVo> getCanvas(@RequestParam String formId, @RequestParam(required=false) String appId) {
        return ApiResponse.success((Object)this.appFormService.getCanvas(formId, appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u89c6\u56fe", notes="\u83b7\u53d6\u8868\u5355\u89c6\u56fe")
    @GetMapping(value={"/getView"})
    public ApiResponse<FormViewVo> getView(@RequestParam String formId, @RequestParam(required=false) String appId) throws Exception {
        return ApiResponse.success((Object)this.appFormService.getViewByUser(formId, appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u6570\u636e\u6761\u6570", notes="\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u6570\u636e\u6761\u6570")
    @PostMapping(value={"/getDataCount"})
    public ApiResponse<List<QueryDataCountVo>> getDataCount(@RequestParam String formId, @RequestParam String appId) {
        return this.appFormService.getDataCount(formId, appId);
    }

    @PostMapping(value={"/save_personal_view"})
    public ApiResponse<Boolean> savePersonalView(@RequestBody CustomViewDTO customViewDTO) {
        return ApiResponse.success((Object)this.appFormService.savePersonalView(customViewDTO));
    }

    @PostMapping(value={"/edit_view"})
    public ApiResponse<Boolean> saveViewEdit(@RequestBody CustomViewDTO customViewDTO) {
        return ApiResponse.success((Object)this.appFormService.saveViewEdit(customViewDTO));
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u6bb5\u6743\u9650", notes="\u83b7\u53d6\u5b57\u6bb5\u6743\u9650")
    @GetMapping(value={"/getFieldControl"})
    public ApiResponse<FieldControlVo> getFieldControl(@RequestParam String formId, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmFormType, @RequestParam(required=false) String processKey, @RequestParam(required=false) String appId) throws IOException {
        return ApiResponse.success((Object)this.appFormService.getFieldControl(formId, taskId, bpmFormType, processKey, appId));
    }

    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279\u83b7\u53d6\u5b57\u6bb5\u6743\u9650", notes="\u6279\u91cf\u5ba1\u6279\u83b7\u53d6\u5b57\u6bb5\u6743\u9650")
    @GetMapping(value={"/getFieldControlForSubmitBatch"})
    public ApiResponse<FieldControlVo> getFieldControlForSubmitBatch(@RequestParam String formId, @RequestParam(required=false) String bpmFormType, @RequestParam(required=false) String processKey, @RequestParam(required=false) String appId, @RequestParam String taskDefinitionKey) throws IOException {
        return ApiResponse.success((Object)this.appFormService.getFieldControlForSubmitBatch(formId, bpmFormType, processKey, appId, taskDefinitionKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u6279\u91cf\u5ba1\u6279\u8fdb\u5ea6", notes="\u83b7\u53d6\u6279\u91cf\u5ba1\u6279\u8fdb\u5ea6")
    @GetMapping(value={"/getFlowBatchProcess"})
    public ApiResponse<FlowBatchStatusVo> getFlowBatchProcess(@RequestParam(value="processName") String processName, @RequestParam(value="processKey") String processKey) {
        return ApiResponse.success((Object)this.appFormService.getFlowBatchCache(processName, processKey));
    }

    @PostMapping(value={"/copy_view"})
    public ApiResponse<Long> copyView(@RequestBody DataView dataView) {
        Long viewId = this.appFormService.copyView(dataView);
        return ApiResponse.success((Object)viewId);
    }

    @PostMapping(value={"/order_view"})
    public ApiResponse<Boolean> orderView(@RequestParam String formId, @RequestBody List<ViewHideDTO> viewHide) {
        Boolean flag = this.appFormService.orderView(formId, viewHide);
        return ApiResponse.success((Object)flag);
    }

    @PostMapping(value={"/save_update_view"})
    public ApiResponse<Boolean> saveOrUpdateView(@RequestBody DataView dataView) {
        Boolean flag = this.appFormService.saveOrUpdateView(dataView);
        return ApiResponse.success((Object)flag);
    }

    @PostMapping(value={"/delete_view"})
    public ApiResponse<Boolean> deleteView(@RequestParam String viewId) {
        Boolean flag = this.appFormService.deleteView(viewId);
        return ApiResponse.success((Object)flag);
    }

    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u6743\u9650", notes="\u83b7\u53d6\u64cd\u4f5c\u6743\u9650")
    @GetMapping(value={"/getOperateControl"})
    public ApiResponse<FieldOperateControlVo> getOperateControl(@RequestParam String formId, @RequestParam(required=false) boolean addPageButton, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmformType, @RequestParam(required=false) String processKey) {
        return ApiResponse.success((Object)this.appFormService.getOperateControl(formId, taskId, bpmformType, processKey, addPageButton));
    }

    @ApiOperation(value="\u83b7\u53d6\u6458\u8981", notes="\u83b7\u53d6\u6458\u8981")
    @GetMapping(value={"/getSummary"})
    public ApiResponse<List<String>> getSummary(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getSummary(formId));
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6807\u9898", notes="\u83b7\u53d6\u6570\u636e\u6807\u9898")
    @GetMapping(value={"/getTitle"})
    public ApiResponse<TitleSchema> getTitle(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getTitle(formId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u914d\u7f6e", notes="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u914d\u7f6e")
    @GetMapping(value={"/getSubmit"})
    public ApiResponse<SubmitSchema> getSubmit(@RequestParam String formId, @RequestParam(required=false) String appId) {
        return ApiResponse.success((Object)this.appFormService.getSubmit(formId, appId));
    }

    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u6279\u91cf\u5220\u9664", notes="\u6d41\u7a0b\u8868\u5355\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/flowDeleteBatch"})
    public ResponseEntity<ApiResponse<Object>> flowDeleteBatch(@RequestParam String formId, @RequestParam String ids, @RequestParam(required=false) String appId, @RequestParam(required=false) Integer convertVersion) {
        return this.appFormService.flowDeleteBatch(formId, ids, appId, convertVersion);
    }

    @GetMapping(value={"/queryCustomFieldInfo"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5e93\u8868\u914d\u7f6e", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5e93\u8868\u914d\u7f6e\u63a5\u53e3")
    public ApiResponse<SysNoCodeCustomTable> queryCustomFieldInfo(@RequestParam String viewId, @RequestParam Long formId) {
        return ApiResponse.success((Object)this.hussarAppCustomFieldService.queryCustomFieldInfo(viewId, formId));
    }

    @PostMapping(value={"/insertOrUpdateCustomFieldInfo"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6570\u636e\u914d\u7f6e", notes="\u65b0\u589e\u6216\u4fee\u6539\u6570\u636e\u914d\u7f6e")
    public ApiResponse<String> addCustomFieldInfo(@RequestBody SysNoCodeCustomTable sysNoCodeCustomTable) {
        return ApiResponse.success((String)this.hussarAppCustomFieldService.insertOrUpdate(sysNoCodeCustomTable));
    }

    @GetMapping(value={"/getQueryInfo"})
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6", notes="\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6")
    public ApiResponse<List<SysNoCodeConditionInfo>> getQueryInfo(@RequestParam String viewId, @RequestParam Long formId) {
        return ApiResponse.success((Object)this.hussarAppConditionInfoService.getQueryInfo(viewId, formId));
    }

    @PostMapping(value={"/insertConditionInfo"})
    @ApiOperation(value="\u65b0\u589e\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u65b0\u589e\u6216\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> insertConditionInfo(@RequestBody SysNoCodeConditionInfo sysNoCodeConditionInfo) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.insertOrUpdate(sysNoCodeConditionInfo));
    }

    @PostMapping(value={"/updateConditionInfo"})
    @ApiOperation(value="\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> updateConditionInfo(@RequestBody SysNoCodeConditionInfo sysNoCodeConditionInfo) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.insertOrUpdate(sysNoCodeConditionInfo));
    }

    @PostMapping(value={"/delConditionInfo"})
    @ApiOperation(value="\u5220\u9664\u67e5\u8be2\u6761\u4ef6\u6a21\u677f", notes="\u5220\u9664\u67e5\u8be2\u6761\u4ef6\u6a21\u677f")
    public ApiResponse<String> delConditionInfo(@RequestBody Long id) {
        return ApiResponse.success((String)this.hussarAppConditionInfoService.del(id));
    }

    @PostMapping(value={"/defaultCondition"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u6761\u4ef6", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u6761\u4ef6")
    public ApiResponse<String> setDefaultCondition(@RequestBody Long id) {
        return this.hussarAppConditionInfoService.setDefaultCondition(id);
    }

    @PostMapping(value={"/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u9ed8\u8ba4\u6761\u4ef6", notes="\u53d6\u6d88\u9ed8\u8ba4\u6761\u4ef6")
    public ApiResponse<String> cancelDefaultCondition(@RequestBody Long id) {
        return this.hussarAppConditionInfoService.cancelDefaultCondition(id);
    }

    @PostMapping(value={"/queryBusinessData"})
    @ApiOperation(value="\u8868\u683c\u67e5\u8be2", notes="\u8868\u683c\u67e5\u8be2")
    public ApiResponse<QueryBusinessDataVo> queryBusinessData(@RequestParam String formId, @RequestParam String appId, @RequestBody Map<String, Object> params) {
        return this.appFormService.queryBusinessData(formId, appId, params);
    }

    @PostMapping(value={"/saveStaffScope"})
    public ApiResponse<Boolean> saveStaffScope(@RequestBody StaffScopeDto staffScopeDto) throws Exception {
        return this.appFormService.saveStaff(staffScopeDto);
    }

    @GetMapping(value={"/getStaffScope"})
    public ApiResponse<StaffScope> getStaffScope(@RequestParam String formId, @RequestParam String widgetName, @RequestParam(required=false) String appId) throws Exception {
        return this.appFormService.getStaffScope(formId, widgetName, appId);
    }

    @PostMapping(value={"/queryReferTable"})
    @ApiOperation(value="\u8868\u683c\u67e5\u8be2\u5173\u8054\u8868\u5355\u6570\u636e", notes="\u8868\u683c\u67e5\u8be2\u5173\u8054\u8868\u5355\u6570\u636e")
    public ResponseEntity<ApiResponse<Object>> queryReferTable(@RequestParam String formId, @RequestParam String appId, @RequestBody Map<String, Object> params) throws JsonProcessingException {
        return this.appFormService.queryReferTable(formId, appId, params);
    }

    @GetMapping(value={"/getShowForms"})
    @ApiOperation(value="\u67e5\u8be2\u5c55\u793a\u8868\u5355", notes="\u67e5\u8be2\u5c55\u793a\u8868\u5355")
    public ApiResponse<List<FormDetailVO>> getShowForms(@RequestParam String formId, @RequestParam(required=false) String appId) throws Exception {
        return this.appFormService.getShowForms(formId, appId);
    }

    @GetMapping(value={"/getHideRule"})
    @ApiOperation(value="\u67e5\u8be2\u663e\u9690\u89c4\u5219", notes="\u67e5\u8be2\u663e\u9690\u89c4\u5219")
    public ApiResponse<HideRuleSchema> getHideRule(@RequestParam String formId) throws Exception {
        return ApiResponse.success((Object)this.appFormService.getHideRule(formId));
    }

    @GetMapping(value={"/getFormState"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u72b6\u6001", notes="\u67e5\u8be2\u8868\u5355\u72b6\u6001")
    public ApiResponse<Integer> getFormState(@RequestParam String appId, @RequestParam String formId) {
        return this.appFormService.getFormState(appId, formId);
    }

    @PostMapping(value={"/queryData"})
    public ApiResponse<QueryBusinessDataVo> queryData(@RequestBody QueryDataDTO queryDataDTO) throws IOException, LcdpException {
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.FORM.getType())) {
            return this.hussarAppDataSourceService.queryAppBusinessData(queryDataDTO.getFormId(), queryDataDTO.getAppId(), queryDataDTO.getParams());
        }
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.DATASET.getType())) {
            return this.hussarAppDataSourceService.querySetBusinessData(queryDataDTO.getFormId(), queryDataDTO.getParams());
        }
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.EXTERNALAPI.getType())) {
            return this.hussarAppDataSourceService.queryApiBusinessData(queryDataDTO.getFormId(), queryDataDTO.getAppCode(), queryDataDTO.getApiCode(), queryDataDTO.getUri(), queryDataDTO.getParams());
        }
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.DATAPACKET.getType())) {
            return this.hussarAppDataSourceService.queryPacketData(queryDataDTO.getAppId(), queryDataDTO.getPacketCode(), queryDataDTO.getUri(), queryDataDTO.getParams());
        }
        return ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
    }

    @PostMapping(value={"/queryDataOnCascader"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> queryDataOnCascader(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody QueryDataOnCascaderDTO queryDataDto) {
        if (HussarUtils.equals((Object)queryDataDto.getType(), (Object)DataType.FORM.getType())) {
            return this.hussarAppDataSourceService.queryAppBusinessDataOnCascader(queryDataDto);
        }
        return ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
    }

    @PostMapping(value={"/searchDataOnCascader"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> searchDataOnCascader(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody SearchDataOnCascaderDTO searchDataDTO) {
        return this.hussarAppDataSourceService.searchDataOnCascader(searchDataDTO);
    }

    @PostMapping(value={"/queryDataOnCascaderByIds"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> queryDataOnCascaderByIds(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody QueryDataOnCascaderByIdsDTO queryDataDto) {
        return this.hussarAppDataSourceService.queryDataOnCascaderByIds(queryDataDto);
    }

    @GetMapping(value={"/export_fields"})
    public ApiResponse<List<Widget>> getExportFields(@RequestParam String formId) {
        return this.appFormService.getExportFields(formId);
    }

    @GetMapping(value={"/excelImportDownloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", notes="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    public void excelImportDownloadTemplate(@RequestParam(value="formId") String formId, HttpServletResponse response, String appId, String langCode, String viewId) throws Exception {
        this.appFormService.excelImportDownloadTemplate(formId, response, appId, langCode, viewId);
    }

    @PostMapping(value={"/excelImportUpload"})
    @ApiOperation(value="\u4e0a\u4f20\u5bfc\u5165\u6587\u6863\u5e76\u8fd4\u56de\u6807\u5934\u548c\u793a\u4f8b\u6570\u636e", notes="\u4e0a\u4f20\u5bfc\u5165\u6587\u6863\u5e76\u8fd4\u56de\u6807\u5934\u548c\u793a\u4f8b\u6570\u636e")
    public ApiResponse<ExcelImportDataVo> excelImportUpload(MultipartFile file, HttpServletResponse response) {
        try {
            return this.appFormService.excelImportUpload(file, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)IMPORT_ERR);
        }
    }

    @PostMapping(value={"/excelImportPreview"})
    @ApiOperation(value="\u6839\u636e\u65b0\u7684\u8868\u5934\u91cd\u65b0\u89e3\u6790excel\u5e76\u8fd4\u56de\u6807\u5934\u548c\u9884\u89c8\u6570\u636e", notes="\u6839\u636e\u65b0\u7684\u8868\u5934\u91cd\u65b0\u89e3\u6790excel\u5e76\u8fd4\u56de\u6807\u5934\u548c\u9884\u89c8\u6570\u636e")
    public ApiResponse<ExcelImportSheetVo> excelImportPreview(@RequestBody ExcelImportPreviewVo excelImportPreviewVo, HttpServletResponse response) {
        try {
            return this.appFormService.excelImportPreview(excelImportPreviewVo, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)IMPORT_ERR);
        }
    }

    @PostMapping(value={"/excelImport"})
    @ApiOperation(value="excel\u5bfc\u5165", notes="excel\u5bfc\u5165")
    @OpControllerAnno
    public ApiResponse<ExcelImportResultVo> excelImport(@RequestBody ExcelImportPreviewVo excelImportPreviewVo, HttpServletResponse response) {
        try {
            return this.appFormService.excelImportAndCreateTask(excelImportPreviewVo, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return ApiResponse.fail((String)IMPORT_ERR);
        }
    }

    @PostMapping(value={"/excel_export"})
    public ApiResponse<Long> exportData(@RequestBody DataExportDTO dataExportDTO) {
        return this.appFormService.exportData(dataExportDTO);
    }

    @GetMapping(value={"/downLoadExcelErrorFile"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u5931\u8d25\u660e\u7ec6", notes="\u4e0b\u8f7d\u5bfc\u5165\u5931\u8d25\u660e\u7ec6")
    public void download(@RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        this.excelExport.fileDownLoad(Long.valueOf(fileName), response);
    }

    @PostMapping(value={"/getTaskById/{taskId}"})
    public ApiResponse<SysExcelTaskNoCode> getTaskById(@PathVariable Long taskId, HttpServletResponse response) {
        return this.appFormService.getTaskById(taskId, response);
    }

    @GetMapping(value={"/export_excel_download/{fileId}"})
    public void downloadExportData(@PathVariable Long fileId, HttpServletResponse response) {
        this.excelExport.fileDownLoad(fileId, response);
    }

    @PostMapping(value={"/addAssignee"})
    @ApiOperation(value="\u6d41\u7a0b\u52a0\u7b7e")
    public ApiResponse<Void> addAssignee(@RequestBody AddAssigneeDto addAssigneeDto) {
        this.appFormService.addAssignee(addAssigneeDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/createAssistTask"})
    @ApiOperation(value="\u65b0\u589e\u534f\u529e")
    public ApiResponse<Void> createAssistTask(@RequestBody CreateAssistTaskDto createAssistTaskDto) {
        this.appFormService.createAssistTask(createAssistTaskDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/addCustomNode"})
    @ApiOperation(value="\u8ffd\u52a0\u81ea\u5b9a\u4e49\u5ba1\u6279\u8282\u70b9")
    public ApiResponse<Void> addCustomNode(@RequestBody AddCustomNodeDto addCustomNodeDto) {
        this.appFormService.addCustomNode(addCustomNodeDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/getDataAuth"})
    public ApiResponse<Boolean> getDataAuth(@RequestBody JSONObject param) {
        return this.appFormService.getDataAuth(param);
    }

    @PostMapping(value={"/deleteDataAuth"})
    public ApiResponse<Boolean> deleteDataAuth(@RequestBody JSONObject param) {
        return this.appFormService.deleteDataAuth(param);
    }

    @PostMapping(value={"/saveOrUpdateSignature"})
    public ApiResponse<Boolean> saveOrUpdateSignature(@RequestBody SysUserAttachment sysUserAttachment) {
        return ApiResponse.success((Object)this.hussarBaseUserAttachmentService.updateUserSignInfo(sysUserAttachment));
    }

    @PostMapping(value={"/getSignature"})
    public ApiResponse<SysUserAttachmentVo> getSignature(@RequestBody SysUserAttachment sysUserAttachment) {
        return ApiResponse.success((Object)this.hussarBaseUserAttachmentService.queryUserSign(sysUserAttachment));
    }

    @GetMapping(value={"/getSystemTime"})
    @CheckSafe
    public ApiResponse<String> getSystemTime() {
        return ApiResponse.success((Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (String)ResultCode.SUCCESS.getMessage());
    }

    @GetMapping(value={"/requestSignature"})
    public ResponseEntity<ApiResponse<String>> requestSignature(@RequestParam(value="appId") String appId, @RequestParam(value="formId") String formId) {
        return this.handwrittenSignatureService.requestSignature(appId, formId);
    }

    @GetMapping(value={"/scanSignature"})
    public ResponseEntity<ApiResponse<Boolean>> scanSignature(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.scanSignature(randomCode);
    }

    @PostMapping(value={"/saveSignatureToRedis"})
    public ResponseEntity<ApiResponse<Boolean>> saveSignatureToRedis(@RequestBody JSONObject param) {
        return this.handwrittenSignatureService.saveSignatureToRedis(param);
    }

    @GetMapping(value={"/getSignatureFromRedis"})
    public ResponseEntity<ApiResponse<String>> getSignatureFromRedis(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.getSignatureFromRedis(randomCode);
    }

    @PostMapping(value={"/checkParticipant"})
    public ApiResponse<JSONObject> checkParticipant(@RequestBody JSONObject param) {
        return this.appFormService.checkParticipant(param);
    }

    @GetMapping(value={"/convertCheck"})
    @ApiOperation(value="\u8868\u5355\u8f6c\u6362\u68c0\u6d4b")
    public ApiResponse<FormConvertCheckVo> convertCheck(@RequestParam String formId) throws Exception {
        return this.appFormService.convertCheck(formId);
    }

    @PostMapping(value={"/convert"})
    @ApiOperation(value="\u5c06\u666e\u901a\u8868\u5355\u8f6c\u4e3a\u6d41\u7a0b\u8868\u5355\u6216\u5c06\u6d41\u7a0b\u8868\u5355\u8f6c\u4e3a\u666e\u901a\u8868\u5355")
    public ApiResponse<Boolean> convertForm(@RequestParam String formId) throws Exception {
        return this.appFormService.convertForm(formId);
    }

    @GetMapping(value={"/delSignatureFromRedis"})
    public ResponseEntity<ApiResponse<Boolean>> delSignatureFromRedis(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.delSignatureFromRedis(randomCode);
    }

    @PostMapping(value={"/flowEditAssignee"})
    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u52a0\u7b7e\u51cf\u7b7e")
    public ResponseEntity<ApiResponse<Object>> flowEditAssignee(@RequestBody Map<String, Object> paramsMap) {
        return this.appFormService.flowEditAssignee(paramsMap);
    }

    @PostMapping(value={"/flowFreeJump"})
    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u81ea\u7531\u8df3\u8f6c")
    public ResponseEntity<ApiResponse<Object>> flowFreeJump(@RequestBody Map<String, Object> paramsMap) {
        return this.appFormService.flowFreeJump(paramsMap);
    }

    @PostMapping(value={"/creatFlowAssistTask"})
    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u65b0\u589e\u534f\u529e")
    public ResponseEntity<ApiResponse<Object>> createAssistTask(@RequestBody Map<String, Object> paramsMap) {
        return this.appFormService.createAssistTask(paramsMap);
    }

    @PostMapping(value={"/completeAssistTask"})
    @ApiOperation(value="\u6d41\u7a0b\u8868\u5355\u5b8c\u6210\u534f\u529e")
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> completeAssistTask(@RequestBody Map<String, Object> paramsMap) {
        return this.appFormService.completeAssistTask(paramsMap);
    }

    @PostMapping(value={"/queryDataFromMerge"})
    public ApiResponse<QueryBusinessDataVo> queryDataFromMerge(@RequestBody QueryDataDTO queryDataDTO) {
        return this.hussarAppDataSourceService.queryApiBusinessDataFromMerge(queryDataDTO.getFormId(), queryDataDTO.getAppCode(), queryDataDTO.getApiCode(), queryDataDTO.getUri(), queryDataDTO.getParams());
    }
}

