/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewSchemaVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewVo;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangBoService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class I18nUtil {
    @Resource
    private ISysMultiLangMgtBoService sysMultiLangMgtService;
    @Resource
    private ISysMultiLangBoService sysMultiLangService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    private static Logger logger = LoggerFactory.getLogger(I18nUtil.class);

    public String getTitle(WidgetDTO widget, String langCode, DataView view) {
        if (HussarUtils.isNotEmpty((Object)view)) {
            String i18nKeys = "";
            List showFields = view.getShowFields();
            ShowField field = null;
            for (ShowField showField : showFields) {
                String name = showField.getName();
                if (widget.getIsInChild()) {
                    return this.getWidgetAlias(widget, langCode, view);
                }
                if (!name.equals(widget.getName())) continue;
                field = showField;
                i18nKeys = showField.getI18nKeys();
                break;
            }
            if (HussarUtils.isNotEmpty((Object)i18nKeys)) {
                JSONObject parse = (JSONObject)JSONObject.parse((String)i18nKeys);
                Object object = parse.get((Object)"alias");
                return this.getCommonI18nByKey(langCode, object, this.getViewAlias(widget, langCode, view, field));
            }
            return this.getViewAlias(widget, langCode, view, field);
        }
        return this.getWidgetAlias(widget, langCode, view);
    }

    public String getTitleByWidget(Widget widget, String langCode, DataView view) {
        String json = JsonUtil.toJson((Object)widget);
        WidgetDTO widgetDTO = (WidgetDTO)JsonUtil.parse((String)json, WidgetDTO.class);
        return this.getTitle(widgetDTO, langCode, view);
    }

    public String getViewAlias(WidgetDTO widget, String langCode, DataView view, ShowField field) {
        if (HussarUtils.isNotEmpty((Object)field) && HussarUtils.isNotEmpty((Object)field.getAlias())) {
            return field.getAlias();
        }
        return this.getWidgetAlias(widget, langCode, view);
    }

    public String getWidgetAlias(WidgetDTO widget, String langCode, DataView view) {
        String i18ntitle = widget.getI18ntitle();
        return this.getCommonI18nByKey(langCode, i18ntitle, widget.getTitle());
    }

    public String getCommonI18nByKeys(String langCode, String i18nKeys, String key, String defaultValue) {
        if (HussarUtils.isNotEmpty((Object)i18nKeys)) {
            JSONObject jsonObject = (JSONObject)JSON.parse((String)i18nKeys);
            Object object1 = jsonObject.get((Object)key);
            return this.getCommonI18nByKey(langCode, object1, defaultValue);
        }
        return defaultValue;
    }

    public String getCommonI18nByKey(String langCode, Object i18nKey, String defaultValue) {
        if (HussarUtils.isNotEmpty((Object)langCode) && HussarUtils.isNotEmpty((Object)i18nKey)) {
            String langKey = String.valueOf(i18nKey);
            SysMultiLangMgt sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(langKey, langCode);
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                return sysMultiLangMgt.getLangText();
            }
            SysMultiLang sysMultiLang = this.sysMultiLangService.getDefaultLang();
            if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
                String code = sysMultiLang.getLangCode();
                sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(langKey, code);
                if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                    return sysMultiLangMgt.getLangText();
                }
                return defaultValue;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public DataView getView(String viewId, String appId, String formId) {
        try {
            FormViewVo formViewVo = this.hussarAppFormService.getViewByUser(formId, appId);
            FormViewSchemaVo formView = formViewVo.getFormView();
            List views = formView.getViews();
            if (HussarUtils.isNotEmpty((Object)views)) {
                for (DataView view : views) {
                    if (!view.getId().equals(viewId)) continue;
                    return view;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25", (Throwable)e);
        }
        return null;
    }
}

