/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleSendType;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRule;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.application.properties.BusinessRuleProperties;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import javax.annotation.Resource;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class NoCodeRuleAsync {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeRuleAsync.class);
    @Autowired
    private RulesEngine rulesEngine;
    @Resource
    private BusinessRuleProperties businessRuleProperties;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private SysMsgPushTaskService sysMsgPushTaskService;

    public void excNoCodeRuleAsync(String appId, String formId, JSONObject businessData, SecurityUser user, String triggerType, String traceId, List<String> ruleIds) {
        Long userId = null;
        if (HussarUtils.isNotEmpty((Object)user)) {
            userId = user.getUserId();
        }
        try {
            this.sysMsgPushTaskService.asyncGenerateTaskByDataChange(Long.valueOf(formId), businessData, triggerType);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u63a8\u9001 => \u5f02\u6b65\u8c03\u7528\u5931\u8d25", (Throwable)e);
        }
        try {
            ISysTimingTriggerTaskService sysTimingTriggerTaskService = (ISysTimingTriggerTaskService)SpringUtil.getBean(ISysTimingTriggerTaskService.class);
            HussarNoCodeThreadUtil.executeUserTask(() -> sysTimingTriggerTaskService.asyncGenerateTaskByDataChange(Long.valueOf(formId), businessData, triggerType));
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u89e6\u53d1 => \u89e6\u53d1\u6570\u636e\u53d8\u5316\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (HussarUtils.isEmpty((Object)traceId)) {
            traceId = IdUtil.randomUUID();
        }
        if (NoCodeRuleSendType.RABBITMQ.getType().equalsIgnoreCase(this.businessRuleProperties.getSendType())) {
            try {
                logger.info("\u8c03\u7528\u96f6\u4ee3\u7801\u4e1a\u52a1\u89c4\u5219:\u5411rabbitmq\u53d1\u9001\u4e1a\u52a1\u89c4\u5219\u8c03\u7528\u4fe1\u606f\uff0c\u94fe\u8defId:{},formId\uff1a{}\uff0ctriggerType\uff1a{}\uff0cuser\uff1a{}", new Object[]{traceId, formId, triggerType, userId});
                this.sendRabbitmq(appId, formId, businessData, user, triggerType, traceId, ruleIds);
            }
            catch (Exception e) {
                logger.info("\u8c03\u7528\u96f6\u4ee3\u7801\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u4f7f\u7528rabbitmq\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6539\u4e3a\u672c\u5730\u5f02\u6b65\u8c03\u7528\u4e1a\u52a1\u89c4\u5219:,\u94fe\u8defid:{},formId\uff1a{}\uff0ctriggerType\uff1a{}\uff0c\uff0cuser\uff1a{}", new Object[]{traceId, formId, triggerType, userId});
                this.localAsync(appId, formId, businessData, user, triggerType, traceId, ruleIds);
            }
        } else {
            logger.info("\u8c03\u7528\u96f6\u4ee3\u7801\u4e1a\u52a1\u89c4\u5219:\u672c\u5730\u5f02\u6b65\u8c03\u7528\uff0c\u94fe\u8defid:{},formId\uff1a{}\uff0ctriggerType\uff1a{}\uff0cuser\uff1a{}", new Object[]{traceId, formId, triggerType, userId});
            this.localAsync(appId, formId, businessData, user, triggerType, traceId, ruleIds);
        }
    }

    public void localAsync(String appId, String formId, JSONObject businessData, SecurityUser user, String triggerType, String traceId, List<String> ruleIds) {
        Rules rules = new Rules(new Rule[0]);
        rules.register(new Object[]{new NoCodeRule()});
        Facts facts = new Facts();
        facts.put("formId", (Object)formId);
        facts.put("businessData", (Object)businessData);
        facts.put("triggerType", (Object)triggerType);
        facts.put("loginUser", (Object)user);
        facts.put("appId", (Object)appId);
        facts.put("traceId", (Object)traceId);
        facts.put("ruleIds", ruleIds);
        this.rulesEngine.fire(rules, facts);
    }

    private void sendRabbitmq(String appId, String formId, JSONObject businessData, SecurityUser user, String triggerType, String traceId, List<String> ruleIds) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formId", (Object)formId);
        jsonObject.put("businessData", (Object)businessData);
        jsonObject.put("triggerType", (Object)triggerType);
        jsonObject.put("user", (Object)user);
        jsonObject.put("appId", (Object)appId);
        jsonObject.put("traceId", (Object)traceId);
        jsonObject.put("ruleIds", ruleIds);
        this.rabbitTemplate.convertAndSend("nocodeRuleTrigger", (Object)JSON.toJSONString((Object)jsonObject));
    }
}

