/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppRegionService;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.ExcelFormatEnum;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleAsync;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelExport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExelTaskUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportErrorVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewMatchVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResultVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.util.TimeFormatUtil;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExcelImportAsync {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportAsync.class);
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private HussarFormDesignProperties hussarFormDesignFrameProperties;
    @Value(value="${hussar.excel.maxRow:0x7fffffff}")
    private int maxRow;
    @Value(value="${hussar.excel.maxCell:0x7fffffff}")
    private int maxCell;
    private static final String PRIMARY_KEY_TITLE_NAME = "\u6570\u636eid\uff08\u4e0d\u53ef\u66f4\u6539\uff09";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ExcelExport excelExport;
    @Resource
    private ExcelImport excelImport;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Autowired
    private IHussarAppRegionService hussarAppRegionService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Autowired
    private ExelTaskUtil exelTaskUtil;
    @Resource
    private NoCodeRuleAsync noCodeRuleAsync;
    @Resource
    private ISysApplicationBoService applicationBoService;

    @OperateLogTypeCache(mode=1)
    @HussarDs(value="#dataSourceKey")
    public void excelImportAndSave(ExcelImportPreviewVo excelImportPreviewVo, HttpServletResponse response, Long taskId, UserDetails userDetails, String dataSourceKey) {
        logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u6267\u884c\u5bfc\u5165", (Object)userDetails.getUserName(), (Object)TimeFormatUtil.now());
        long startTo = System.currentTimeMillis();
        JSONObject sysData = new JSONObject();
        logger.info("=======\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}======\u8fdb\u5165excelImportAndSave\u8fd4\u56de\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
        if (HussarUtils.isEmpty((Object)excelImportPreviewVo) || HussarUtils.isEmpty((Object)excelImportPreviewVo.getFormId())) {
            throw new BaseException("\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(excelImportPreviewVo.getFormId())));
        AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
        SysApplication appDetail = this.applicationBoService.selectById(form.getAppId());
        if (HussarUtils.isNotEmpty((Object)appDetail)) {
            HussarCacheUtil.put((String)"appDevelopRole", (Object)form.getId(), (Object)appDetail.getDevelopRoleId(), (long)300L);
        }
        boolean containDataId = false;
        boolean containUser = false;
        boolean containOrg = false;
        boolean containAddress = false;
        List matches = excelImportPreviewVo.getMatches();
        if (HussarUtils.isNotEmpty((Object)matches)) {
            for (ExcelImportPreviewMatchVo excelImportPreviewMatchVo : matches) {
                if ("RECORD_ID".equals(excelImportPreviewMatchVo.getFieldName())) {
                    containDataId = true;
                }
                if (WidgetType.JXDNUser.getType().equals(excelImportPreviewMatchVo.getFieldType()) || WidgetType.JXDNUserMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containUser = true;
                }
                if (WidgetType.JXDNOrg.getType().equals(excelImportPreviewMatchVo.getFieldType()) || WidgetType.JXDNOrgMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containOrg = true;
                }
                if (!WidgetType.ADDRESS.getType().equals(excelImportPreviewMatchVo.getFieldType())) continue;
                containAddress = true;
            }
        }
        if (!(excelImportPreviewVo.getImportType() != 2 && excelImportPreviewVo.getImportType() != 3 || containDataId)) {
            throw new BaseException("data_id\u672a\u5339\u914d\u5b57\u6bb5\uff0c\u8bf7\u5148\u5bfc\u51fa\u6570\u636e\u53cadata_id");
        }
        ExcelImportResultVo excelImportResultVo = new ExcelImportResultVo();
        FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(form);
        FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
        if (HussarUtils.isEmpty((Object)canvas)) {
            logger.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)excelImportPreviewVo.getFormId());
        }
        List<Widget> widgets = new ArrayList<Widget>();
        List widgetsFromCanvas = canvas.widgets();
        List childTables = canvas.childTables();
        widgetsFromCanvas = JSON.parseArray((String)JSON.toJSONString((Object)widgetsFromCanvas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Widget.class);
        childTables = JSON.parseArray((String)JSON.toJSONString((Object)childTables, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Widget.class);
        widgets.addAll(widgetsFromCanvas);
        widgets.addAll(childTables);
        widgets.add(this.excelExport.createDataIdWidget(form));
        widgets.addAll(canvas.systemWidgets());
        widgets = this.excelImport.dealWidgets(widgets, null);
        this.excelImport.addChildIdWidgetRecursion(widgets);
        List<Object> allUsers = new ArrayList();
        List<Object> allOrgans = new ArrayList();
        List allRegionVos = new ArrayList();
        Map<Object, Object> parentIdRegionVoMap = new HashMap();
        if (containUser) {
            allUsers = this.excelImport.getAllUser();
        }
        if (containOrg) {
            allOrgans = this.excelImport.getAllOrgan();
        }
        if (containAddress) {
            allRegionVos = this.hussarAppRegionService.getRegionInfo();
            parentIdRegionVoMap = allRegionVos.stream().collect(Collectors.groupingBy(RegionVo::getParentId));
        }
        sysData.put("allUsers", allUsers);
        sysData.put("allOrgans", allOrgans);
        sysData.put("allRegionVos", allRegionVos);
        sysData.put("parentIdRegionVoMap", parentIdRegionVoMap);
        String cacheKey = excelImportPreviewVo.getCacheKey();
        String fileId = cacheKey.substring(0, cacheKey.lastIndexOf("."));
        AttachmentManagerModel model = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)Long.valueOf(fileId));
        String attachmentDir = model.getAttachmentDir();
        String filePath = attachmentDir + excelImportPreviewVo.getCacheKey();
        String fileName = excelImportPreviewVo.getCacheKey();
        FileInputStream fileInputStream = null;
        ExcelImportSheetVo excelImportSheetVo = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            excelImportSheetVo = this.excelImport.analysisExcelAndReturnPreviewData(excelImportPreviewVo.getSheetIndex(), fileInputStream, null, excelImportPreviewVo.getCacheKey());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new BaseException((Throwable)e);
        }
        finally {
            if (HussarUtils.isNotEmpty(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        List rowsFromExcel = excelImportSheetVo.getRows();
        List matchs = excelImportPreviewVo.getMatches();
        if (rowsFromExcel.size() > this.maxRow) {
            excelImportResultVo.setInsertNum(0);
            excelImportResultVo.setFailNum(rowsFromExcel.size());
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u884c\u6570\u8d85\u957f");
            throw new BaseException("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u884c\u6570\u8d85\u957f,\u6700\u5927\u503c\u4e3a" + this.maxRow);
        }
        if (matchs.size() > this.maxCell) {
            excelImportResultVo.setInsertNum(0);
            excelImportResultVo.setFailNum(rowsFromExcel.size());
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5217\u6570\u8d85\u957f");
            throw new BaseException("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5217\u6570\u8d85\u957f,\u6700\u5927\u503c\u4e3a" + this.maxCell);
        }
        excelImportResultVo = this.excelImport.dealExcelData(excelImportPreviewVo, rowsFromExcel, widgets, form, sysData);
        List importList = excelImportResultVo.getDataList();
        logger.info("\u672c\u6b21\u5bfc\u5165\u6570\u636e\u6570\u91cf\uff1a{}\uff0c\u64cd\u4f5c\u4eba\uff1a{}", (Object)importList.size(), (Object)userDetails.getUserName());
        if (importList.size() > 0) {
            ArrayList dataList;
            HashMap<String, Object> flowFormSubmitsParams;
            if (HussarUtils.isNotEmpty((Object)form) && FormCreateTypeEnum.FORM_TO_FORM.getType().equals(form.getCreateSource())) {
                importList.forEach(importData -> importData.put("FORM_ID", (Object)form.getId()));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("importList", importList);
            if (excelImportPreviewVo.getTriggerProcess() == 2) {
                logger.info("=====\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==2\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                flowFormSubmitsParams = new HashMap<String, Object>();
                dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", false);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u6267\u884c\u5165\u5e93\u64cd\u4f5c\uff08\u89e6\u53d1\u6d41\u7a0b\uff09\uff0c\u63d2\u5165\u6570\u636e\u91cf\uff1a{}", new Object[]{userDetails.getUserName(), TimeFormatUtil.now(), importList.size()});
                long startT = System.currentTimeMillis();
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
                logger.info("\u6570\u636e\u5bfc\u5165\u7ed3\u675f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - startT));
            } else if (excelImportPreviewVo.getTriggerProcess() == 3) {
                logger.info("===========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}=========getTriggerProcess()==3\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                flowFormSubmitsParams = new HashMap();
                dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", true);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u6267\u884c\u5165\u5e93\u64cd\u4f5c\uff08\u89e6\u53d1\u6d41\u7a0b\u5e76\u7ed3\u675f\uff09\uff0c\u63d2\u5165\u6570\u636e\u91cf\uff1a{}", new Object[]{userDetails.getUserName(), TimeFormatUtil.now(), importList.size()});
                long startT = System.currentTimeMillis();
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
                logger.info("\u6570\u636e\u5bfc\u5165\u7ed3\u675f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - startT));
            } else if (excelImportPreviewVo.getTriggerProcess() == 4 || excelImportPreviewVo.getTriggerProcess() == 1) {
                if (excelImportPreviewVo.getTriggerProcess() == 4) {
                    logger.info("=========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==4\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                } else {
                    logger.info("=========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==1\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                }
                FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
                List canvasWidgets = formCanvasSchemaDTO.getWidgets();
                String json = JsonUtil.toJson((Object)canvasWidgets);
                List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
                boolean targetFormChild = widgetDTOS.stream().anyMatch(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) || widgets.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).anyMatch(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()));
                logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u6267\u884c\u5165\u5e93\u64cd\u4f5c\uff08\u4e0d\u89e6\u53d1\u6d41\u7a0b\u6216\u8349\u7a3f\uff09\uff0c\u63d2\u5165\u6570\u636e\u91cf\uff1a{}", new Object[]{userDetails.getUserName(), TimeFormatUtil.now(), importList.size()});
                if (targetFormChild) {
                    HashMap<String, List> map = new HashMap<String, List>();
                    map.put(form.getTableName(), importList);
                    HashMap<String, HashMap<String, List>> typeMap = new HashMap<String, HashMap<String, List>>();
                    typeMap.put("saveAndUpdate", map);
                    long startT = System.currentTimeMillis();
                    this.formOperateExposedService.formIncrementSave(excelImportPreviewVo.getFormId(), typeMap, excelImportPreviewVo.getAppId());
                    logger.info("\u6570\u636e\u5bfc\u5165\u7ed3\u675f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - startT));
                } else {
                    long startT = System.currentTimeMillis();
                    this.formOperateExposedService.tableSave(excelImportPreviewVo.getAppId(), excelImportPreviewVo.getFormId(), params);
                    logger.info("\u6570\u636e\u5bfc\u5165\u7ed3\u675f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - startT));
                }
            }
            this.ruleForTableSave(excelImportPreviewVo, params);
            HussarCacheUtil.evict((String)"appDevelopRole", (Object)form.getId());
        }
        excelImportResultVo.setDataList(null);
        boolean isError = false;
        if (excelImportResultVo.getFailNum() > 0) {
            isError = true;
            String fileSuffix = null;
            if (fileName.endsWith(".xls")) {
                fileSuffix = ".xls";
            } else if (fileName.endsWith(".xlsx")) {
                fileSuffix = ".xlsx";
            }
            ArrayList<ExcelImportResultVo> excelImportResultVos = new ArrayList<ExcelImportResultVo>();
            excelImportResultVos.add(excelImportResultVo);
            this.downloadFile(taskId, filePath, fileSuffix, excelImportResultVos, excelImportResultVo.getFailNum());
            fileName = taskId + fileSuffix;
        }
        if (new File(filePath).exists()) {
            if (new File(filePath).delete()) {
                logger.info("File deleted successfully: " + filePath);
            } else {
                logger.warn("Failed to delete file: " + filePath);
            }
        }
        excelImportResultVo.setFailExcelId("1");
        SysExcelTaskNoCode task = new SysExcelTaskNoCode();
        task.setId(taskId);
        if (isError) {
            task.setFileName(fileName);
        }
        task.setTaskStatus(Integer.valueOf(4));
        task.setErrorMsg(excelImportResultVo.getFailMessages() == null ? "" : JSON.toJSONString((Object)excelImportResultVo.getFailMessages()));
        task.setDataSuccess(Integer.valueOf(excelImportResultVo.getInsertNum()));
        task.setDataError(Integer.valueOf(excelImportResultVo.getFailNum()));
        logger.info("============\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}=======excelImportAndSave\u65b9\u6cd5\u7ed3\u675f\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
        HussarNoCodeThreadUtil.executeUserTask(() -> this.exelTaskUtil.updateExelTask(task, dataSourceKey));
        logger.info("\u6570\u636e\u5bfc\u5165\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - startTo));
    }

    private String copyFile(String filePath) throws IOException {
        String[] split = filePath.split("\\.");
        String filePathCopy = split[0] + "error." + split[1];
        Path source = Paths.get(filePath, new String[0]);
        Path target = Paths.get(filePathCopy, new String[0]);
        Files.copy(source, target, new CopyOption[0]);
        return filePathCopy;
    }

    private void ruleForTableSave(ExcelImportPreviewVo excelImportPreviewVo, Map<String, Object> paramsImport) {
        try {
            if (!HussarUtils.equals((Object)excelImportPreviewVo.getTriggerProcess(), (Object)4)) {
                String appId = excelImportPreviewVo.getAppId();
                String formId = excelImportPreviewVo.getFormId();
                String triggerType = "";
                if (HussarUtils.isNotEmpty((Object)paramsImport.get("importList"))) {
                    List paramList = (List)paramsImport.get("importList");
                    for (Map params : paramList) {
                        triggerType = HussarUtils.isEmpty(params.get("createUser_user")) ? NoCodeRuleTriggerType.TriggerTypeUpdate.getType() : NoCodeRuleTriggerType.TriggerTypeCreate.getType();
                        SecurityUser user = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
                        String traceId = (String)TransmittableThreadLocalHolder.get((String)"traceId");
                        String finalTriggerType = triggerType;
                        HussarNoCodeThreadUtil.executeUserTask(() -> this.noCodeRuleAsync.excNoCodeRuleAsync(appId, formId, new JSONObject(params), user, finalTriggerType, traceId, new ArrayList<String>()));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("formSave\u8c03\u7528\u4e1a\u52a1\u89c4\u5219\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean downloadFile(Long taskId, String filePath, String fileSuffix, List<ExcelImportResultVo> importResultVos, int failNum) {
        File file = new File(FileUtil.posixPath((String[])new String[]{this.hussarFormDesignFrameProperties.getWorkspace(), "import"}));
        if (!file.exists()) {
            try {
                FileUtils.forceMkdir((File)file);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        String outputFilePath = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignFrameProperties.getWorkspace(), "import", taskId + fileSuffix});
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean deleteFileFlag = true;
        try {
            fileInputStream = new FileInputStream(filePath);
            Workbook workbook = ExcelFormatEnum.getWorkbook(fileSuffix, fileInputStream);
            Sheet sheet = workbook.getSheetAt(0);
            for (int i = 1; i <= importResultVos.get(0).getInsertNum() + importResultVos.get(0).getFailNum(); ++i) {
                if (importResultVos.get(0).getFailRowNums().contains(i + 1)) continue;
                Row row = sheet.getRow(i);
                sheet.removeRow(row);
                sheet.removeRowBreak(i);
            }
            ArrayList errorRows = new ArrayList();
            if (failNum > 0) {
                for (int i = 0; i < importResultVos.size(); ++i) {
                    List excelImportErrorVos = importResultVos.get(i).getExcelImportErrorVos();
                    if (!HussarUtils.isNotEmpty((Object)excelImportErrorVos)) continue;
                    for (ExcelImportErrorVo errorVo : excelImportErrorVos) {
                        if (!HussarUtils.isNotEmpty((Object)errorVo.getRow()) || !HussarUtils.isNotEmpty((Object)errorVo.getCol())) continue;
                        ExcelImportAsync.setCell(workbook, workbook.getSheetAt(i), errorVo.getRow(), errorVo.getCol(), errorVo.getFailMessage());
                    }
                }
            }
            for (int i = sheet.getLastRowNum(); i >= 0; --i) {
                Row row = sheet.getRow(i);
                if (row != null || i >= sheet.getLastRowNum()) continue;
                sheet.shiftRows(i + 1, sheet.getLastRowNum(), -1);
            }
            fileOutputStream = new FileOutputStream(outputFilePath);
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new BaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return deleteFileFlag;
    }

    private static void setCell(Workbook workbook, Sheet sheet, int rowIndex, int columnIndex, String errorMsg) {
        Cell cell;
        XSSFCellStyle style = (XSSFCellStyle)workbook.createCellStyle();
        CreationHelper helper = workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(columnIndex);
        anchor.setRow1(rowIndex + 2);
        anchor.setCol2(columnIndex + 3);
        anchor.setRow2(rowIndex + 5);
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setString(helper.createRichTextString(errorMsg));
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(columnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).getCellStyle() != null) {
            style.cloneStyleFrom(cell.getCellStyle());
        }
        cell.setCellStyle((CellStyle)style);
        if (cell.getCellComment() == null) {
            cell.setCellComment(comment);
        }
        byte[] errorRgb = new byte[]{-15, -52, -86};
        XSSFColor errorColor = new XSSFColor(errorRgb, null);
        style.setFillForegroundColor(errorColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    public List<Widget> createChildDataIdWidget(SysForm form) {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
        List widgets = formCanvasSchemaDTO.getWidgets();
        String json = JsonUtil.toJson((Object)widgets);
        List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
        widgetDTOS.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).forEach(widget -> {
            String parentKey = widget.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.JXDNTabs.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        return widgetList;
    }
}

