/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.strategy.widgetstrategy;

import com.jxdinfo.hussar.formdesign.app.frame.server.strategy.IWidgetStrategy;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class JXDNSecurityLevelStrategy
implements IWidgetStrategy {
    private static final Long SECURITY_LEVEL_TYPE_ID = 1450742089372590091L;
    @Resource
    private ISysDicRefService sysDicRefService;

    @Override
    public WidgetType getWidgetType() {
        return WidgetType.JXDNSecurityLevel;
    }

    @Override
    public Object deal(EngineResultEntity entity, Widget widget) {
        String widgetName = widget.getName();
        try {
            entity.put((Object)(widgetName + "_value"), entity.get((Object)widgetName));
            Object label = entity.get((Object)(widgetName + "_label"));
            if (HussarUtils.isNotEmpty((Object)label)) {
                return label;
            }
            List dicts = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
            Map<String, String> optionMap = dicts.stream().collect(Collectors.toMap(DicLevelTreeVo::getValue, DicLevelTreeVo::getLabel, (key1, key2) -> key2));
            return HussarUtils.isNotEmpty((Object)optionMap.get(entity.get((Object)widgetName).toString())) ? optionMap.get(entity.get((Object)widgetName).toString()) : entity.get((Object)widgetName);
        }
        catch (Exception e) {
            return entity.get((Object)widgetName);
        }
    }
}

