/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.util.TriggerVerify;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleExec;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.FormOutLinkUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.NoCodeRuleUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerTask;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerConfigService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class NoCodeRuleTrigger {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeRuleTrigger.class);
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private ISysRuleInfoService sysRuleInfoService;
    @Resource
    private ISysTimingTriggerConfigService sysTimingTriggerConfigService;
    @Resource
    private IHussarBaseUserBoService sysUsersService;
    @Resource
    private NoCodeRuleExec noCodeRuleExec;

    public JSONObject triggerRule(JSONObject businessData, SysRuleInfoWithDetailsDto ruleInfoWithDetails, String triggerType) throws Exception {
        JSONObject newBusinessDate = JSON.parseObject((String)businessData.toJSONString());
        String triggers = ruleInfoWithDetails.getSysRuleTriggerAction().getTriggerConditions();
        String formId = String.valueOf(ruleInfoWithDetails.getSysRuleTriggerAction().getFormId());
        String triggerAction = ruleInfoWithDetails.getSysRuleTriggerAction().getTriggerAction();
        if (!NoCodeRuleTriggerType.TriggerTypeUpdate.getType().equals(triggerType)) {
            if (HussarUtils.isEmpty((Object)businessData) || HussarUtils.isEmpty((Object)ruleInfoWithDetails) || HussarUtils.isEmpty((Object)triggerType) || HussarUtils.isEmpty((Object)ruleInfoWithDetails.getSysRuleTriggerAction()) || !triggerType.equals(ruleInfoWithDetails.getSysRuleTriggerAction().getTriggerAction())) {
                logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c,\u4e0d\u6ee1\u8db3\u89e3\u6790\u6761\u4ef6\u6216\u8005\u89e6\u53d1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u89e6\u53d1\u7c7b\u578b\uff1a{}", new Object[]{businessData, JsonUtil.toJson((Object)ruleInfoWithDetails), triggerType});
                return null;
            }
            Boolean verify = TriggerVerify.conditionVerify((JSONObject)businessData, (String)triggers, (String)formId, (String)triggerType);
            return verify != false ? businessData : null;
        }
        Map<String, Object> dataMap = NoCodeRuleUtil.analysisChildByOperateType((Map<String, Object>)newBusinessDate, formId);
        String triggerSubtable = ruleInfoWithDetails.getSysRuleTriggerAction().getTriggerSubtable();
        if (NoCodeRuleTriggerType.TriggerTypeChildrenCreate.getType().equals(triggerAction)) {
            if (HussarUtils.isEmpty((Object)triggerSubtable) || HussarUtils.isEmpty((Object)dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenCreate.getType()))) {
                logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c,\u4e0d\u6ee1\u8db3\u89e3\u6790\u6761\u4ef6\u6216\u8005\u89e6\u53d1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u89e6\u53d1\u7c7b\u578b\uff1a{}", new Object[]{newBusinessDate, JsonUtil.toJson((Object)ruleInfoWithDetails), triggerAction});
                return null;
            }
            if (HussarUtils.isNotEmpty((Object)dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenCreate.getType())) && HussarUtils.isNotEmpty((Object)triggerSubtable)) {
                Object dataMapObject = dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenCreate.getType());
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)dataMapObject));
                if (HussarUtils.isEmpty((Object)jsonObject.get((Object)triggerSubtable))) {
                    logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c,\u4e0d\u6ee1\u8db3\u89e3\u6790\u6761\u4ef6\u6216\u8005\u89e6\u53d1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u89e6\u53d1\u7c7b\u578b\uff1a{}", new Object[]{newBusinessDate, JsonUtil.toJson((Object)ruleInfoWithDetails), triggerAction});
                    return null;
                }
                Object createChildDataObject = jsonObject.get((Object)triggerSubtable);
                List createChildDataList = (List)JSON.parseObject((String)JSON.toJSONString((Object)createChildDataObject), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                if (HussarUtils.isNotEmpty((Object)createChildDataList)) {
                    newBusinessDate.replace((Object)triggerSubtable, (Object)createChildDataList);
                }
                return this.childDataVerify(triggerSubtable, newBusinessDate, triggers, formId, triggerType);
            }
        } else if (NoCodeRuleTriggerType.TriggerTypeChildrenRemove.getType().equals(triggerAction)) {
            if (HussarUtils.isEmpty((Object)triggerSubtable) || HussarUtils.isEmpty((Object)dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenRemove.getType()))) {
                logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c,\u4e0d\u6ee1\u8db3\u89e3\u6790\u6761\u4ef6\u6216\u8005\u89e6\u53d1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u89e6\u53d1\u7c7b\u578b\uff1a{}", new Object[]{newBusinessDate, JsonUtil.toJson((Object)ruleInfoWithDetails), triggerAction});
                return null;
            }
            if (HussarUtils.isNotEmpty((Object)dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenRemove.getType())) && HussarUtils.isNotEmpty((Object)triggerSubtable)) {
                Object dataMapObject = dataMap.get(NoCodeRuleTriggerType.TriggerTypeChildrenRemove.getType());
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)dataMapObject));
                if (HussarUtils.isEmpty((Object)jsonObject.get((Object)triggerSubtable))) {
                    logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c,\u4e0d\u6ee1\u8db3\u89e3\u6790\u6761\u4ef6\u6216\u8005\u89e6\u53d1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u89e6\u53d1\u7c7b\u578b\uff1a{}", new Object[]{newBusinessDate, JsonUtil.toJson((Object)ruleInfoWithDetails), triggerAction});
                    return null;
                }
                Object removeChildDataObject = jsonObject.get((Object)triggerSubtable);
                List removeChildDataList = (List)JSON.parseObject((String)JSON.toJSONString((Object)removeChildDataObject), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                if (HussarUtils.isNotEmpty((Object)removeChildDataList)) {
                    newBusinessDate.replace((Object)triggerSubtable, (Object)removeChildDataList);
                }
                return this.childDataVerify(triggerSubtable, newBusinessDate, triggers, formId, triggerType);
            }
        } else if (NoCodeRuleTriggerType.TriggerTypeUpdate.getType().equals(triggerAction)) {
            JSONObject map = JSON.parseObject((String)businessData.toJSONString());
            NoCodeRuleUtil.removeDelChilren((Map<String, Object>)map, formId);
            Boolean verify = TriggerVerify.conditionVerify((JSONObject)map, (String)triggers, (String)formId, (String)triggerType);
            return verify != false ? map : null;
        }
        return null;
    }

    private JSONObject childDataVerify(String triggerSubtable, JSONObject businessData, String triggers, String formId, String triggerType) throws Exception {
        if (HussarUtils.isNotEmpty((Object)triggerSubtable)) {
            ArrayList<Map<String, Object>> childList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> verifyedChildList = new ArrayList<Map<String, Object>>();
            if (businessData.get((Object)triggerSubtable) instanceof JSONArray) {
                JSONArray dependChildFiledNameArray = (JSONArray)businessData.get((Object)triggerSubtable);
                childList = NoCodeRuleUtil.convertJsonArrayToMapList(dependChildFiledNameArray);
            } else {
                childList = (ArrayList<Map<String, Object>>)businessData.get((Object)triggerSubtable);
            }
            JSONObject newBusinessDate = JSON.parseObject((String)businessData.toJSONString());
            for (Map<String, Object> map : childList) {
                List<Map> oneChildDate = Arrays.asList(map);
                newBusinessDate.replace((Object)triggerSubtable, oneChildDate);
                Boolean verifyWithChildren = TriggerVerify.conditionVerifyWithChildren((JSONObject)newBusinessDate, (String)triggers, (String)formId, (String)triggerType);
                if (!verifyWithChildren.booleanValue()) continue;
                verifyedChildList.add(map);
            }
            if (HussarUtils.isNotEmpty(verifyedChildList)) {
                newBusinessDate.replace((Object)triggerSubtable, verifyedChildList);
                return newBusinessDate;
            }
        }
        return null;
    }

    public void triggeredByCond(SysTimingTriggerTask sysTimingTriggerTask) {
        Long triggerId = sysTimingTriggerTask.getTriggerId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        SysRuleTriggerAction sysRuleTriggerAction = (SysRuleTriggerAction)this.sysRuleTriggerActionService.getOne((Wrapper)queryWrapper.eq(SysRuleTriggerAction::getTriggerId, (Object)triggerId));
        List<JSONObject> triggerDataList = NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(sysRuleTriggerAction.getTriggerAction()) ? this.getTriggerDataByDataId(sysTimingTriggerTask) : this.getTriggerDataByFilter(triggerId.toString());
        if (HussarUtils.isNotEmpty(triggerDataList)) {
            logger.info("\u901a\u8fc7\u5b9a\u65f6\u4efb\u52a1\u89e6\u53d1\u7684\u89e6\u53d1\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.toJson(triggerDataList));
            Long formId = sysRuleTriggerAction.getFormId();
            SysForm form = this.applicationService.getFormDetailById(formId);
            Long appId = form.getAppId();
            SysRuleInfoWithDetailsDto sysRuleInfoWithDetails = this.sysRuleInfoService.getSysRuleInfoWithDetails(Long.valueOf(triggerId.toString()));
            String traceId = (String)TransmittableThreadLocalHolder.get((String)"traceId") == null ? IdUtil.randomUUID() : (String)TransmittableThreadLocalHolder.get((String)"traceId");
            for (int i = 0; i < triggerDataList.size(); ++i) {
                JSONObject value = triggerDataList.get(i);
                String createUserId = (String)value.get((Object)"createUser_user");
                SecurityUser securityUser = new SecurityUser();
                securityUser.setUserId(Long.valueOf(createUserId));
                if (FormOutLinkUtil.getExternalUserId().toString().equals(createUserId)) {
                    securityUser.setUserName(FormOutLinkUtil.getUserName());
                } else {
                    SysUsers sysUser = this.sysUsersService.getUser(Long.valueOf(createUserId));
                    securityUser.setUserName(sysUser == null ? "" : sysUser.getUserName());
                }
                this.noCodeRuleExec.excRule(String.valueOf(appId), String.valueOf(formId), value, sysRuleInfoWithDetails, securityUser, traceId, new ArrayList<String>());
            }
        }
    }

    public List<JSONObject> getTriggerDataByDataId(SysTimingTriggerTask sysTimingTriggerTask) {
        Long dataId = sysTimingTriggerTask.getDataId();
        Long appId = sysTimingTriggerTask.getAppId();
        Long formId = sysTimingTriggerTask.getFormId();
        List<Object> triggerDataList = new ArrayList<JSONObject>();
        ArrayList filters = new ArrayList();
        HashMap newParam = new HashMap();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("rule", "_eq");
        filter.put("val", dataId);
        filter.put("field", "RECORD_ID");
        filter.put("match", "AND");
        filters.add(filter);
        newParam.put("superQueryConditionDto", filters);
        ResponseEntity newResponse = this.formOperateExposedService.tableQueryByCondition(String.valueOf(appId), formId.toString(), newParam);
        PageVo newPageData = (PageVo)((ApiResponse)Objects.requireNonNull(newResponse.getBody())).getData();
        List data = newPageData.getData();
        if (!data.isEmpty()) {
            String resultStr = JsonUtil.toJson((Object)data);
            triggerDataList = JSON.parseArray((String)resultStr, JSONObject.class);
        }
        return triggerDataList;
    }

    public List<JSONObject> getTriggerDataByFilter(String triggerId) {
        List<Object> triggerDataList = new ArrayList<JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        SysRuleTriggerAction sysRuleTriggerAction = (SysRuleTriggerAction)this.sysRuleTriggerActionService.getOne((Wrapper)queryWrapper.eq(SysRuleTriggerAction::getTriggerId, (Object)Long.valueOf(triggerId)));
        logger.info("\u5f02\u6b65\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u89e6\u53d1\u52a8\u4f5c\uff1a{}", (Object)JsonUtil.toJson((Object)sysRuleTriggerAction));
        Long formId = sysRuleTriggerAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        Long appId = form.getAppId();
        String triggerConditions = sysRuleTriggerAction.getTriggerConditions();
        JSONObject jsonObject = JSON.parseObject((String)triggerConditions);
        JSONArray condArray = jsonObject.getJSONArray("cond");
        ArrayList filters = new ArrayList();
        HashMap newParam = new HashMap();
        if (!condArray.isEmpty()) {
            for (int i = 0; i < condArray.size(); ++i) {
                JSONObject condObject = condArray.getJSONObject(i);
                HashMap filter = TriggerVerify.filterParamsFormat((JSONObject)condObject);
                filters.add(filter);
            }
        } else {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("rule", "_ne");
            filter.put("val", "");
            filter.put("field", "RECORD_ID");
            filter.put("match", "AND");
            filters.add(filter);
        }
        if ("1".equals(form.getFormType())) {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("rule", "_isNotNull");
            filter.put("val", "");
            filter.put("field", "PROCESS_KEY");
            filter.put("match", "AND");
            filters.add(filter);
        }
        newParam.put("superQueryConditionDto", filters);
        logger.info("\u5f02\u6b65\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)JsonUtil.toJson(newParam));
        ResponseEntity newResponse = this.formOperateExposedService.tableQueryByCondition(String.valueOf(appId), String.valueOf(formId), newParam);
        PageVo newPageData = (PageVo)((ApiResponse)Objects.requireNonNull(newResponse.getBody())).getData();
        List data = newPageData.getData();
        logger.info("\u5f02\u6b65\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\uff1a{}", (Object)JsonUtil.toJson((Object)data));
        if (!data.isEmpty()) {
            String resultStr = JsonUtil.toJson((Object)data);
            triggerDataList = JSON.parseArray((String)resultStr, JSONObject.class);
        }
        return triggerDataList;
    }
}

