/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AttachListDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.BatchDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.BatchDownLoadStatus;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormAttachmentService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadComponent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.data.service.BatchDownLodService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.app.frame.server.impl.formAttachmentServiceImpl")
public class FormAttachmentServiceImpl
implements FormAttachmentService {
    @Resource
    private BatchDownLodService batchDownLodService;
    @Autowired
    private DownLoadComponent downLoadComponent;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormAttachmentServiceImpl.class);
    private static Random random;

    public ApiResponse<SysBatchDownloadTask> downloadAttachmentsInList(AttachListDownloadDto attachListDownloadDto, HttpServletResponse response) {
        SysBatchDownloadTask task = new SysBatchDownloadTask();
        Long taskId = this.createId();
        task.setTaskId(taskId);
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.DERIVING.getStatus()));
        this.batchDownLodService.save((Object)task);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.downLoadComponent.handleAttachmentsInList(attachListDownloadDto, task, dataSourceKey));
        return ApiResponse.success((Object)task);
    }

    private Long createId() {
        return System.currentTimeMillis() + (long)random.nextInt();
    }

    public ApiResponse<SysBatchDownloadTask> batchDownload(BatchDownloadDto batchDownloadDto, HttpServletResponse response) {
        SysBatchDownloadTask task = new SysBatchDownloadTask();
        Long taskId = this.createId();
        task.setTaskId(taskId);
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.DERIVING.getStatus()));
        this.batchDownLodService.save((Object)task);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.downLoadComponent.handleBatchDownload(batchDownloadDto, task, dataSourceKey));
        return ApiResponse.success((Object)task);
    }

    private void compressFolder(String zipFolderPath, HttpServletResponse response) {
        Path sourcePath = Paths.get(zipFolderPath, new String[0]);
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + sourcePath.getFileName().toString() + ".zip\"");
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream((OutputStream)os);){
            Files.walk(sourcePath, new FileVisitOption[0]).forEach(filePath -> {
                if (!Files.isDirectory(filePath, new LinkOption[0])) {
                    try {
                        ZipEntry zipEntry = new ZipEntry(sourcePath.relativize((Path)filePath).toString());
                        zipOut.putNextEntry(zipEntry);
                        Files.copy(filePath, zipOut);
                        zipOut.closeEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            random = new SecureRandom();
        }
        catch (Exception e) {
            LOGGER.info("Exception:", (Throwable)e);
        }
    }
}

