/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.formdesign.app.frame.api.service.IDirectoryNavService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.openApi.common.ApiResponse;
import com.jxdinfo.hussar.openApi.dto.DirectoryNodeDTO;
import com.jxdinfo.hussar.openApi.service.IAiQAService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DirectoryNavServiceImpl
implements IDirectoryNavService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryNavServiceImpl.class);
    private static final String DIRECTORY_ID = "951863478782795776";
    @Resource
    private IAiQAService aiQaService;
    @Resource
    private ISysApplicationService sysApplicationService;

    public Void saveDirectoryNavAsync(FormCanvasSchema newCanvas) {
        LOGGER.info("=================\u5f00\u59cb\u8c03\u7528aiNode\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)newCanvas.getId());
        DirectoryNodeDTO directory = this.modelToDirectoryNavNode(newCanvas);
        ApiResponse mapApiResponse = this.aiQaService.saveOrUpdateNode(directory);
        LOGGER.info("=================ai\u8868\u5355Node\u4fdd\u5b58{}=============", (Object)mapApiResponse.getMsg());
        LOGGER.info("=================\u7ed3\u675f\u8c03\u7528aiNode\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)newCanvas.getId());
        return null;
    }

    public Void deleteDirectoryNavAsync(List<String> ids) {
        ApiResponse apiResponse = this.aiQaService.deleteNodes(ids);
        LOGGER.info("=================\u76ee\u5f55\u8868\u5355\u5220\u9664{}=============", (Object)apiResponse.getMsg());
        return null;
    }

    private DirectoryNodeDTO modelToDirectoryNavNode(FormCanvasSchema formCanvasSchema) {
        DirectoryNodeDTO directoryNodes = new DirectoryNodeDTO();
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
            directoryNodes.setParentId("0");
            directoryNodes.setId(formCanvasSchema.getId());
            directoryNodes.setNodeKey(formCanvasSchema.getId());
            directoryNodes.setNodeId(Long.valueOf(formCanvasSchema.getId()));
            directoryNodes.setNodeName(formCanvasSchema.getTitle());
            directoryNodes.setDirectoryId(Long.valueOf(DIRECTORY_ID));
            directoryNodes.setAppName(((SysApplicationVo)this.sysApplicationService.getAppDetail(Long.valueOf(formCanvasSchema.getAppId())).getData()).getAppName());
            if (HussarUtils.isNotEmpty((Object)formCanvasSchema.getProps())) {
                Map props = formCanvasSchema.getProps();
                if (HussarUtils.isNotEmpty(props.get("description"))) {
                    directoryNodes.setExplanation(props.get("description").toString());
                } else {
                    directoryNodes.setExplanation(formCanvasSchema.getTitle());
                }
            }
        }
        return directoryNodes;
    }
}

