/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.formdesign.app.frame.api.service.IAiFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IAiSyncService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IDirectoryNavService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IFormPathService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AiSyncServiceImpl
implements IAiSyncService {
    @Autowired
    private IAiFormService aiFormService;
    @Autowired
    private IDirectoryNavService directoryNavService;
    @Autowired
    private IFormPathService formPathService;
    @Autowired
    private CanvasService canvasService;

    public void syncForm(Long formId) {
        FormDesignResponse formCanvasSchemaFormDesignResponse = this.canvasService.get(formId.toString());
        FormCanvasSchema newCanvas = (FormCanvasSchema)formCanvasSchemaFormDesignResponse.getData();
        if (!"\u672a\u547d\u540d\u8868\u5355".equals(newCanvas.getTitle())) {
            this.aiFormService.saveAiFormAsync(newCanvas);
            this.directoryNavService.saveDirectoryNavAsync(newCanvas);
            this.formPathService.saveFormPathAsync(newCanvas);
        }
    }

    public void deleteForm(Long formId) {
        ArrayList<String> formIds = new ArrayList<String>();
        formIds.add(String.valueOf(formId));
        this.aiFormService.deleteAiFormAsync(formIds);
        this.directoryNavService.deleteDirectoryNavAsync(formIds);
        this.formPathService.deleteFormPathAsync(String.valueOf(formId));
    }
}

